/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.repgen;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.awt.Frame;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.repgen.TagCorrelationInfo;
import net.maizegenetics.analysis.popgen.LinkageDisequilibrium;
import net.maizegenetics.dna.tag.RepGenSQLite;
import net.maizegenetics.dna.tag.Tag;
import net.maizegenetics.dna.tag.TaxaDistribution;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.GeneratePluginCode;
import net.maizegenetics.plugindef.PluginParameter;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.apache.commons.math3.stat.correlation.SpearmansCorrelation;
import org.apache.log4j.Logger;

public class RepGenLDAnalysisPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(RepGenLDAnalysisPlugin.class);
    private PluginParameter<String> myDBFile = new PluginParameter.Builder<String>("db", null, String.class).guiName("Input DB").required(true).inFile().description("Input database file with tags and taxa distribution").build();
    private PluginParameter<Integer> minTaxa = new PluginParameter.Builder<Integer>("minTaxa", 20, Integer.class).guiName("Min Taxa for RSquared").description("Minimum number of taxa that must be present for R-squared to be calculated.").build();

    public RepGenLDAnalysisPlugin() {
        super(null, false);
    }

    public RepGenLDAnalysisPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    public RepGenLDAnalysisPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public void postProcessParameters() {
        if (this.myDBFile.isEmpty() || !Files.exists(Paths.get(this.inputDB(), new String[0]), new LinkOption[0])) {
            throw new IllegalArgumentException("RepGenLDAnalysisPlugin: postProcessParameters: Input DB not set or found");
        }
    }

    @Override
    public DataSet processData(DataSet input) {
        long totalTime = System.nanoTime();
        long time = System.nanoTime();
        try {
            System.out.println("RepGenLDAnalysis:processData begin, get all tags/taxadist from db");
            RepGenSQLite repGenData = new RepGenSQLite(this.inputDB());
            Map<Tag, TaxaDistribution> tagTaxaMap = repGenData.getAllTagsTaxaMap();
            int tagcount = 0;
            int processedTags = 0;
            System.out.println("TIme to get all tags with taxa from db: " + (double)(System.nanoTime() - totalTime) / 1.0E9 + " seconds.\n");
            time = System.nanoTime();
            Multimap tagTagCorrelations = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
            System.out.println("\nStart processing tag correlations.  Number of tags in db: " + tagTaxaMap.keySet().size());
            Set<Tag> tagSet = tagTaxaMap.keySet();
            ArrayList<Tag> tagList = new ArrayList<Tag>(tagSet);
            for (int tidx = 0; tidx < tagList.size(); ++tidx) {
                Tag tag1 = (Tag)tagList.get(tidx);
                ++tagcount;
                ++processedTags;
                TaxaDistribution tag1TD = tagTaxaMap.get(tag1);
                if (tag1TD == null) {
                    repGenData.close();
                    System.out.println("GetTagTaxaDist: got null tagTD at tagcount " + tagcount);
                    return null;
                }
                int[] depths1 = tag1TD.depths();
                double[] ddepths1 = new double[depths1.length];
                for (int idx = 0; idx < depths1.length; ++idx) {
                    ddepths1[idx] = depths1[idx];
                }
                double[] depthsPrime1 = new double[depths1.length];
                for (int idx = 0; idx < depthsPrime1.length; ++idx) {
                    depthsPrime1[idx] = ddepths1[idx] > 0.0 ? 1.0 : 0.0;
                }
                int tIdxFinal = tidx;
                IntStream.range(tidx + 1, tagList.size()).parallel().forEach(item -> this.calculateCorrelations((Multimap<Tag, TagCorrelationInfo>)tagTagCorrelations, tagTaxaMap, (Tag)tagList.get(tIdxFinal), (Tag)tagList.get(item), ddepths1, depthsPrime1));
                if (tagcount <= 1000) continue;
                System.out.println("FInished processing " + processedTags + " tags, this set took " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds, now load to db ...");
                time = System.nanoTime();
                repGenData.putTagTagCorrelationMatrix((Multimap<Tag, TagCorrelationInfo>)tagTagCorrelations);
                System.out.println("Loading DB took " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds.\n");
                tagcount = 0;
                tagTagCorrelations.clear();
                time = System.nanoTime();
            }
            if (tagcount > 0) {
                System.out.println("Finished processing last tags, load to DB");
                time = System.nanoTime();
                repGenData.putTagTagCorrelationMatrix((Multimap<Tag, TagCorrelationInfo>)tagTagCorrelations);
                System.out.println("Loading DB took " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds.\n");
                tagcount = 0;
                tagTagCorrelations.clear();
            }
            System.out.println("Total number of tags processed: " + processedTags);
            repGenData.close();
        }
        catch (Exception exc) {
            System.out.println("RepGenLDAnalysis:process_data:  processing error");
            exc.printStackTrace();
        }
        System.out.println("Process took " + (double)(System.nanoTime() - totalTime) / 1.0E9 + " seconds.\n");
        return null;
    }

    public void calculateCorrelations(Multimap<Tag, TagCorrelationInfo> tagTagCorrelations, Map<Tag, TaxaDistribution> tagTaxaMap, Tag tag1, Tag tag2, double[] ddepths1, double[] depthsPrime1) {
        TaxaDistribution tag2TD = tagTaxaMap.get(tag2);
        if (tag2TD == null) {
            System.out.println("GetTagTaxaDist: got null tagTD for sequence " + tag2.sequence());
            return;
        }
        int[] depths2 = tag2TD.depths();
        double[] ddepths2 = new double[depths2.length];
        for (int idx = 0; idx < depths2.length; ++idx) {
            ddepths2[idx] = depths2[idx];
        }
        double[] depthsPrime2 = new double[depths2.length];
        for (int idx = 0; idx < depthsPrime1.length; ++idx) {
            depthsPrime2[idx] = ddepths2[idx] > 0.0 ? 1.0 : 0.0;
        }
        PearsonsCorrelation Pearsons = new PearsonsCorrelation();
        double p1 = Pearsons.correlation(ddepths1, ddepths2);
        SpearmansCorrelation Spearmans = new SpearmansCorrelation();
        double spearval = Spearmans.correlation(ddepths1, ddepths2);
        double p2 = Pearsons.correlation(depthsPrime1, depthsPrime2);
        int t1Nott2 = 0;
        int t2Nott1 = 0;
        int neither = 0;
        int both = 0;
        for (int didx = 0; didx < depthsPrime2.length; ++didx) {
            if (depthsPrime1[didx] > 0.0 && depthsPrime2[didx] > 0.0) {
                ++both;
            }
            if (depthsPrime1[didx] == 0.0 && depthsPrime2[didx] == 0.0) {
                ++neither;
            }
            if (depthsPrime1[didx] > 0.0 && depthsPrime2[didx] == 0.0) {
                ++t1Nott2;
            }
            if (depthsPrime1[didx] != 0.0 || !(depthsPrime2[didx] > 0.0)) continue;
            ++t2Nott1;
        }
        double r2 = LinkageDisequilibrium.calculateRSqr(neither, t1Nott2, t2Nott1, both, this.minTaxa());
        TagCorrelationInfo tci = new TagCorrelationInfo(tag2, p1, spearval, p2, r2);
        tagTagCorrelations.put((Object)tag1, (Object)tci);
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return null;
    }

    public static void main(String[] args) {
        GeneratePluginCode.generate(RepGenLDAnalysisPlugin.class);
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    public String inputDB() {
        return this.myDBFile.value();
    }

    public RepGenLDAnalysisPlugin inputDB(String value) {
        this.myDBFile = new PluginParameter<String>(this.myDBFile, value);
        return this;
    }

    public Integer minTaxa() {
        return this.minTaxa.value();
    }

    public RepGenLDAnalysisPlugin minTaxa(Integer value) {
        this.minTaxa = new PluginParameter<Integer>(this.minTaxa, value);
        return this;
    }
}

