/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.v2;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import java.awt.Frame;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.v2.TagTaxaDistribution;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.GenomeSequence;
import net.maizegenetics.dna.map.GenomeSequenceBuilder;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.snp.Allele;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.snp.SimpleAllele;
import net.maizegenetics.dna.tag.Tag;
import net.maizegenetics.dna.tag.TagBuilder;
import net.maizegenetics.dna.tag.TagDataSQLite;
import net.maizegenetics.dna.tag.TagDataWriter;
import net.maizegenetics.dna.tag.TaxaDistBuilder;
import net.maizegenetics.dna.tag.TaxaDistribution;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.Tuple;
import org.apache.log4j.Logger;
import org.biojava.nbio.alignment.Alignments;
import org.biojava.nbio.alignment.template.AlignedSequence;
import org.biojava.nbio.alignment.template.Profile;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.util.ConcurrencyTools;

public class DiscoverySNPCallerPluginV2
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(DiscoverySNPCallerPluginV2.class);
    private PluginParameter<String> myInputDB = new PluginParameter.Builder<String>("db", null, String.class).guiName("Input GBS Database").required(true).inFile().description("Input Database file if using SQLite").build();
    private PluginParameter<Double> myMinMinorAlleleFreq = new PluginParameter.Builder<Double>("mnMAF", 0.01, Double.class).guiName("Min Minor Allele Freq").description("Minimum minor allele frequency").build();
    private PluginParameter<Double> myMinLocusCoverage = new PluginParameter.Builder<Double>("mnLCov", 0.1, Double.class).guiName("Min Locus Coverage").description("Minimum locus coverage (proportion of Taxa with a genotype)").build();
    private PluginParameter<String> myRefGenome = new PluginParameter.Builder<String>("ref", null, String.class).guiName("Reference Genome File").inFile().description("Path to reference genome in fasta format. Ensures that a tag from the reference genome is always included when the tags at a locus are aligned against each other to call SNPs. The reference allele for each site is then provided in the output HapMap files, under the taxon name \"REFERENCE_GENOME\" (first taxon). DEFAULT: Don't use reference genome.").build();
    private PluginParameter<Chromosome> myStartChr = new PluginParameter.Builder<Chromosome>("sC", null, Chromosome.class).guiName("Start Chromosome").required(false).description("Start Chromosome").build();
    private PluginParameter<Chromosome> myEndChr = new PluginParameter.Builder<Chromosome>("eC", null, Chromosome.class).guiName("End Chromosome").required(false).description("End Chromosome").build();
    private PluginParameter<Boolean> myIncludeGaps = new PluginParameter.Builder<Boolean>("inclGaps", false, Boolean.class).guiName("Include Gaps").description("Include sites where major or minor allele is a GAP").build();
    private PluginParameter<Double> myGapAlignmentThreshold = new PluginParameter.Builder<Double>("gapAlignRatio", 1.0, Double.class).guiName("Gap Alignment Threshold").description("Gap alignment threshold ratio of indel contrasts to non indel contrasts: IC/(IC + NC). Any loci with a tag alignment value above this threshold will be excluded from the pool.").build();
    private PluginParameter<Integer> maxTagsPerCutSite = new PluginParameter.Builder<Integer>("maxTagsCutSite", 64, Integer.class).guiName("Max Number of Cut Sites").required(false).description("Maximum number of tags per cut site").build();
    private PluginParameter<Boolean> myDeleteOldData = new PluginParameter.Builder<Boolean>("deleteOldData", true, Boolean.class).guiName("Delete Previous Discovery Data").description("Delete existing SNP data from tables").build();
    private TagDataWriter tagDataWriter = null;
    boolean includeReference = false;
    static GenomeSequence myRefSequence = null;
    private boolean customSNPLogging = true;
    private boolean customFiltering = false;
    private int refTagsNotAdded = 0;
    private static Map<String, Integer> keyFileStringToInt = null;

    public DiscoverySNPCallerPluginV2() {
        super(null, false);
    }

    public DiscoverySNPCallerPluginV2(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        Chromosome endChrom;
        List<Chromosome> myChroms;
        myLogger.info((Object)("Finding SNPs in " + this.inputDB() + "."));
        myLogger.info((Object)String.format("StartChr:%s EndChr:%s %n", this.startChromosome(), this.endChromosome()));
        this.tagDataWriter = new TagDataSQLite(this.inputDB());
        if (this.deleteOldData().booleanValue()) {
            myLogger.info((Object)"deleteOldData is TRUE: Clearing previous Discovery and SNPQuality data");
            this.tagDataWriter.clearSNPQualityData();
            this.tagDataWriter.clearDiscoveryData();
        }
        if ((myChroms = this.tagDataWriter.getChromosomesFromCutPositions()) == null || myChroms.size() == 0) {
            myLogger.error((Object)"No Chromosomes found in cutPosition tables");
            try {
                ((TagDataSQLite)this.tagDataWriter).close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return null;
        }
        Collections.sort(myChroms);
        Chromosome startChrom = this.myStartChr.isEmpty() ? myChroms.get(0) : this.startChromosome();
        Chromosome chromosome = endChrom = this.myEndChr.isEmpty() ? myChroms.get(myChroms.size() - 1) : this.endChromosome();
        if (startChrom.compareTo(endChrom) > 0) {
            String message = "The start chromosome " + startChrom.getName() + " is larger than the end chromosome " + endChrom.getName();
            myLogger.error((Object)message);
            try {
                ((TagDataSQLite)this.tagDataWriter).close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return null;
        }
        List chromsToProcess = myChroms.stream().filter(chrom -> chrom.compareTo(startChrom) >= 0 && chrom.compareTo(endChrom) <= 0).collect(Collectors.toList());
        chromsToProcess.stream().forEach(chr -> {
            myLogger.info((Object)("Start processing chromosome " + chr + "\n"));
            HashMultimap chromosomeAllelemap = HashMultimap.create();
            myLogger.info((Object)"Calling getCutPosForStrand FORWARD strands...");
            this.tagDataWriter.getCutPosForStrandTagTaxaMap((Chromosome)chr, -1, -1, true).entrySet().stream().forEach(arg_0 -> this.lambda$null$1(chr, (Multimap)chromosomeAllelemap, arg_0));
            myLogger.info((Object)"\nCalling getCutPosForStrand REVERSE strands...");
            this.tagDataWriter.getCutPosForStrandTagTaxaMap((Chromosome)chr, -1, -1, false).entrySet().stream().forEach(arg_0 -> this.lambda$null$2(chr, (Multimap)chromosomeAllelemap, arg_0));
            myLogger.info((Object)("Finished processing chromosome " + chr + "\n\n"));
            this.tagDataWriter.putTagAlleles((Multimap<Tag, Allele>)chromosomeAllelemap);
        });
        ConcurrencyTools.shutdown();
        try {
            ((TagDataSQLite)this.tagDataWriter).close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    @Override
    public void postProcessParameters() {
        if (this.myInputDB.isEmpty() || !Files.exists(Paths.get(this.inputDB(), new String[0]), new LinkOption[0])) {
            throw new IllegalArgumentException("DiscoverySNPCallerPlugin: postProcessParameters: Input DB not set or found");
        }
        if (!this.myRefGenome.isEmpty()) {
            this.includeReference = true;
            myRefSequence = GenomeSequenceBuilder.instance(this.referenceGenomeFile());
        }
        if (!this.myStartChr.isEmpty() && !this.myEndChr.isEmpty() && this.startChromosome().compareTo(this.endChromosome()) > 0) {
            throw new IllegalArgumentException("The start chromosome is larger than the end chromosome.");
        }
        myLogger.info((Object)String.format("MinMAF:%g %n", this.minMinorAlleleFreq()));
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Discovery SNP Caller";
    }

    @Override
    public String getToolTipText() {
        return "Discovery SNP Caller";
    }

    Multimap<Tag, Allele> findAlleleByAlignment(Position cutPosition, Map<Tag, TaxaDistribution> tagTaxaMap, Chromosome chromosome, boolean forwardStrand) {
        if (tagTaxaMap.isEmpty()) {
            return null;
        }
        int numberOfTaxa = tagTaxaMap.values().stream().findFirst().get().maxTaxa();
        if (this.minMinorAlleleFreq() > 0.0 && tagTaxaMap.size() < 2) {
            return null;
        }
        if (!tagTaxaMap.keySet().stream().anyMatch(Tag::isReference)) {
            if (myRefSequence != null) {
                if ((tagTaxaMap = DiscoverySNPCallerPluginV2.createReferenceTag(cutPosition, tagTaxaMap, chromosome, numberOfTaxa, forwardStrand)) == null) {
                    return null;
                }
            } else {
                tagTaxaMap = DiscoverySNPCallerPluginV2.setCommonToReference(tagTaxaMap);
            }
        }
        boolean printDebug = cutPosition.getPosition() > 179000 && cutPosition.getPosition() < 1500000;
        printDebug = false;
        if (printDebug) {
            System.out.println("\nTagLocus: " + cutPosition.toString());
        }
        double taxaCoverage = (double)tagTaxaMap.values().stream().mapToInt(t -> t.numberOfTaxaWithTag()).sum() / (double)numberOfTaxa;
        if (printDebug) {
            System.out.println("taxaCoverage = " + taxaCoverage + " myMinLocusCoverage:" + this.myMinLocusCoverage.value());
        }
        if (taxaCoverage < this.myMinLocusCoverage.value()) {
            return null;
        }
        Map<Tag, String> alignedTagsUnfiltered = DiscoverySNPCallerPluginV2.alignTags(tagTaxaMap, this.maxTagsPerCutSite(), cutPosition.getStrand(), printDebug);
        if (alignedTagsUnfiltered == null || alignedTagsUnfiltered.size() == 0) {
            return null;
        }
        Map<Tag, String> alignedTags = DiscoverySNPCallerPluginV2.filterAlignedTags(alignedTagsUnfiltered, cutPosition, this.myGapAlignmentThreshold.value());
        if (alignedTags == null || alignedTags.size() == 0) {
            return null;
        }
        Table<Position, Byte, List<TagTaxaDistribution>> tAlign = DiscoverySNPCallerPluginV2.convertAlignmentToTagTable(alignedTags, tagTaxaMap, cutPosition);
        List positionToKeep = tAlign.rowMap().entrySet().stream().filter(entry -> (double)DiscoverySNPCallerPluginV2.numberTaxaAtSiteIgnoreGaps((Map)entry.getValue()) / (double)numberOfTaxa > this.minLocusCoverage()).filter(entry -> {
            List<Tuple<Byte, Integer>> aC = DiscoverySNPCallerPluginV2.alleleTaxaCounts((Map)entry.getValue());
            if (!this.includeGaps().booleanValue()) {
                if ((Byte)aC.get((int)0).x == 5) {
                    return false;
                }
                if (aC.size() > 1 && (Byte)aC.get((int)1).x == 5) {
                    return false;
                }
            }
            if (this.minMinorAlleleFreq() <= 0.0) {
                return true;
            }
            return aC.size() > 1 && (double)((Integer)aC.get((int)1).y).intValue() > this.minMinorAlleleFreq() * taxaCoverage * (double)numberOfTaxa;
        }).map(Map.Entry::getKey).collect(Collectors.toList());
        HashMultimap tagAllelemap = HashMultimap.create();
        for (Position position : positionToKeep) {
            for (Map.Entry entry2 : tAlign.row((Object)position).entrySet()) {
                SimpleAllele allele = new SimpleAllele((Byte)entry2.getKey(), position);
                for (TagTaxaDistribution tagTaxaDistribution : (List)entry2.getValue()) {
                    Tag currentTag = tagTaxaDistribution.tag();
                    TaxaDistribution td = tagTaxaDistribution.taxaDist();
                    if (td.totalDepth() == 0) {
                        ++this.refTagsNotAdded;
                        continue;
                    }
                    tagAllelemap.put((Object)currentTag, (Object)allele);
                }
            }
        }
        return tagAllelemap;
    }

    private static Map<Tag, TaxaDistribution> setCommonToReference(Map<Tag, TaxaDistribution> tagTaxaMap) {
        Tag commonTag = tagTaxaMap.entrySet().stream().max(Comparator.comparingInt(e -> ((TaxaDistribution)e.getValue()).numberOfTaxaWithTag())).map(e -> (Tag)e.getKey()).get();
        TaxaDistribution commonTD = tagTaxaMap.get(commonTag);
        Tag refTag = TagBuilder.instance(commonTag.seq2Bit(), commonTag.seqLength()).reference().build();
        ImmutableMap.Builder tagTaxaMapBuilder = new ImmutableMap.Builder();
        for (Map.Entry<Tag, TaxaDistribution> entry : tagTaxaMap.entrySet()) {
            if (entry.getKey() != commonTag) {
                tagTaxaMapBuilder.put(entry);
                continue;
            }
            tagTaxaMapBuilder.put((Object)refTag, (Object)commonTD);
        }
        return tagTaxaMapBuilder.build();
    }

    private static Map<Tag, TaxaDistribution> createReferenceTag(Position cutPos, Map<Tag, TaxaDistribution> tagTaxaMap, Chromosome myChrom, int numberOfTaxa, boolean forwardStrand) {
        TaxaDistribution refTD;
        byte[] seqInBytes;
        Tag refTag = null;
        int cutPosition = cutPos.getPosition();
        Tag longestTag = tagTaxaMap.keySet().stream().max(Comparator.comparingInt(key -> key.seqLength())).get();
        short longestTagLen = longestTag.seqLength();
        int seqStart = cutPosition;
        int seqEnd = cutPosition + longestTagLen - 1;
        if (!forwardStrand) {
            seqStart = cutPosition - (longestTagLen - 1);
            seqEnd = cutPosition;
        }
        try {
            seqInBytes = myRefSequence.chromosomeSequence(myChrom, seqStart, seqEnd);
        }
        catch (IllegalArgumentException iae) {
            String msg = "Error creating reference tag at position " + cutPosition + " with length " + longestTagLen + ", seqStart " + seqStart + " seqEnd " + seqEnd + " isForwardStrand " + forwardStrand + ". Position not found in reference file.  . Please verify the reference file used for the plugin matches the reference file used for the aligner.";
            myLogger.error((Object)msg);
            return null;
        }
        String seqInBytesString = NucleotideAlignmentConstants.nucleotideBytetoString(seqInBytes);
        if (seqInBytesString == null) {
            System.out.println(" createReferenceTag: seqInBytesString is null, seqInBytes value: " + seqInBytes);
        }
        if (seqInBytesString.contains("N") || seqInBytesString.contains("null")) {
            return null;
        }
        refTag = TagBuilder.instance(seqInBytesString).reference().build();
        if (refTag == null) {
            System.out.println("\ncreateReferenceTag: forward strand refTag is null, seqInBytesString: " + seqInBytesString + "\n");
            return null;
        }
        if (!forwardStrand && (refTag = TagBuilder.reverseComplement(refTag).reference().build()) == null) {
            System.out.println("\ncreateReferenceTag: reverse complemented refTag is null for seqInBytesString: " + seqInBytesString + "\n");
            return null;
        }
        ImmutableMap.Builder tagTaxaMapBuilder = new ImmutableMap.Builder();
        int mapCount = 0;
        if (!tagTaxaMap.containsKey(refTag)) {
            refTD = TaxaDistBuilder.create(numberOfTaxa);
            tagTaxaMapBuilder.put((Object)refTag, (Object)refTD);
            ++mapCount;
        } else {
            refTD = tagTaxaMap.get(refTag);
            tagTaxaMap.remove(refTag);
            tagTaxaMapBuilder.put((Object)refTag, (Object)refTD);
            ++mapCount;
        }
        for (Map.Entry<Tag, TaxaDistribution> entry : tagTaxaMap.entrySet()) {
            if (entry.getKey().equals(refTag)) continue;
            tagTaxaMapBuilder.put(entry);
            ++mapCount;
        }
        return tagTaxaMapBuilder.build();
    }

    private static List<Tuple<Byte, Integer>> alleleTaxaCounts(Map<Byte, List<TagTaxaDistribution>> alleleDistMap) {
        ArrayList<Tuple<Byte, Integer>> alleleCnt = new ArrayList<Tuple<Byte, Integer>>();
        for (Map.Entry<Byte, List<TagTaxaDistribution>> entry : alleleDistMap.entrySet()) {
            alleleCnt.add(new Tuple<Byte, Integer>(entry.getKey(), DiscoverySNPCallerPluginV2.numberOfTaxa(entry.getValue())));
        }
        Collections.sort(alleleCnt, (a, b) -> ((Integer)b.y).compareTo((Integer)a.y));
        return alleleCnt;
    }

    private static Map<Tag, String> alignTags(Map<Tag, TaxaDistribution> tags, int maxTagsPerCutSite, byte strand, boolean printDebug) {
        ArrayList<DNASequence> lst = new ArrayList<DNASequence>();
        for (Map.Entry<Tag, TaxaDistribution> entry : tags.entrySet()) {
            Tag tag = entry.getKey();
            if (printDebug) {
                System.out.println(tag.toString());
            }
            String sequence = strand == 1 ? tag.sequence() : tag.toReverseComplement();
            try {
                DNASequence ds = new DNASequence(sequence);
                ds.setUserCollection((Collection)ImmutableList.of((Object)tag));
                lst.add(ds);
            }
            catch (CompoundNotFoundException ex) {
                myLogger.error((Object)("DSNPCaller:alignTags, compoundNotFound exception from DNASequence call for: " + sequence));
                myLogger.debug((Object)ex.getMessage(), (Throwable)ex);
                return null;
            }
        }
        ImmutableMap.Builder result = new ImmutableMap.Builder();
        if (lst.size() == 1) {
            Tag tag = (Tag)((ImmutableList)((DNASequence)lst.get(0)).getUserCollection()).get(0);
            result.put((Object)tag, (Object)tag.sequence());
            return result.build();
        }
        if (lst.size() > maxTagsPerCutSite) {
            return null;
        }
        Profile profile = Alignments.getMultipleSequenceAlignment(lst, (Object[])new Object[0]);
        if (printDebug) {
            System.out.printf("Clustalw:%n%s%n", profile);
        }
        for (AlignedSequence compounds : profile) {
            ImmutableList tagList = (ImmutableList)((DNASequence)compounds.getOriginalSequence()).getUserCollection();
            result.put((Object)((Tag)tagList.get(0)), (Object)compounds.getSequenceAsString());
        }
        return result.build();
    }

    private static Map<Tag, String> filterAlignedTags(Map<Tag, String> alignedTags, Position refStartPosition, double threshold) {
        HashMap<Tag, String> filteredTags = new HashMap<Tag, String>();
        List<Optional<Position>> referencePositions = DiscoverySNPCallerPluginV2.referencePositions(refStartPosition, alignedTags);
        for (Map.Entry<Tag, String> entry : alignedTags.entrySet()) {
            Tag tag = entry.getKey();
            String value = entry.getValue();
            int IC = 0;
            int NC = 0;
            for (int index = 0; index < value.length(); ++index) {
                byte allele = NucleotideAlignmentConstants.getNucleotideAlleleByte(value.charAt(index));
                Optional<Position> p = referencePositions.get(index);
                if (!p.isPresent()) {
                    if (allele == 5) continue;
                    ++IC;
                    continue;
                }
                if (allele == 5) {
                    ++IC;
                    continue;
                }
                ++NC;
            }
            double alignValue = (double)IC / (double)(IC + NC);
            if (alignValue <= threshold) {
                filteredTags.put(tag, value);
                continue;
            }
            filteredTags.clear();
            return null;
        }
        return filteredTags;
    }

    private static Table<Position, Byte, List<TagTaxaDistribution>> convertAlignmentToTagTable(Map<Tag, String> alignedTags, Map<Tag, TaxaDistribution> tagTaxaDistMap, Position cutPosition) {
        TreeBasedTable alignT = TreeBasedTable.create();
        List<Optional<Position>> referencePositions = DiscoverySNPCallerPluginV2.referencePositions(cutPosition, alignedTags);
        alignedTags.forEach((arg_0, arg_1) -> DiscoverySNPCallerPluginV2.lambda$convertAlignmentToTagTable$11(tagTaxaDistMap, referencePositions, (Table)alignT, arg_0, arg_1));
        return alignT;
    }

    private static String toString(Table<Position, Byte, List<TagTaxaDistribution>> snpTagTable) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Rows %d Columns %d\n", snpTagTable.rowKeySet().size(), snpTagTable.columnKeySet().size()));
        sb.append("Columns bases:");
        snpTagTable.columnKeySet().stream().forEach(b -> sb.append(b + ","));
        sb.append("\n");
        snpTagTable.rowMap().forEach((p, ttd) -> {
            sb.append(String.format("Position: %d", p.getPosition()));
            for (Map.Entry byteListEntry : ttd.entrySet()) {
                sb.append(String.format("\tAllele: %d ->", byteListEntry.getKey()));
                ((List)byteListEntry.getValue()).forEach(tt -> sb.append(String.join((CharSequence)",", tt.tag().sequence() + "#" + tt.taxaDist().numberOfTaxaWithTag() + " ")));
            }
            sb.append("\n");
        });
        return sb.toString();
    }

    private static int numberOfTaxa(List<TagTaxaDistribution> tagTaxaDistributions) {
        return tagTaxaDistributions.stream().mapToInt(t -> t.taxaDist().numberOfTaxaWithTag()).sum();
    }

    private static int numberTaxaAtSite(Map<Byte, List<TagTaxaDistribution>> tagTaxaDistributions) {
        return tagTaxaDistributions.values().stream().flatMap(tList -> tList.stream()).mapToInt(t -> t.taxaDist().numberOfTaxaWithTag()).sum();
    }

    private static int numberTaxaAtSiteIgnoreGaps(Map<Byte, List<TagTaxaDistribution>> tagTaxaDistributions) {
        return tagTaxaDistributions.entrySet().stream().filter(e -> (Byte)e.getKey() != 5).flatMap(tList -> ((List)tList.getValue()).stream()).mapToInt(tag -> tag.taxaDist().numberOfTaxaWithTag()).sum();
    }

    private static List<Optional<Position>> referencePositions(Position cutPosition, Map<Tag, String> alignedTags) {
        Tag refTag = alignedTags.keySet().stream().filter(Tag::isReference).findFirst().orElseThrow(() -> new IllegalStateException("Reference not found"));
        AtomicInteger start = new AtomicInteger(cutPosition.getPosition());
        String refChars = alignedTags.get(refTag);
        byte strand = cutPosition.getStrand();
        ArrayList<Optional<Position>> positionList = new ArrayList<Optional<Position>>();
        if (strand == 1) {
            for (int cidx = 0; cidx < refChars.length(); ++cidx) {
                char currChar = refChars.charAt(cidx);
                if (currChar == '-') {
                    positionList.add(Optional.empty());
                    continue;
                }
                byte refAllele = NucleotideAlignmentConstants.getNucleotideAlleleByte(currChar);
                positionList.add(Optional.of(new GeneralPosition.Builder(cutPosition.getChromosome(), start.getAndIncrement()).allele(WHICH_ALLELE.Reference, refAllele).build()));
            }
        } else {
            int revCidx;
            ArrayList revPositionList = new ArrayList();
            for (revCidx = refChars.length() - 1; revCidx >= 0; --revCidx) {
                char currChar = refChars.charAt(revCidx);
                if (currChar == '-') {
                    revPositionList.add(Optional.empty());
                    continue;
                }
                byte refAllele = NucleotideAlignmentConstants.getNucleotideAlleleByte(currChar);
                revPositionList.add(Optional.of(new GeneralPosition.Builder(cutPosition.getChromosome(), start.getAndDecrement()).allele(WHICH_ALLELE.Reference, refAllele).build()));
            }
            for (revCidx = revPositionList.size() - 1; revCidx >= 0; --revCidx) {
                positionList.add((Optional<Position>)revPositionList.get(revCidx));
            }
        }
        return positionList;
    }

    public String inputDB() {
        return this.myInputDB.value();
    }

    public DiscoverySNPCallerPluginV2 inputDB(String value) {
        this.myInputDB = new PluginParameter<String>(this.myInputDB, value);
        return this;
    }

    public Double minMinorAlleleFreq() {
        return this.myMinMinorAlleleFreq.value();
    }

    public DiscoverySNPCallerPluginV2 minMinorAlleleFreq(Double value) {
        this.myMinMinorAlleleFreq = new PluginParameter<Double>(this.myMinMinorAlleleFreq, value);
        return this;
    }

    public Double minLocusCoverage() {
        return this.myMinLocusCoverage.value();
    }

    public DiscoverySNPCallerPluginV2 minLocusCoverage(Double value) {
        this.myMinLocusCoverage = new PluginParameter<Double>(this.myMinLocusCoverage, value);
        return this;
    }

    public String referenceGenomeFile() {
        return this.myRefGenome.value();
    }

    public DiscoverySNPCallerPluginV2 referenceGenomeFile(String value) {
        this.myRefGenome = new PluginParameter<String>(this.myRefGenome, value);
        return this;
    }

    public Chromosome startChromosome() {
        return this.myStartChr.value();
    }

    public DiscoverySNPCallerPluginV2 startChromosome(Chromosome value) {
        this.myStartChr = new PluginParameter<Chromosome>(this.myStartChr, value);
        return this;
    }

    public Chromosome endChromosome() {
        return this.myEndChr.value();
    }

    public DiscoverySNPCallerPluginV2 endChromosome(Chromosome value) {
        this.myEndChr = new PluginParameter<Chromosome>(this.myEndChr, value);
        return this;
    }

    public Boolean includeGaps() {
        return this.myIncludeGaps.value();
    }

    public DiscoverySNPCallerPluginV2 includeGaps(Boolean value) {
        this.myIncludeGaps = new PluginParameter<Boolean>(this.myIncludeGaps, value);
        return this;
    }

    public Double gapAlignmentThreshold() {
        return this.myGapAlignmentThreshold.value();
    }

    public DiscoverySNPCallerPluginV2 gapAlignmentThreshold(Double value) {
        this.myGapAlignmentThreshold = new PluginParameter<Double>(this.myGapAlignmentThreshold, value);
        return this;
    }

    public Integer maxTagsPerCutSite() {
        return this.maxTagsPerCutSite.value();
    }

    public DiscoverySNPCallerPluginV2 maxTagsPerCutSite(Integer value) {
        this.maxTagsPerCutSite = new PluginParameter<Integer>(this.maxTagsPerCutSite, value);
        return this;
    }

    public static void setKeyFileStringToInt(Map<String, Integer> inputKeyFile) {
        keyFileStringToInt = inputKeyFile;
    }

    public Boolean deleteOldData() {
        return this.myDeleteOldData.value();
    }

    public DiscoverySNPCallerPluginV2 deleteOldData(Boolean value) {
        this.myDeleteOldData = new PluginParameter<Boolean>(this.myDeleteOldData, value);
        return this;
    }

    public static int keyFileReturnChromInt(String chromosome) {
        if (keyFileStringToInt != null) {
            if (keyFileStringToInt.containsKey(chromosome)) {
                return keyFileStringToInt.get(chromosome);
            }
        } else {
            System.out.println("LCJ - DiscoverySNP .. keyFileStringToInt is NULL");
        }
        return -1;
    }

    private static /* synthetic */ void lambda$convertAlignmentToTagTable$11(Map tagTaxaDistMap, List referencePositions, Table alignT, Tag t, String s) {
        TagTaxaDistribution td = new TagTaxaDistribution(t, (TaxaDistribution)tagTaxaDistMap.get(t));
        for (int i = 0; i < s.length(); ++i) {
            byte allele = NucleotideAlignmentConstants.getNucleotideAlleleByte(s.charAt(i));
            Optional p = (Optional)referencePositions.get(i);
            if (!p.isPresent()) continue;
            List tdList = (List)alignT.get(p.get(), (Object)allele);
            if (tdList != null) {
                tdList.add(td);
                continue;
            }
            ArrayList<TagTaxaDistribution> ttdL = new ArrayList<TagTaxaDistribution>();
            ttdL.add(td);
            alignT.put(p.get(), (Object)allele, ttdL);
        }
    }

    private /* synthetic */ void lambda$null$2(Chromosome chr, Multimap chromosomeAllelemap, Map.Entry emp) {
        Multimap<Tag, Allele> tm = this.findAlleleByAlignment((Position)emp.getKey(), (Map)emp.getValue(), chr, false);
        if (tm != null) {
            chromosomeAllelemap.putAll(tm);
        }
    }

    private /* synthetic */ void lambda$null$1(Chromosome chr, Multimap chromosomeAllelemap, Map.Entry emp) {
        Multimap<Tag, Allele> tm = this.findAlleleByAlignment((Position)emp.getKey(), (Map)emp.getValue(), chr, true);
        if (tm != null) {
            chromosomeAllelemap.putAll(tm);
        }
    }
}

