/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.v2;

public class GBSEnzyme {
    private final String theEnzyme;
    private final String[] initialCutSiteRemnant;
    private final String[] likelyReadEnd;
    private final int readEndCutSiteRemnantLength;

    public GBSEnzyme(String enzyme) {
        if (enzyme.matches("(?i)apek[i1]")) {
            this.theEnzyme = "ApeKI";
            this.initialCutSiteRemnant = new String[]{"CAGC", "CTGC"};
            this.likelyReadEnd = new String[]{"GCAGC", "GCTGC", "GCAGAGAT", "GCTGAGAT"};
            this.readEndCutSiteRemnantLength = 4;
        } else if (enzyme.matches("(?i)pst[i1]")) {
            this.theEnzyme = "PstI";
            this.initialCutSiteRemnant = new String[]{"TGCAG"};
            this.likelyReadEnd = new String[]{"CTGCAG", "CTGCAAGAT"};
            this.readEndCutSiteRemnantLength = 5;
        } else if (enzyme.matches("(?i)ecot22[i1]")) {
            this.theEnzyme = "EcoT22I";
            this.initialCutSiteRemnant = new String[]{"TGCAT"};
            this.likelyReadEnd = new String[]{"ATGCAT", "ATGCAAGAT"};
            this.readEndCutSiteRemnantLength = 5;
        } else if (enzyme.matches("(?i)pas[i1]")) {
            this.theEnzyme = "PasI";
            this.initialCutSiteRemnant = new String[]{"CAGGG", "CTGGG"};
            this.likelyReadEnd = new String[]{"CCCAGGG", "CCCTGGG", "CCCTGAGAT", "CCCAGAGAT"};
            this.readEndCutSiteRemnantLength = 5;
        } else if (enzyme.matches("(?i)hpaii|(?i)hpa2")) {
            this.theEnzyme = "HpaII";
            this.initialCutSiteRemnant = new String[]{"CGG"};
            this.likelyReadEnd = new String[]{"CCGG", "CCGAGATCGG"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)msp[i1]")) {
            this.theEnzyme = "MspI";
            this.initialCutSiteRemnant = new String[]{"CGG"};
            this.likelyReadEnd = new String[]{"CCGG", "CCGAGATCGG"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)pst[i1]-apek[i1]")) {
            this.theEnzyme = "PstI-ApeKI";
            this.initialCutSiteRemnant = new String[]{"TGCAG"};
            this.likelyReadEnd = new String[]{"GCAGC", "GCTGC", "CTGCAG", "GCAGAGAT", "GCTGAGAT"};
            this.readEndCutSiteRemnantLength = 4;
        } else if (enzyme.matches("(?i)pst[i1]-bfa[i1]")) {
            this.theEnzyme = "PstI-BfaI";
            this.initialCutSiteRemnant = new String[]{"TGCAG"};
            this.likelyReadEnd = new String[]{"CTGCAG", "CTAG", "CTAAGATC"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)pst[i1]-ecot22[i1]")) {
            this.theEnzyme = "PstI-EcoT22I";
            this.initialCutSiteRemnant = new String[]{"TGCAG", "TGCAT"};
            this.likelyReadEnd = new String[]{"ATGCAT", "CTGCAG", "CTGCAAGAT", "ATGCAAGAT"};
            this.readEndCutSiteRemnantLength = 5;
        } else if (enzyme.matches("(?i)pst[i1]-msp[i1]")) {
            this.theEnzyme = "PstI-MspI";
            this.initialCutSiteRemnant = new String[]{"TGCAG"};
            this.likelyReadEnd = new String[]{"CCGG", "CTGCAG", "CCGAGATC"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)pst[i1]-msp[i1]-GDFcustom")) {
            this.theEnzyme = "PstI-MspI-GDFcustom";
            this.initialCutSiteRemnant = new String[]{"TGCAG"};
            this.likelyReadEnd = new String[]{"CCGG", "CTGCAG", "CCGCTCAGG"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)pst[i1]-taq[i1]")) {
            this.theEnzyme = "PstI-TaqI";
            this.initialCutSiteRemnant = new String[]{"TGCAG"};
            this.likelyReadEnd = new String[]{"TCGA", "CTGCAG", "TCGAGATC"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)nsi[i1]-msp[i1]")) {
            this.theEnzyme = "NsiI-MspI";
            this.initialCutSiteRemnant = new String[]{"TGCAT"};
            this.likelyReadEnd = new String[]{"CCGG", "ATGCAT", "CCGAGATC"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)PaeR7[i1]-Hha[i1]")) {
            this.theEnzyme = "PaeR7I-HhaI";
            this.initialCutSiteRemnant = new String[]{"TCGAG"};
            this.likelyReadEnd = new String[]{"GCGC", "CTCGAG", "GCGAGATC"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)sbf[i1]-msp[i1]")) {
            this.theEnzyme = "SbfI-MspI";
            this.initialCutSiteRemnant = new String[]{"TGCAGG"};
            this.likelyReadEnd = new String[]{"CCGG", "CCTGCAGG", "CCGAGATC"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)sbf[i1]-hpaii|(?i)sbf[i1]-hpa2")) {
            this.theEnzyme = "SbfI-HpaII";
            this.initialCutSiteRemnant = new String[]{"TGCAGG"};
            this.likelyReadEnd = new String[]{"CCGG", "CCTGCAGG", "CCGAGATC"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)sbf[i1]-bfa[i1]")) {
            this.theEnzyme = "SbfI-BfaI";
            this.initialCutSiteRemnant = new String[]{"TGCAGG"};
            this.likelyReadEnd = new String[]{"CTAG", "CCTGCAGG", "CTAAGATC"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)sph[i1]-ecor[i1]")) {
            this.theEnzyme = "SphI-EcoRI";
            this.initialCutSiteRemnant = new String[]{"CATGC"};
            this.likelyReadEnd = new String[]{"GCATGC", "GAATTC", "GAATTAGATC"};
            this.readEndCutSiteRemnantLength = 5;
        } else if (enzyme.matches("(?i)asis[i1]-msp[i1]")) {
            this.theEnzyme = "AsiSI-MspI";
            this.initialCutSiteRemnant = new String[]{"ATCGC"};
            this.likelyReadEnd = new String[]{"CCGG", "GCGATCGC", "CCGAGATC"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)bsshii-msp[i1]|(?i)bssh2-msp[i1]")) {
            this.theEnzyme = "BssHII-MspI";
            this.initialCutSiteRemnant = new String[]{"CGCGC"};
            this.likelyReadEnd = new String[]{"CCGG", "GCGCGC", "CCGAGATC"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)fse[i1]-msp[i1]")) {
            this.theEnzyme = "FseI-MspI";
            this.initialCutSiteRemnant = new String[]{"CCGGCC"};
            this.likelyReadEnd = new String[]{"CCGG", "GGCCGGCC", "CCGAGATC"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)sal[i1]-msp[i1]")) {
            this.theEnzyme = "SalI-MspI";
            this.initialCutSiteRemnant = new String[]{"TCGAC"};
            this.likelyReadEnd = new String[]{"CCGG", "GTCGAC", "CCGAGATC"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)ecor[i1]-msp[i1]")) {
            this.theEnzyme = "EcoRI-MspI";
            this.initialCutSiteRemnant = new String[]{"AATTC"};
            this.likelyReadEnd = new String[]{"CCGG", "GAATTC", "CCGAGATC"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)hindiii-msp[i1]|(?i)hind3-msp[i1]")) {
            this.theEnzyme = "HindIII-MspI";
            this.initialCutSiteRemnant = new String[]{"AGCTT"};
            this.likelyReadEnd = new String[]{"CCGG", "AAGCTT", "CCGAGATC"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)hindiii-nlaiii|(?i)hind3-nla3")) {
            this.theEnzyme = "HindIII-NlaIII";
            this.initialCutSiteRemnant = new String[]{"AGCTT"};
            this.likelyReadEnd = new String[]{"CATG", "AAGCTT", "CATGAGATC"};
            this.readEndCutSiteRemnantLength = 4;
        } else if (enzyme.matches("(?i)sexa[i1]-sau3a[i1]")) {
            this.theEnzyme = "SexAI-Sau3AI";
            this.initialCutSiteRemnant = new String[]{"CCAGGT", "CCTGGT"};
            this.likelyReadEnd = new String[]{"GATC", "ACCAGGT", "ACCTGGT", "GATCAGATC"};
            this.readEndCutSiteRemnantLength = 4;
        } else if (enzyme.matches("(?i)bamh[i1l]-mluc[i1]")) {
            this.theEnzyme = "BamHI-MluCI";
            this.initialCutSiteRemnant = new String[]{"GATCC"};
            this.likelyReadEnd = new String[]{"AATT", "GGATCC", "AATTAGATC"};
            this.readEndCutSiteRemnantLength = 4;
        } else if (enzyme.matches("(?i)pst[i1]-mluc[i1]")) {
            this.theEnzyme = "PstI-MluCI";
            this.initialCutSiteRemnant = new String[]{"TGCAG"};
            this.likelyReadEnd = new String[]{"AATT", "CTGCAG", "AATTAGATC"};
            this.readEndCutSiteRemnantLength = 4;
        } else if (enzyme.matches("(?i)psti-msei|(?i)pst1-mse1")) {
            this.theEnzyme = "PstI-MseI";
            this.initialCutSiteRemnant = new String[]{"TGCAG"};
            this.likelyReadEnd = new String[]{"TTAA", "CTGCAG", "TTAAGATC"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)avaii-msei|(?i)ava2-mse1")) {
            this.theEnzyme = "AvaII-MseI";
            this.initialCutSiteRemnant = new String[]{"GACC", "GTCC"};
            this.likelyReadEnd = new String[]{"TTAA", "GGACC", "GGTCC", "TTAAGATC"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)ecori-msei|(?i)ecor1-mse1")) {
            this.theEnzyme = "EcoRI-MseI";
            this.initialCutSiteRemnant = new String[]{"AATTC"};
            this.likelyReadEnd = new String[]{"TTAA", "GAATTC", "TTAAGATC"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)ecori-avaii|(?i)ecor1-ava2")) {
            this.theEnzyme = "EcoRI-AvaII";
            this.initialCutSiteRemnant = new String[]{"AATTC"};
            this.likelyReadEnd = new String[]{"GGACC", "GGTCC", "GAATTC", "GGACAGATC", "GGTCAGATC"};
            this.readEndCutSiteRemnantLength = 4;
        } else if (enzyme.matches("(?i)ecori-hinfi|(?i)ecor1-hinf1")) {
            this.theEnzyme = "EcoRI-HinfI";
            this.initialCutSiteRemnant = new String[]{"AATTC"};
            this.likelyReadEnd = new String[]{"GAATC", "GACTC", "GAGTC", "GATTC", "GAATTC", "GAATAGATC", "GACTAGATC", "GAGTAGATC", "GATTAGATC"};
            this.readEndCutSiteRemnantLength = 4;
        } else if (enzyme.matches("(?i)bbvci-mspi|(?i)bbvc1-msp1")) {
            this.theEnzyme = "BbvCI-MspI";
            this.initialCutSiteRemnant = new String[]{"TCAGC"};
            this.likelyReadEnd = new String[]{"CCGG", "CCTCAGC", "CCGAGATC"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)msp[i1]-apek[i1]")) {
            this.theEnzyme = "MspI-ApeKI";
            this.initialCutSiteRemnant = new String[]{"CGG", "CAGC", "CTGC"};
            this.likelyReadEnd = new String[]{"CCGG", "GCAGC", "GCTGC", "CCGAGATCGG", "GCAGAGAT", "GCTGAGAT"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)apo[i1]")) {
            this.theEnzyme = "ApoI";
            this.initialCutSiteRemnant = new String[]{"AATTC", "AATTT"};
            this.likelyReadEnd = new String[]{"AAATTC", "AAATTT", "GAATTC", "GAATTT", "AAATTAGAT", "GAATTAGAT"};
            this.readEndCutSiteRemnantLength = 5;
        } else if (enzyme.matches("(?i)BamH[i1l]")) {
            this.theEnzyme = "BamHI";
            this.initialCutSiteRemnant = new String[]{"GATCC"};
            this.likelyReadEnd = new String[]{"GGATCC", "GGATCAGAT"};
            this.readEndCutSiteRemnantLength = 5;
        } else if (enzyme.matches("(?i)mse[i1]")) {
            this.theEnzyme = "MseI";
            this.initialCutSiteRemnant = new String[]{"TAA"};
            this.likelyReadEnd = new String[]{"TTAA", "TTAAGAT"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)Sau3A[i1]")) {
            this.theEnzyme = "Sau3AI";
            this.initialCutSiteRemnant = new String[]{"GATC"};
            this.likelyReadEnd = new String[]{"GATC", "GATCAGAT"};
            this.readEndCutSiteRemnantLength = 4;
        } else if (enzyme.matches("(?i)nde[i1]")) {
            this.theEnzyme = "NdeI";
            this.initialCutSiteRemnant = new String[]{"TATG"};
            this.likelyReadEnd = new String[]{"CATATG", "CATAAGAT"};
            this.readEndCutSiteRemnantLength = 4;
        } else if (enzyme.matches("(?i)hinp1[i1]")) {
            this.theEnzyme = "HinP1I";
            this.initialCutSiteRemnant = new String[]{"CGC"};
            this.likelyReadEnd = new String[]{"GCGC", "GCGAGAT"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)sbf[i1]")) {
            this.theEnzyme = "SbfI";
            this.initialCutSiteRemnant = new String[]{"TGCAGG"};
            this.likelyReadEnd = new String[]{"CCTGCAGG", "CCTGCAAGAT"};
            this.readEndCutSiteRemnantLength = 6;
        } else if (enzyme.matches("(?i)hindiii|(?i)hind3")) {
            this.theEnzyme = "HindIII";
            this.initialCutSiteRemnant = new String[]{"AGCTT"};
            this.likelyReadEnd = new String[]{"AAGCTT", "AAGCTAGAT"};
            this.readEndCutSiteRemnantLength = 5;
        } else if (enzyme.matches("(?i)ecor[i1]")) {
            this.theEnzyme = "EcoRI";
            this.initialCutSiteRemnant = new String[]{"AATTC"};
            this.likelyReadEnd = new String[]{"GAATTC", "GAATTAGAT"};
            this.readEndCutSiteRemnantLength = 5;
        } else if (enzyme.matches("(?i)cviq[i1]")) {
            this.theEnzyme = "CviQI";
            this.initialCutSiteRemnant = new String[]{"TAC"};
            this.likelyReadEnd = new String[]{"GTAC", "GTAAGATCGG"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)csp6[i1]")) {
            this.theEnzyme = "Csp6I";
            this.initialCutSiteRemnant = new String[]{"TAC"};
            this.likelyReadEnd = new String[]{"GTAC", "GTAAGATCGG"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)nlaiii|(?i)nla3")) {
            this.theEnzyme = "NlaIII";
            this.initialCutSiteRemnant = new String[]{"CATG"};
            this.likelyReadEnd = new String[]{"CATG", "CATGAGAT"};
            this.readEndCutSiteRemnantLength = 4;
        } else if (enzyme.matches("(?i)sph[i1]")) {
            this.theEnzyme = "SphI";
            this.initialCutSiteRemnant = new String[]{"CATGC"};
            this.likelyReadEnd = new String[]{"GCATGC", "GCATGAGAT"};
            this.readEndCutSiteRemnantLength = 5;
        } else if (enzyme.matches("(?i)nsp[i1]")) {
            this.theEnzyme = "NspI";
            this.initialCutSiteRemnant = new String[]{"CATGC", "CATGT"};
            this.likelyReadEnd = new String[]{"ACATGT", "GCATGC", "ACATGAGAT", "GCATGAGAT"};
            this.readEndCutSiteRemnantLength = 5;
        } else if (enzyme.matches("(?i)kpn[i1]")) {
            this.theEnzyme = "KpnI";
            this.initialCutSiteRemnant = new String[]{"GTACC"};
            this.likelyReadEnd = new String[]{"GGTACC", "GGTACAGAT"};
            this.readEndCutSiteRemnantLength = 5;
        } else if (enzyme.matches("(?i)sty[i1]")) {
            this.theEnzyme = "StyI";
            this.initialCutSiteRemnant = new String[]{"CAAGG", "CATGG", "CTAGG", "CTTGG"};
            this.likelyReadEnd = new String[]{"CCAAGG", "CCATGG", "CCTAGG", "CCTTGG", "CCAAGAGAT", "CCATGAGAT", "CCTAGAGAT", "CCTTGAGAT"};
            this.readEndCutSiteRemnantLength = 5;
        } else if (enzyme.matches("(?i)styi-msei|(?i)sty1-mse1")) {
            this.theEnzyme = "StyI-MseI";
            this.initialCutSiteRemnant = new String[]{"CAAGG", "CATGG", "CTAGG", "CTTGG"};
            this.likelyReadEnd = new String[]{"TTAA", "CCAAGG", "CCATGG", "CCTAGG", "CCTTGG", "TTAAGAT"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)fse[i1]")) {
            this.theEnzyme = "FseI";
            this.initialCutSiteRemnant = new String[]{"CCGGCC"};
            this.likelyReadEnd = new String[]{"GGCCGGCC", "AGATCGGAAG"};
            this.readEndCutSiteRemnantLength = 0;
        } else if (enzyme.matches("(?i)NgoMIV|(?i)NgoM4")) {
            this.theEnzyme = "NgoMIV";
            this.initialCutSiteRemnant = new String[]{"CCGGC"};
            this.likelyReadEnd = new String[]{"GCCGGC", "AGATCGGAAG"};
            this.readEndCutSiteRemnantLength = 0;
        } else if (enzyme.matches("(?i)msl[i1]")) {
            this.theEnzyme = "MslI";
            this.initialCutSiteRemnant = new String[]{""};
            this.likelyReadEnd = new String[]{"AGATCGGA"};
            this.readEndCutSiteRemnantLength = 0;
        } else if (enzyme.matches("(?i)ase[i1]")) {
            this.theEnzyme = "AseI";
            this.initialCutSiteRemnant = new String[]{"TAAT"};
            this.likelyReadEnd = new String[]{"ATTAAT", "ATTAAGAT"};
            this.readEndCutSiteRemnantLength = 4;
        } else if (enzyme.matches("(?i)avaii|(?i)ava2")) {
            this.theEnzyme = "AvaII";
            this.initialCutSiteRemnant = new String[]{"GACC", "GTCC"};
            this.likelyReadEnd = new String[]{"GGACC", "GGTCC", "GGACAGAT", "GGTCAGAT"};
            this.readEndCutSiteRemnantLength = 4;
        } else if (enzyme.matches("(?i)kpn[i1]-msp[i1]")) {
            this.theEnzyme = "KpnI-MspI";
            this.initialCutSiteRemnant = new String[]{"GTACC"};
            this.likelyReadEnd = new String[]{"CCGG", "GGTACC", "CCGAGATC"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)RBSTA")) {
            this.theEnzyme = "RBSTA";
            this.initialCutSiteRemnant = new String[]{"TA"};
            this.likelyReadEnd = new String[]{"TTAA", "GTAC", "CTAG", "TTAAGAT", "GTAAGAT", "CTAAGAT"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)RBSCG")) {
            this.theEnzyme = "RBSCG";
            this.initialCutSiteRemnant = new String[]{"CG"};
            this.likelyReadEnd = new String[]{"CCGC", "TCGA", "GCGC", "CCGG", "ACGT", "CCGAGAT", "TCGAGAT", "GCGAGAT", "ACGAGAT"};
            this.readEndCutSiteRemnantLength = 3;
        } else if (enzyme.matches("(?i)ignore")) {
            this.theEnzyme = "unspecified";
            this.initialCutSiteRemnant = new String[]{""};
            this.likelyReadEnd = new String[]{"AGATCGGA"};
            this.readEndCutSiteRemnantLength = 0;
        } else {
            this.enyzmeErrorMessage();
            this.theEnzyme = null;
            this.initialCutSiteRemnant = null;
            this.likelyReadEnd = null;
            this.readEndCutSiteRemnantLength = -1;
        }
        System.out.println("Enzyme: " + enzyme);
    }

    private void enyzmeErrorMessage() {
        System.out.println("The software didn't recognize your restriction enzyme (-e option).\nCurrently, only the following enzymes are recognized for single enzyme digests:\n  ApeKI\n  ApoI\n  AseI\n  AvaII\n  BamHI\n  Csp6I\n  CviQI\n  EcoRI\n  EcoT22I\n  FseI\n  HindIII\n  HinP1I\n  HpaII\n  KpnI\n  MseI\n  MslI\n  MspI\n  NdeI\n  NgoMIV\n  NlaIII\n  NspI\n  PasI\n  PstI\n  Sau3AI\n  SbfI\n  SphI\n  StyI\n  RBSTA\n  RBSCG\n  ignore\nOr the following for two-enzyme digests:\n  AsiSI-MspI\n  AvaII-MseI\n  BamHI-MluCI\n  BbvCI-MspI\n  BssHII-MspI\n  EcoRI-AvaII\n  EcoRI-HinfI\n  EcoRI-MseI\n  EcoRI-MspI\n  FseI-MspI\n  HindIII-MspI\n  HindIII-NlaIII\n  KpnI-MspI\n  MspI-ApeKI\n  NsiI-MspI\n  PaeR7I-HhaI\n  PstI-ApeKI\n  PstI-BfaI\n  PstI-EcoT22I\n  PstI-MluCI\n  PstI-MseI\n  PstI-MspI\n  PstI-MspI-GDFcustom\n  PstI-TaqI\n  SbfI-BfaI\n  SbfI-HpaII\n  SalI-MspI\n  SbfI-MspI\n  SexAI-Sau3AI\n  SphI-EcoRI\n  StyI-MseI\n  ignore\n");
        System.out.println("For two-enzyme digest, enzyme names should be separated by a dash, e.g. -e PstI-MspI");
        System.out.println("\nIf your enzyme is not on the above list you can use \"-e ignore\". In this case\n   barcodes and common adapter start sequences will be recognized, but chimeric DNA\n   fragments (or partial digests) will not be trimmed.");
    }

    public String enzyme() {
        return this.theEnzyme;
    }

    public String[] initialCutSiteRemnant() {
        return this.initialCutSiteRemnant;
    }

    public String[] likelyReadEnd() {
        return this.likelyReadEnd;
    }

    public int readEndCutSiteRemnantLength() {
        return this.readEndCutSiteRemnantLength;
    }
}

