/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.v2;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.LongAdder;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.Barcode;
import net.maizegenetics.analysis.gbs.v2.BarcodeTrie;
import net.maizegenetics.analysis.gbs.v2.GBSEnzyme;
import net.maizegenetics.analysis.gbs.v2.GBSUtils;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.snp.Allele;
import net.maizegenetics.dna.snp.ExportUtils;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.SimpleAllele;
import net.maizegenetics.dna.snp.genotypecall.BasicGenotypeMergeRule;
import net.maizegenetics.dna.snp.genotypecall.GenotypeMergeRule;
import net.maizegenetics.dna.snp.score.AlleleDepthUtil;
import net.maizegenetics.dna.tag.Tag;
import net.maizegenetics.dna.tag.TagBuilder;
import net.maizegenetics.dna.tag.TagData;
import net.maizegenetics.dna.tag.TagDataSQLite;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListIOUtils;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.DirectoryCrawler;
import net.maizegenetics.util.Utils;
import org.ahocorasick.trie.Emit;
import org.ahocorasick.trie.Trie;
import org.apache.log4j.Logger;

public class ProductionSNPCallerPluginV2
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(ProductionSNPCallerPluginV2.class);
    private PluginParameter<String> myInputDir = new PluginParameter.Builder<String>("i", null, String.class).guiName("Input Directory").required(true).inDir().description("Input directory containing fastq AND/OR qseq files.").build();
    private PluginParameter<String> myKeyFile = new PluginParameter.Builder<String>("k", null, String.class).guiName("Key File").required(true).inFile().description("Key file listing barcodes distinguishing the samples").build();
    private PluginParameter<String> myEnzyme = new PluginParameter.Builder<String>("e", null, String.class).guiName("Enzyme").required(true).description("Enzyme used to create the GBS library").build();
    private PluginParameter<String> myInputDB = new PluginParameter.Builder<String>("db", null, String.class).guiName("Input GBS Database").required(true).inFile().description("Input Database file if using SQLite").build();
    private PluginParameter<String> myOutputGenotypes = new PluginParameter.Builder<String>("o", null, String.class).guiName("Output Genotypes File").required(true).outFile().description("Output (target) genotypes file to produce.  Default output file type is VCF.  If file suffix is .h5, an hdf5 file will be created instead.").build();
    private PluginParameter<Double> myAveSeqErrorRate = new PluginParameter.Builder<Double>("eR", 0.01, Double.class).guiName("Ave Seq Error Rate").description("Average sequencing error rate per base (used to decide between heterozygous and homozygous calls)").build();
    private PluginParameter<Integer> myMaxDivergence = new PluginParameter.Builder<Integer>("d", 0, Integer.class).guiName("Max Divergence").description("Maximum divergence (edit distance) between new read and previously mapped read (Default: 0 = perfect matches only)").build();
    private PluginParameter<Boolean> myKeepGenotypesOpen = new PluginParameter.Builder<Boolean>("ko", false, Boolean.class).guiName("Keep Genotypes Open").description("Only applicable to hdf5 output files: Keep hdf5 genotypes open for future runs that add more taxa or more depth").build();
    private PluginParameter<Boolean> myDepthOutput = new PluginParameter.Builder<Boolean>("do", true, Boolean.class).guiName("Write Depths to Output").description("Depth output: True means write depths to the output hdf5 genotypes file, false means do NOT write depths to the hdf5 file").build();
    private PluginParameter<Integer> myKmerLength = new PluginParameter.Builder<Integer>("kmerLength", 64, Integer.class).guiName("Maximum Kmer Length").description("Length of kmers to process").build();
    private PluginParameter<Double> posQualityScore = new PluginParameter.Builder<Double>("minPosQS", 0.0, Double.class).guiName("Minimun snp quality score").description("Minimum quality score for snp position to be included").build();
    private PluginParameter<Integer> myBatchSize = new PluginParameter.Builder<Integer>("batchSize", 8, Integer.class).guiName("Batch size of fastq files").required(false).description("Number of flow cells being processed simultaneously").build();
    private PluginParameter<Integer> myMinQualScore = new PluginParameter.Builder<Integer>("mnQS", 0, Integer.class).guiName("Minimum quality score").required(false).description("Minimum quality score within the barcode and read length to be accepted").build();
    private String myOutputDir = null;
    private static boolean isHDF5 = false;
    private TagData tagDataReader = null;
    Multimap<Taxon, Tag> tagCntMap = Multimaps.synchronizedMultimap((Multimap)ArrayListMultimap.create((int)384, (int)500000));
    private Set<String> seqFilesInKeyAndDir = new TreeSet<String>();
    protected static int readEndCutSiteRemnantLength;
    private Trie ahoCorasickTrie;
    private String[] likelyReadEndStrings;
    private Map<String, Integer> rawReadCountsMap = new TreeMap<String, Integer>();
    private Map<String, Integer> rawReadCountsForFullSampleName = Collections.synchronizedMap(this.rawReadCountsMap);
    private Map<String, Integer> matchedReadCountsMap = new TreeMap<String, Integer>();
    private Map<String, Integer> matchedReadCountsForFullSampleName = Collections.synchronizedMap(this.matchedReadCountsMap);
    private GenotypeMergeRule genoMergeRule = null;
    private boolean taglenException;

    public ProductionSNPCallerPluginV2() {
        super(null, false);
    }

    public ProductionSNPCallerPluginV2(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public void postProcessParameters() {
        try {
            this.myOutputDir = new File(this.outputGenotypesFile()).getCanonicalFile().getParent();
        }
        catch (IOException e) {
            throw new IllegalStateException("Problem resolving output directory:" + e);
        }
        this.genoMergeRule = new BasicGenotypeMergeRule(this.aveSeqErrorRate());
        if (!this.myOutputGenotypes.isEmpty() && this.outputGenotypesFile().endsWith(".h5")) {
            isHDF5 = true;
        }
        if (!this.myEnzyme.isEmpty()) {
            GBSEnzyme enzyme = new GBSEnzyme(this.enzyme());
            this.likelyReadEndStrings = enzyme.likelyReadEnd();
            readEndCutSiteRemnantLength = enzyme.readEndCutSiteRemnantLength();
        }
    }

    @Override
    public DataSet processData(DataSet input) {
        int batchSize = this.batchSize();
        Path keyPath = Paths.get(this.keyFile(), new String[0]).toAbsolutePath();
        List<Path> directoryFiles = DirectoryCrawler.listPaths("glob:*{.fq,fq.gz,fastq,fastq.txt,fastq.gz,fastq.txt.gz,_sequence.txt,_sequence.txt.gz}", Paths.get(this.myInputDir.value(), new String[0]).toAbsolutePath());
        if (directoryFiles.isEmpty()) {
            myLogger.warn((Object)"No files matching:glob:*{.fq,fq.gz,fastq,fastq.txt,fastq.gz,fastq.txt.gz,_sequence.txt,_sequence.txt.gz}");
            return null;
        }
        List<Path> inputSeqFiles = GBSUtils.culledFiles(directoryFiles, keyPath);
        if (inputSeqFiles.size() == 0) {
            return null;
        }
        this.tagDataReader = new TagDataSQLite(this.myInputDB.value());
        TaxaList masterTaxaList = TaxaListIOUtils.readTaxaAnnotationFile(this.keyFile(), "FullSampleName", new HashMap<String, String>(), true);
        this.writeInitialTaxaReadCounts(masterTaxaList);
        HashMap canonicalTag = new HashMap();
        this.tagDataReader.getTags().stream().forEach(t -> canonicalTag.put(t, t));
        int batchNum = inputSeqFiles.size() / batchSize;
        if (inputSeqFiles.size() % batchSize != 0) {
            ++batchNum;
        }
        System.out.println("ProductionSNPCallerPluginV2: Total batches to process: " + batchNum);
        PositionList positionList = this.tagDataReader.getSNPPositions(this.positionQualityScore());
        if (positionList == null || positionList.size() == 0) {
            String errMsg = "\nNo snp positons found with quality score of " + this.positionQualityScore() + ".\nPlease run UpdateSNPPositionQualityPlugin to add quality scores for your positions,\n then select snp positions within a quality range you have specified.\n";
            myLogger.error((Object)errMsg);
            return null;
        }
        GenotypeTableBuilder gtb = ProductionSNPCallerPluginV2.setUpGenotypeTableBuilder(this.outputGenotypesFile(), positionList, this.genoMergeRule);
        ArrayListMultimap tagsToIndex = ArrayListMultimap.create();
        this.tagDataReader.getAlleleMap().entries().stream().forEach(arg_0 -> this.lambda$processData$1(positionList, (Multimap)tagsToIndex, arg_0));
        this.taglenException = false;
        for (int idx = 0; idx < inputSeqFiles.size(); idx += batchSize) {
            this.tagCntMap.clear();
            int end = idx + batchSize;
            if (end > inputSeqFiles.size()) {
                end = inputSeqFiles.size();
            }
            ArrayList<Path> sub = new ArrayList<Path>();
            for (int jdx = idx; jdx < end; ++jdx) {
                sub.add(inputSeqFiles.get(jdx));
            }
            System.out.println("\nStart processing batch " + String.valueOf(idx / batchSize + 1));
            sub.parallelStream().forEach(inputSeqFile -> {
                try {
                    this.processFastQFile(masterTaxaList, keyPath, (Path)inputSeqFile, this.enzyme(), canonicalTag, this.kmerLength(), this.minimumQualityScore());
                }
                catch (StringIndexOutOfBoundsException oobe) {
                    oobe.printStackTrace();
                    myLogger.error((Object)oobe.getMessage());
                    this.setTagLenException();
                    return;
                }
            });
            if (this.taglenException) {
                return null;
            }
            this.tagCntMap.asMap().entrySet().stream().forEach(arg_0 -> this.lambda$processData$3((Multimap)tagsToIndex, positionList, gtb, arg_0));
            System.out.println("\nFinished processing batch " + String.valueOf(idx / batchSize + 1));
        }
        if (isHDF5) {
            if (this.keepGenotypesOpen().booleanValue()) {
                gtb.closeUnfinished();
            } else {
                gtb.build();
            }
        } else {
            GenotypeTable myGt = gtb.build();
            ExportUtils.writeToVCF(myGt, this.outputGenotypesFile(), this.depthToOutput());
        }
        this.writeReadsPerSampleReports(positionList.size());
        return null;
    }

    private static void callGenotypes(Taxon taxon, Collection<Tag> tags, Multimap<Tag, AlleleWithPosIndex> tagsToIndex, PositionList positionList, GenotypeMergeRule genoMergeRule, GenotypeTableBuilder gtb, boolean outputDepths) {
        int[][] alleleDepths = new int[6][positionList.numberOfSites()];
        tags.stream().map(t -> tagsToIndex.get(t)).flatMap(c -> c.stream()).forEach(a -> {
            int[] nArray = alleleDepths[a.allele()];
            int n = a.positionIndex();
            nArray[n] = nArray[n] + 1;
        });
        if (outputDepths) {
            byte[][] byteDepths = AlleleDepthUtil.depthIntToByte(alleleDepths);
            gtb.addTaxon(taxon, ProductionSNPCallerPluginV2.resolveGenosForTaxon(alleleDepths, genoMergeRule), byteDepths);
        } else {
            gtb.addTaxon(taxon, ProductionSNPCallerPluginV2.resolveGenosForTaxon(alleleDepths, genoMergeRule));
        }
    }

    private void processFastQFile(TaxaList masterTaxaList, Path keyPath, Path fastQPath, String enzymeName, Map<Tag, Tag> canonicalTags, int preferredTagLength, int minQual) throws StringIndexOutOfBoundsException {
        ArrayList<Taxon> tl = GBSUtils.getLaneAnnotatedTaxaList(keyPath, fastQPath);
        BarcodeTrie barcodeTrie = GBSUtils.initializeBarcodeTrie(tl, masterTaxaList, new GBSEnzyme(enzymeName));
        this.processFastQ(fastQPath, barcodeTrie, canonicalTags, preferredTagLength, minQual);
    }

    private void processFastQ(Path fastqFile, BarcodeTrie barcodeTrie, Map<Tag, Tag> canonicalTags, int preferredTagLength, int minQual) throws StringIndexOutOfBoundsException {
        int allReads = 0;
        int goodBarcodedReads = 0;
        int lowQualityReads = 0;
        try {
            String[] seqAndQual;
            int qualityScoreBase = GBSUtils.determineQualityScoreBase(fastqFile);
            BufferedReader br = Utils.getBufferedReader(fastqFile.toString(), 0x400000);
            long time = System.nanoTime();
            while ((seqAndQual = GBSUtils.readFastQBlock(br, allReads)) != null) {
                ++allReads;
                Barcode barcode = barcodeTrie.longestPrefix(seqAndQual[0]);
                if (barcode == null) continue;
                if (minQual > 0 && BaseEncoder.getFirstLowQualityPos(seqAndQual[1], minQual, qualityScoreBase) < barcode.getBarLength() + preferredTagLength) {
                    ++lowQualityReads;
                    continue;
                }
                this.rawReadCountsForFullSampleName.put(barcode.getTaxaName(), this.rawReadCountsForFullSampleName.get(barcode.getTaxaName()) + 1);
                int barcodeLen = barcode.getBarLength();
                if (seqAndQual[0].length() - barcodeLen < preferredTagLength) {
                    String errMsg = "\n\nERROR processing " + fastqFile.toString() + "\nReading entry number " + allReads + " fails the length test.\nSequence length " + seqAndQual[0].length() + " minus barcode length " + barcodeLen + " is less than kmerLength " + preferredTagLength + ".\nRe-run your files with either a shorter kmerLength value or a higher minimum quality score.\n";
                    throw new StringIndexOutOfBoundsException(errMsg);
                }
                Tag tag = this.removeSecondCutSiteIndexOf(seqAndQual[0].substring(barcodeLen), preferredTagLength);
                if (tag == null) continue;
                ++goodBarcodedReads;
                Tag canonicalTag = canonicalTags.get(tag);
                if (canonicalTag != null) {
                    this.tagCntMap.put((Object)barcode.getTaxon(), (Object)canonicalTag);
                    this.matchedReadCountsForFullSampleName.put(barcode.getTaxaName(), this.matchedReadCountsForFullSampleName.get(barcode.getTaxaName()) + 1);
                }
                if (allReads % 1000000 != 0) continue;
                myLogger.info((Object)("Total Reads:" + allReads + " Reads with barcode and cut site overhang:" + goodBarcodedReads + " rate:" + (System.nanoTime() - time) / (long)allReads + " ns/read"));
            }
            myLogger.info((Object)("Total number of reads in lane=" + allReads));
            myLogger.info((Object)("Total number of good barcoded reads=" + goodBarcodedReads));
            myLogger.info((Object)("Total number of low quality reads=" + lowQualityReads));
            myLogger.info((Object)"Timing process (sorting, collapsing, and writing TagCount to file).");
            myLogger.info((Object)("Process took " + (double)(System.nanoTime() - time) / 1000000.0 + " milliseconds for file " + fastqFile.toString()));
            br.close();
        }
        catch (Exception e) {
            myLogger.error((Object)("Good Barcodes Read: " + goodBarcodedReads));
            e.printStackTrace();
        }
    }

    private Tag removeSecondCutSiteIndexOf(String seq, int preferredLength) {
        Tag tag = null;
        if (this.enzyme().equalsIgnoreCase("ApeKI") && (seq.startsWith("CAGCTGC") || seq.startsWith("CTGCAGC"))) {
            seq = seq.substring(3, seq.length());
        }
        int indexOfReadEnd = -1;
        String shortSeq = seq.substring(20);
        for (String readEnd : this.likelyReadEndStrings) {
            int indx = shortSeq.indexOf(readEnd);
            if (indx <= 0 || indexOfReadEnd >= 0 && indx >= indexOfReadEnd) continue;
            indexOfReadEnd = indx;
        }
        if (indexOfReadEnd <= 0 || indexOfReadEnd + 20 + readEndCutSiteRemnantLength >= preferredLength) {
            byte seqEnd = (byte)Math.min(seq.length(), preferredLength);
            return TagBuilder.instance(seq.substring(0, seqEnd)).build();
        }
        tag = TagBuilder.instance(seq.substring(0, indexOfReadEnd + 20 + readEndCutSiteRemnantLength)).build();
        return tag;
    }

    private Tag removeSecondCutSiteAhoC(String seq, int preferredLength) {
        Tag tag = null;
        int cutSiteIndex = 9999;
        if (this.enzyme().equalsIgnoreCase("ApeKI") && (seq.startsWith("CAGCTGC") || seq.startsWith("CTGCAGC"))) {
            seq = seq.substring(3, seq.length());
        }
        Collection emits = null;
        try {
            emits = this.ahoCorasickTrie.parseText(seq.substring(20));
        }
        catch (Exception emitsEx) {
            System.out.println("ahoCorasick excep: seq: " + seq);
            emitsEx.printStackTrace();
            byte seqEnd = (byte)Math.min(seq.length(), preferredLength);
            return TagBuilder.instance(seq.substring(0, seqEnd)).build();
        }
        Iterator emitsEx = emits.iterator();
        if (emitsEx.hasNext()) {
            Emit emit = (Emit)emitsEx.next();
            cutSiteIndex = emit.getStart();
        }
        if (cutSiteIndex + 20 + readEndCutSiteRemnantLength < preferredLength) {
            tag = TagBuilder.instance(seq.substring(0, cutSiteIndex + 20 + readEndCutSiteRemnantLength)).build();
        } else {
            byte seqEnd = (byte)Math.min(seq.length(), preferredLength);
            tag = TagBuilder.instance(seq.substring(0, seqEnd)).build();
        }
        return tag;
    }

    private void reportProgress(int[] counters, long readSeqReadTime, long ifRRNotNullTime) {
        myLogger.info((Object)("totalReads:" + counters[0] + "  goodBarcodedReads:" + counters[1] + "  goodMatchedToTOPM:" + counters[2] + "  cumulReadSequenceTime: " + (double)readSeqReadTime / 1.0E9 + " sec  cumulProcessSequenceTime: " + (double)ifRRNotNullTime / 1.0E9 + " sec"));
    }

    private void reportTotals(Path fileName, int[] counters, int nFilesProcessed) {
        myLogger.info((Object)("Total number of reads in lane=" + counters[0]));
        myLogger.info((Object)("Total number of good, barcoded reads=" + counters[1]));
        myLogger.info((Object)("Total number of good, barcoded reads matched to the TOPM=" + counters[2]));
        myLogger.info((Object)("Finished reading " + nFilesProcessed + " of " + this.seqFilesInKeyAndDir.size() + " sequence files: " + fileName + "\n"));
    }

    private static GenotypeTableBuilder setUpGenotypeTableBuilder(String anOutputFile, PositionList positionList, GenotypeMergeRule mergeRule) {
        if (isHDF5) {
            File hdf5File = new File(anOutputFile);
            if (hdf5File.exists()) {
                myLogger.info((Object)("\nGenotypes will be added to existing HDF5 file:\n  " + anOutputFile + "\n"));
                return GenotypeTableBuilder.mergeTaxaIncremental(anOutputFile, mergeRule);
            }
            myLogger.info((Object)("\nThe target HDF5 file:\n  " + anOutputFile + "\ndoes not exist. A new HDF5 file of that name will be created \nto hold the genotypes from this run."));
            return GenotypeTableBuilder.getTaxaIncrementalWithMerging(anOutputFile, positionList, mergeRule);
        }
        GenotypeTableBuilder gtb = GenotypeTableBuilder.getTaxaIncremental(positionList, mergeRule);
        myLogger.info((Object)("\nOutput VCF file: \n" + anOutputFile + " \ncreated for genotypes from this run."));
        return gtb;
    }

    private static byte[] resolveGenosForTaxon(int[][] depthsForTaxon, GenotypeMergeRule genoMergeRule) {
        int nAlleles = depthsForTaxon.length;
        int[] depthsAtSite = new int[nAlleles];
        int nSites = depthsForTaxon[0].length;
        byte[] genos = new byte[nSites];
        for (int site = 0; site < nSites; ++site) {
            for (int allele = 0; allele < nAlleles; ++allele) {
                depthsAtSite[allele] = depthsForTaxon[allele][site];
            }
            genos[site] = genoMergeRule.callBasedOnDepth(depthsAtSite);
        }
        return genos;
    }

    private void writeReadsPerSampleReports(int tagsProcessed) {
        myLogger.info((Object)"\nWriting ReadsPerSample log file...");
        String outFileS = this.myOutputDir + File.separator + new File(this.keyFile()).getName();
        outFileS = outFileS.replaceAll(".txt", "_ReadsPerSample.log");
        outFileS = outFileS.replaceAll("_key", "");
        try {
            String msg = "ReadsPerSample log file: " + outFileS;
            myLogger.info((Object)msg);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(outFileS))), 65536);
            bw.write("FullSampleName\t\t\tgoodBarcodedReads\tgoodReadsMatchedToDataBase\n");
            for (String fullSampleName : this.rawReadCountsForFullSampleName.keySet()) {
                bw.write(fullSampleName + "\t" + this.rawReadCountsForFullSampleName.get(fullSampleName) + "\t\t" + this.matchedReadCountsForFullSampleName.get(fullSampleName) + "\n");
            }
            bw.close();
        }
        catch (Exception e) {
            myLogger.error((Object)("Couldn't write to ReadsPerSample log file: " + e));
            e.printStackTrace();
            System.exit(1);
        }
        myLogger.info((Object)("\n\nTotal number of SNPs processed with minimum quality score " + this.minimumQualityScore() + " was " + tagsProcessed + ".\n"));
        myLogger.info((Object)"   ...done\n");
    }

    private void writeInitialTaxaReadCounts(TaxaList tl) {
        tl.stream().forEach(taxon -> {
            this.rawReadCountsForFullSampleName.put(taxon.getName(), 0);
            this.matchedReadCountsForFullSampleName.put(taxon.getName(), 0);
        });
    }

    public void setTagLenException() {
        this.taglenException = true;
    }

    private void printFileNameConventions(String actualFileName) {
        String message = "\n\nError in parsing file name:\n   The raw sequence filename does not contain either 3, 4, or 5 underscore-delimited values.\n   Acceptable file naming conventions include the following (where FLOWCELL indicates the flowcell name and LANE is an integer):\n       FLOWCELL_LANE_fastq.gz\n       FLOWCELL_s_LANE_fastq.gz\n       code_FLOWCELL_s_LANE_fastq.gz\n       FLOWCELL_LANE_fastq.txt.gz\n       FLOWCELL_s_LANE_fastq.txt.gz\n       code_FLOWCELL_s_LANE_fastq.txt.gz\n       FLOWCELL_LANE_qseq.txt.gz\n       FLOWCELL_s_LANE_qseq.txt.gz\n       code_FLOWCELL_s_LANE_qseq.txt.gz\n\n   Actual Filename: " + actualFileName + "\n\n";
        myLogger.error((Object)message);
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Production SNP Caller";
    }

    @Override
    public String getToolTipText() {
        return "Production SNP Caller";
    }

    public TagData runPlugin(DataSet input) {
        return (TagData)this.performFunction(input).getData(0).getData();
    }

    public String inputDirectory() {
        return this.myInputDir.value();
    }

    public ProductionSNPCallerPluginV2 inputDirectory(String value) {
        this.myInputDir = new PluginParameter<String>(this.myInputDir, value);
        return this;
    }

    public String keyFile() {
        return this.myKeyFile.value();
    }

    public ProductionSNPCallerPluginV2 keyFile(String value) {
        this.myKeyFile = new PluginParameter<String>(this.myKeyFile, value);
        return this;
    }

    public String enzyme() {
        return this.myEnzyme.value();
    }

    public ProductionSNPCallerPluginV2 enzyme(String value) {
        this.myEnzyme = new PluginParameter<String>(this.myEnzyme, value);
        return this;
    }

    public String inputGBSDatabase() {
        return this.myInputDB.value();
    }

    public ProductionSNPCallerPluginV2 inputGBSDatabase(String value) {
        this.myInputDB = new PluginParameter<String>(this.myInputDB, value);
        return this;
    }

    public String outputGenotypesFile() {
        return this.myOutputGenotypes.value();
    }

    public ProductionSNPCallerPluginV2 outputGenotypesFile(String value) {
        this.myOutputGenotypes = new PluginParameter<String>(this.myOutputGenotypes, value);
        return this;
    }

    public Double aveSeqErrorRate() {
        return this.myAveSeqErrorRate.value();
    }

    public ProductionSNPCallerPluginV2 aveSeqErrorRate(Double value) {
        this.myAveSeqErrorRate = new PluginParameter<Double>(this.myAveSeqErrorRate, value);
        return this;
    }

    public Integer maxDivergence() {
        return this.myMaxDivergence.value();
    }

    public ProductionSNPCallerPluginV2 maxDivergence(Integer value) {
        this.myMaxDivergence = new PluginParameter<Integer>(this.myMaxDivergence, value);
        return this;
    }

    public Boolean keepGenotypesOpen() {
        return this.myKeepGenotypesOpen.value();
    }

    public ProductionSNPCallerPluginV2 keepGenotypesOpen(Boolean value) {
        this.myKeepGenotypesOpen = new PluginParameter<Boolean>(this.myKeepGenotypesOpen, value);
        return this;
    }

    public Boolean depthToOutput() {
        return this.myDepthOutput.value();
    }

    public ProductionSNPCallerPluginV2 depthToOutput(Boolean value) {
        this.myDepthOutput = new PluginParameter<Boolean>(this.myDepthOutput, value);
        return this;
    }

    public Integer kmerLength() {
        return this.myKmerLength.value();
    }

    public ProductionSNPCallerPluginV2 kmerLength(Integer value) {
        this.myKmerLength = new PluginParameter<Integer>(this.myKmerLength, value);
        return this;
    }

    public Double positionQualityScore() {
        return this.posQualityScore.value();
    }

    public ProductionSNPCallerPluginV2 positionQualityScore(Double value) {
        this.posQualityScore = new PluginParameter<Double>(this.posQualityScore, value);
        return this;
    }

    public Integer batchSize() {
        return this.myBatchSize.value();
    }

    public ProductionSNPCallerPluginV2 batchSize(Integer value) {
        this.myBatchSize = new PluginParameter<Integer>(this.myBatchSize, value);
        return this;
    }

    public Integer minimumQualityScore() {
        return this.myMinQualScore.value();
    }

    public ProductionSNPCallerPluginV2 minimumQualityScore(Integer value) {
        this.myMinQualScore = new PluginParameter<Integer>(this.myMinQualScore, value);
        return this;
    }

    private /* synthetic */ void lambda$processData$3(Multimap tagsToIndex, PositionList positionList, GenotypeTableBuilder gtb, Map.Entry e) {
        ProductionSNPCallerPluginV2.callGenotypes((Taxon)e.getKey(), (Collection)e.getValue(), (Multimap<Tag, AlleleWithPosIndex>)tagsToIndex, positionList, this.genoMergeRule, gtb, this.depthToOutput());
    }

    private /* synthetic */ void lambda$processData$1(PositionList positionList, Multimap tagsToIndex, Map.Entry e) {
        int posIndex = positionList.indexOf(((Allele)e.getValue()).position());
        if (posIndex >= 0) {
            tagsToIndex.put(e.getKey(), (Object)new AlleleWithPosIndex((Allele)e.getValue(), posIndex));
        }
    }

    private class CountOfReadQuality {
        LongAdder allReads = new LongAdder();
        LongAdder goodBarcodedReads = new LongAdder();
        LongAdder goodMatched = new LongAdder();
        LongAdder perfectMatches = new LongAdder();
        LongAdder imperfectMatches = new LongAdder();
        LongAdder singleImperfectMatches = new LongAdder();

        private CountOfReadQuality() {
        }
    }

    private class AlleleWithPosIndex
    extends SimpleAllele {
        private int positionIndex;

        private AlleleWithPosIndex(Allele myAllele, int positionIndex) {
            super(myAllele.allele(), myAllele.position());
            this.positionIndex = positionIndex;
        }

        public int positionIndex() {
            return this.positionIndex;
        }
    }
}

