/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.v2;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import java.awt.Frame;
import java.io.BufferedReader;
import java.util.Optional;
import java.util.Set;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.tag.SAMUtils;
import net.maizegenetics.dna.tag.Tag;
import net.maizegenetics.dna.tag.TagBuilder;
import net.maizegenetics.dna.tag.TagData;
import net.maizegenetics.dna.tag.TagDataSQLite;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.Tuple;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public final class SAMToGBSdbPlugin
extends AbstractPlugin {
    boolean cleanCutSites = true;
    private static final Logger myLogger = Logger.getLogger(SAMToGBSdbPlugin.class);
    private PluginParameter<String> myInputFile = new PluginParameter.Builder<String>("i", null, String.class).guiName("SAM Input File").required(true).inFile().description("Name of input file in SAM text format").build();
    private PluginParameter<String> myOutputFile = new PluginParameter.Builder<String>("db", null, String.class).guiName("GBS DB File").required(true).outFile().description("Name of output file (e.g. GBSv2.db)").build();
    private PluginParameter<Double> alignProportion = new PluginParameter.Builder<Double>("aProp", 0.0, Double.class).guiName("SAM Min Align Proportion").required(false).range((Range<Comparable<Double>>)Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0))).description("Minimum proportion of sequence that must align to store the SAM entry").build();
    private PluginParameter<Integer> minAlignLength = new PluginParameter.Builder<Integer>("aLen", 0, Integer.class).guiName("SAM Min Align Length").required(false).range((Range<Comparable<Integer>>)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1000))).description("Minimum length of bps aligning to store the SAM entry").build();
    private PluginParameter<String> mappingApproach = new PluginParameter.Builder<String>("mapper", "BWA", String.class).guiName("Mapper").required(false).description("Mapping approach (one of Bowtie2, BWA, or bwaMem)").build();
    private PluginParameter<Boolean> myDeleteOldData = new PluginParameter.Builder<Boolean>("deleteOldData", true, Boolean.class).guiName("Delete Old Data").description("Delete existing SNP data from db tables").build();
    private PluginParameter<Integer> minMAPQ = new PluginParameter.Builder<Integer>("minMAPQ", 0, Integer.class).guiName("SAM Min MAPQ value").required(false).description("Minimum value of MAPQ to store the SAM entry").build();
    private static int mapQBad = 0;
    private static int mapQGood = 0;

    public SAMToGBSdbPlugin() {
        super(null, false);
    }

    public SAMToGBSdbPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        int tagsNotFoundInDB = 0;
        int tagsNotMapped = 0;
        try {
            String inputLine;
            BufferedReader bw = Utils.getBufferedReader(this.sAMInputFile());
            TagDataSQLite tagData = new TagDataSQLite(this.gBSDBFile());
            if (this.deleteOldData().booleanValue()) {
                myLogger.info((Object)"deleteOldData is TRUE: Clearing existing Alignment, Discovery and SNPQuality data");
                tagData.clearSNPQualityData();
                tagData.clearDiscoveryData();
                tagData.clearAlignmentData();
            }
            Set<Tag> knownTags = tagData.getTags();
            HashMultimap tagPositions = HashMultimap.create((int)knownTags.size(), (int)2);
            while ((inputLine = bw.readLine()) != null) {
                if (inputLine.startsWith("@")) {
                    if (!inputLine.contains("bowtie2")) continue;
                    this.mappingApproach("Bowtie2");
                    continue;
                }
                Tuple<Tag, Optional<Position>> tagPositionTuple = this.parseRow(inputLine);
                if (tagPositionTuple == null) continue;
                tagPresence tagP = this.isKnownTag(inputLine, (Tag)tagPositionTuple.x, knownTags);
                if (tagP == tagPresence.notPresent) {
                    ++tagsNotFoundInDB;
                }
                if (((Optional)tagPositionTuple.y).isPresent()) {
                    if (tagP == tagPresence.originalPresent) {
                        String[] stringTokens = inputLine.split("\\s");
                        String origSeq = stringTokens[0].split("=")[1];
                        Tag oTag = TagBuilder.instance(origSeq).build();
                        tagPositions.put((Object)oTag, ((Optional)tagPositionTuple.y).get());
                        continue;
                    }
                    tagPositions.put(tagPositionTuple.x, ((Optional)tagPositionTuple.y).get());
                    continue;
                }
                ++tagsNotMapped;
            }
            bw.close();
            if (tagsNotFoundInDB == 0) {
                tagData.putTagAlignments((Multimap<Tag, Position>)tagPositions);
                myLogger.info((Object)("Finished reading SAM file and adding tags to DB.\nTotal number of tags mapped: " + tagPositions.keySet().size() + " (total mappings " + tagPositions.size() + ")\nTags not mapped: " + tagsNotMapped + "\nTags dropped due to minimum mapq value: " + mapQBad + "\n\n"));
            } else {
                System.out.println("Unobserved tags were found in the SAM file count= " + tagsNotFoundInDB);
                myLogger.info((Object)("Finished reading SAM file.  No Tags added to DB as " + tagsNotFoundInDB + " unobserved tags were found.\nPlease ensure all tags in the SAM file already exist in the DB.\n\n"));
            }
            tagData.close();
        }
        catch (Exception e) {
            myLogger.info((Object)("Catch in reading TagCount file e=" + e));
            e.printStackTrace();
        }
        return null;
    }

    private Tuple<Tag, Optional<Position>> parseRow(String inputLine) {
        boolean name = false;
        boolean flag = true;
        int chr = 2;
        int pos = 3;
        int cigar = 5;
        int tagS = 9;
        String[] s = inputLine.split("\\s+");
        String origSeq = s[0].split("=")[1];
        Tag tag = TagBuilder.instance(origSeq).build();
        int mapq = Integer.parseInt(s[4]);
        if (mapq < this.minMAPQ()) {
            ++mapQBad;
            return new Tuple<Tag, Optional<Position>>(tag, Optional.empty());
        }
        ++mapQGood;
        if (tag == null) {
            return null;
        }
        boolean forwardStrand = this.isForwardStrand(s[1]);
        int samPos = Integer.parseInt(s[3]);
        int[] alignSpan = SAMUtils.adjustCoordinates(s[5], samPos);
        int cutPos = forwardStrand ? alignSpan[0] : alignSpan[1];
        if (alignSpan[0] < 0 || alignSpan[1] < 0) {
            return new Tuple<Tag, Optional<Position>>(tag, Optional.empty());
        }
        if (!this.hasAlignment(s[1])) {
            return new Tuple<Tag, Optional<Position>>(tag, Optional.empty());
        }
        if (!this.hasMinAlignLength(s)) {
            return new Tuple<Tag, Optional<Position>>(tag, Optional.empty());
        }
        if (!this.hasMinAlignProportion(s)) {
            return new Tuple<Tag, Optional<Position>>(tag, Optional.empty());
        }
        Chromosome chromosome = new Chromosome(s[2]);
        String alignmentScore = this.getAlignmentScore(s);
        byte strand = (byte)(forwardStrand ? 1 : 0);
        GeneralPosition position = new GeneralPosition.Builder(chromosome, cutPos).strand(strand).addAnno("forward", forwardStrand ? "true" : "false").addAnno("mappingapproach", this.mappingApproach()).addAnno("cigar", s[5]).addAnno("supportvalue", alignmentScore).build();
        return new Tuple<Tag, Optional<Position>>(tag, Optional.of(position));
    }

    private boolean hasAlignment(String samFlag) {
        int flag = Integer.parseInt(samFlag);
        return (flag & 4) == 0;
    }

    private boolean isForwardStrand(String samFlag) {
        int flag = Integer.parseInt(samFlag);
        return (flag & 0x10) == 0;
    }

    private boolean hasMinAlignLength(String[] samReadParsed) {
        if (this.minAlignLength() == 0) {
            return true;
        }
        int matchLen = this.calculateNumberAligned(samReadParsed);
        return matchLen >= this.minAlignLength();
    }

    private boolean hasMinAlignProportion(String[] samRead) {
        if (this.minAlignProportion() == 0.0) {
            return true;
        }
        float seqLength = samRead[9].length();
        int matchLen = this.calculateNumberAligned(samRead);
        float matchProportion = (float)matchLen / seqLength;
        return (double)matchProportion >= this.minAlignProportion();
    }

    private int calculateNumberAligned(String[] samRead) {
        String mdField = "";
        for (int index = 11; index < samRead.length; ++index) {
            String[] optField = samRead[index].split(":");
            if (!optField[0].equals("MD")) continue;
            mdField = samRead[index];
            break;
        }
        int matchLen = 0;
        if (!mdField.equals("")) {
            String mdVal = mdField.split(":")[2];
            int curNum = 0;
            for (int mdIdx = 0; mdIdx < mdVal.length(); ++mdIdx) {
                char currChar = mdVal.charAt(mdIdx);
                if (Character.isDigit(currChar)) {
                    curNum = curNum * 10 + Character.getNumericValue(currChar);
                    continue;
                }
                matchLen += curNum;
                curNum = 0;
            }
            matchLen += curNum;
        } else {
            String cigar = samRead[5];
            int curNum = 0;
            for (int cIdx = 0; cIdx < cigar.length(); ++cIdx) {
                char currChar = cigar.charAt(cIdx);
                if (Character.isDigit(currChar)) {
                    curNum = curNum * 10 + Character.getNumericValue(currChar);
                    continue;
                }
                if (currChar == 'M' || currChar == 'm') {
                    matchLen += curNum;
                }
                curNum = 0;
            }
            matchLen += curNum;
        }
        return matchLen;
    }

    private String getAlignmentScore(String[] samRead) {
        String asField = null;
        for (int index = 11; index < samRead.length; ++index) {
            String[] optField = samRead[index].split(":");
            if (!optField[0].equals("AS")) continue;
            asField = samRead[index].split(":")[2];
            break;
        }
        if (asField == null) {
            asField = "0";
        }
        return asField;
    }

    private tagPresence isKnownTag(String inputLine, Tag tag, Set knownTags) {
        if (knownTags.contains(tag)) {
            return tagPresence.present;
        }
        String[] stringTokens = inputLine.split("\\s");
        String origSeq = stringTokens[0].split("=")[1];
        Tag oTag = TagBuilder.instance(origSeq).build();
        if (knownTags.contains(oTag)) {
            return tagPresence.originalPresent;
        }
        return tagPresence.notPresent;
    }

    public SAMToGBSdbPlugin mappingApproach(String value) {
        this.mappingApproach = new PluginParameter<String>(this.mappingApproach, value);
        return this;
    }

    public String mappingApproach() {
        return this.mappingApproach.value();
    }

    public TagData runPlugin(DataSet input) {
        return (TagData)this.performFunction(input).getData(0).getData();
    }

    public String sAMInputFile() {
        return this.myInputFile.value();
    }

    public SAMToGBSdbPlugin sAMInputFile(String value) {
        this.myInputFile = new PluginParameter<String>(this.myInputFile, value);
        return this;
    }

    public String gBSDBFile() {
        return this.myOutputFile.value();
    }

    public SAMToGBSdbPlugin gBSDBFile(String value) {
        this.myOutputFile = new PluginParameter<String>(this.myOutputFile, value);
        return this;
    }

    public Double minAlignProportion() {
        return this.alignProportion.value();
    }

    public SAMToGBSdbPlugin minAlignProportion(Double value) {
        this.alignProportion = new PluginParameter<Double>(this.alignProportion, value);
        return this;
    }

    public Integer minAlignLength() {
        return this.minAlignLength.value();
    }

    public SAMToGBSdbPlugin minAlignLength(Integer value) {
        this.minAlignLength = new PluginParameter<Integer>(this.minAlignLength, value);
        return this;
    }

    public Integer minMAPQ() {
        return this.minMAPQ.value();
    }

    public SAMToGBSdbPlugin minMAPQ(Integer value) {
        this.minMAPQ = new PluginParameter<Integer>(this.minMAPQ, value);
        return this;
    }

    public Boolean deleteOldData() {
        return this.myDeleteOldData.value();
    }

    public SAMToGBSdbPlugin deleteOldData(Boolean value) {
        this.myDeleteOldData = new PluginParameter<Boolean>(this.myDeleteOldData, value);
        return this;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "SAM to TOPM Converter";
    }

    @Override
    public String getToolTipText() {
        return "SAM to TOPM Converter";
    }

    private static enum tagPresence {
        present,
        originalPresent,
        notPresent;

    }
}

