/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gobii;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import net.maizegenetics.analysis.gobii.BMSConnection;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class GOBIIPostgresConnection {
    private static final Logger myLogger = Logger.getLogger(GOBIIPostgresConnection.class);

    private GOBIIPostgresConnection() {
    }

    public static Connection connection(String propertiesFile) {
        Properties properties = new Properties();
        try {
            properties.load(Utils.getBufferedReader(propertiesFile));
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("GOBIIPostgresConnection: connection: problem reading properties file: " + propertiesFile);
        }
        String host = properties.getProperty("host");
        String user = properties.getProperty("user");
        String password = properties.getProperty("password");
        String dbName = properties.getProperty("DB");
        return GOBIIPostgresConnection.connection(host, user, password, dbName);
    }

    public static Connection connection(String host, String user, String password, String dbName) {
        Connection connection = null;
        String url = "jdbc:postgresql://" + host + "/" + dbName;
        try {
            Class.forName("org.postgresql.Driver");
            connection = DriverManager.getConnection(url, user, password);
        }
        catch (ClassNotFoundException e) {
            myLogger.error((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("GOBIIPostgresConnection: connection: org.postgresql.Driver can't be found");
        }
        catch (SQLException e) {
            myLogger.error((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("GOBIIPostgresConnection: connection: problem connecting to database: " + e.getMessage());
        }
        myLogger.info((Object)("Connected to database:  " + url + "\n"));
        return connection;
    }

    public static TaxaList taxaList(Connection postgres, String datasetName, Connection bms) {
        if (postgres == null) {
            throw new IllegalArgumentException("GOBIIPostgresConnection: taxaList: Must specify database connection.");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("select germplasm.external_code from dataset, dataset_dnarun, dnarun, dnasample, germplasm ");
        builder.append("where dataset.name='");
        builder.append(datasetName);
        builder.append("'");
        builder.append(" and dataset_dnarun.dataset_id = dataset.dataset_id");
        builder.append(" and dnarun.dnarun_id = dataset_dnarun.dnarun_id");
        builder.append(" and dnarun.dnasample_id = dnasample.dnasample_id");
        builder.append(" and dnasample.germplasm_id = germplasm.germplasm_id");
        builder.append(" order by dataset_dnarun.dnarun_idx;");
        String query = builder.toString();
        myLogger.info((Object)("taxaList: query statement: " + query));
        LinkedHashMap<String, Taxon.Builder> gids = new LinkedHashMap<String, Taxon.Builder>();
        try {
            ResultSet rs = postgres.createStatement().executeQuery(query);
            Object object = null;
            try {
                while (rs.next()) {
                    String string = rs.getString("external_code");
                    gids.put(string, null);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (object != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Exception se) {
            myLogger.debug((Object)se.getMessage(), (Throwable)se);
            throw new IllegalStateException("GOBIIPostgresConnection: taxaList: Problem querying the database: " + se.getMessage());
        }
        BMSConnection.taxaList(bms, gids);
        TaxaListBuilder taxa = new TaxaListBuilder();
        for (Map.Entry entry : gids.entrySet()) {
            taxa.add(((Taxon.Builder)entry.getValue()).build());
        }
        return taxa.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PositionList positionList(Connection connection, String datasetName) {
        if (connection == null) {
            throw new IllegalArgumentException("GOBIIPostgresConnection: positionList: Must specify database connection.");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("select marker.name, marker_linkage_group.start, marker_linkage_group.stop, linkage_group.name ");
        builder.append("from dataset, dataset_marker, marker, marker_linkage_group, linkage_group ");
        builder.append("where dataset.name='");
        builder.append(datasetName);
        builder.append("'");
        builder.append(" and dataset.dataset_id=dataset_marker.dataset_id");
        builder.append(" and dataset_marker.marker_id=marker.marker_id");
        builder.append(" and marker.marker_id=marker_linkage_group.marker_id");
        builder.append(" and marker_linkage_group.linkage_group_id=linkage_group.linkage_group_id");
        builder.append(" order by dataset_marker.marker_idx;");
        String query = builder.toString();
        myLogger.info((Object)("positionList: query statement: " + query));
        HashMap<String, Chromosome> chromosomes = new HashMap<String, Chromosome>();
        try (ResultSet rs = connection.createStatement().executeQuery(query);){
            PositionListBuilder positions = new PositionListBuilder();
            while (rs.next()) {
                int end;
                int start = rs.getInt("start");
                if (start != (end = rs.getInt("stop"))) {
                    throw new IllegalArgumentException("GOBIIPostgresConnection: positionList: start position: " + start + " and end position: " + end + " should be the same.");
                }
                String snpName = rs.getString(1);
                String chrStr = rs.getString(4);
                Chromosome chr = (Chromosome)chromosomes.get(chrStr);
                if (chr == null) {
                    chr = new Chromosome(chrStr);
                    chromosomes.put(chrStr, chr);
                }
                GeneralPosition.Builder current = new GeneralPosition.Builder(chr, start);
                current.snpName(snpName);
                positions.add(current.build());
            }
            PositionList positionList = positions.build();
            return positionList;
        }
        catch (Exception se) {
            myLogger.debug((Object)se.getMessage(), (Throwable)se);
            throw new IllegalStateException("GOBIIPostgresConnection: taxaList: Problem querying the database: " + se.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String hdf5Filename(Connection connection, String datasetName) {
        if (connection == null) {
            throw new IllegalArgumentException("GOBIIPostgresConnection: hdf5Filename: Must specify database connection.");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("select data_file ");
        builder.append("from dataset ");
        builder.append("where dataset.name='");
        builder.append(datasetName);
        builder.append("';");
        String query = builder.toString();
        myLogger.info((Object)("hdf5Filename: query statement: " + query));
        try (ResultSet rs = connection.createStatement().executeQuery(query);){
            if (!rs.next()) {
                throw new IllegalStateException("GOBIIPostgresConnection: hdf5Filename: dataset name: " + datasetName + " doesn't map to any hdf5 filename.");
            }
            String result = rs.getString("data_file");
            if (rs.next()) {
                throw new IllegalStateException("GOBIIPostgresConnection: hdf5Filename: dataset name: " + datasetName + " maps to more than one hdf5 filename.");
            }
            if (result == null) throw new IllegalStateException("GOBIIPostgresConnection: hdf5Filename: dataset name: " + datasetName + " doesn't map to any hdf5 filename.");
            if (result.length() == 0) {
                throw new IllegalStateException("GOBIIPostgresConnection: hdf5Filename: dataset name: " + datasetName + " doesn't map to any hdf5 filename.");
            }
            myLogger.info((Object)("Dataset Name: " + datasetName + " HDF5 Filename: " + result));
            String string = result;
            return string;
        }
        catch (Exception se) {
            myLogger.debug((Object)se.getMessage(), (Throwable)se);
            throw new IllegalStateException("GOBIIPostgresConnection: hdf5Filename: Problem querying the database: " + se.getMessage());
        }
    }

    public static void printAvailableDatasets(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("GOBIIPostgresConnection: printAvailableDatasets: Must specify database connection.");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("select name from dataset;");
        String query = builder.toString();
        myLogger.info((Object)("printAvailableDatasets: query statement: " + query));
        myLogger.info((Object)"Avaliable Datasets...");
        try (ResultSet rs = connection.createStatement().executeQuery(query);){
            while (rs.next()) {
                System.out.println(rs.getString("name"));
            }
        }
        catch (Exception se) {
            myLogger.debug((Object)se.getMessage(), (Throwable)se);
            throw new IllegalStateException("GOBIIPostgresConnection: printAvailableDatasets: Problem querying the database: " + se.getMessage());
        }
    }
}

