/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gobii;

import java.awt.Frame;
import java.io.BufferedWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gobii.GOBIIDbUtils;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class MonetDB_IFLFilePlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(MonetDB_IFLFilePlugin.class);
    private PluginParameter<String> dbConfigFile = new PluginParameter.Builder<String>("dbConfigFile", null, String.class).guiName("dbConfigFile").required(true).description("DB connection config file").build();
    private PluginParameter<String> datasetName = new PluginParameter.Builder<String>("datasetName", null, String.class).guiName("dataset name").required(true).description("Name of dataset whose marker and dnarun IDs are to be pulled").build();
    private PluginParameter<String> outputDir = new PluginParameter.Builder<String>("outputDir", null, String.class).guiName("Path of output directory").required(true).description("Full path name of output directory, must end with a /").build();

    public MonetDB_IFLFilePlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    public MonetDB_IFLFilePlugin() {
        super(null, false);
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return null;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    @Override
    public DataSet processData(DataSet input) {
        String dnarunFile = this.outputDir() + ".dnarun_id";
        String markerFile = this.outputDir() + ".marker_id";
        try {
            BufferedWriter writerRunID = Utils.getBufferedWriter(dnarunFile);
            BufferedWriter writerMarkerID = Utils.getBufferedWriter(markerFile);
            long time = System.nanoTime();
            Connection dbConnection = GOBIIDbUtils.connectToDB(this.dbConfigFile());
            if (dbConnection == null) {
                throw new IllegalStateException("MonetDB_IFLFilePlugin:processData: Problem connecting to database.");
            }
            StringBuilder builder = new StringBuilder();
            builder.append("select dnarun_id from dataset_dnarun, dataset where dataset.name = '");
            builder.append(this.datasetName());
            builder.append("'");
            builder.append(" and dataset.dataset_id = dataset_dnarun.dataset_id order by dnarun_idx;");
            String query = builder.toString();
            myLogger.info((Object)("processData: query statement: " + query));
            System.out.println("MonetDB_IFLFilePlugin: execute query: " + query);
            dbConnection.setAutoCommit(false);
            Statement st = dbConnection.createStatement();
            st.setFetchSize(100000);
            ResultSet rs = st.executeQuery(query);
            writerRunID.write("Header\n");
            while (rs.next()) {
                int dnarun_id = rs.getInt("dnarun_id");
                writerRunID.write(String.valueOf(dnarun_id));
                writerRunID.write("\n");
            }
            System.out.printf("TotalTime for dnarun_id query %g sec%n", (double)(System.nanoTime() - time) / 1.0E9);
            builder = new StringBuilder();
            builder.append("select marker_id from dataset_marker, dataset where dataset.name = '");
            builder.append(this.datasetName());
            builder.append("'");
            builder.append(" and dataset.dataset_id = dataset_marker.dataset_id order by marker_idx;");
            query = builder.toString();
            myLogger.info((Object)("processData: query statement: " + query));
            System.out.println("MonetDB_IFLFilePlugin: execute query: " + query);
            st.setFetchSize(100000);
            rs = st.executeQuery(query);
            while (rs.next()) {
                int marker_id = rs.getInt("marker_id");
                writerMarkerID.write(String.valueOf(marker_id));
                writerMarkerID.write("\n");
            }
            writerRunID.close();
            writerMarkerID.close();
            System.out.printf("TotalTime for marker_id query: %g sec%n", (double)(System.nanoTime() - time) / 1.0E9);
        }
        catch (Exception exc) {
            System.out.println("Monetdb_IFLFile:  caught exception processing writing files");
            exc.printStackTrace();
        }
        System.out.println("\nFiles written to " + dnarunFile + " and " + markerFile);
        return null;
    }

    public String dbConfigFile() {
        return this.dbConfigFile.value();
    }

    public MonetDB_IFLFilePlugin dbConfigFile(String value) {
        this.dbConfigFile = new PluginParameter<String>(this.dbConfigFile, value);
        return this;
    }

    public String datasetName() {
        return this.datasetName.value();
    }

    public MonetDB_IFLFilePlugin datasetName(String value) {
        this.datasetName = new PluginParameter<String>(this.datasetName, value);
        return this;
    }

    public String outputDir() {
        return this.outputDir.value();
    }

    public MonetDB_IFLFilePlugin outputDir(String value) {
        this.outputDir = new PluginParameter<String>(this.outputDir, value);
        return this;
    }
}

