/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gobii;

import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.ImageIcon;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.Utils;

public class SplitFile_IFLFilePlugin
extends AbstractPlugin {
    private PluginParameter<String> inFile = new PluginParameter.Builder<String>("inFile", null, String.class).guiName("Input FIle").required(true).description("Name of file to split.  It must have 1 and only 1 period in the name to separate dataset name from table name").build();
    private PluginParameter<Integer> maxSize = new PluginParameter.Builder<Integer>("maxSize", null, Integer.class).guiName("Maximum file size").required(true).description("Maximum size of each file after splitting.").build();
    private PluginParameter<String> outputDir = new PluginParameter.Builder<String>("outputDir", null, String.class).guiName("Path of output directory").required(true).description("Full path name of output directory, must end with a /").build();

    public SplitFile_IFLFilePlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    public SplitFile_IFLFilePlugin() {
        super(null, false);
    }

    @Override
    public DataSet processData(DataSet input) {
        BufferedReader br = Utils.getBufferedReader(this.inFile(), 0x400000);
        DataOutputStream bw = null;
        StringBuilder sb = new StringBuilder();
        int fileCount = 1;
        Path filePath = Paths.get(this.inFile(), new String[0]);
        String fileName = filePath.getFileName().toString();
        String[] fileparts = fileName.split("\\.");
        System.out.println("FileName is " + fileName + ", fileparts.length " + fileparts.length + "\n");
        if (fileparts.length != 2) {
            System.out.println("Input file must have 1 and only 1 period in the name to differentiate dataset name from table name");
            System.out.println("Inputfile example:  DS_4.marker");
            return null;
        }
        try {
            String line = br.readLine();
            String headerLine = line + "\n";
            int linecount = 0;
            int totalLines = 0;
            int maxBuffer = 10000;
            String outfile = this.outputDir() + fileparts[0] + "_" + fileCount + "." + fileparts[1];
            bw = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outfile)));
            bw.writeBytes(headerLine);
            ++fileCount;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
                if (++totalLines != this.maxSize() && ++linecount != maxBuffer) continue;
                bw.writeBytes(sb.toString());
                sb.setLength(0);
                if (totalLines == this.maxSize()) {
                    bw.close();
                    System.out.println("Wrote file " + outfile + " with lines " + totalLines);
                    outfile = this.outputDir() + fileparts[0] + "_" + fileCount + "." + fileparts[1];
                    bw = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outfile)));
                    bw.writeBytes(headerLine);
                    ++fileCount;
                    totalLines = 0;
                }
                linecount = 0;
            }
            if (linecount > 0) {
                bw.writeBytes(sb.toString());
                System.out.println("Wrote remaining lines to file " + outfile + " with lines " + linecount);
            }
            bw.close();
        }
        catch (Exception exc) {
            System.out.println("Whoops - error reading/writing file " + this.inFile() + " or outfile " + fileCount);
        }
        return null;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return null;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    public String inFile() {
        return this.inFile.value();
    }

    public SplitFile_IFLFilePlugin inFile(String value) {
        this.inFile = new PluginParameter<String>(this.inFile, value);
        return this;
    }

    public Integer maxSize() {
        return this.maxSize.value();
    }

    public SplitFile_IFLFilePlugin maxSize(Integer value) {
        this.maxSize = new PluginParameter<Integer>(this.maxSize, value);
        return this;
    }

    public String outputDir() {
        return this.outputDir.value();
    }

    public SplitFile_IFLFilePlugin outputDir(String value) {
        this.outputDir = new PluginParameter<String>(this.outputDir, value);
        return this;
    }
}

