/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.clustering.Haplotype;
import net.maizegenetics.analysis.clustering.HaplotypeCluster;
import net.maizegenetics.analysis.clustering.HaplotypeClusterer;
import net.maizegenetics.analysis.data.GetTaxaListPlugin;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.phenotype.NumericAttribute;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.phenotype.PhenotypeBuilder;
import net.maizegenetics.phenotype.TaxaAttribute;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.OpenBitSet;

public class ClusterGenotypesPlugin
extends AbstractPlugin {
    private GenotypeTable myGenotype;
    private String dataName;
    private final byte NN = (byte)-1;
    private static final Pattern comma_space = Pattern.compile("[,\\s]+");
    PluginParameter<Boolean> useSiteList = new PluginParameter.Builder<Boolean>("useSiteList", false, Boolean.class).description("If true, use the list of sites. If false, use start site and number of sites. (Default = false)").guiName("Use Site List").build();
    PluginParameter<Integer> startSiteIndex = new PluginParameter.Builder<Integer>("startSite", 0, Integer.class).description("Start the cluster at this site").guiName("Start Site").dependentOnParameter(this.useSiteList, false).build();
    PluginParameter<Integer> numberOfSites = new PluginParameter.Builder<Integer>("nsites", 30, Integer.class).description("Cluster this many sites. (Default = 30)").guiName("Number of Sites").dependentOnParameter(this.useSiteList, false).build();
    PluginParameter<String> siteList = new PluginParameter.Builder<String>("sites", null, String.class).description("Comma separated list of sites. Example: 1-5, 8, 10-12.").guiName("Site List").dependentOnParameter(this.useSiteList).build();
    PluginParameter<Integer> maxDiff = new PluginParameter.Builder<Integer>("maxDiff", 0, Integer.class).description("If the distance between two haplotypes is less than or equal to maxDiff, the haplotypes can be placed in the same cluster. (Default = 0)").guiName("Max Diff").build();
    PluginParameter<Integer> minHap = new PluginParameter.Builder<Integer>("minHap", 1, Integer.class).description("Only keep clusters that have minHap members or more. (Default = 1)").guiName("Min Hap").build();
    PluginParameter<Boolean> clusterOnce = new PluginParameter.Builder<Boolean>("unique", false, Boolean.class).description("Place each haplotype in only one cluster. (Default = false)").guiName("One cluster per Haplotype").build();
    PluginParameter<Boolean> noMissingValues = new PluginParameter.Builder<Boolean>("nomiss", false, Boolean.class).description("Use only haplotypes with no missing values. (Default = false)").guiName("No Missing Values").build();
    PluginParameter<Boolean> makePhenotype = new PluginParameter.Builder<Boolean>("convert", false, Boolean.class).description("Should the two biggest clusters be converted to a Phenotype? (Default = false)").guiName("Make Phenotype").build();

    public ClusterGenotypesPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        List<Datum> genotypes = input.getDataOfType(GenotypeTable.class);
        if (genotypes.size() != 1) {
            throw new IllegalArgumentException("Exactly one genotype data set must be selected");
        }
        this.myGenotype = (GenotypeTable)genotypes.get(0).getData();
        this.dataName = genotypes.get(0).getName();
    }

    @Override
    public DataSet processData(DataSet input) {
        byte[] haplotype;
        int t;
        ArrayList<Position> filterPositions;
        ArrayList<Haplotype> hapList = new ArrayList<Haplotype>();
        int ntaxa = this.myGenotype.numberOfTaxa();
        if (this.useSiteList.value().booleanValue()) {
            filterPositions = new ArrayList();
            List<Integer> siteNumberList = this.parseSiteList();
            for (Integer sitenumber : siteNumberList) {
                filterPositions.add((Position)this.myGenotype.positions().get(sitenumber));
            }
            int nsites = siteNumberList.size();
            for (t = 0; t < ntaxa; ++t) {
                haplotype = new byte[nsites];
                for (int s = 0; s < nsites; ++s) {
                    haplotype[s] = this.myGenotype.genotype(t, siteNumberList.get(s));
                }
                if (!this.noMissingValues.value().booleanValue()) {
                    hapList.add(new Haplotype(haplotype));
                    continue;
                }
                if (!this.hasNoMissingSites(haplotype)) continue;
                hapList.add(new Haplotype(haplotype));
            }
        } else {
            int startSite = this.startSiteIndex.value();
            int endSite = startSite + this.numberOfSites.value();
            filterPositions = this.myGenotype.positions().subList(startSite, endSite);
            for (t = 0; t < ntaxa; ++t) {
                haplotype = this.myGenotype.genotypeRange(t, startSite, endSite);
                if (!this.noMissingValues.value().booleanValue()) {
                    hapList.add(new Haplotype(haplotype));
                    continue;
                }
                if (!this.hasNoMissingSites(haplotype)) continue;
                hapList.add(new Haplotype(haplotype));
            }
        }
        PositionList filterPosList = PositionListBuilder.getInstance(filterPositions);
        if (hapList.size() < 2) {
            throw new RuntimeException("No haplotypes to cluster");
        }
        HaplotypeClusterer clusterMaker = new HaplotypeClusterer(hapList);
        clusterMaker.makeClusters();
        if (this.clusterOnce.value().booleanValue()) {
            clusterMaker.moveAllHaplotypesToBiggestCluster(this.maxDiff.value());
        } else {
            clusterMaker.mergeClusters(this.maxDiff.value());
        }
        clusterMaker.sortClusters();
        ArrayList<HaplotypeCluster> clusterList = clusterMaker.getClusterList();
        GenotypeTableBuilder genoBuilder = GenotypeTableBuilder.getTaxaIncremental(filterPosList);
        int count = 0;
        int minSize = this.minHap.value();
        for (HaplotypeCluster cluster2 : clusterList) {
            String name = String.format("Cluster%d:%d(%1.1f)", count++, cluster2.getSize(), cluster2.getScore());
            if (cluster2.getSize() < minSize) continue;
            genoBuilder.addTaxon(new Taxon(name), cluster2.getMajorityHaplotype());
        }
        ArrayList<Datum> resultList = new ArrayList<Datum>();
        String comment = String.format("Clusters built from %s\nusing maxDiff = %d and minHap = %d.", this.dataName, this.maxDiff.value(), this.minHap.value());
        Datum result = new Datum("Clusters_" + this.dataName, genoBuilder.build(), comment);
        resultList.add(result);
        if (this.makePhenotype.value().booleanValue()) {
            int taxonIndex;
            int nrows = clusterMaker.getClusterList().get(0).getSize();
            ArrayList<Taxon> taxa = new ArrayList<Taxon>(nrows += clusterMaker.getClusterList().get(1).getSize());
            float[] code = new float[nrows];
            OpenBitSet missing = new OpenBitSet(nrows);
            count = 0;
            for (Haplotype hap : clusterMaker.getClusterList().get(0).getHaplotypeList()) {
                taxonIndex = hap.taxonIndex;
                taxa.add((Taxon)this.myGenotype.taxa().get(taxonIndex));
                code[count++] = 0.0f;
            }
            for (Haplotype hap : clusterMaker.getClusterList().get(1).getHaplotypeList()) {
                taxonIndex = hap.taxonIndex;
                taxa.add((Taxon)this.myGenotype.taxa().get(taxonIndex));
                code[count++] = 1.0f;
            }
            ArrayList<PhenotypeAttribute> attrList = new ArrayList<PhenotypeAttribute>();
            ArrayList<Phenotype.ATTRIBUTE_TYPE> typeList = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
            attrList.add(new TaxaAttribute(taxa));
            attrList.add(new NumericAttribute("genotype", code, missing));
            typeList.add(Phenotype.ATTRIBUTE_TYPE.taxa);
            typeList.add(Phenotype.ATTRIBUTE_TYPE.data);
            Phenotype clusterCode = new PhenotypeBuilder().fromAttributeList(attrList, typeList).build().get(0);
            comment = String.format("Phenotype of two largest clusters \nfrom %s", this.dataName);
            result = new Datum("Coded_Cluster_" + this.dataName, clusterCode, comment);
            resultList.add(result);
        }
        return new DataSet(resultList, (Plugin)this);
    }

    private boolean hasNoMissingSites(byte[] geno) {
        boolean noMissing = true;
        for (byte b : geno) {
            if (b != -1) continue;
            noMissing = false;
        }
        return noMissing;
    }

    private List<Integer> parseSiteList() {
        ArrayList<Integer> siteNumbers = new ArrayList<Integer>();
        String siteListString = this.siteList.value();
        try {
            String[] items;
            for (String str : items = comma_space.split(siteListString)) {
                if ((str = str.trim()).contains("-")) {
                    String[] strints = str.split("-");
                    int start = Integer.parseInt(strints[0]);
                    int end = Integer.parseInt(strints[1]);
                    for (int i = start; i <= end; ++i) {
                        siteNumbers.add(i);
                    }
                    continue;
                }
                if (str.length() <= 0) continue;
                siteNumbers.add(Integer.parseInt(str));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Malformed site list: " + siteListString);
        }
        return siteNumbers;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = GetTaxaListPlugin.class.getResource("/net/maizegenetics/analysis/images/pca.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Cluster Genotypes";
    }

    @Override
    public String getToolTipText() {
        return "Cluster the genotypes in a dataset";
    }
}

