/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.imputation.EmissionProbability;
import net.maizegenetics.analysis.imputation.FILLINDonorGenotypeUtils;
import net.maizegenetics.analysis.imputation.FILLINImputationAccuracy;
import net.maizegenetics.analysis.imputation.FILLINImputationUtils;
import net.maizegenetics.analysis.imputation.ImputedTaxon;
import net.maizegenetics.analysis.imputation.TransitionProbability;
import net.maizegenetics.analysis.imputation.ViterbiAlgorithm;
import net.maizegenetics.analysis.popgen.DonorHypoth;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.DonorHaplotypes;
import net.maizegenetics.dna.snp.ExportUtils;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.dna.snp.ProjectionBuilder;
import net.maizegenetics.dna.snp.io.ProjectionGenotypeIO;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.GeneratePluginCode;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class FILLINImputationPlugin
extends AbstractPlugin {
    private int minMajorRatioToMinorCnt = 10;
    private PluginParameter<String> hmpFile = new PluginParameter.Builder<String>("hmp", null, String.class).guiName("Target file").inFile().required(true).description("Input HapMap file of target genotypes to impute. Accepts all file types supported by TASSEL5. This file should include _ALL_ available sites, not just those segregating in your material. (ie: don't filter the input)").build();
    private PluginParameter<String> donorFile = new PluginParameter.Builder<String>("d", null, String.class).guiName("Donor").required(true).description("Directory containing donor haplotype files from output of FILLINFindHaplotypesPlugin. All files with '.gc' in the filename will be read in, only those with matching sites are used. Alternately, a single file to use as a donor, will be cut into sub genos in size specified (eg, high densitySNP file for projection").build();
    private PluginParameter<String> outFileBase = new PluginParameter.Builder<String>("o", null, String.class).guiName("Output filename").outFile().required(true).description("Output file; hmp.txt.gz and .hmp.h5 accepted.").build();
    private PluginParameter<Integer> appoxSitesPerDonorGenotypeTable = new PluginParameter.Builder<Integer>("hapSize", 8000, Integer.class).guiName("Preferred haplotype size").description("Preferred haplotype block size in sites (use same as in FILLINFindHaplotypesPlugin)").build();
    private PluginParameter<Double> hetThresh = new PluginParameter.Builder<Double>("mxHet", 0.02, Double.class).guiName("Heterozygosity threshold").description("Threshold per taxon heterozygosity for treating taxon as heterozygous (no Viterbi, het thresholds).").build();
    private PluginParameter<Double> maximumInbredError = new PluginParameter.Builder<Double>("mxInbErr", 0.01, Double.class).guiName("Max error to impute one donor").description("Maximum error rate for applying one haplotype to entire site window").build();
    private PluginParameter<Double> maxHybridErrorRate = new PluginParameter.Builder<Double>("mxHybErr", 0.003, Double.class).guiName("Max combined error to impute two donors").description("Maximum error rate for applying Viterbi with two haplotypes to entire site window").build();
    private PluginParameter<Integer> minTestSites = new PluginParameter.Builder<Integer>("mnTestSite", 20, Integer.class).guiName("Min sites to test match").description("Minimum number of sites to test for IBS between haplotype and target in focus block").build();
    private PluginParameter<Integer> minMinorCnt = new PluginParameter.Builder<Integer>("minMnCnt", 20, Integer.class).guiName("Min num of minor alleles to compare").description("Minimum number of informative minor alleles in the search window (or " + this.minMajorRatioToMinorCnt + "X major)").build();
    private PluginParameter<Integer> maxDonorHypotheses = new PluginParameter.Builder<Integer>("mxDonH", 20, Integer.class).guiName("Max donor hypotheses").description("Maximum number of donor hypotheses to be explored. (Note: For heterozygous samples you may want to set this number higher, but the computation load goes up quickly.)").build();
    private PluginParameter<Boolean> imputeAllHets = new PluginParameter.Builder<Boolean>("impAllHets", false, Boolean.class).guiName("Impute all het calls").description("Write all imputed heterozygous calls as such, even if the original file has a homozygous call. (Not recommended for inbred lines.)").build();
    private PluginParameter<Boolean> hybridNN = new PluginParameter.Builder<Boolean>("hybNN", true, Boolean.class).guiName("Combine two haplotypes as heterozygote").description("If true, uses combination mode in focus block, else does not impute").build();
    private PluginParameter<Boolean> isOutputProjection = new PluginParameter.Builder<Boolean>("ProjA", false, Boolean.class).guiName("Output projection alignment").description("Create a projection alignment for high density markers").build();
    private PluginParameter<Boolean> imputeDonorFile = new PluginParameter.Builder<Boolean>("impDonor", false, Boolean.class).guiName("Impute donor file").description("Impute the donor file itself").build();
    private PluginParameter<Boolean> nonverboseOutput = new PluginParameter.Builder<Boolean>("nV", false, Boolean.class).guiName("Supress system out").description("Supress system out").build();
    private PluginParameter<Boolean> accuracy = new PluginParameter.Builder<Boolean>("accuracy", false, Boolean.class).guiName("Calculate accuracy").description("Masks input file before imputation and calculates accuracy based on masked genotypes").build();
    private PluginParameter<Double> propSitesMask = new PluginParameter.Builder<Double>("propSitesMask", 0.01, Double.class).guiName("Proportion of genotypes to mask if no depth").description("Proportion of genotypes to mask for accuracy calculation if depth not available").dependentOnParameter(this.accuracy).build();
    private PluginParameter<Integer> depthToMask = new PluginParameter.Builder<Integer>("depthMask", 9, Integer.class).guiName("Depth of genotypes to mask").description("Depth of genotypes to mask for accuracy calculation if depth information available").dependentOnParameter(this.accuracy).build();
    private PluginParameter<Double> propDepthSitesMask = new PluginParameter.Builder<Double>("propDepthSitesMask", 0.2, Double.class).guiName("Proportion of depth genotypes to mask").description("Proportion of genotypes of given depth to mask for accuracy calculation if depth available").dependentOnParameter(this.accuracy).build();
    private PluginParameter<String> maskKey = new PluginParameter.Builder<String>("maskKey", null, String.class).inFile().required(false).guiName("Optional key to calculate accuracy").description("Key to calculate accuracy. Genotypes missing (masked) in target file should be present in key, with all other sites set to missing. Overrides otheraccuracy options if present and all sites and taxa present in target file present").dependentOnParameter(this.accuracy).build();
    private PluginParameter<Boolean> byMAF = new PluginParameter.Builder<Boolean>("byMAF", false, Boolean.class).guiName("Calculate accuracy within MAF categories").description("Calculate R2 accuracy within MAF categories based on donor file").dependentOnParameter(this.accuracy).build();
    private boolean verboseOutput = true;
    private boolean twoWayViterbi = true;
    private double minimumDonorDistance = this.maximumInbredError.value() * 5.0;
    private double maxNonMedelian = this.maximumInbredError.value() * 5.0;
    private double maxHybridErrFocusHomo = 0.3333 * this.maxHybridErrorRate.value();
    private double maxInbredErrFocusHomo = 0.3 * this.maximumInbredError.value();
    private double maxSmashErrFocusHomo = this.maximumInbredError.value();
    private double maxInbredErrFocusHet = 0.1 * this.maximumInbredError.value();
    private double maxSmashErrFocusHet = this.maximumInbredError.value();
    public static GenotypeTable unimpAlign;
    public static GenotypeTable maskKeyAlign;
    public static double[] MAFClass;
    private int testing = 0;
    private boolean isSwapMajorMinor = true;
    private boolean resolveHetIfUndercalled = false;
    double[][] transition = new double[][]{{0.999, 1.0E-4, 3.0E-4, 1.0E-4, 5.0E-4}, {2.0E-4, 0.999, 5.0E-5, 5.0E-5, 2.0E-4}, {2.0E-4, 5.0E-5, 0.999, 5.0E-5, 2.0E-4}, {2.0E-4, 5.0E-5, 5.0E-5, 0.999, 2.0E-4}, {5.0E-4, 1.0E-4, 3.0E-4, 1.0E-4, 0.999}};
    double[][] emission = new double[][]{{0.998, 0.001, 0.001}, {0.6, 0.2, 0.2}, {0.4, 0.2, 0.4}, {0.2, 0.2, 0.6}, {0.001, 0.001, 0.998}};
    FILLINImputationAccuracy acc = null;
    private static final Logger myLogger;

    @Override
    protected void postProcessParameters() {
        System.out.println("Calling FILLINImputationPlugin.postProcessParameters()...");
        File parent = new File(this.outputFilename()).getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        this.minimumDonorDistance = this.maximumInbredError.value() * 5.0;
        this.maxNonMedelian = this.maximumInbredError.value() * 5.0;
        this.maxInbredErrFocusHomo = 0.3 * this.maximumInbredError.value();
        this.maxSmashErrFocusHomo = this.maximumInbredError.value();
        this.maxInbredErrFocusHet = 0.1 * this.maximumInbredError.value();
        this.maxSmashErrFocusHet = this.maximumInbredError.value();
        this.maxHybridErrFocusHomo = 0.3333 * this.maxHybridErrorRate.value();
        this.resolveHetIfUndercalled = this.imputeAllHets.value();
        if (this.nonverboseOutput.value().booleanValue()) {
            this.verboseOutput = false;
        }
        if (!this.byMAF.value().booleanValue()) {
            MAFClass = null;
        }
        if (!new File(this.donorFile.value()).exists()) {
            System.out.println("Donor is not a file or folder: " + this.donorFile.value());
        }
    }

    public FILLINImputationPlugin() {
        super(null, false);
    }

    public FILLINImputationPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public String getCitation() {
        return "Swarts K, Li H, Romero Navarro JA, An D, Romay MC, Hearne S, Acharya C, Glaubitz JC, Mitchell S, Elshire RJ, Buckler ES, Bradbury PJ (2014) Novel methods to optimize genotypic imputation for low-coverage, next-generation sequence data in crop plants. Plant Genome 7(3). doi:10.3835/plantgenome2014.05.0023";
    }

    @Override
    public DataSet processData(DataSet input) {
        long time = System.currentTimeMillis();
        String donor = this.donorFile.value();
        unimpAlign = ImportUtils.read(this.hmpFile.value());
        if (this.isOutputProjection.value().booleanValue()) {
            unimpAlign = FILLINDonorGenotypeUtils.RemoveSitesThatDoNotMatchMinMaj(this.donorFile.value(), unimpAlign, this.verboseOutput);
            donor = donor.subSequence(0, donor.lastIndexOf(".")) + ".matchMinMaj.hmp.txt.gz";
        }
        GenotypeTable[] donorAlign = FILLINDonorGenotypeUtils.loadDonors(donor, unimpAlign, this.minTestSites.value(), this.verboseOutput, this.appoxSitesPerDonorGenotypeTable.value());
        if (this.accuracy.value().booleanValue()) {
            time = System.currentTimeMillis() - time;
            if (this.maskKey.value() != null) {
                maskKeyAlign = ImportUtils.readGuessFormat(this.maskKey.value());
            }
            this.acc = new FILLINImputationAccuracy(unimpAlign, maskKeyAlign, donorAlign, this.propSitesMask.value(), this.depthToMask.value(), this.propDepthSitesMask.value(), this.outFileBase.value(), MAFClass, this.verboseOutput);
            unimpAlign = this.acc.initiateAccuracy();
            time = System.currentTimeMillis() - time;
        }
        OpenBitSet[][] conflictMasks = FILLINDonorGenotypeUtils.createMaskForAlignmentConflicts(unimpAlign, donorAlign, this.verboseOutput);
        System.out.printf("Unimputed taxa:%d sites:%d %n", unimpAlign.numberOfTaxa(), unimpAlign.numberOfSites());
        System.out.println("Creating Export GenotypeTable:" + this.outFileBase.value());
        Object mna = this.isOutputProjection.value().booleanValue() ? new ProjectionBuilder(ImportUtils.readGuessFormat(this.donorFile.value())) : (this.outFileBase.value().contains(".h5") ? GenotypeTableBuilder.getTaxaIncremental(unimpAlign.positions(), this.outFileBase.value()) : GenotypeTableBuilder.getTaxaIncremental(unimpAlign.positions()));
        int numThreads = Runtime.getRuntime().availableProcessors();
        System.out.println("Time to read in files and generate masks: " + (System.currentTimeMillis() - time) / 1000L + " sec");
        ExecutorService pool = Executors.newFixedThreadPool(numThreads);
        for (int taxon = 0; taxon < unimpAlign.numberOfTaxa(); ++taxon) {
            int[] trackBlockNN = new int[5];
            ImputeOneTaxon theTaxon = (double)unimpAlign.heterozygousCountForTaxon(taxon) / (double)unimpAlign.totalNonMissingForTaxon(taxon) < this.hetThresh.value() ? new ImputeOneTaxon(taxon, donorAlign, this.minTestSites.value(), conflictMasks, this.imputeDonorFile.value(), mna, trackBlockNN, this.maxInbredErrFocusHomo, this.maxHybridErrFocusHomo, this.maxSmashErrFocusHomo, true) : new ImputeOneTaxon(taxon, donorAlign, this.minTestSites.value(), conflictMasks, this.imputeDonorFile.value(), mna, trackBlockNN, this.maxInbredErrFocusHet, 0.0, this.maxSmashErrFocusHet, false);
            pool.execute(theTaxon);
        }
        pool.shutdown();
        try {
            if (!pool.awaitTermination(48L, TimeUnit.HOURS)) {
                System.out.println("processing threads timed out.");
            }
        }
        catch (Exception e) {
            System.out.println("Error processing threads");
        }
        System.out.println("");
        StringBuilder s = new StringBuilder();
        s.append(String.format("%s %s MinMinor:%d ", this.donorFile.value(), this.hmpFile.value(), this.minMinorCnt.value()));
        System.out.println(s.toString());
        double runtime = (double)(System.currentTimeMillis() - time) / 1000.0;
        System.out.printf("%d %g %d %n", this.minMinorCnt.value(), this.maximumInbredError.value(), this.maxDonorHypotheses.value());
        System.out.println("Runtime: " + runtime + " seconds");
        GenotypeTable out = null;
        if (this.isOutputProjection.value().booleanValue()) {
            out = ((ProjectionBuilder)mna).build();
            ProjectionGenotypeIO.writeToFile(this.outFileBase.value(), out);
        } else {
            GenotypeTableBuilder ab = (GenotypeTableBuilder)mna;
            ab.sortTaxa();
            out = ab.build();
            if (!ab.isHDF5()) {
                ExportUtils.writeToHapmap(out, false, this.outFileBase.value(), '\t', null);
            }
            if (this.accuracy.value().booleanValue()) {
                this.acc.calcAccuracy(ImportUtils.readGuessFormat(this.outFileBase.value()), runtime);
            }
        }
        return new DataSet(new Datum("outFile", out, null), null);
    }

    private ImputedTaxon solveEntireDonorRegion(int taxon, GenotypeTable donorAlign, int donorOffset, DonorHypoth[][] regionHypoth, ImputedTaxon impT, BitSet[] maskedTargetBits, double maxHybridErrorRate, byte[][][] targetToDonorDistances) {
        int blocks = maskedTargetBits[0].getNumWords();
        if (this.testing == 1) {
            System.out.println("Starting complete hybrid search");
        }
        int[] d = FILLINImputationUtils.bestDonorsAcrossEntireRegion(targetToDonorDistances, this.minTestSites.value(), this.maxDonorHypotheses.value());
        int[] testList = FILLINImputationUtils.fillInc(0, donorAlign.numberOfTaxa() - 1);
        int[] bestDonorList = Arrays.copyOfRange(d, 0, Math.min(d.length, 5));
        DonorHypoth[] bestDBasedOnBest = FILLINImputationUtils.findHeterozygousDonorHypoth(taxon, maskedTargetBits[0].getBits(), maskedTargetBits[1].getBits(), 0, blocks - 1, blocks / 2, donorAlign, bestDonorList, testList, (int)this.maxDonorHypotheses.value(), (int)this.minTestSites.value());
        DonorHypoth[] best2Dsearchdonors = FILLINImputationUtils.findHeterozygousDonorHypoth(taxon, maskedTargetBits[0].getBits(), maskedTargetBits[1].getBits(), 0, blocks - 1, blocks / 2, donorAlign, d, d, (int)this.maxDonorHypotheses.value(), (int)this.minTestSites.value());
        Object[] best2donors = FILLINImputationUtils.combineDonorHypothArrays(this.maxDonorHypotheses.value(), bestDBasedOnBest, best2Dsearchdonors);
        if (this.testing == 1) {
            System.out.println(Arrays.toString(best2donors));
        }
        ArrayList<Object> goodDH = new ArrayList<Object>();
        for (Object dh : best2donors) {
            if (dh == null) continue;
            if (((DonorHypoth)dh).isInbred() && ((DonorHypoth)dh).getErrorRate() < this.maximumInbredError.value()) {
                goodDH.add(dh);
                continue;
            }
            if (!(((DonorHypoth)dh).getErrorRate() < maxHybridErrorRate) || (dh = this.getStateBasedOnViterbi((DonorHypoth)dh, donorOffset, donorAlign, this.twoWayViterbi, this.transition)) == null) continue;
            goodDH.add(dh);
        }
        if (goodDH.isEmpty()) {
            return impT;
        }
        DonorHypoth[] vdh = new DonorHypoth[goodDH.size()];
        for (int i = 0; i < vdh.length; ++i) {
            vdh[i] = (DonorHypoth)goodDH.get(i);
        }
        impT.setSegmentSolved(true);
        return this.setAlignmentWithDonors(donorAlign, vdh, donorOffset, false, impT, false, false);
    }

    private ImputedTaxon solveByBlockNearestNeighbor(ImputedTaxon impT, int targetTaxon, GenotypeTable donorAlign, int donorOffset, DonorHypoth[][] regionHypth, boolean hybridMode, BitSet[] maskedTargetBits, int minMinorCnt, double focusInbredErr, double focusHybridErr, double focusSmashErr, int[] donorIndices, int[] blockNN, boolean hetsToMiss) {
        int[] currBlocksSolved = new int[5];
        int blocks = maskedTargetBits[0].getNumWords();
        for (int focusBlock = 0; focusBlock < blocks; ++focusBlock) {
            boolean vit = false;
            int[] d = this.getUniqueDonorsForBlock(regionHypth, focusBlock);
            int[] resultRange = FILLINImputationUtils.getBlockWithMinMinorCount(maskedTargetBits[0].getBits(), maskedTargetBits[1].getBits(), focusBlock, minMinorCnt, minMinorCnt * this.minMajorRatioToMinorCnt);
            if (resultRange == null) {
                currBlocksSolved[3] = currBlocksSolved[3] + 1;
                continue;
            }
            if (d == null) {
                currBlocksSolved[3] = currBlocksSolved[3] + 1;
                continue;
            }
            DonorHypoth[] best2donors = FILLINImputationUtils.findHeterozygousDonorHypoth(targetTaxon, maskedTargetBits[0].getBits(resultRange[0], resultRange[2]), maskedTargetBits[1].getBits(resultRange[0], resultRange[2]), resultRange[0], resultRange[2], focusBlock, donorAlign, d, d, (int)this.maxDonorHypotheses.value(), (int)this.minTestSites.value());
            if (best2donors[0] == null) {
                currBlocksSolved[3] = currBlocksSolved[3] + 1;
                continue;
            }
            ArrayList<DonorHypoth> goodDH = new ArrayList<DonorHypoth>();
            if (best2donors[0].getErrorRate() < focusInbredErr) {
                boolean top = true;
                DonorHypoth[] donorHypothArray = best2donors;
                int n = donorHypothArray.length;
                for (int i = 0; i < n; ++i) {
                    DonorHypoth dh = donorHypothArray[i];
                    if (dh == null) continue;
                    if (dh.isInbred() && dh.getErrorRate() < focusInbredErr) {
                        goodDH.add(dh);
                    } else if (dh.getErrorRate() < focusHybridErr) {
                        if ((dh = this.getStateBasedOnViterbi(dh, donorOffset, donorAlign, this.twoWayViterbi, this.transition)) != null) {
                            goodDH.add(dh);
                        }
                        if (top) {
                            vit = true;
                        }
                    }
                    top = false;
                }
                if (goodDH.size() == 0) continue;
                DonorHypoth[] vdh = new DonorHypoth[goodDH.size()];
                for (int i = 0; i < vdh.length; ++i) {
                    vdh[i] = (DonorHypoth)goodDH.get(i);
                }
                regionHypth[focusBlock] = vdh;
                impT = this.setAlignmentWithDonors(donorAlign, regionHypth[focusBlock], donorOffset, true, impT, false, false);
                impT.incBlocksSolved();
                if (vit) {
                    currBlocksSolved[1] = currBlocksSolved[1] + 1;
                } else {
                    currBlocksSolved[0] = currBlocksSolved[0] + 1;
                }
                currBlocksSolved[4] = currBlocksSolved[4] + 1;
                continue;
            }
            if (hybridMode && best2donors[0].getErrorRate() < focusSmashErr) {
                for (DonorHypoth dh : best2donors) {
                    if (dh == null || !(dh.getErrorRate() < focusSmashErr)) continue;
                    goodDH.add(dh);
                }
                if (goodDH.size() == 0) continue;
                DonorHypoth[] vdh = new DonorHypoth[goodDH.size()];
                for (int i = 0; i < vdh.length; ++i) {
                    vdh[i] = (DonorHypoth)goodDH.get(i);
                }
                regionHypth[focusBlock] = vdh;
                impT = this.setAlignmentWithDonors(donorAlign, regionHypth[focusBlock], donorOffset, true, impT, true, hetsToMiss);
                impT.incBlocksSolved();
                currBlocksSolved[2] = currBlocksSolved[2] + 1;
                currBlocksSolved[4] = currBlocksSolved[4] + 1;
                continue;
            }
            currBlocksSolved[3] = currBlocksSolved[3] + 1;
        }
        if (currBlocksSolved[4] != 0) {
            impT.setSegmentSolved(true);
        } else {
            impT.setSegmentSolved(false);
        }
        int leftNullCnt = currBlocksSolved[3];
        if (this.testing == 1) {
            System.out.printf("targetTaxon:%d hybridError:%g block:%d proportionBlocksImputed:%d null:%d inbredDone:%d viterbiDone:%d hybridDone:%d noData:%d %n", targetTaxon, focusHybridErr, blocks, currBlocksSolved[4] / blocks, leftNullCnt, currBlocksSolved[0], currBlocksSolved[1], currBlocksSolved[2], currBlocksSolved[3]);
        }
        for (int i = 0; i < currBlocksSolved.length; ++i) {
            int n = i;
            blockNN[n] = blockNN[n] + currBlocksSolved[i];
        }
        return impT;
    }

    private DonorHypoth getStateBasedOnViterbi(DonorHypoth dh, int donorOffset, GenotypeTable donorAlign, boolean forwardReverse, double[][] trans) {
        int endSite = dh.endSite >= donorAlign.numberOfSites() ? donorAlign.numberOfSites() - 1 : dh.endSite;
        int sites = endSite - dh.startSite + 1;
        StatePositionChain informative = this.createInformativeStateChainForViterbi(dh.startSite, this.maxNonMedelian, this.minimumDonorDistance, unimpAlign.genotypeRange(dh.targetTaxon, dh.startSite + donorOffset, endSite + 1 + donorOffset), donorAlign.genotypeRange(dh.donor1Taxon, dh.startSite, endSite + 1), donorAlign.genotypeRange(dh.donor2Taxon, dh.startSite, endSite + 1));
        if (informative == null) {
            return null;
        }
        int chrlength = donorAlign.chromosomalPosition(endSite) - donorAlign.chromosomalPosition(dh.startSite);
        byte[] callsF = this.callsFromViterbi(trans, chrlength / sites, informative);
        DonorHypoth dh2 = new DonorHypoth(dh.targetTaxon, dh.donor1Taxon, dh.donor2Taxon, dh.startBlock, dh.focusBlock, dh.endBlock);
        dh2.phasedResults = callsF;
        if (forwardReverse) {
            byte[] callsR = this.callsFromViterbi(trans, chrlength / sites, StatePositionChain.reverseInstance(informative));
            ArrayUtils.reverse((byte[])callsR);
            byte[] callsC = new byte[callsF.length];
            System.arraycopy(callsR, 0, callsC, 0, callsC.length / 2);
            System.arraycopy(callsF, callsC.length / 2, callsC, callsC.length / 2, callsC.length - callsC.length / 2);
            dh2.phasedResults = callsC;
        }
        return dh2;
    }

    private byte[] callsFromViterbi(double[][] trans, int avgChrLength, StatePositionChain informative) {
        TransitionProbability tpF = new TransitionProbability();
        EmissionProbability ep = new EmissionProbability();
        tpF.setTransitionProbability(trans);
        ep.setEmissionProbability(this.emission);
        double probHeterozygous = 0.5;
        double phom = 0.25;
        double[] pTrue = new double[]{0.25, 0.125, 0.25, 0.125, 0.25};
        tpF.setAverageSegmentLength(avgChrLength);
        tpF.setPositions(informative.informSites);
        ViterbiAlgorithm vaF = new ViterbiAlgorithm(informative.informStates, tpF, ep, pTrue);
        vaF.calculate();
        byte[] resultStatesF = vaF.getMostProbableStateSequence();
        int currPos = 0;
        byte[] callsF = new byte[informative.totalSiteCnt];
        for (int cs = 0; cs < informative.totalSiteCnt; ++cs) {
            byte by = callsF[cs] = resultStatesF[currPos] == 1 ? (byte)1 : (byte)(resultStatesF[currPos] / 2);
            if (informative.informSites[currPos] >= cs + informative.startSite || currPos >= resultStatesF.length - 1) continue;
            ++currPos;
        }
        return callsF;
    }

    private StatePositionChain createInformativeStateChainForViterbi(int startSite, double maxNonMendelian, double minDonorDistance, byte[] targetGenotype, byte[] donor1Genotype, byte[] donor2Genotype) {
        int nonMendel = 0;
        int donorDifferences = 0;
        ArrayList<Byte> nonMissingObs = new ArrayList<Byte>();
        ArrayList<Integer> informSites = new ArrayList<Integer>();
        for (int cs = 0; cs < targetGenotype.length; ++cs) {
            if (targetGenotype[cs] == -1 || donor1Genotype[cs] == -1 || donor2Genotype[cs] == -1 || targetGenotype[cs] == 85 || donor1Genotype[cs] == 85 || donor2Genotype[cs] == 85 || GenotypeTableUtils.isHeterozygous(donor1Genotype[cs]) || GenotypeTableUtils.isHeterozygous(donor2Genotype[cs])) continue;
            if (donor1Genotype[cs] == donor2Genotype[cs]) {
                if (targetGenotype[cs] == donor1Genotype[cs]) continue;
                ++nonMendel;
                continue;
            }
            ++donorDifferences;
            int state = 1;
            if (targetGenotype[cs] == donor1Genotype[cs]) {
                state = 0;
            } else if (targetGenotype[cs] == donor2Genotype[cs]) {
                state = 2;
            }
            nonMissingObs.add((byte)state);
            informSites.add(cs + startSite);
        }
        if (informSites.size() < 10) {
            return null;
        }
        if ((double)nonMendel / (double)informSites.size() > maxNonMendelian) {
            return null;
        }
        if ((double)donorDifferences / (double)informSites.size() < minDonorDistance) {
            return null;
        }
        return new StatePositionChain(startSite, targetGenotype.length, Bytes.toArray(nonMissingObs), Ints.toArray(informSites));
    }

    private int[] getUniqueDonorsForBlock(DonorHypoth[][] regionHypth, int block) {
        HashSet<Integer> donors = new HashSet<Integer>();
        for (int h = 0; h < regionHypth[block].length; ++h) {
            if (regionHypth[block][h] == null) continue;
            donors.add(regionHypth[block][h].donor1Taxon);
            donors.add(regionHypth[block][h].donor2Taxon);
        }
        if (donors.isEmpty()) {
            return null;
        }
        return Ints.toArray(donors);
    }

    private ImputedTaxon setAlignmentWithDonors(GenotypeTable donorAlign, DonorHypoth[] theDH, int donorOffset, boolean setJustFocus, ImputedTaxon impT, boolean smashOn, boolean hetsMiss) {
        int endSite;
        if (theDH[0].targetTaxon < 0) {
            return impT;
        }
        boolean print = false;
        int startSite = setJustFocus ? theDH[0].getFocusStartSite() : theDH[0].startSite;
        int n = endSite = setJustFocus ? theDH[0].getFocusEndSite() : theDH[0].endSite;
        if (endSite >= donorAlign.numberOfSites()) {
            endSite = donorAlign.numberOfSites() - 1;
        }
        int[] prevDonors = new int[]{-1, -1};
        if (theDH[0].getPhaseForSite(startSite) == 0) {
            prevDonors = new int[]{theDH[0].donor1Taxon, theDH[0].donor1Taxon};
        } else if (theDH[0].getPhaseForSite(startSite) == 2) {
            prevDonors = new int[]{theDH[0].donor2Taxon, theDH[0].donor2Taxon};
        } else if (theDH[0].getPhaseForSite(startSite) == 1) {
            prevDonors = new int[]{theDH[0].donor1Taxon, theDH[0].donor2Taxon};
        }
        int prevDonorStart = startSite;
        int[] currDonors = prevDonors;
        for (int cs = startSite; cs <= endSite; ++cs) {
            byte donorEst = -1;
            int neighbor = 0;
            for (int i = 0; i < theDH.length && donorEst == -1; ++i) {
                neighbor = (byte)(neighbor + 1);
                if (theDH[i] == null || theDH[i].donor1Taxon < 0 || theDH[i].getErrorRate() > this.maximumInbredError.value()) continue;
                byte bD1 = donorAlign.genotype(theDH[i].donor1Taxon, cs);
                if (theDH[i].getPhaseForSite(cs) == 0) {
                    donorEst = bD1;
                    if (i != 0) continue;
                    currDonors = new int[]{theDH[0].donor1Taxon, theDH[0].donor1Taxon};
                    continue;
                }
                byte bD2 = donorAlign.genotype(theDH[i].donor2Taxon, cs);
                if (theDH[i].getPhaseForSite(cs) == 2) {
                    donorEst = bD2;
                    if (i != 0) continue;
                    currDonors = new int[]{theDH[0].donor2Taxon, theDH[0].donor2Taxon};
                    continue;
                }
                donorEst = GenotypeTableUtils.getUnphasedDiploidValueNoHets(bD1, bD2);
                if (i != 0) continue;
                currDonors = new int[]{theDH[0].donor1Taxon, theDH[0].donor2Taxon};
            }
            byte knownBase = impT.getOrigGeno(cs + donorOffset);
            if (!Arrays.equals(prevDonors, currDonors)) {
                DonorHaplotypes dhaps = new DonorHaplotypes(donorAlign.chromosome(prevDonorStart), donorAlign.chromosomalPosition(prevDonorStart), donorAlign.chromosomalPosition(cs), prevDonors[0], prevDonors[1]);
                impT.addBreakPoint(dhaps);
                prevDonors = currDonors;
                prevDonorStart = cs;
            }
            impT.chgHis[cs + donorOffset] = theDH[0].phasedResults == null ? (int)(-neighbor) : neighbor;
            impT.impGeno[cs + donorOffset] = donorEst;
            if (knownBase == -1) {
                if (GenotypeTableUtils.isHeterozygous(donorEst)) {
                    if (smashOn && hetsMiss) {
                        impT.resolveGeno[cs + donorOffset] = knownBase;
                        continue;
                    }
                    impT.resolveGeno[cs + donorOffset] = donorEst;
                    continue;
                }
                impT.resolveGeno[cs + donorOffset] = donorEst;
                continue;
            }
            if (!GenotypeTableUtils.isHeterozygous(donorEst) || !this.resolveHetIfUndercalled || !GenotypeTableUtils.isPartiallyEqual(knownBase, donorEst) || smashOn) continue;
            impT.resolveGeno[cs + donorOffset] = donorEst;
        }
        DonorHaplotypes dhaps = new DonorHaplotypes(donorAlign.chromosome(prevDonorStart), donorAlign.chromosomalPosition(prevDonorStart), donorAlign.chromosomalPosition(endSite), prevDonors[0], prevDonors[1]);
        impT.addBreakPoint(dhaps);
        return impT;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Impute By FILLIN";
    }

    @Override
    public String getToolTipText() {
        return "Imputation that relies on a combination of HMM and Nearest Neighbor using donors derived from FILLINFindHaplotypesPlugin";
    }

    public static void main(String[] args) {
        GeneratePluginCode.generate(FILLINImputationPlugin.class);
    }

    public String targetFile() {
        return this.hmpFile.value();
    }

    public FILLINImputationPlugin targetFile(String value) {
        this.hmpFile = new PluginParameter<String>(this.hmpFile, value);
        return this;
    }

    public String donorDir() {
        return this.donorFile.value();
    }

    public FILLINImputationPlugin donorDir(String value) {
        this.donorFile = new PluginParameter<String>(this.donorFile, value);
        return this;
    }

    public String outputFilename() {
        return this.outFileBase.value();
    }

    public FILLINImputationPlugin outputFilename(String value) {
        this.outFileBase = new PluginParameter<String>(this.outFileBase, value);
        return this;
    }

    public Integer preferredHaplotypeSize() {
        return this.appoxSitesPerDonorGenotypeTable.value();
    }

    public FILLINImputationPlugin preferredHaplotypeSize(Integer value) {
        this.appoxSitesPerDonorGenotypeTable = new PluginParameter<Integer>(this.appoxSitesPerDonorGenotypeTable, value);
        return this;
    }

    public Double heterozygosityThreshold() {
        return this.hetThresh.value();
    }

    public FILLINImputationPlugin heterozygosityThreshold(Double value) {
        this.hetThresh = new PluginParameter<Double>(this.hetThresh, value);
        return this;
    }

    public Double maxErrorToImputeOneDonor() {
        return this.maximumInbredError.value();
    }

    public FILLINImputationPlugin maxErrorToImputeOneDonor(Double value) {
        this.maximumInbredError = new PluginParameter<Double>(this.maximumInbredError, value);
        return this;
    }

    public Double maxCombinedErrorToImputeTwoDonors() {
        return this.maxHybridErrorRate.value();
    }

    public FILLINImputationPlugin maxCombinedErrorToImputeTwoDonors(Double value) {
        this.maxHybridErrorRate = new PluginParameter<Double>(this.maxHybridErrorRate, value);
        return this;
    }

    public Integer minSitesToTestMatch() {
        return this.minTestSites.value();
    }

    public FILLINImputationPlugin minSitesToTestMatch(Integer value) {
        this.minTestSites = new PluginParameter<Integer>(this.minTestSites, value);
        return this;
    }

    public Integer minNumOfMinorAllelesToCompare() {
        return this.minMinorCnt.value();
    }

    public FILLINImputationPlugin minNumOfMinorAllelesToCompare(Integer value) {
        this.minMinorCnt = new PluginParameter<Integer>(this.minMinorCnt, value);
        return this;
    }

    public Integer maxDonorHypotheses() {
        return this.maxDonorHypotheses.value();
    }

    public FILLINImputationPlugin maxDonorHypotheses(Integer value) {
        this.maxDonorHypotheses = new PluginParameter<Integer>(this.maxDonorHypotheses, value);
        return this;
    }

    public Boolean imputeAllHetCalls() {
        return this.imputeAllHets.value();
    }

    public FILLINImputationPlugin imputeAllHetCalls(Boolean value) {
        this.imputeAllHets = new PluginParameter<Boolean>(this.imputeAllHets, value);
        return this;
    }

    public Boolean combineTwoHaplotypesAsHeterozygote() {
        return this.hybridNN.value();
    }

    public FILLINImputationPlugin combineTwoHaplotypesAsHeterozygote(Boolean value) {
        this.hybridNN = new PluginParameter<Boolean>(this.hybridNN, value);
        return this;
    }

    public Boolean outputProjectionAlignment() {
        return this.isOutputProjection.value();
    }

    public FILLINImputationPlugin outputProjectionAlignment(Boolean value) {
        this.isOutputProjection = new PluginParameter<Boolean>(this.isOutputProjection, value);
        return this;
    }

    public Boolean imputeDonorFile() {
        return this.imputeDonorFile.value();
    }

    public FILLINImputationPlugin imputeDonorFile(Boolean value) {
        this.imputeDonorFile = new PluginParameter<Boolean>(this.imputeDonorFile, value);
        return this;
    }

    public Boolean supressSystemOut() {
        return this.nonverboseOutput.value();
    }

    public FILLINImputationPlugin supressSystemOut(Boolean value) {
        this.nonverboseOutput = new PluginParameter<Boolean>(this.nonverboseOutput, value);
        return this;
    }

    public Boolean calculateAccuracy() {
        return this.accuracy.value();
    }

    public FILLINImputationPlugin calculateAccuracy(Boolean value) {
        this.accuracy = new PluginParameter<Boolean>(this.accuracy, value);
        return this;
    }

    public Double proportionOfGenotypesToMaskIfNoDepth() {
        return this.propSitesMask.value();
    }

    public FILLINImputationPlugin proportionOfGenotypesToMaskIfNoDepth(Double value) {
        this.propSitesMask = new PluginParameter<Double>(this.propSitesMask, value);
        return this;
    }

    public Integer depthOfGenotypesToMask() {
        return this.depthToMask.value();
    }

    public FILLINImputationPlugin depthOfGenotypesToMask(Integer value) {
        this.depthToMask = new PluginParameter<Integer>(this.depthToMask, value);
        return this;
    }

    public Double proportionOfDepthGenotypesToMask() {
        return this.propDepthSitesMask.value();
    }

    public FILLINImputationPlugin proportionOfDepthGenotypesToMask(Double value) {
        this.propDepthSitesMask = new PluginParameter<Double>(this.propDepthSitesMask, value);
        return this;
    }

    public String optionalKeyToCalculateAccuracy() {
        return this.maskKey.value();
    }

    public FILLINImputationPlugin optionalKeyToCalculateAccuracy(String value) {
        this.maskKey = new PluginParameter<String>(this.maskKey, value);
        return this;
    }

    public Boolean calculateAccuracyWithinMAFCategories() {
        return this.byMAF.value();
    }

    public FILLINImputationPlugin calculateAccuracyWithinMAFCategories(Boolean value) {
        this.byMAF = new PluginParameter<Boolean>(this.byMAF, value);
        return this;
    }

    static {
        maskKeyAlign = null;
        MAFClass = new double[]{0.0, 0.02, 0.05, 0.1, 0.2, 0.3, 0.4, 0.5, 1.0};
        myLogger = Logger.getLogger(FILLINImputationPlugin.class);
    }

    private static class StatePositionChain {
        final int startSite;
        final int totalSiteCnt;
        final byte[] informStates;
        final int[] informSites;

        private StatePositionChain(int startSite, int totalSiteCnt, byte[] informStates, int[] informSites) {
            this.startSite = startSite;
            this.totalSiteCnt = totalSiteCnt;
            this.informStates = informStates;
            this.informSites = informSites;
        }

        protected static StatePositionChain reverseInstance(StatePositionChain forwardSPC) {
            byte[] informStatesR = Arrays.copyOf(forwardSPC.informStates, forwardSPC.informStates.length);
            ArrayUtils.reverse((byte[])informStatesR);
            int[] informSitesReverse = new int[forwardSPC.informSites.length];
            for (int site = 0; site < informSitesReverse.length; ++site) {
                informSitesReverse[site] = forwardSPC.totalSiteCnt - 1 - forwardSPC.informSites[forwardSPC.informSites.length - site - 1];
            }
            return new StatePositionChain(informSitesReverse[0], forwardSPC.totalSiteCnt, informStatesR, informSitesReverse);
        }
    }

    private class ImputeOneTaxon
    implements Runnable {
        int taxon;
        GenotypeTable[] donorAlign;
        int minSitesPresent;
        OpenBitSet[][] conflictMasks;
        boolean imputeDonorFile;
        GenotypeTableBuilder alignBuilder = null;
        ProjectionBuilder projBuilder = null;
        int[] trackBlockNN;
        double focusInbredErr;
        double focusHybridErr;
        double focusSmashErr;
        boolean hetsMiss;

        public ImputeOneTaxon(int taxon, GenotypeTable[] donorAlign, int minSitesPresent, OpenBitSet[][] conflictMasks, boolean imputeDonorFile, Object mna, int[] trackBlockNN, double focusInbErr, double focusHybridErr, double focusSmashErr, boolean hetsToMissing) {
            this.taxon = taxon;
            this.donorAlign = donorAlign;
            this.minSitesPresent = minSitesPresent;
            this.conflictMasks = conflictMasks;
            this.imputeDonorFile = imputeDonorFile;
            this.trackBlockNN = trackBlockNN;
            this.focusInbredErr = focusInbErr;
            this.focusHybridErr = focusHybridErr;
            this.focusSmashErr = focusSmashErr;
            this.hetsMiss = hetsToMissing;
            if (mna instanceof GenotypeTableBuilder) {
                this.alignBuilder = (GenotypeTableBuilder)mna;
            } else if (mna instanceof ProjectionBuilder) {
                this.projBuilder = (ProjectionBuilder)mna;
            } else {
                throw new IllegalArgumentException("Only Aligmnent or Projection Builders may be used.");
            }
        }

        @Override
        public void run() {
            StringBuilder sb = new StringBuilder();
            String name = unimpAlign.taxaName(this.taxon);
            ImputedTaxon impTaxon = new ImputedTaxon(this.taxon, unimpAlign.genotypeAllSites(this.taxon), (Boolean)FILLINImputationPlugin.this.isOutputProjection.value());
            boolean het = this.focusHybridErr == 0.0;
            int[] unkHets = FILLINImputationUtils.countUnknownAndHeterozygotes(impTaxon.getOrigGeno());
            sb.append(String.format("Imputed %d:%s AsHet:%b Mj:%d, Mn:%d Unk:%d Hets:%d... ", this.taxon, name, het, unimpAlign.allelePresenceForAllSites(this.taxon, WHICH_ALLELE.Major).cardinality(), unimpAlign.allelePresenceForAllSites(this.taxon, WHICH_ALLELE.Minor).cardinality(), unkHets[0], unkHets[1]));
            boolean enoughData = unimpAlign.totalNonMissingForTaxon(this.taxon) > this.minSitesPresent;
            int countFullLength = 0;
            int countByFocus = 0;
            for (int da = 0; da < this.donorAlign.length && enoughData; ++da) {
                int i;
                int[] donorIndices;
                int donorOffset = unimpAlign.siteOfPhysicalPosition(this.donorAlign[da].chromosomalPosition(0), this.donorAlign[da].chromosome(0));
                int blocks = this.donorAlign[da].allelePresenceForAllSites(0, WHICH_ALLELE.Major).getNumWords();
                BitSet[] maskedTargetBits = FILLINDonorGenotypeUtils.arrangeMajorMinorBtwAlignments(unimpAlign, this.taxon, donorOffset, this.donorAlign[da].numberOfSites(), this.conflictMasks[da][0], this.conflictMasks[da][1], FILLINImputationPlugin.this.isSwapMajorMinor);
                if (this.imputeDonorFile) {
                    donorIndices = new int[this.donorAlign[da].numberOfTaxa() - 1];
                    for (i = 0; i < donorIndices.length; ++i) {
                        donorIndices[i] = i;
                        if (i < this.taxon) continue;
                        int n = i;
                        donorIndices[n] = donorIndices[n] + 1;
                    }
                } else {
                    donorIndices = new int[this.donorAlign[da].numberOfTaxa()];
                    for (i = 0; i < donorIndices.length; ++i) {
                        donorIndices[i] = i;
                    }
                }
                DonorHypoth[][] regionHypthInbred = new DonorHypoth[blocks][((Integer)FILLINImputationPlugin.this.maxDonorHypotheses.value()).intValue()];
                byte[][][] targetToDonorDistances = FILLINImputationUtils.calcAllelePresenceCountsBtwTargetAndDonors(maskedTargetBits, this.donorAlign[da]);
                for (int focusBlock = 0; focusBlock < blocks; ++focusBlock) {
                    int[] resultRange = FILLINImputationUtils.getBlockWithMinMinorCount(maskedTargetBits[0].getBits(), maskedTargetBits[1].getBits(), focusBlock, (Integer)FILLINImputationPlugin.this.minMinorCnt.value(), (Integer)FILLINImputationPlugin.this.minMinorCnt.value() * FILLINImputationPlugin.this.minMajorRatioToMinorCnt);
                    if (resultRange == null) continue;
                    regionHypthInbred[focusBlock] = FILLINImputationUtils.findHomozygousDonorHypoth(this.taxon, resultRange[0], resultRange[2], focusBlock, donorIndices, targetToDonorDistances, (Integer)FILLINImputationPlugin.this.minTestSites.value(), (Integer)FILLINImputationPlugin.this.maxDonorHypotheses.value());
                }
                impTaxon.setSegmentSolved(false);
                impTaxon = FILLINImputationPlugin.this.solveEntireDonorRegion(this.taxon, this.donorAlign[da], donorOffset, regionHypthInbred, impTaxon, maskedTargetBits, (Double)FILLINImputationPlugin.this.maxHybridErrorRate.value(), targetToDonorDistances);
                if (impTaxon.isSegmentSolved()) {
                    ++countFullLength;
                    continue;
                }
                if (!(impTaxon = FILLINImputationPlugin.this.solveByBlockNearestNeighbor(impTaxon, this.taxon, this.donorAlign[da], donorOffset, regionHypthInbred, (Boolean)FILLINImputationPlugin.this.hybridNN.value(), maskedTargetBits, (Integer)FILLINImputationPlugin.this.minMinorCnt.value(), this.focusInbredErr, this.focusHybridErr, this.focusSmashErr, donorIndices, this.trackBlockNN, this.hetsMiss)).isSegmentSolved()) continue;
                ++countByFocus;
            }
            double totalFocus = (double)this.trackBlockNN[3] + (double)this.trackBlockNN[4];
            sb.append(String.format("InbredOrViterbi:%d FocusBlock:%d PropFocusInbred:%f PropFocusViterbi:%f PropFocusSmash:%f PropFocusMissing:%f BlocksSolved:%d ", countFullLength, countByFocus, (double)this.trackBlockNN[0] / totalFocus, (double)this.trackBlockNN[1] / totalFocus, (double)this.trackBlockNN[2] / totalFocus, (double)this.trackBlockNN[3] / totalFocus, impTaxon.getBlocksSolved()));
            int[] unk = FILLINImputationUtils.countUnknownAndHeterozygotes(impTaxon.resolveGeno);
            sb.append(String.format("Unk:%d PropMissing:%g ", unk[0], (double)unk[0] / (double)impTaxon.getOrigGeno().length));
            sb.append(String.format("Het:%d PropHet:%g ", unk[1], (double)unk[1] / (double)impTaxon.getOrigGeno().length));
            sb.append(" BreakPoints:" + impTaxon.getBreakPoints().size());
            if (!((Boolean)FILLINImputationPlugin.this.isOutputProjection.value()).booleanValue()) {
                this.alignBuilder.addTaxon((Taxon)unimpAlign.taxa().get(this.taxon), impTaxon.resolveGeno);
            } else {
                this.projBuilder.addTaxon((Taxon)unimpAlign.taxa().get(this.taxon), impTaxon.getBreakPoints());
            }
            if (FILLINImputationPlugin.this.verboseOutput) {
                System.out.println(sb.toString());
            }
        }
    }
}

