/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.maizegenetics.analysis.data.FileLoadPlugin;
import net.maizegenetics.analysis.imputation.CrossProgenyEmissionMatrix;
import net.maizegenetics.analysis.imputation.RephaseParents;
import net.maizegenetics.analysis.imputation.TransitionProbability;
import net.maizegenetics.analysis.imputation.ViterbiAlgorithm;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.snp.ExportUtils;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.OpenBitSet;
import net.maizegenetics.util.Tuple;
import org.apache.log4j.Logger;

public class ImputeCrossProgeny {
    private Logger myLogger = Logger.getLogger(ImputeCrossProgeny.class);
    private static final byte N = 15;
    private static final byte missingState = 4;
    private static final byte NN = -1;
    private static final byte AA = NucleotideAlignmentConstants.getNucleotideDiploidByte("A");
    private static final byte CC = NucleotideAlignmentConstants.getNucleotideDiploidByte("C");
    private static final byte GG = NucleotideAlignmentConstants.getNucleotideDiploidByte("G");
    private static final byte TT = NucleotideAlignmentConstants.getNucleotideDiploidByte("T");
    private static final byte[] stateNucleotide = new byte[]{AA, CC, GG, TT, -1};
    private static final byte[] ACGT = new byte[]{AA, CC, GG, TT};
    private List<String[]> plotList;
    private Map<String, byte[][]> haplotypeMap;
    private GenotypeTable myGenotype;
    private String parentCallFilename;
    private String phasedParentOutFilename;
    private String imputedGenotypeOutFilename;
    private String parentcallOutFilename;

    public void setPlotList(List<String[]> plotList) {
        this.plotList = plotList;
    }

    public void imputeAll() {
        String now = DateFormat.getDateInstance().format(new Date().getTime());
        int[] chrstart = this.myGenotype.chromosomesOffsets();
        int numberOfChromosomes = chrstart.length;
        int[] chrend = new int[10];
        System.arraycopy(chrstart, 1, chrend, 0, 9);
        chrend[9] = this.myGenotype.numberOfSites();
        HashMap<String, byte[]> phasedProgeny = new HashMap<String, byte[]>();
        HashMap<String, String[]> parentMap = new HashMap<String, String[]>();
        for (String[] plot : this.plotList) {
            int ndx = this.myGenotype.taxa().indexOf(plot[0]);
            if (ndx == -1) continue;
            byte[][] hap0 = this.haplotypeMap.get(plot[1]);
            byte[][] hap1 = this.haplotypeMap.get(plot[2]);
            if (hap0 == null || hap1 == null || !this.notMissingHap(hap0) || !this.notMissingHap(hap1)) continue;
            phasedProgeny.put(plot[0], this.imputeCrossFromParents(plot[0], hap0, hap1));
            parentMap.put(plot[0], new String[]{plot[1], plot[2]});
        }
        for (byte[] states : phasedProgeny.values()) {
            this.fillgaps(states);
        }
        List taxa = phasedProgeny.keySet().stream().map(p -> new Taxon((String)p)).collect(Collectors.toList());
        Collections.sort(taxa);
        GenotypeTableBuilder parentCalls = GenotypeTableBuilder.getTaxaIncremental(this.myGenotype.positions());
        int nsites = this.myGenotype.numberOfSites();
        taxa.stream().forEach(t -> {
            byte[] states = (byte[])phasedProgeny.get(t);
            byte[] geno = new byte[nsites];
            for (int s = 0; s < nsites; ++s) {
                geno[s] = stateNucleotide[states[s]];
            }
            parentCalls.addTaxon((Taxon)t, geno);
        });
        ExportUtils.writeToHapmap(parentCalls.build(), this.parentcallOutFilename);
        GenotypeTableBuilder imputedGeno = GenotypeTableBuilder.getTaxaIncremental(this.myGenotype.positions());
        taxa.stream().forEach(t -> {
            byte[] states = (byte[])phasedProgeny.get(t);
            byte[] geno = new byte[nsites];
            String[] parents = (String[])parentMap.get(t.getName());
            byte[][] hap0 = this.haplotypeMap.get(parents[0]);
            byte[][] hap1 = this.haplotypeMap.get(parents[1]);
            for (int s = 0; s < nsites; ++s) {
                geno[s] = hap0[0][s] == 15 || hap0[1][s] == 15 || hap1[0][s] == 15 || hap1[1][s] == 15 ? -1 : (states[s] == 0 ? GenotypeTableUtils.getDiploidValue(hap0[0][s], hap1[0][s]) : (states[s] == 1 ? GenotypeTableUtils.getDiploidValue(hap0[0][s], hap1[1][s]) : (states[s] == 2 ? GenotypeTableUtils.getDiploidValue(hap0[1][s], hap1[0][s]) : (states[s] == 3 ? GenotypeTableUtils.getDiploidValue(hap0[1][s], hap1[1][s]) : (hap0[0][s] == hap0[1][s] && hap0[0][s] == hap1[0][s] && hap0[0][s] == hap1[1][s] ? GenotypeTableUtils.getDiploidValue(hap0[0][s], hap0[0][s]) : (byte)-1)))));
            }
            imputedGeno.addTaxon((Taxon)t, geno);
        });
        ExportUtils.writeToHapmap(imputedGeno.build(), this.imputedGenotypeOutFilename);
    }

    boolean notMissingHap(byte[][] hap) {
        int[] nm = new int[2];
        for (int i = 0; i < 2; ++i) {
            for (byte b : hap[i]) {
                if (b == 15) continue;
                int n = i;
                nm[n] = nm[n] + 1;
            }
        }
        return nm[0] > 100 && nm[1] > 0;
    }

    public byte[] imputeCrossFromParents(String progeny, byte[][] hap0, byte[][] hap1) {
        int taxonIndex = this.myGenotype.taxa().indexOf(progeny);
        int nsites = this.myGenotype.numberOfSites();
        byte[] progenyGenotype = new byte[nsites];
        Arrays.fill(progenyGenotype, (byte)4);
        int[] chrstart = this.myGenotype.chromosomesOffsets();
        int numberOfChromosomes = chrstart.length;
        int[] chrend = new int[numberOfChromosomes];
        System.arraycopy(chrstart, 1, chrend, 0, numberOfChromosomes - 1);
        chrend[numberOfChromosomes - 1] = this.myGenotype.numberOfSites();
        for (int c = 0; c < numberOfChromosomes; ++c) {
            System.out.printf("Imputing cross progeny %s, chr %d\n", progeny, c + 1);
            Chromosome chr = new Chromosome(Integer.toString(c + 1));
            TransitionProbability tp = new TransitionProbability();
            byte[] geno = this.myGenotype.genotypeRange(taxonIndex, chrstart[c], chrend[c]);
            int ngeno = geno.length;
            OpenBitSet isMissing = new OpenBitSet(ngeno);
            byte[] nonMissingGenotypes = new byte[ngeno];
            int[] nonMissingPositions = new int[ngeno];
            int[] nonMissingHaplotypeIndices = new int[ngeno];
            int numberNotMissing = 0;
            int prevpos = -100;
            int numberInconsistent = 0;
            for (int s = 0; s < ngeno; ++s) {
                int siteIndex = chrstart[c] + s;
                int pos = ((Position)this.myGenotype.positions().get(siteIndex)).getPosition();
                int originalSite = siteIndex;
                if (geno[s] == -1 || hap0[0][originalSite] == 15 || hap0[1][originalSite] == 15 || hap1[0][originalSite] == 15 || hap1[1][originalSite] == 15 || pos - prevpos < 64) {
                    isMissing.fastSet(s);
                    continue;
                }
                if (hap0[0][originalSite] == hap0[1][originalSite] && hap0[0][originalSite] == hap1[0][originalSite] && hap0[0][originalSite] == hap1[1][originalSite]) {
                    isMissing.fastSet(s);
                    if (geno[s] == GenotypeTableUtils.getDiploidValue(hap0[0][originalSite], hap0[0][originalSite])) continue;
                    ++numberInconsistent;
                    continue;
                }
                if (hap0[0][originalSite] == hap0[1][originalSite] && hap1[0][originalSite] == hap1[1][originalSite]) {
                    isMissing.fastSet(s);
                    continue;
                }
                nonMissingPositions[numberNotMissing] = pos;
                nonMissingGenotypes[numberNotMissing] = geno[s];
                nonMissingHaplotypeIndices[numberNotMissing] = originalSite;
                prevpos = pos;
                ++numberNotMissing;
            }
            System.out.printf("For %s, %d of %d sites inconsistent with parents\n", progeny, numberInconsistent, numberNotMissing);
            nonMissingGenotypes = Arrays.copyOf(nonMissingGenotypes, numberNotMissing);
            nonMissingPositions = Arrays.copyOf(nonMissingPositions, numberNotMissing);
            nonMissingHaplotypeIndices = Arrays.copyOf(nonMissingHaplotypeIndices, numberNotMissing);
            if (numberNotMissing < 100) {
                System.out.printf("Number not missing = %d for %s, chromosome %s\n", numberNotMissing, progeny, chr.getName());
                continue;
            }
            tp.setPositions(nonMissingPositions);
            double avgTP = 1.0 / (double)(numberNotMissing - 1);
            double avgDO = avgTP * avgTP;
            double[][] transition = new double[][]{{1.0 - avgTP - avgDO, 0.5 * avgTP, 0.5 * avgTP, avgDO}, {0.5 * avgTP, 1.0 - avgTP - avgDO, avgDO, 0.5 * avgTP}, {0.5 * avgTP, avgDO, 1.0 - avgTP - avgDO, 0.5 * avgTP}, {avgDO, 0.5 * avgTP, 0.5 * avgTP, 1.0 - avgTP - avgDO}};
            tp.setTransitionProbability(transition);
            tp.setAverageSegmentLength((nonMissingPositions[numberNotMissing - 1] - nonMissingPositions[0]) / (numberNotMissing - 1));
            CrossProgenyEmissionMatrix ep = new CrossProgenyEmissionMatrix(new byte[][][]{hap0, hap1}, this.myGenotype, taxonIndex, nonMissingHaplotypeIndices);
            ViterbiAlgorithm va = new ViterbiAlgorithm(nonMissingGenotypes, tp, ep, new double[]{0.25, 0.25, 0.25, 0.25});
            va.calculate();
            byte[] states = va.getMostProbableStateSequence();
            for (int i = 0; i < numberNotMissing; ++i) {
                progenyGenotype[nonMissingHaplotypeIndices[i]] = states[i];
            }
        }
        return progenyGenotype;
    }

    public void improveImputedProgenyStates() {
        int t2;
        int[] chrstart = this.myGenotype.chromosomesOffsets();
        int numberOfChromosomes = chrstart.length;
        int[] chrend = new int[numberOfChromosomes];
        for (int i = 1; i < numberOfChromosomes; ++i) {
            chrend[i - 1] = chrstart[i];
        }
        chrend[numberOfChromosomes - 1] = this.myGenotype.numberOfSites();
        FileLoadPlugin flp = new FileLoadPlugin(null, false);
        flp.setTheFileType(FileLoadPlugin.TasselFileType.Unknown);
        flp.setOpenFiles(new File[]{new File(this.parentCallFilename)});
        GenotypeTable progenyStateGeno = (GenotypeTable)flp.performFunction(null).getData(0).getData();
        int nsites = progenyStateGeno.numberOfSites();
        HashMap<Byte, Byte> stateMap = new HashMap<Byte, Byte>();
        stateMap.put(NucleotideAlignmentConstants.getNucleotideDiploidByte("A"), new Byte(0));
        stateMap.put(NucleotideAlignmentConstants.getNucleotideDiploidByte("C"), new Byte(1));
        stateMap.put(NucleotideAlignmentConstants.getNucleotideDiploidByte("G"), new Byte(2));
        stateMap.put(NucleotideAlignmentConstants.getNucleotideDiploidByte("T"), new Byte(3));
        stateMap.put(NucleotideAlignmentConstants.getNucleotideDiploidByte("NN"), new Byte(4));
        HashMap<String, String[]> plotInfoMap = new HashMap<String, String[]>();
        for (String[] plot : this.plotList) {
            plotInfoMap.put(plot[0], plot);
        }
        HashMap<String, String[]> parentMap = new HashMap<String, String[]>();
        long[][] stateObsCounts = new long[3][3];
        this.myLogger.info((Object)"Loading progeny states and getting stateByObservation counts.");
        long start = System.currentTimeMillis();
        TaxaList myProgenyTaxaList = progenyStateGeno.taxa();
        int ntaxa = myProgenyTaxaList.size();
        byte[][] states = new byte[ntaxa][nsites];
        for (int s = 0; s < nsites; ++s) {
            for (t2 = 0; t2 < ntaxa; ++t2) {
                states[t2][s] = (Byte)stateMap.get(progenyStateGeno.genotype(t2, s));
            }
        }
        this.myLogger.info((Object)String.format("Progeny states loaded in %d ms.", System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        HashMap<String, byte[]> phasedProgenyMap = new HashMap<String, byte[]>();
        for (t2 = 0; t2 < ntaxa; ++t2) {
            String taxonName = ((Taxon)myProgenyTaxaList.get(t2)).getName();
            phasedProgenyMap.put(taxonName, states[t2]);
            String[] plot = (String[])plotInfoMap.get(taxonName);
            byte[][] hap0 = this.haplotypeMap.get(plot[1]);
            byte[][] hap1 = this.haplotypeMap.get(plot[2]);
            this.updateStateObsCounts(stateObsCounts, hap0, hap1, states[t2], taxonName);
            parentMap.put(taxonName, new String[]{plot[1], plot[2]});
        }
        this.myLogger.info((Object)String.format("stateObsCounts updated in %d ms.", System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.myLogger.info((Object)"Rephasing parents");
        RephaseParents rephaser = new RephaseParents(this.myGenotype, phasedProgenyMap, this.plotList, this.haplotypeMap);
        Map<String, double[][]> haplotypeProbabilities = rephaser.rephaseUsingAlleleDepth(this.phasedParentOutFilename);
        this.myLogger.info((Object)String.format("Time to rephase parents = %d ms.", System.currentTimeMillis() - start));
        this.myLogger.info((Object)"Calculating stateGivenObs probability");
        double[][] stateGivenObs = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            double rowsum = Arrays.stream(stateObsCounts[i]).sum();
            for (int col = 0; col < 3; ++col) {
                stateGivenObs[i][col] = (double)stateObsCounts[i][col] / rowsum;
            }
        }
        this.myLogger.debug((Object)"stateGivenObs probabilities");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                sb.append(String.format("%1.4f ", stateGivenObs[i][j]));
            }
        }
        this.myLogger.debug((Object)sb.toString());
        start = System.currentTimeMillis();
        this.myLogger.info((Object)"Rephasing progeny.");
        List resultList = this.plotList.stream().filter(p -> haplotypeProbabilities.get(p[1]) != null && haplotypeProbabilities.get(p[2]) != null).map(p -> {
            double[][] hapProb0 = (double[][])haplotypeProbabilities.get(p[1]);
            double[][] hapProb1 = (double[][])haplotypeProbabilities.get(p[2]);
            byte[] progenyStates = this.imputeCrossFromParentsUsingProbabilities(p[0], hapProb0, hapProb1, stateGivenObs);
            return new Tuple<String, byte[]>(p[0], progenyStates);
        }).collect(Collectors.toList());
        HashMap rephasedProgeny = new HashMap();
        for (Tuple result : resultList) {
            rephasedProgeny.put(result.x, result.y);
        }
        this.myLogger.info((Object)String.format("Progeny rephase in %d ms.", System.currentTimeMillis() - start));
        for (byte[] state : rephasedProgeny.values()) {
            this.fillgaps(state);
        }
        GenotypeTableBuilder parentCalls = GenotypeTableBuilder.getTaxaIncremental(this.myGenotype.positions());
        myProgenyTaxaList.stream().forEach(t -> {
            byte[] state = (byte[])rephasedProgeny.get(t.getName());
            byte[] geno = new byte[nsites];
            for (int s = 0; s < nsites; ++s) {
                geno[s] = stateNucleotide[state[s]];
            }
            parentCalls.addTaxon((Taxon)t, geno);
        });
        ExportUtils.writeToHapmap(parentCalls.build(), this.parentcallOutFilename);
        GenotypeTableBuilder imputedGeno = GenotypeTableBuilder.getTaxaIncremental(this.myGenotype.positions());
        double[] limit = new double[]{0.001, 0.999};
        myProgenyTaxaList.stream().forEach(t -> {
            byte[] state = (byte[])rephasedProgeny.get(t.getName());
            byte[] geno = new byte[nsites];
            Arrays.fill(geno, (byte)-1);
            String[] parents = (String[])parentMap.get(t.getName());
            double[][] hapProb0 = (double[][])haplotypeProbabilities.get(parents[0]);
            double[][] hapProb1 = (double[][])haplotypeProbabilities.get(parents[1]);
            for (int s = 0; s < nsites; ++s) {
                double[] prob = new double[]{Double.NaN, Double.NaN};
                switch (state[s]) {
                    case 0: {
                        prob[0] = hapProb0[0][s];
                        prob[1] = hapProb1[0][s];
                        break;
                    }
                    case 1: {
                        prob[0] = hapProb0[0][s];
                        prob[1] = hapProb1[1][s];
                        break;
                    }
                    case 2: {
                        prob[0] = hapProb0[1][s];
                        prob[1] = hapProb1[0][s];
                        break;
                    }
                    case 3: {
                        prob[0] = hapProb0[1][s];
                        prob[1] = hapProb1[1][s];
                    }
                }
                if (Double.isNaN(prob[0]) || Double.isNaN(prob[1])) {
                    geno[s] = -1;
                    continue;
                }
                if (prob[0] > limit[0] && prob[0] < limit[1] || prob[1] > limit[0] && prob[1] < limit[1]) {
                    geno[s] = -1;
                    continue;
                }
                byte[] haplotype = new byte[]{prob[0] > 0.5 ? this.myGenotype.majorAllele(s) : this.myGenotype.minorAllele(s), prob[1] > 0.5 ? this.myGenotype.majorAllele(s) : this.myGenotype.minorAllele(s)};
                geno[s] = GenotypeTableUtils.getDiploidValue(haplotype[0], haplotype[1]);
            }
            imputedGeno.addTaxon((Taxon)t, geno);
        });
        ExportUtils.writeToHapmap(imputedGeno.build(), this.imputedGenotypeOutFilename);
    }

    public byte[] imputeCrossFromParentsUsingProbabilities(String progeny, double[][] hapProb0, double[][] hapProb1, double[][] probObsGivenState) {
        int[] chrstart = this.myGenotype.chromosomesOffsets();
        int numberOfChromosomes = chrstart.length;
        int[] chrend = new int[numberOfChromosomes];
        System.arraycopy(chrstart, 1, chrend, 0, numberOfChromosomes - 1);
        chrend[numberOfChromosomes - 1] = this.myGenotype.numberOfSites();
        if (hapProb0 == null) {
            this.myLogger.debug((Object)String.format("hapProb0 is null for progeny %s", progeny));
        }
        if (hapProb1 == null) {
            this.myLogger.debug((Object)String.format("hapProb1 is null for progeny %s", progeny));
        }
        int nsites = this.myGenotype.numberOfSites();
        byte[] progenyGenotype = new byte[nsites];
        Arrays.fill(progenyGenotype, (byte)4);
        for (int c = 0; c < 10; ++c) {
            Chromosome chr = new Chromosome(Integer.toString(c + 1));
            TransitionProbability tp = new TransitionProbability();
            int taxonIndex = this.myGenotype.taxa().indexOf(progeny);
            byte[] geno = this.myGenotype.genotypeRange(taxonIndex, chrstart[c], chrend[c]);
            int ngeno = geno.length;
            OpenBitSet isMissing = new OpenBitSet(ngeno);
            byte[] nonMissingGenotypes = new byte[ngeno];
            int[] nonMissingPositions = new int[ngeno];
            int[] nonMissingHaplotypeIndices = new int[ngeno];
            int numberNotMissing = 0;
            int prevpos = -100;
            boolean numberInconsistent = false;
            int nNotNN = 0;
            int[] nNotNan = new int[4];
            for (int s = 0; s < ngeno; ++s) {
                int siteIndex = chrstart[c] + s;
                int pos = ((Position)this.myGenotype.positions().get(siteIndex)).getPosition();
                int originalSite = siteIndex;
                if (geno[s] == -1 || Double.isNaN(hapProb0[0][originalSite]) || Double.isNaN(hapProb0[1][originalSite]) || Double.isNaN(hapProb1[0][originalSite]) || Double.isNaN(hapProb1[1][originalSite]) || pos - prevpos < 64) {
                    isMissing.fastSet(s);
                    continue;
                }
                nonMissingPositions[numberNotMissing] = pos;
                nonMissingGenotypes[numberNotMissing] = geno[s];
                nonMissingHaplotypeIndices[numberNotMissing] = originalSite;
                prevpos = pos;
                ++numberNotMissing;
            }
            if (numberNotMissing < 20) {
                this.myLogger.debug((Object)String.format("numberNotMissing = %d for %s chr %d", numberNotMissing, progeny, c + 1));
                this.myLogger.debug((Object)String.format("notNN, notNaN(00,01,10,11): %d, %d, %d, %d, %d", nNotNN, nNotNan[0], nNotNan[1], nNotNan[2], nNotNan[3]));
                if (numberNotMissing < 5) continue;
            }
            nonMissingGenotypes = Arrays.copyOf(nonMissingGenotypes, numberNotMissing);
            nonMissingPositions = Arrays.copyOf(nonMissingPositions, numberNotMissing);
            nonMissingHaplotypeIndices = Arrays.copyOf(nonMissingHaplotypeIndices, numberNotMissing);
            tp.setPositions(nonMissingPositions);
            double avgTP = 1.0 / (double)(numberNotMissing - 1);
            double avgDO = avgTP * avgTP;
            double[][] transition = new double[][]{{1.0 - avgTP - avgDO, 0.5 * avgTP, 0.5 * avgTP, avgDO}, {0.5 * avgTP, 1.0 - avgTP - avgDO, avgDO, 0.5 * avgTP}, {0.5 * avgTP, avgDO, 1.0 - avgTP - avgDO, 0.5 * avgTP}, {avgDO, 0.5 * avgTP, 0.5 * avgTP, 1.0 - avgTP - avgDO}};
            tp.setTransitionProbability(transition);
            tp.setAverageSegmentLength((nonMissingPositions[numberNotMissing - 1] - nonMissingPositions[0]) / (numberNotMissing - 1));
            double[][] haplotypeProbs = new double[][]{hapProb0[0], hapProb0[1], hapProb1[0], hapProb1[1]};
            CrossProgenyEmissionMatrix ep = new CrossProgenyEmissionMatrix(haplotypeProbs, this.myGenotype, probObsGivenState, taxonIndex, nonMissingHaplotypeIndices);
            ViterbiAlgorithm va = new ViterbiAlgorithm(nonMissingGenotypes, tp, ep, new double[]{0.25, 0.25, 0.25, 0.25});
            va.calculate();
            byte[] states = va.getMostProbableStateSequence();
            for (int i = 0; i < numberNotMissing; ++i) {
                progenyGenotype[nonMissingHaplotypeIndices[i]] = states[i];
            }
        }
        return progenyGenotype;
    }

    public void updateStateObsCounts(long[][] counts, byte[][] hap0, byte[][] hap1, byte[] states, String progenyName) {
        int ndx = this.myGenotype.taxa().indexOf(progenyName);
        int nsites = this.myGenotype.numberOfSites();
        int[][] stateMap = new int[][]{{0, 0}, {0, 1}, {1, 0}, {1, 1}};
        for (int s = 0; s < nsites; ++s) {
            int stateIndex = -1;
            int obsIndex = -1;
            byte obs = this.myGenotype.genotype(ndx, s);
            if (obs == -1 || states[s] == 4) continue;
            byte major = this.myGenotype.majorAllele(s);
            byte minor = this.myGenotype.minorAllele(s);
            int[] myState = stateMap[states[s]];
            byte[] stateAlleles = new byte[]{hap0[myState[0]][s], hap1[myState[1]][s]};
            if (stateAlleles[0] == major) {
                if (stateAlleles[1] == major) {
                    stateIndex = 0;
                } else if (stateAlleles[1] == minor) {
                    stateIndex = 1;
                }
            } else if (stateAlleles[0] == minor) {
                if (stateAlleles[1] == major) {
                    stateIndex = 1;
                } else if (stateAlleles[1] == minor) {
                    stateIndex = 2;
                }
            }
            if (GenotypeTableUtils.isHeterozygous(obs)) {
                obsIndex = 1;
            } else {
                byte obsAllele = GenotypeTableUtils.getDiploidValues(obs)[0];
                if (obsAllele == major) {
                    obsIndex = 0;
                } else if (obsAllele == minor) {
                    obsIndex = 2;
                }
            }
            if (stateIndex <= -1 || obsIndex <= -1) continue;
            long[] lArray = counts[stateIndex];
            int n = obsIndex;
            lArray[n] = lArray[n] + 1L;
        }
    }

    public void fillgaps(byte[] states) {
        int[] chrstart = this.myGenotype.chromosomesOffsets();
        int[] chrend = new int[10];
        System.arraycopy(chrstart, 1, chrend, 0, 9);
        chrend[9] = this.myGenotype.numberOfSites();
        for (int c = 0; c < 10; ++c) {
            int segStart = chrstart[c];
            byte segNuke = states[segStart];
            for (int s = chrstart[c] + 1; s < chrend[c]; ++s) {
                if (segNuke == 4) {
                    if (states[s] == 4) continue;
                    segStart = s;
                    segNuke = states[s];
                    continue;
                }
                if (states[s] == segNuke) {
                    for (int i = segStart + 1; i < s; ++i) {
                        states[i] = segNuke;
                    }
                    segStart = s;
                    continue;
                }
                if (states[s] == 4) continue;
                segStart = s;
                segNuke = states[s];
            }
        }
    }

    public void setParentCallInputFilename(String parentCallFilename) {
        this.parentCallFilename = parentCallFilename;
    }

    public void setMyGenotype(GenotypeTable myGenotype) {
        this.myGenotype = myGenotype;
    }

    public void setParentage(String parentageFilename) {
        this.plotList = new ArrayList<String[]>();
        try (BufferedReader br = Files.newBufferedReader(Paths.get(parentageFilename, new String[0]));){
            String input;
            br.readLine();
            while ((input = br.readLine()) != null) {
                String[] data = input.split("\t");
                if (data.length <= 3) continue;
                this.plotList.add(data);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void setHaplotypeMap(String parentHaplotypeFilename) {
        try {
            FileInputStream fis = new FileInputStream(parentHaplotypeFilename);
            ObjectInputStream ois = new ObjectInputStream(fis);
            this.haplotypeMap = (Map)ois.readObject();
            ois.close();
        }
        catch (IOException | ClassNotFoundException e) {
            this.haplotypeMap = null;
            e.printStackTrace();
        }
    }

    public void setImputedGenotypeOutFilename(String imputedGenotypeOutFilename) {
        this.imputedGenotypeOutFilename = imputedGenotypeOutFilename;
    }

    public void setParentcallOutFilename(String parentcallOutFilename) {
        this.parentcallOutFilename = parentcallOutFilename;
    }

    public void setPhasedParentOutFilename(String phasedParentOutFilename) {
        this.phasedParentOutFilename = phasedParentOutFilename;
    }

    public void writeBreakpointFile(GenotypeTable imputedGenotypes, String outFilename) {
        TreeSet<String> haplotypeSet = new TreeSet<String>();
        for (String[] record : this.plotList) {
            haplotypeSet.add(record[1] + "_0");
            haplotypeSet.add(record[1] + "_1");
            haplotypeSet.add(record[2] + "_0");
            haplotypeSet.add(record[2] + "_1");
        }
        HashMap<String, Integer> haplotypeMap = new HashMap<String, Integer>();
        int ndx = 0;
        for (String string : haplotypeSet) {
            haplotypeMap.put(string, ndx++);
        }
        HashMap<String, int[]> progenyMap = new HashMap<String, int[]>();
        for (String[] record : this.plotList) {
            int[] progenyParents = new int[]{(Integer)haplotypeMap.get(record[1] + "_0"), (Integer)haplotypeMap.get(record[1] + "_1"), (Integer)haplotypeMap.get(record[2] + "_0"), (Integer)haplotypeMap.get(record[2] + "_1")};
            progenyMap.put(record[0], progenyParents);
        }
        try (PrintWriter printWriter = new PrintWriter(outFilename);){
            int numberOfParents = haplotypeMap.size();
            int numberOfProgeny = imputedGenotypes.numberOfTaxa();
            printWriter.printf("%d\t%d%n", numberOfParents, numberOfProgeny);
            printWriter.println("#indexed parents");
            for (Map.Entry entry : haplotypeMap.entrySet()) {
                printWriter.printf("%d\t%s%n", entry.getValue(), entry.getKey());
            }
            printWriter.println("#progeny breakpoints");
            PositionList myPositions = imputedGenotypes.positions();
            ArrayList bpRecords = new ArrayList();
            for (int taxonIndex = 0; taxonIndex < imputedGenotypes.numberOfTaxa(); ++taxonIndex) {
                Position hapStartPos = null;
                Position hapEndPos = null;
                String taxonName = imputedGenotypes.taxaName(taxonIndex);
                StringBuilder bpRecordBuilder = new StringBuilder(taxonName);
                int[] myParents = (int[])progenyMap.get(taxonName);
                byte previousGeno = -18;
                for (int siteIndex = 0; siteIndex < imputedGenotypes.numberOfSites(); ++siteIndex) {
                    byte currentGeno = imputedGenotypes.genotype(taxonIndex, siteIndex);
                    Position currentPos = (Position)imputedGenotypes.positions().get(siteIndex);
                    if (hapStartPos == null && this.inACGT(currentGeno)) {
                        hapStartPos = hapEndPos = currentPos;
                        previousGeno = currentGeno;
                        continue;
                    }
                    if (!currentPos.getChromosome().equals(hapEndPos.getChromosome())) {
                        this.appendBreakpointRecord(bpRecordBuilder, hapStartPos, hapEndPos, myParents, previousGeno);
                        if (this.inACGT(currentGeno)) {
                            hapEndPos = hapStartPos = currentPos;
                            previousGeno = currentGeno;
                            continue;
                        }
                        hapStartPos = null;
                        hapEndPos = null;
                        continue;
                    }
                    if (currentGeno == previousGeno) {
                        hapEndPos = currentPos;
                        continue;
                    }
                    if (!this.inACGT(currentGeno)) continue;
                    this.appendBreakpointRecord(bpRecordBuilder, hapStartPos, hapEndPos, myParents, previousGeno);
                    hapEndPos = hapStartPos = currentPos;
                    previousGeno = currentGeno;
                }
                printWriter.println(bpRecordBuilder.toString());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException("Cannot open " + outFilename + " for writing.");
        }
    }

    private boolean inACGT(byte diploidGenotype) {
        for (byte geno : ACGT) {
            if (diploidGenotype != geno) continue;
            return true;
        }
        return false;
    }

    private void appendBreakpointRecord(StringBuilder bp, Position start, Position end, int[] parents, byte geno) {
        if (!this.inACGT(geno) || start == null || end == null) {
            return;
        }
        bp.append(" ").append(start.getChromosome().getName()).append(":").append(start.getPosition()).append(":").append(end.getPosition()).append(":");
        if (geno == AA) {
            bp.append(parents[0]).append(":").append(parents[2]);
        }
        if (geno == CC) {
            bp.append(parents[0]).append(":").append(parents[3]);
        }
        if (geno == GG) {
            bp.append(parents[1]).append(":").append(parents[2]);
        }
        if (geno == TT) {
            bp.append(parents[1]).append(":").append(parents[3]);
        }
    }
}

