/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.imputation.ImputeCrossProgeny;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;

public class ImputeProgenyStatesPlugin
extends AbstractPlugin {
    private PluginParameter<Boolean> rephase = new PluginParameter.Builder<Boolean>("rephase", false, Boolean.class).guiName("Rephase Parents First").description("If true, rephase parents before imputing. If false, input haplotypes from file.").build();
    private PluginParameter<String> input = PluginParameter.getLabelInstance("Input --------------------");
    private PluginParameter<String> parentageFile = new PluginParameter.Builder<String>("parentage", null, String.class).guiName("Parentage Input File").inFile().description("The input file containing the parentage which lists the parents of each progeny and whether they were derived by self or outcross.").required(true).build();
    private PluginParameter<String> parentHaplotypeFilename = new PluginParameter.Builder<String>("parentHap", null, String.class).guiName("Parent Haplotypes Input File").inFile().description("The input file containing the parent haplotypes expressed as nucleotides. ").build();
    private PluginParameter<String> progenyFile = new PluginParameter.Builder<String>("progeny", null, String.class).dependentOnParameter(this.rephase).guiName("Progeny States Input File").inFile().description("The input file containing the progeny states (parentcalls). Needed for rephasing using haplotype probabilities or for writing breakpoints.").build();
    private PluginParameter<String> output = PluginParameter.getLabelInstance("Output --------------------");
    private PluginParameter<String> imputedFile = new PluginParameter.Builder<String>("imputedOut", null, String.class).guiName("Imputed Genotypes Output File").outFile().description("The output file containing the imputed progeny genotypes in hapmap format.").build();
    private PluginParameter<String> statesFile = new PluginParameter.Builder<String>("statesOut", null, String.class).guiName("Progeny States Output File").outFile().description("The output file containing the new progeny states (parentcalls) in hapmap format").build();
    private PluginParameter<String> hapProbFile = new PluginParameter.Builder<String>("probOut", null, String.class).guiName("Updated Haplotype Probabilities Output File").outFile().description("The output file containing the new parent haplotype probabilities, binary format. A .bin extension will be appended if not present.").build();
    private PluginParameter<Boolean> writeBreakpoints = new PluginParameter.Builder<Boolean>("writebp", false, Boolean.class).guiName("Write Breakpoints").description("Write breakpoint file from imputed genotypes and parentage. Progeny states will not be imputed.").build();
    private PluginParameter<String> breakpointOutFile = new PluginParameter.Builder<String>("bpOut", null, String.class).guiName("Breakpoint Output File").outFile().description("The name of the output file for writing the breakpoints. If the file exists, it will be overwritten.").build();

    public ImputeProgenyStatesPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        ArrayList<Datum> resultList = new ArrayList<Datum>();
        GenotypeTable inputGenotype = (GenotypeTable)input.getDataOfType(GenotypeTable.class).get(0).getData();
        ImputeCrossProgeny icp = new ImputeCrossProgeny();
        icp.setParentage(this.parentageFile.value());
        if (this.writeBreakpoints().booleanValue()) {
            icp.writeBreakpointFile(inputGenotype, this.breakpointOutFile());
            return null;
        }
        icp.setMyGenotype(inputGenotype);
        icp.setParentage(this.parentageFile.value());
        icp.setHaplotypeMap(this.parentHaplotypeFilename.value());
        icp.setImputedGenotypeOutFilename(this.imputedFile.value());
        icp.setParentcallOutFilename(this.statesFile.value());
        icp.setPhasedParentOutFilename(this.hapProbFile.value());
        if (this.rephase.value().booleanValue()) {
            icp.setParentCallInputFilename(this.progenyFile.value());
            icp.improveImputedProgenyStates();
        } else {
            icp.imputeAll();
        }
        return new DataSet(resultList, (Plugin)this);
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Progeny States";
    }

    @Override
    public String getToolTipText() {
        return "Impute progeny states from parent haplotypes.";
    }

    @Override
    public String pluginDescription() {
        return "Impute progeny states using parental haplotypes either represented as nucleotides or as the probability that a haplotype carries the major allele at a site. The plugin also provides a method for estimating haplotype probabilities from progeny states.";
    }

    public Boolean rephase() {
        return this.rephase.value();
    }

    public ImputeProgenyStatesPlugin rephase(Boolean value) {
        this.rephase = new PluginParameter<Boolean>(this.rephase, value);
        return this;
    }

    public String parentageFile() {
        return this.parentageFile.value();
    }

    public ImputeProgenyStatesPlugin parentageFile(String value) {
        this.parentageFile = new PluginParameter<String>(this.parentageFile, value);
        return this;
    }

    public String parentHaplotypeFilename() {
        return this.parentHaplotypeFilename.value();
    }

    public ImputeProgenyStatesPlugin parentHaplotypeFilename(String value) {
        this.parentHaplotypeFilename = new PluginParameter<String>(this.parentHaplotypeFilename, value);
        return this;
    }

    public String progenyFile() {
        return this.progenyFile.value();
    }

    public ImputeProgenyStatesPlugin progenyFile(String value) {
        this.progenyFile = new PluginParameter<String>(this.progenyFile, value);
        return this;
    }

    public String imputedFile() {
        return this.imputedFile.value();
    }

    public ImputeProgenyStatesPlugin imputedFile(String value) {
        this.imputedFile = new PluginParameter<String>(this.imputedFile, value);
        return this;
    }

    public String statesFile() {
        return this.statesFile.value();
    }

    public ImputeProgenyStatesPlugin statesFile(String value) {
        this.statesFile = new PluginParameter<String>(this.statesFile, value);
        return this;
    }

    public String hapProbFile() {
        return this.hapProbFile.value();
    }

    public ImputeProgenyStatesPlugin hapProbFile(String value) {
        this.hapProbFile = new PluginParameter<String>(this.hapProbFile, value);
        return this;
    }

    public Boolean writeBreakpoints() {
        return this.writeBreakpoints.value();
    }

    public ImputeProgenyStatesPlugin writeBreakpoints(Boolean value) {
        this.writeBreakpoints = new PluginParameter<Boolean>(this.writeBreakpoints, value);
        return this;
    }

    public String breakpointOutFile() {
        return this.breakpointOutFile.value();
    }

    public ImputeProgenyStatesPlugin breakpointOutFile(String value) {
        this.breakpointOutFile = new PluginParameter<String>(this.breakpointOutFile, value);
        return this;
    }
}

