/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import java.awt.Frame;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.imputation.FILLINImputationPlugin;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.HDF5Utils;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class ReImputeUpdatedTaxaByFILLINPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(ReImputeUpdatedTaxaByFILLINPlugin.class);
    private PluginParameter<String> rawHDF5GenotypeFile = new PluginParameter.Builder<String>("raw", null, String.class).guiName("Raw HDF5 Genotype File").required(true).inFile().description("Input, unfinished HDF5 (*.h5) file containing raw (unimputed) genotypes").build();
    private PluginParameter<String> imputedHDF5GenotypeFile = new PluginParameter.Builder<String>("imp", null, String.class).guiName("Imputed HDF5 Genotype File").required(true).inFile().description("Target, unfinished HDF5 (*.h5) file containing imputed genotypes to be updated").build();
    private PluginParameter<String> donorDir = new PluginParameter.Builder<String>("d", null, String.class).guiName("Donor Dir").inDir().required(true).description("Directory containing donor haplotype files from output of the FILLINFindHaplotypesPlugin. All files with '.gc' in the filename will be read in, only those with matching sites are used").build();
    private PluginParameter<String> positionSourceHDF5GenoFile = new PluginParameter.Builder<String>("pos", null, String.class).guiName("Position Source HDF5 Geno File").required(false).inFile().description("Finished (built) HDF5 (*.h5) file to be used as a PositionList source (containing a small number of [ignored] taxa)").build();
    private PluginParameter<Integer> preferredHaplotypeSize = new PluginParameter.Builder<Integer>("hapSize", 8000, Integer.class).guiName("Preferred haplotype size").required(false).description("Preferred haplotype block size in sites (use same as in FILLINFindHaplotypesPlugin)").build();
    private PluginParameter<Boolean> keepTempGenotypes = new PluginParameter.Builder<Boolean>("kt", false, Boolean.class).guiName("Keep Temp Genotypes").description("Keep the temporary hdf5 genotype files generated by this plugin (raw and imputed) rather than deleting them").build();
    IHDF5Reader rawGenosReader;
    IHDF5Writer impGenosWriter;
    String tempPath;

    public ReImputeUpdatedTaxaByFILLINPlugin() {
        super(null, false);
    }

    public ReImputeUpdatedTaxaByFILLINPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, false);
    }

    @Override
    public String pluginDescription() {
        return "This plugin compares an unfinished HDF5 file containing raw genotypes to a corresponding unfinished HDF5 file containing FILLIN-imputed genotypes to find new taxa (or taxa with additional depth) in the raw geno file, then imputes (or reimputes) these with FILLIN and adds them to (or replaces them in) the imputed geno file.";
    }

    @Override
    protected void postProcessParameters() {
        this.tempPath = Utils.getDirectory(this.imputedHDF5GenotypeFile()) + File.separator;
    }

    @Override
    public DataSet processData(DataSet input) {
        this.ReImputeUpdatedTaxaByFILLIN();
        this.fireProgress(100);
        return null;
    }

    private void ReImputeUpdatedTaxaByFILLIN() {
        this.openInputHDF5GenoFiles();
        TaxaList modifiedTaxa = this.compareRawAndImputedTaxa();
        if (modifiedTaxa.isEmpty()) {
            myLogger.info((Object)"  No additional or updated taxa were found in the raw genotype input file.");
            return;
        }
        String tempInFile = this.createTempInputFileForFILLIN(modifiedTaxa);
        String tempOutFile = this.runFILLIN(tempInFile);
        this.replaceTaxaInImputedFile(tempOutFile);
        if (!this.keepTempGenotypes().booleanValue()) {
            this.deleteTemporaryFiles(tempInFile, tempOutFile);
        }
    }

    private void openInputHDF5GenoFiles() {
        myLogger.info((Object)("\nOpening input raw genotypes file:\n  " + this.rawHDF5GenotypeFile() + "\n"));
        this.rawGenosReader = HDF5Factory.openForReading((String)this.rawHDF5GenotypeFile());
        myLogger.info((Object)("\nOpening target imputed genotypes file:\n  " + this.imputedHDF5GenotypeFile() + "\n"));
        this.impGenosWriter = HDF5Factory.open((String)this.imputedHDF5GenotypeFile());
    }

    private TaxaList compareRawAndImputedTaxa() {
        myLogger.info((Object)"Comparing taxa in raw and imputed genotype files for additions or additional depth in the raw genotypes:\n");
        StringBuilder modifiedTaxaReport = new StringBuilder("Modified taxa:\n");
        ArrayList<Taxon> modifiedTaxa = new ArrayList<Taxon>();
        List<String> rawTaxaNames = HDF5Utils.getAllTaxaNames(this.rawGenosReader);
        for (String taxonName : rawTaxaNames) {
            Taxon modTax;
            if (!HDF5Utils.doTaxonCallsExist((IHDF5Reader)this.impGenosWriter, taxonName)) {
                modTax = HDF5Utils.getTaxon(this.rawGenosReader, taxonName);
                modifiedTaxa.add(modTax);
                modifiedTaxaReport.append("  " + taxonName + " (new taxon) " + modTax.toStringWithVCFAnnotation() + "\n");
                continue;
            }
            if (!this.flowcellLaneAdded(taxonName)) continue;
            modTax = HDF5Utils.getTaxon(this.rawGenosReader, taxonName);
            modifiedTaxa.add(modTax);
            modifiedTaxaReport.append("  " + taxonName + " (additional depth) " + modTax.toStringWithVCFAnnotation() + "\n");
        }
        if (!modifiedTaxa.isEmpty()) {
            myLogger.info((Object)modifiedTaxaReport.toString());
        }
        return new TaxaListBuilder().addAll((Collection<Taxon>)modifiedTaxa).sortTaxaAlphabetically().build();
    }

    private boolean flowcellLaneAdded(String taxonName) {
        Taxon rawTaxon = HDF5Utils.getTaxon(this.rawGenosReader, taxonName);
        if (rawTaxon == null) {
            throw new IllegalStateException("No corresponding Taxon found in the raw genotype file for the existing taxon name: " + taxonName);
        }
        Taxon impTaxon = HDF5Utils.getTaxon((IHDF5Reader)this.impGenosWriter, taxonName);
        if (impTaxon == null) {
            return true;
        }
        String[] rawFlowCellLanes = rawTaxon.getAnnotation().getTextAnnotation("Flowcell_Lane");
        String[] impFlowCellLanes = impTaxon.getAnnotation().getTextAnnotation("Flowcell_Lane");
        for (String rawFlowCellLane : rawFlowCellLanes) {
            boolean found = false;
            for (String impFlowCellLane : impFlowCellLanes) {
                if (!impFlowCellLane.equals(rawFlowCellLane)) continue;
                found = true;
            }
            if (found) continue;
            return true;
        }
        return false;
    }

    private String createTempInputFileForFILLIN(TaxaList modifiedTaxa) {
        PositionList positionList;
        myLogger.info((Object)"Creating temporary HDF5 file to hold raw genos for modified taxa (input for FILLIN)");
        String tempRawGenosFileName = "tempRawGenos" + new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss_Z").format(new Date()) + ".h5";
        if (this.positionSourceHDF5GenoFile() == null) {
            positionList = PositionListBuilder.getInstance(this.rawGenosReader);
        } else {
            IHDF5Reader posListReader = HDF5Factory.openForReading((String)this.positionSourceHDF5GenoFile());
            positionList = PositionListBuilder.getInstance(posListReader);
        }
        GenotypeTableBuilder gtb = GenotypeTableBuilder.getTaxaIncremental(positionList, this.tempPath + tempRawGenosFileName);
        for (Taxon modTaxon : modifiedTaxa) {
            gtb.addTaxon(modTaxon, HDF5Utils.getHDF5GenotypesCalls(this.rawGenosReader, modTaxon.getName()));
        }
        gtb.build();
        return tempRawGenosFileName;
    }

    private String runFILLIN(String tempInFile) {
        myLogger.info((Object)("Running FILLIN on the modified taxa using default paramenters (preferredHaplotypeSize:" + this.preferredHaplotypeSize() + ")"));
        String tempImpGenosFileName = tempInFile.replaceFirst("Raw", "Imp");
        FILLINImputationPlugin fip = new FILLINImputationPlugin().targetFile(this.tempPath + tempInFile).outputFilename(this.tempPath + tempImpGenosFileName).donorDir(this.donorDir()).preferredHaplotypeSize(this.preferredHaplotypeSize());
        fip.performFunction(null);
        return tempImpGenosFileName;
    }

    private void replaceTaxaInImputedFile(String tempImpFile) {
        myLogger.info((Object)"Replacing modified taxa in the target file containing cumulative, imputed genotypes");
        IHDF5Reader impGenosReader = HDF5Factory.openForReading((String)(this.tempPath + tempImpFile));
        List<String> impTaxaNames = HDF5Utils.getAllTaxaNames(impGenosReader);
        for (String taxonName : impTaxaNames) {
            Taxon impTaxon = HDF5Utils.getTaxon(impGenosReader, taxonName);
            byte[] genoCalls = HDF5Utils.getHDF5GenotypesCalls(impGenosReader, taxonName);
            Taxon origTaxon = HDF5Utils.getTaxon((IHDF5Reader)this.impGenosWriter, taxonName);
            if (origTaxon == null) {
                HDF5Utils.addTaxon(this.impGenosWriter, impTaxon);
                HDF5Utils.writeHDF5GenotypesCalls(this.impGenosWriter, taxonName, genoCalls);
                continue;
            }
            Taxon modTaxon = this.updateTaxonAnnotations(origTaxon, impTaxon);
            HDF5Utils.replaceTaxonAnnotations(this.impGenosWriter, modTaxon);
            HDF5Utils.replaceHDF5GenotypesCalls(this.impGenosWriter, taxonName, genoCalls);
        }
    }

    private Taxon updateTaxonAnnotations(Taxon origTaxon, Taxon newTaxon) {
        Map.Entry<String, String>[] allNewAnnos = newTaxon.getAnnotation().getAllAnnotationEntries();
        HashMap<String, String> annosToAdd = new HashMap<String, String>();
        for (Map.Entry<String, String> newAnno : allNewAnnos) {
            if (origTaxon.getAnnotation().isAnnotatedWithValue(newAnno.getKey(), newAnno.getValue())) continue;
            annosToAdd.put(newAnno.getKey(), newAnno.getValue());
        }
        Taxon.Builder modTaxonBuilder = new Taxon.Builder(origTaxon);
        for (Map.Entry annoToAdd : annosToAdd.entrySet()) {
            modTaxonBuilder.addAnno((String)annoToAdd.getKey(), (String)annoToAdd.getValue());
        }
        return modTaxonBuilder.build();
    }

    private void deleteTemporaryFiles(String tempInFile, String tempOutFile) {
        myLogger.info((Object)"Deleting the temporary HDF5 files");
        try {
            Files.delete(Paths.get(this.tempPath + tempInFile, new String[0]));
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't delete temporary HDF5 raw geno file: " + e);
        }
        try {
            Files.delete(Paths.get(this.tempPath + tempOutFile, new String[0]));
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't delete temporary HDF5 imputed geno file: " + e);
        }
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Update imputed genotypes";
    }

    @Override
    public String getToolTipText() {
        return "Update imputed genotypes file based on modified/new taxa in raw genotypes file";
    }

    public DataSet runPlugin(DataSet input) {
        return (DataSet)this.performFunction(input).getData(0).getData();
    }

    public String rawHDF5GenotypeFile() {
        return this.rawHDF5GenotypeFile.value();
    }

    public ReImputeUpdatedTaxaByFILLINPlugin rawHDF5GenotypeFile(String value) {
        this.rawHDF5GenotypeFile = new PluginParameter<String>(this.rawHDF5GenotypeFile, value);
        return this;
    }

    public String imputedHDF5GenotypeFile() {
        return this.imputedHDF5GenotypeFile.value();
    }

    public ReImputeUpdatedTaxaByFILLINPlugin imputedHDF5GenotypeFile(String value) {
        this.imputedHDF5GenotypeFile = new PluginParameter<String>(this.imputedHDF5GenotypeFile, value);
        return this;
    }

    public String donorDir() {
        return this.donorDir.value();
    }

    public ReImputeUpdatedTaxaByFILLINPlugin donorDir(String value) {
        this.donorDir = new PluginParameter<String>(this.donorDir, value);
        return this;
    }

    public String positionSourceHDF5GenoFile() {
        return this.positionSourceHDF5GenoFile.value();
    }

    public ReImputeUpdatedTaxaByFILLINPlugin positionSourceHDF5GenoFile(String value) {
        this.positionSourceHDF5GenoFile = new PluginParameter<String>(this.positionSourceHDF5GenoFile, value);
        return this;
    }

    public Integer preferredHaplotypeSize() {
        return this.preferredHaplotypeSize.value();
    }

    public ReImputeUpdatedTaxaByFILLINPlugin preferredHaplotypeSize(Integer value) {
        this.preferredHaplotypeSize = new PluginParameter<Integer>(this.preferredHaplotypeSize, value);
        return this;
    }

    public Boolean keepTempGenotypes() {
        return this.keepTempGenotypes.value();
    }

    public ReImputeUpdatedTaxaByFILLINPlugin keepTempGenotypes(Boolean value) {
        this.keepTempGenotypes = new PluginParameter<Boolean>(this.keepTempGenotypes, value);
        return this;
    }
}

