/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import java.util.ArrayList;
import net.maizegenetics.analysis.imputation.EmissionProbability;
import net.maizegenetics.analysis.imputation.TransitionProbability;

public class ViterbiAlgorithmVariableStateNumber {
    TransitionProbability myTransitionMatrix;
    EmissionProbability probObservationGivenState;
    byte[] obs;
    ArrayList<int[]> history;
    double[] distance;
    double[] probTrueStates;
    int numberOfObs;
    byte[] finalState;
    int numberOfCurrentNodeStates;
    int numberOfPreviousNodeStates;

    public ViterbiAlgorithmVariableStateNumber(byte[] observations, TransitionProbability transitionMatrix, EmissionProbability obsGivenTrue, double[] pTrue) {
        this.obs = observations;
        this.numberOfObs = this.obs.length;
        this.myTransitionMatrix = transitionMatrix;
        this.probObservationGivenState = obsGivenTrue;
        this.probTrueStates = new double[pTrue.length];
        for (int i = 0; i < pTrue.length; ++i) {
            this.probTrueStates[i] = Math.log(pTrue[i]);
        }
        this.history = new ArrayList(this.numberOfObs);
    }

    public void calculate() {
        this.initialize();
        for (int i = 1; i < this.numberOfObs; ++i) {
            this.updateDistanceAndHistory(i);
        }
    }

    public void initialize() {
        int n;
        this.numberOfCurrentNodeStates = this.numberOfPreviousNodeStates = (n = this.probTrueStates.length);
        this.distance = new double[n];
        for (int i = 0; i < n; ++i) {
            try {
                this.distance[i] = this.probObservationGivenState.getLnProbObsGivenState(i, this.obs[0], 0) + this.probTrueStates[i];
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void updateDistanceAndHistory(int node) {
        int i;
        int j;
        this.myTransitionMatrix.setNode(node);
        this.numberOfPreviousNodeStates = this.numberOfCurrentNodeStates;
        this.numberOfCurrentNodeStates = this.myTransitionMatrix.getNumberOfStates();
        double[][] candidateDistance = new double[this.numberOfPreviousNodeStates][this.numberOfCurrentNodeStates];
        int distanceLength = this.distance.length;
        try {
            for (int i2 = 0; i2 < this.numberOfPreviousNodeStates; ++i2) {
                for (int j2 = 0; j2 < this.numberOfCurrentNodeStates; ++j2) {
                    candidateDistance[i2][j2] = this.distance[i2] + this.myTransitionMatrix.getLnTransitionProbability(i2, j2) + this.probObservationGivenState.getLnProbObsGivenState(j2, this.obs[node], node);
                }
            }
        }
        catch (Exception e) {
            System.out.println(String.format("at node %d, distance.length = %d, numberOfPreviousNodeStates = %d, and numberOfCurrentNodeStates = %d", node, this.distance.length, this.numberOfPreviousNodeStates, this.numberOfCurrentNodeStates));
            throw new RuntimeException(e);
        }
        int[] max = new int[this.numberOfCurrentNodeStates];
        for (int i3 = 0; i3 < this.numberOfPreviousNodeStates; ++i3) {
            for (j = 0; j < this.numberOfCurrentNodeStates; ++j) {
                if (!(candidateDistance[i3][j] > candidateDistance[max[j]][j])) continue;
                max[j] = i3;
            }
        }
        this.distance = new double[this.numberOfCurrentNodeStates];
        int[] nodeHistory = new int[this.numberOfCurrentNodeStates];
        this.history.add(nodeHistory);
        for (j = 0; j < this.numberOfCurrentNodeStates; ++j) {
            this.distance[j] = candidateDistance[max[j]][j];
            nodeHistory[j] = (byte)max[j];
        }
        double maxd = this.distance[0];
        double mind = 0.0;
        for (i = 0; i < this.numberOfCurrentNodeStates; ++i) {
            if (this.distance[i] > maxd) {
                maxd = this.distance[i];
            }
            if (this.distance[i] == Double.NEGATIVE_INFINITY || !(this.distance[i] < mind)) continue;
            mind = this.distance[i];
        }
        if (mind < -1.0E100) {
            i = 0;
            while (i < this.numberOfCurrentNodeStates) {
                int n = i++;
                this.distance[n] = this.distance[n] - maxd;
            }
        }
    }

    public int[] getMostProbableIntegerStateSequence() {
        int i;
        int[] seq = new int[this.numberOfObs];
        int finalState = 0;
        for (i = 1; i < this.distance.length; ++i) {
            if (!(this.distance[i] > this.distance[finalState])) continue;
            finalState = (byte)i;
        }
        seq[this.numberOfObs - 1] = finalState;
        for (i = this.numberOfObs - 2; i >= 0; --i) {
            seq[i] = this.history.get(i)[seq[i + 1]];
        }
        return seq;
    }

    @Deprecated
    public byte[] getMostProbableStateSequence() {
        int i;
        byte[] seq = new byte[this.numberOfObs];
        byte finalState = 0;
        for (i = 1; i < this.distance.length; ++i) {
            if (!(this.distance[i] > this.distance[finalState])) continue;
            finalState = (byte)i;
        }
        seq[this.numberOfObs - 1] = finalState;
        for (i = this.numberOfObs - 2; i >= 0; --i) {
            seq[i] = (byte)this.history.get(i)[seq[i + 1]];
        }
        return seq;
    }

    public void setStateProbability(double[] probTrueState) {
        int n = probTrueState.length;
        this.probTrueStates = new double[n];
        for (int i = 0; i < n; ++i) {
            this.probTrueStates[i] = Math.log(probTrueState[i]);
        }
    }
}

