/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.modelfitter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.maizegenetics.analysis.modelfitter.AbstractForwardRegression;
import net.maizegenetics.analysis.modelfitter.AdditiveSite;
import net.maizegenetics.analysis.modelfitter.ForwardStepAdditiveSpliterator;
import net.maizegenetics.analysis.modelfitter.ForwardStepSubsettingAdditiveSpliterator;
import net.maizegenetics.phenotype.GenotypePhenotype;
import net.maizegenetics.stats.linearmodels.CovariateModelEffect;
import net.maizegenetics.stats.linearmodels.FactorModelEffect;
import net.maizegenetics.stats.linearmodels.ModelEffect;
import net.maizegenetics.stats.linearmodels.SweepFastLinearModel;
import org.apache.commons.math3.distribution.FDistribution;

public class AdditiveResidualForwardRegression
extends AbstractForwardRegression {
    double[] residuals;

    public AdditiveResidualForwardRegression(GenotypePhenotype data) {
        super(data);
    }

    @Override
    public void fitModel() {
        int maxModelSize = this.myModel.size() + this.maxVariants;
        SweepFastLinearModel sflm = new SweepFastLinearModel(this.myModel, this.y);
        this.residuals = sflm.getResiduals().to1DArray();
        for (int step = 0; step < maxModelSize && this.forwardStepParallel(true, step); ++step) {
        }
    }

    @Override
    public void fitModelForSubsample(int[] subSample, int iteration) {
        this.myModel = this.myBaseModel.stream().map(me -> me.getSubSample(subSample)).collect(Collectors.toList());
        double[] ySubSample = Arrays.stream(subSample).mapToDouble(i -> this.y[i]).toArray();
        SweepFastLinearModel sflm = new SweepFastLinearModel(this.myModel, ySubSample);
        this.residuals = sflm.getResiduals().to1DArray();
        int maxModelSize = this.myModel.size() + this.maxVariants;
        for (int step = 0; step < maxModelSize && this.forwardStepParallel(subSample, true, iteration, step); ++step) {
        }
    }

    private boolean forwardStepParallel(boolean doParallel, int step) {
        double p;
        int nsamples = this.residuals.length;
        FactorModelEffect meanMe = new FactorModelEffect(new int[nsamples], false, "mean");
        List<ModelEffect> residualModel = Arrays.asList(meanMe);
        AdditiveSite bestSite = StreamSupport.stream(new ForwardStepAdditiveSpliterator(this.siteList, residualModel, this.residuals), doParallel).max((a, b) -> a.compareTo(b)).get();
        CovariateModelEffect siteEffect = new CovariateModelEffect(bestSite.getCovariate());
        residualModel.add(siteEffect);
        SweepFastLinearModel sflm = new SweepFastLinearModel(residualModel, this.residuals);
        double[] errorSSdf = sflm.getResidualSSdf();
        double[] siteSSdf = sflm.getIncrementalSSdf(this.myModel.size() - 1);
        if (siteSSdf[1] < 1.0E-9 || errorSSdf[0] < 1.0E-9) {
            double F = Double.NaN;
            p = Double.NaN;
        } else {
            double F = siteSSdf[0] / siteSSdf[1] / errorSSdf[0] * errorSSdf[1];
            p = 1.0 - new FDistribution(siteSSdf[1], errorSSdf[1]).cumulativeProbability(F);
        }
        if (!Double.isNaN(p) && p <= this.enterLimit) {
            this.addVariant(bestSite, p, 0, step);
            this.residuals = sflm.getResiduals().to1DArray();
            return true;
        }
        return false;
    }

    private boolean forwardStepParallel(int[] subset, boolean doParallel, int iteration, int step) {
        double p;
        int nsamples = this.residuals.length;
        FactorModelEffect meanMe = new FactorModelEffect(new int[nsamples], false, "mean");
        List<ModelEffect> residualModel = Arrays.asList(meanMe);
        AdditiveSite bestSite = StreamSupport.stream(new ForwardStepSubsettingAdditiveSpliterator((List<AdditiveSite>)this.siteList, residualModel, this.residuals, subset), doParallel).max((a, b) -> a.compareTo(b)).get();
        CovariateModelEffect siteEffect = new CovariateModelEffect(bestSite.getCovariate(subset));
        residualModel.add(siteEffect);
        SweepFastLinearModel sflm = new SweepFastLinearModel(residualModel, this.residuals);
        double[] errorSSdf = sflm.getResidualSSdf();
        double[] siteSSdf = sflm.getIncrementalSSdf(this.myModel.size() - 1);
        if (siteSSdf[1] < 1.0E-9 || errorSSdf[0] < 1.0E-9) {
            double F = Double.NaN;
            p = Double.NaN;
        } else {
            double F = siteSSdf[0] / siteSSdf[1] / errorSSdf[0] * errorSSdf[1];
            p = 1.0 - new FDistribution(siteSSdf[1], errorSSdf[1]).cumulativeProbability(F);
        }
        if (!Double.isNaN(p) && p <= this.enterLimit) {
            this.addVariant(bestSite, p, iteration, step);
            this.residuals = sflm.getResiduals().to1DArray();
            return true;
        }
        return false;
    }
}

