/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.modelfitter;

import java.util.Arrays;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.maizegenetics.analysis.modelfitter.AdditiveSite;
import net.maizegenetics.stats.linearmodels.ModelEffect;
import net.maizegenetics.stats.linearmodels.PartitionedLinearModel;
import net.maizegenetics.stats.linearmodels.SweepFastLinearModel;

public class ForwardStepAdditiveSpliterator
implements Spliterator<AdditiveSite> {
    protected final PartitionedLinearModel plm;
    protected List<AdditiveSite> mySites;
    protected final List<ModelEffect> baseModel;
    protected final double[] y;
    protected int origin;
    protected final int end;
    protected final double baseModeldf;
    protected final int nobs;
    protected int nsites;

    public ForwardStepAdditiveSpliterator(List<AdditiveSite> siteList, List<ModelEffect> baseModel, double[] y) {
        SweepFastLinearModel sflm = new SweepFastLinearModel(baseModel, y);
        this.baseModeldf = sflm.getFullModelSSdf()[1];
        this.nobs = y.length;
        this.plm = new PartitionedLinearModel(baseModel, sflm);
        this.mySites = siteList;
        this.baseModel = baseModel;
        this.y = y;
        this.origin = 0;
        this.end = siteList.size();
        this.nsites = siteList.size();
    }

    protected ForwardStepAdditiveSpliterator(List<AdditiveSite> siteList, List<ModelEffect> baseModel, double[] y, int numberOfSites) {
        this(siteList, baseModel, y);
        this.nsites = numberOfSites;
    }

    @Override
    public boolean tryAdvance(Consumer<? super AdditiveSite> action) {
        if (this.origin == this.end) {
            return false;
        }
        AdditiveSite as = this.mySites.get(this.origin);
        switch (as.selectionCriterion()) {
            case pval: {
                as.criterionValue(this.plm.testNewModelEffect(as.getCovariate()));
                break;
            }
            case aic: {
                this.plm.testNewModelEffect(as.getCovariate());
                double rss = this.plm.getErrorSS();
                as.criterionValue((double)this.nobs * Math.log(rss / (double)this.nobs) + 2.0 * (this.baseModeldf + 1.0));
                break;
            }
            case bic: {
                this.plm.testNewModelEffect(as.getCovariate());
                double rss = this.plm.getErrorSS();
                as.criterionValue((double)this.nobs * Math.log(rss / (double)this.nobs) + Math.log(this.nobs) * (this.baseModeldf + 1.0));
                break;
            }
            case mbic: {
                this.plm.testNewModelEffect(as.getCovariate());
                double rss = this.plm.getErrorSS();
                as.criterionValue((double)this.nobs * Math.log(rss / (double)this.nobs) + Math.log(this.nobs) * (this.baseModeldf + 1.0) + 2.0 * (this.baseModeldf + 1.0) * Math.log((double)this.nsites / 2.2 - 1.0));
            }
        }
        action.accept(as);
        ++this.origin;
        return true;
    }

    @Override
    public Spliterator<AdditiveSite> trySplit() {
        int numberRemaining = this.end - this.origin;
        if (numberRemaining < 50) {
            return null;
        }
        int mid = this.origin + numberRemaining / 2;
        List<AdditiveSite> splitSublist = this.mySites.subList(this.origin, mid);
        this.origin = mid;
        double[] yCopy = Arrays.copyOf(this.y, this.y.length);
        List<ModelEffect> baseModelCopy = this.baseModel.stream().map(me -> me.getCopy()).collect(Collectors.toList());
        return new ForwardStepAdditiveSpliterator(splitSublist, baseModelCopy, yCopy, this.nsites);
    }

    @Override
    public long estimateSize() {
        return this.end - this.origin;
    }

    @Override
    public int characteristics() {
        return 17728;
    }
}

