/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.modelfitter;

import java.util.Arrays;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.maizegenetics.analysis.modelfitter.AdditiveSite;
import net.maizegenetics.analysis.modelfitter.ForwardStepAdditiveSpliterator;
import net.maizegenetics.stats.linearmodels.ModelEffect;

public class ForwardStepSubsettingAdditiveSpliterator
extends ForwardStepAdditiveSpliterator {
    private final int[] subset;

    public ForwardStepSubsettingAdditiveSpliterator(List<AdditiveSite> siteList, List<ModelEffect> baseModel, double[] y, int[] subset) {
        super(siteList, baseModel, y);
        this.subset = subset;
    }

    private ForwardStepSubsettingAdditiveSpliterator(List<AdditiveSite> siteList, List<ModelEffect> baseModel, double[] y, int numberOfSites, int[] subset) {
        super(siteList, baseModel, y, numberOfSites);
        this.subset = subset;
    }

    @Override
    public boolean tryAdvance(Consumer<? super AdditiveSite> action) {
        if (this.origin == this.end) {
            return false;
        }
        AdditiveSite as = (AdditiveSite)this.mySites.get(this.origin);
        switch (as.selectionCriterion()) {
            case pval: {
                as.criterionValue(this.plm.testNewModelEffect(as.getCovariate(this.subset)));
                break;
            }
            case aic: {
                this.plm.testNewModelEffect(as.getCovariate(this.subset));
                double rss = this.plm.getErrorSS();
                as.criterionValue((double)this.nobs * Math.log(rss / (double)this.nobs) + 2.0 * (this.baseModeldf + 1.0));
                break;
            }
            case bic: {
                this.plm.testNewModelEffect(as.getCovariate(this.subset));
                double rss = this.plm.getErrorSS();
                as.criterionValue((double)this.nobs * Math.log(rss / (double)this.nobs) + Math.log(this.nobs) * (this.baseModeldf + 1.0));
                break;
            }
            case mbic: {
                this.plm.testNewModelEffect(as.getCovariate(this.subset));
                double rss = this.plm.getErrorSS();
                as.criterionValue((double)this.nobs * Math.log(rss / (double)this.nobs) + Math.log(this.nobs) * (this.baseModeldf + 1.0) + 2.0 * (this.baseModeldf + 1.0) * Math.log((double)this.nsites / 2.2 - 1.0));
            }
        }
        action.accept(as);
        ++this.origin;
        return true;
    }

    @Override
    public Spliterator<AdditiveSite> trySplit() {
        int numberRemaining = this.end - this.origin;
        if (numberRemaining < 50) {
            return null;
        }
        int mid = this.origin + numberRemaining / 2;
        List<AdditiveSite> splitSublist = this.mySites.subList(this.origin, mid);
        this.origin = mid;
        double[] yCopy = Arrays.copyOf(this.y, this.y.length);
        List<ModelEffect> baseModelCopy = this.baseModel.stream().map(me -> me.getCopy()).collect(Collectors.toList());
        int[] subsetCopy = Arrays.copyOf(this.subset, this.subset.length);
        return new ForwardStepSubsettingAdditiveSpliterator(splitSublist, baseModelCopy, yCopy, this.nsites, subsetCopy);
    }
}

