/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.modelfitter;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.association.FixedEffectLMPlugin;
import net.maizegenetics.analysis.modelfitter.AdditiveModelForwardRegression;
import net.maizegenetics.phenotype.CategoricalAttribute;
import net.maizegenetics.phenotype.GenotypePhenotype;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.stats.linearmodels.BasicShuffler;
import net.maizegenetics.util.TableReport;
import net.maizegenetics.util.TableReportBuilder;
import org.apache.log4j.Logger;

public class ResamplingGWASPlugin
extends AbstractPlugin {
    private Random randomGen = new Random();
    int numberOfFactors;
    private static Logger myLogger = Logger.getLogger(ResamplingGWASPlugin.class);
    private PluginParameter<Double> enterLimit = new PluginParameter.Builder<Double>("enterLimit", 1.0E-8, Double.class).description("A new term entering the model must have a p-value equal to or less than the enter limit.").guiName("Enter Limit").build();
    private PluginParameter<Integer> maxModelTerms = new PluginParameter.Builder<Integer>("maxterms", 100, Integer.class).description("The maximum number of variants that will be fit. If the chromosome residuals are being fit, the maximum number of variants fit per chromosome.").guiName("Max terms").build();
    private PluginParameter<Boolean> useResiduals = new PluginParameter.Builder<Boolean>("residuals", false, Boolean.class).description("Should new terms be tested using residuals from the prior model? The analysis runs faster using this option.").guiName("Use residuals").build();
    private PluginParameter<Integer> numberOfIterations = new PluginParameter.Builder<Integer>("nIterations", 100, Integer.class).description("The number of times the data should be resampled.").guiName("Number of Iterations").build();
    private PluginParameter<Double> resampleProportion = new PluginParameter.Builder<Double>("resampleProportion", 0.8, Double.class).description("The size of the sample is resample proportion times the number of observations in the complete data. For bootstrap, set this value to 1 and with replacement to true.").guiName("").build();
    private PluginParameter<Boolean> withReplacement = new PluginParameter.Builder<Boolean>("replacement", false, Boolean.class).description("Should the sample be formed by sampling with replacement?  For bootstrap, set resample proportion to 1 and this value to true.").guiName("With Replacement").build();
    private PluginParameter<Boolean> useSerialFile = new PluginParameter.Builder<Boolean>("useSitefile", false, Boolean.class).description("Use an additive site file as the source of genotypes.").guiName("Use Site File").build();
    private PluginParameter<String> serialFilename = new PluginParameter.Builder<String>("sitefile", null, String.class).description("The name of the file containing genotypes stored in site objects.").guiName("Site Filename").dependentOnParameter(this.useSerialFile).build();
    private PluginParameter<Integer> maxThreads = new PluginParameter.Builder<Integer>("maxThreads", -1, Integer.class).description("The maximum number of threads to available to the plugin. If maxThreads = -1, then the value is set to the number of available processors - 2.").guiName("Maximum Thread Number").build();

    public ResamplingGWASPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        Phenotype pheno;
        List<Datum> datumList;
        if (this.useSerialFile.value().booleanValue()) {
            datumList = input.getDataOfType(Phenotype.class);
            if (datumList.size() != 1) {
                throw new IllegalArgumentException("Exactly one joined Phenotype dataset must be supplied as input to Resample GWAS.");
            }
            pheno = (Phenotype)datumList.get(0).getData();
        } else {
            datumList = input.getDataOfType(GenotypePhenotype.class);
            if (datumList.size() != 1) {
                throw new IllegalArgumentException("Exactly one joined Genotype-Phenotype dataset must be supplied as input to Resample GWAS.");
            }
            pheno = ((GenotypePhenotype)datumList.get(0).getData()).phenotype();
        }
        this.numberOfFactors = pheno.numberOfAttributesOfType(Phenotype.ATTRIBUTE_TYPE.factor);
        if (this.numberOfFactors > 1) {
            throw new IllegalArgumentException("Phenotype supplied to Resample GWAS can have at most one factor");
        }
        boolean anyMissing = pheno.attributeStream().anyMatch(pa -> pa.missing().cardinality() > 0L);
        if (anyMissing) {
            throw new IllegalArgumentException("No missing phenotype data allow as input to Resample GWAS");
        }
    }

    @Override
    public DataSet processData(DataSet input) {
        AdditiveModelForwardRegression modelfitter;
        Phenotype pheno;
        List<Datum> datumList;
        long mainStart = System.nanoTime();
        if (this.useSerialFile.value().booleanValue()) {
            datumList = input.getDataOfType(Phenotype.class);
            pheno = (Phenotype)datumList.get(0).getData();
        } else {
            datumList = input.getDataOfType(GenotypePhenotype.class);
            pheno = ((GenotypePhenotype)datumList.get(0).getData()).phenotype();
        }
        String dataname = datumList.get(0).getName();
        if (this.useResiduals.value().booleanValue()) {
            modelfitter = null;
        } else if (this.useSerialFile.value().booleanValue()) {
            long start = System.nanoTime();
            modelfitter = this.maxThreads.value() > 0 ? new AdditiveModelForwardRegression(this.serialFilename.value(), pheno, this.maxThreads.value()) : new AdditiveModelForwardRegression(this.serialFilename.value(), pheno);
            myLogger.debug((Object)String.format("Serialized sites loaded in %d ms", (System.nanoTime() - start) / 1000000L));
            pheno = modelfitter.phenotype();
        } else {
            GenotypePhenotype myGenoPheno = (GenotypePhenotype)datumList.get(0).getData();
            modelfitter = this.maxThreads.value() > 0 ? new AdditiveModelForwardRegression(myGenoPheno, this.maxThreads.value()) : new AdditiveModelForwardRegression(myGenoPheno);
        }
        int numberOfTraits = pheno.numberOfAttributesOfType(Phenotype.ATTRIBUTE_TYPE.data);
        ArrayList<int[]> factorLevelList = new ArrayList<int[]>();
        if (this.numberOfFactors == 1) {
            CategoricalAttribute myFactor = (CategoricalAttribute)pheno.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.factor).get(0);
            int[] levels = myFactor.allIntValues();
            factorLevelList = new ArrayList();
            Map<Integer, List<Integer>> factorGroups = IntStream.range(0, levels.length).boxed().collect(Collectors.groupingBy(i -> new Integer(levels[i])));
            for (int i2 = 0; i2 < factorGroups.size(); ++i2) {
                List<Integer> factorMembers = factorGroups.get(i2);
                factorLevelList.add(factorMembers.stream().mapToInt(I -> I).toArray());
            }
        } else {
            factorLevelList.add(IntStream.range(0, pheno.numberOfObservations()).toArray());
        }
        Object[] columns = new String[]{"trait", "interation", "step", "SnpID", "Chr", "Pos", "p-value", "-log10p"};
        TableReportBuilder reportBuilder = TableReportBuilder.getInstance("Resample terms_" + dataname, columns);
        long start = System.nanoTime();
        List<PhenotypeAttribute> dataAttributes = pheno.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.data);
        for (int ph = 0; ph < numberOfTraits; ++ph) {
            modelfitter.resetModel(ph, this.enterLimit.value(), this.maxModelTerms.value());
            myLogger.debug((Object)String.format("Analyzing phenotype %d, %s.", ph, dataAttributes.get(ph).name()));
            for (int iter = 0; iter < this.numberOfIterations.value(); ++iter) {
                myLogger.debug((Object)String.format("phenotype %d, iteration %d", ph, iter));
                int[] subsample = this.randomSample(factorLevelList);
                modelfitter.fitModelForSubsample(subsample, iter);
            }
            for (Object[] row : modelfitter.fittedModel()) {
                reportBuilder.add(row);
            }
        }
        myLogger.debug((Object)String.format("Resample GWAS model fit in %d ms.", (System.nanoTime() - start) / 1000000L));
        myLogger.debug((Object)String.format("Elapse time for plugin = %d ms.", (System.nanoTime() - mainStart) / 1000000L));
        Datum theResult = new Datum("name", reportBuilder.build(), "comment");
        return new DataSet(theResult, (Plugin)this);
    }

    private int[] randomSample(List<int[]> factorLevelList) {
        double rp = this.resampleProportion.value();
        if (this.withReplacement.value().booleanValue()) {
            return factorLevelList.stream().flatMapToInt(iarray -> this.randomGen.ints((int)Math.round((double)((int[])iarray).length * rp), 0, ((int[])iarray).length).map(i -> iarray[i])).toArray();
        }
        return factorLevelList.stream().flatMapToInt(iarray -> {
            int[] copy = Arrays.copyOf(iarray, ((int[])iarray).length);
            BasicShuffler.shuffle(copy);
            return Arrays.stream(copy).limit((int)Math.round((double)((int[])iarray).length * rp));
        }).toArray();
    }

    @Override
    public String pluginDescription() {
        return "ResamplingGWASPlugin uses forward regression to fit a multiple SNP model to each of a number of samples drawn from the phenotype data. ";
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = FixedEffectLMPlugin.class.getResource("/net/maizegenetics/analysis/images/resample.png");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Resample GWAS";
    }

    @Override
    public String getToolTipText() {
        return "GWAS with resampling";
    }

    public void setRandomSeed(int seed) {
        this.randomGen = new Random(seed);
    }

    public TableReport runPlugin(DataSet input) {
        return (TableReport)this.performFunction(input).getData(0).getData();
    }

    public Double enterLimit() {
        return this.enterLimit.value();
    }

    public ResamplingGWASPlugin enterLimit(Double value) {
        this.enterLimit = new PluginParameter<Double>(this.enterLimit, value);
        return this;
    }

    public Boolean useResiduals() {
        return this.useResiduals.value();
    }

    public ResamplingGWASPlugin useResiduals(Boolean value) {
        this.useResiduals = new PluginParameter<Boolean>(this.useResiduals, value);
        return this;
    }

    public Integer numberOfIterations() {
        return this.numberOfIterations.value();
    }

    public ResamplingGWASPlugin numberOfIterations(Integer value) {
        this.numberOfIterations = new PluginParameter<Integer>(this.numberOfIterations, value);
        return this;
    }

    public Double resampleProportion() {
        return this.resampleProportion.value();
    }

    public ResamplingGWASPlugin resampleProportion(Double value) {
        this.resampleProportion = new PluginParameter<Double>(this.resampleProportion, value);
        return this;
    }

    public Boolean withReplacement() {
        return this.withReplacement.value();
    }

    public ResamplingGWASPlugin withReplacement(Boolean value) {
        this.withReplacement = new PluginParameter<Boolean>(this.withReplacement, value);
        return this;
    }
}

