/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.modelfitter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.maizegenetics.analysis.association.AssociationUtils;
import net.maizegenetics.analysis.modelfitter.SNP;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.phenotype.CategoricalAttribute;
import net.maizegenetics.phenotype.GenotypePhenotype;
import net.maizegenetics.phenotype.NumericAttribute;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.phenotype.PhenotypeBuilder;
import net.maizegenetics.phenotype.TaxaAttribute;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.stats.linearmodels.BasicShuffler;
import net.maizegenetics.stats.linearmodels.CovariateModelEffect;
import net.maizegenetics.stats.linearmodels.FactorModelEffect;
import net.maizegenetics.stats.linearmodels.LinearModelUtils;
import net.maizegenetics.stats.linearmodels.ModelEffect;
import net.maizegenetics.stats.linearmodels.ModelEffectUtils;
import net.maizegenetics.stats.linearmodels.NestedCovariateModelEffect;
import net.maizegenetics.stats.linearmodels.PartitionedLinearModel;
import net.maizegenetics.stats.linearmodels.SweepFastLinearModel;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;
import net.maizegenetics.util.SimpleTableReport;
import net.maizegenetics.util.TableReport;

public class StepwiseOLSModelFitter {
    private final GenotypePhenotype myData;
    private double[] enterlimits = null;
    private double[] exitlimits = null;
    private double enterlimit = 1.0E-5;
    private double exitlimit = 2.0E-5;
    private int maxNumberOfMarkers = 1000;
    private FactorModelEffect nestingEffect;
    private int nestingFactorIndex;
    private boolean isNested;
    private boolean calculateVIF = true;
    private double VIFTolerance = 0.001;
    private VIF_TYPE VIFType = VIF_TYPE.average;
    private ArrayList<String> nestingFactorNames;
    private ArrayList<ModelEffect> currentModel;
    private int currentPhenotypeIndex;
    private int numberOfBaseModelEffects;
    private double[] y;
    private OpenBitSet missing;
    int numberNotMissing;
    int totalNumber;
    private LinkedList<Object[]> resultRowsAnova = new LinkedList();
    private LinkedList<Object[]> resultRowsAnovaWithCI = new LinkedList();
    private LinkedList<Object[]> rowsSiteEffectTable = new LinkedList();
    private LinkedList<Object[]> rowsSiteEffectTableWithCI = new LinkedList();
    private ArrayList<Integer> excludedSNPs = new ArrayList();
    private MODEL_TYPE modelType = MODEL_TYPE.mbic;
    private String datasetName;
    private double globalbestbic = Double.MAX_VALUE;
    private double globalbestmbic = Double.MAX_VALUE;
    private double globalbestaic = Double.MAX_VALUE;
    private boolean test;
    private int[][] theUpperAndLowerBound;
    private int numberOfPermutations = 0;
    private double alpha = 0.05;
    private double[] minPvalues = null;
    private final String[] anovaReportHeader = new String[]{"Trait", "Name", "Locus", "Position", "df", "SS", "MS", "F", "pr>F", "BIC", "mBIC", "AIC", "Model Rsq"};
    private final String[] anovaReportWithCIHeader = new String[]{"Trait", "Name", "Locus", "Position", "df", "SS", "MS", "F", "pr>F", "BIC", "mBIC", "AIC", "Model Rsq", "SuppLeft", "SuppRight"};
    private final GenotypeTable myGenotype;
    private final Phenotype myPhenotype;
    List<PhenotypeAttribute> dataAttributeList;
    List<PhenotypeAttribute> factorAttributeList;
    List<PhenotypeAttribute> covariateAttributeList;

    public void setModelType(MODEL_TYPE modelType) {
        this.modelType = modelType;
    }

    public StepwiseOLSModelFitter(GenotypePhenotype genoPheno, String datasetName) {
        this.myData = genoPheno;
        this.myGenotype = this.myData.genotypeTable();
        this.myPhenotype = this.myData.phenotype();
        this.datasetName = datasetName;
    }

    public DataSet runAnalysis() {
        this.dataAttributeList = this.myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.data);
        this.factorAttributeList = this.myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.factor);
        this.covariateAttributeList = this.myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.covariate);
        int numberOfPhenotypes = this.dataAttributeList.size();
        this.currentPhenotypeIndex = -1;
        for (PhenotypeAttribute attr : this.dataAttributeList) {
            NumericAttribute currentTrait = (NumericAttribute)attr;
            ++this.currentPhenotypeIndex;
            if (this.enterlimits != null) {
                this.enterlimit = this.enterlimits[this.currentPhenotypeIndex];
            }
            if (this.exitlimits != null) {
                this.exitlimit = this.exitlimits[this.currentPhenotypeIndex];
            }
            this.globalbestbic = Double.MAX_VALUE;
            this.globalbestmbic = Double.MAX_VALUE;
            this.globalbestaic = Double.MAX_VALUE;
            float[] phenotypeData = currentTrait.floatValues();
            this.missing = new OpenBitSet(currentTrait.missing());
            for (PhenotypeAttribute factor : this.factorAttributeList) {
                this.missing.or(factor.missing());
            }
            for (PhenotypeAttribute cov : this.covariateAttributeList) {
                this.missing.or(cov.missing());
            }
            this.totalNumber = phenotypeData.length;
            this.numberNotMissing = this.totalNumber - (int)this.missing.cardinality();
            this.y = AssociationUtils.getNonMissingDoubles(phenotypeData, (BitSet)this.missing);
            this.fitModel();
            this.scanAndFindCI();
        }
        return null;
    }

    public void fitModel() {
        this.currentModel = new ArrayList();
        int numberOfTaxa = this.y.length;
        int[] mean = new int[numberOfTaxa];
        FactorModelEffect meanEffect = new FactorModelEffect(mean, false);
        meanEffect.setID("mean");
        this.currentModel.add(meanEffect);
        for (PhenotypeAttribute factor : this.factorAttributeList) {
            ArrayList ids = new ArrayList();
            CategoricalAttribute ca = (CategoricalAttribute)factor;
            String[] factorLabels = AssociationUtils.getNonMissingValues(ca.allLabels(), (BitSet)this.missing);
            int[] levels = ModelEffectUtils.getIntegerLevels(factorLabels, ids);
            FactorModelEffect fme = new FactorModelEffect(levels, true, new Object[]{ca.name(), ids});
            if (this.isNested && this.myPhenotype.attributeIndexForName(factor.name()) == this.nestingFactorIndex) {
                this.nestingEffect = fme;
                this.nestingFactorNames = ids;
            }
            this.currentModel.add(fme);
        }
        for (PhenotypeAttribute cov : this.covariateAttributeList) {
            NumericAttribute na = (NumericAttribute)cov;
            double[] covData = AssociationUtils.getNonMissingDoubles(na.floatValues(), (BitSet)this.missing);
            CovariateModelEffect cme = new CovariateModelEffect(covData, cov.name());
            this.currentModel.add(cme);
        }
        this.numberOfBaseModelEffects = this.currentModel.size();
        System.out.println("-----Number of Permutations = " + this.numberOfPermutations + "------------");
        if (this.numberOfPermutations > 0) {
            this.runPermutationTestNoMissingData();
        }
        System.out.println("--------------the Enter limit is " + this.enterlimit);
        System.out.println("--------------the Exit limit is " + this.exitlimit);
        while (this.forwardStep()) {
            if (this.calculateVIF && this.currentModel.size() > this.numberOfBaseModelEffects + 1) {
                ArrayList<Double> arrayList = this.removeCollinearMarkers(true);
            }
            while (this.backwardStep()) {
            }
        }
        if (this.calculateVIF && this.currentModel.size() > this.numberOfBaseModelEffects + 1) {
            ArrayList<SNP> theSNPs = new ArrayList<SNP>();
            for (int i = this.numberOfBaseModelEffects; i < this.currentModel.size(); ++i) {
                SNP thisSNP = (SNP)this.currentModel.get(i).getID();
                theSNPs.add(thisSNP);
            }
            System.out.println("Here are all of the SNPs in the model prior to identifying a collinear effect: ");
            System.out.println(theSNPs.toString());
            ArrayList<Double> arrayList = this.removeCollinearMarkers(true);
        }
        SweepFastLinearModel theLinearModel = new SweepFastLinearModel(this.currentModel, this.y);
        this.appendAnovaResults(theLinearModel);
        this.appendSiteEffectEstimates(theLinearModel);
    }

    public ArrayList<Double> removeCollinearMarkers(boolean removeCollinearMarker) {
        DoubleMatrix theDesignMatrix = null;
        for (int i = this.numberOfBaseModelEffects; i < this.currentModel.size(); ++i) {
            DoubleMatrix partialDesignMatrix = this.currentModel.get(i).getX();
            theDesignMatrix = i == this.numberOfBaseModelEffects ? partialDesignMatrix : theDesignMatrix.concatenate(partialDesignMatrix, false);
        }
        DoubleMatrix theCenteredDesignmatrix = this.centerCols(theDesignMatrix);
        DoubleMatrix theCenteredAndScaledDesignMatrix = this.scaleCenteredMatrix(theCenteredDesignmatrix);
        double invSqrtSampleSizeMinusOne = 1.0 / Math.sqrt((double)theCenteredAndScaledDesignMatrix.numberOfRows() - 1.0);
        theCenteredAndScaledDesignMatrix = theCenteredAndScaledDesignMatrix.scalarMult(invSqrtSampleSizeMinusOne);
        DoubleMatrix theCorrelationMatrix = theCenteredAndScaledDesignMatrix.crossproduct();
        DoubleMatrix theInvertedCorrelationMatrix = theCorrelationMatrix.inverse();
        ArrayList<Double> theVIFForEachExplanatoryVariable = new ArrayList<Double>();
        int counter = 0;
        double theMinimumValue = Double.MAX_VALUE;
        int indexOfCollinearEffect = 0;
        ArrayList indiciesOfCollinearExplanatoryVariables = new ArrayList();
        ModelEffect theCollinearEffect = null;
        boolean InfiniteVIFsPresent = false;
        for (int i = this.numberOfBaseModelEffects; i < this.currentModel.size(); ++i) {
            int numberOfExplanatoryVariables = this.currentModel.get(i).getX().numberOfColumns();
            double theSumVIFValues = 0.0;
            double theMinimumToleranceValueWithinX = Double.MAX_VALUE;
            double theMaximumToleranceValueWithinX = Double.MIN_VALUE;
            for (int j = 0; j < numberOfExplanatoryVariables; ++j) {
                double theVIF = theInvertedCorrelationMatrix.get(counter + j, counter + j);
                if (Double.isNaN(theVIF)) {
                    theMinimumValue = 0.0;
                    theCollinearEffect = this.currentModel.get(this.currentModel.size() - 1);
                    InfiniteVIFsPresent = true;
                    break;
                }
                double theInvertedVIF = 1.0 / theInvertedCorrelationMatrix.get(counter + j, counter + j);
                if (j == 0 | j == numberOfExplanatoryVariables) {
                    System.out.println("theInvertedVIF is: " + theInvertedVIF);
                }
                if (theInvertedVIF < theMinimumToleranceValueWithinX) {
                    theMinimumToleranceValueWithinX = theInvertedVIF;
                }
                if (theInvertedVIF > theMaximumToleranceValueWithinX) {
                    theMaximumToleranceValueWithinX = theInvertedVIF;
                }
                theSumVIFValues += theInvertedVIF;
            }
            if (InfiniteVIFsPresent) break;
            if (this.VIFType == VIF_TYPE.average) {
                double theAverageVIFValue = theSumVIFValues / (double)numberOfExplanatoryVariables;
                if (theAverageVIFValue < theMinimumValue) {
                    theMinimumValue = theAverageVIFValue;
                    theCollinearEffect = this.currentModel.get(i);
                    indexOfCollinearEffect = i - this.numberOfBaseModelEffects;
                }
                theVIFForEachExplanatoryVariable.add(theAverageVIFValue);
            } else if (this.VIFType == VIF_TYPE.min) {
                if (theMinimumToleranceValueWithinX < theMinimumValue) {
                    theMinimumValue = theMinimumToleranceValueWithinX;
                    theCollinearEffect = this.currentModel.get(i);
                    indexOfCollinearEffect = i - this.numberOfBaseModelEffects;
                }
                theVIFForEachExplanatoryVariable.add(theMinimumToleranceValueWithinX);
            } else if (this.VIFType == VIF_TYPE.max) {
                if (theMaximumToleranceValueWithinX < theMinimumValue) {
                    theMinimumValue = theMaximumToleranceValueWithinX;
                    theCollinearEffect = this.currentModel.get(i);
                    indexOfCollinearEffect = i - this.numberOfBaseModelEffects;
                }
                theVIFForEachExplanatoryVariable.add(theMaximumToleranceValueWithinX);
            }
            counter += numberOfExplanatoryVariables;
            System.out.println("indexOfCollinearEffect: " + indexOfCollinearEffect);
            System.out.println("theVIFForEachExplanatoryVariable");
            System.out.println(theVIFForEachExplanatoryVariable.toString());
        }
        if (removeCollinearMarker && theMinimumValue < this.VIFTolerance) {
            ArrayList<SNP> theSNPs = new ArrayList<SNP>();
            for (int i = this.numberOfBaseModelEffects; i < this.currentModel.size(); ++i) {
                SNP thisSNP = (SNP)this.currentModel.get(i).getID();
                theSNPs.add(thisSNP);
            }
            System.out.println("Here are all of the SNPs in the model prior to identifying a collinear effect: ");
            System.out.println(theSNPs.toString());
            this.currentModel.remove(theCollinearEffect);
            this.excludedSNPs.add(((SNP)theCollinearEffect.getID()).index);
            SNP snpRemoved = (SNP)theCollinearEffect.getID();
            if (!InfiniteVIFsPresent) {
                theVIFForEachExplanatoryVariable.remove(indexOfCollinearEffect);
            }
            System.out.println("------------------" + snpRemoved + " is causing multicollinearity in the model. It has been removed from the model------------------------------");
        }
        return theVIFForEachExplanatoryVariable;
    }

    private DoubleMatrix centerCols(DoubleMatrix data) {
        int nrows = data.numberOfRows();
        int ncols = data.numberOfColumns();
        DoubleMatrix dm = data.copy();
        for (int c = 0; c < ncols; ++c) {
            double colmean = dm.columnSum(c) / (double)nrows;
            for (int r = 0; r < nrows; ++r) {
                dm.set(r, c, dm.get(r, c) - colmean);
            }
        }
        return dm;
    }

    private DoubleMatrix scaleCenteredMatrix(DoubleMatrix data) {
        int nrows = data.numberOfRows();
        int ncols = data.numberOfColumns();
        for (int c = 0; c < ncols; ++c) {
            double sumsq = 0.0;
            for (int r = 0; r < nrows; ++r) {
                double val = data.get(r, c);
                sumsq += val * val;
            }
            double stdDev = Math.sqrt(sumsq / (double)(nrows - 1));
            for (int r = 0; r < nrows; ++r) {
                double val = data.get(r, c);
                data.set(r, c, val / stdDev);
            }
        }
        return data;
    }

    public void scanAndFindCI() {
        int numberOfTerms = this.currentModel.size();
        int firstMarkerIndex = 1;
        firstMarkerIndex += this.factorAttributeList.size();
        System.out.println("firstMarkerIndex " + (firstMarkerIndex += this.covariateAttributeList.size()));
        int[] upperbound = new int[numberOfTerms - firstMarkerIndex];
        int[] lowerbound = new int[numberOfTerms - firstMarkerIndex];
        this.theUpperAndLowerBound = new int[numberOfTerms - firstMarkerIndex][2];
        for (int t = firstMarkerIndex; t < numberOfTerms; ++t) {
            lowerbound[t - firstMarkerIndex] = this.scanASide(true, t);
            System.out.println("lowerbound[t - firstMarkerIndex]");
            System.out.println(lowerbound[t - firstMarkerIndex]);
            upperbound[t - firstMarkerIndex] = this.scanASide(false, t);
            System.out.println("upperbound[t - firstMarkerIndex]");
            System.out.println(upperbound[t - firstMarkerIndex]);
            this.theUpperAndLowerBound[t - firstMarkerIndex][0] = lowerbound[t - firstMarkerIndex];
            this.theUpperAndLowerBound[t - firstMarkerIndex][1] = upperbound[t - firstMarkerIndex];
            SNP bestsnp = null;
            double bestss = 0.0;
            ModelEffect besteffect = null;
            ModelEffect currentme = this.currentModel.remove(t);
            SweepFastLinearModel sflm = new SweepFastLinearModel(this.currentModel, this.y);
            PartitionedLinearModel plm = new PartitionedLinearModel(this.currentModel, sflm);
            for (int m = lowerbound[t - firstMarkerIndex]; m <= upperbound[t - firstMarkerIndex]; ++m) {
                ModelEffect markerEffect = null;
                SNP testsnp = new SNP(this.myGenotype.siteName(m), this.myGenotype.chromosome(m), this.myGenotype.chromosomalPosition(m), m);
                if (this.myGenotype.hasReferenceProbablity()) {
                    double[] cov = new double[this.numberNotMissing];
                    int count = 0;
                    float[] siteReferenceProb = this.myData.referenceProb(m);
                    for (int i = 0; i < this.totalNumber; ++i) {
                        if (this.missing.fastGet(i)) continue;
                        cov[count++] = siteReferenceProb[i];
                    }
                    if (this.isNested) {
                        CovariateModelEffect cme = new CovariateModelEffect(cov);
                        markerEffect = new NestedCovariateModelEffect(cme, this.nestingEffect);
                        markerEffect.setID(testsnp);
                    } else {
                        markerEffect = new CovariateModelEffect(cov, testsnp);
                    }
                } else if (this.myGenotype.hasGenotype()) {
                    byte minor = this.myGenotype.minorAllele(m);
                    double[] cov = new double[this.numberNotMissing];
                    byte[] siteGeno = AssociationUtils.getNonMissingBytes(this.myData.genotypeAllTaxa(m), this.missing);
                    for (int i = 0; i < this.numberNotMissing; ++i) {
                        byte[] diploidAlleles = GenotypeTableUtils.getDiploidValues(siteGeno[i]);
                        if (diploidAlleles[0] == minor) {
                            int n = i;
                            cov[n] = cov[n] + 0.5;
                        }
                        if (diploidAlleles[1] != minor) continue;
                        int n = i;
                        cov[n] = cov[n] + 0.5;
                    }
                    if (this.isNested) {
                        CovariateModelEffect cme = new CovariateModelEffect(cov);
                        markerEffect = new NestedCovariateModelEffect(cme, this.nestingEffect);
                        markerEffect.setID(testsnp);
                    } else {
                        markerEffect = new CovariateModelEffect(cov, testsnp);
                    }
                } else {
                    throw new IllegalArgumentException("No genotypes or reference probabilities in the data set.");
                }
                plm.testNewModelEffect(markerEffect);
                double modelss = plm.getModelSS();
                if (!(modelss > bestss)) continue;
                bestss = modelss;
                bestsnp = testsnp;
                besteffect = markerEffect;
            }
            this.currentModel.add(t, besteffect);
            boolean markerchanged = false;
            SNP currentSnp = (SNP)currentme.getID();
            if (currentSnp.index != bestsnp.index) {
                markerchanged = true;
            }
            if (markerchanged) {
                lowerbound[t - firstMarkerIndex] = this.scanASide(true, t);
                upperbound[t - firstMarkerIndex] = this.scanASide(false, t);
                this.theUpperAndLowerBound[t - firstMarkerIndex][0] = lowerbound[t - firstMarkerIndex];
                this.theUpperAndLowerBound[t - firstMarkerIndex][1] = upperbound[t - firstMarkerIndex];
            }
            System.out.println("upperAndLowerBound[t-firstMarkerIndex][0]");
            System.out.println(this.theUpperAndLowerBound[t - firstMarkerIndex][0]);
            System.out.println("upperAndLowerBound[t-firstMarkerIndex][1]");
            System.out.println(this.theUpperAndLowerBound[t - firstMarkerIndex][1]);
        }
        SweepFastLinearModel theLinearModel = new SweepFastLinearModel(this.currentModel, this.y);
        this.appendAnovaResultsWithCI(theLinearModel);
        this.appendSiteEffectEstimatesWithCI(theLinearModel);
    }

    private int scanASide(boolean left, int whichModelTerm) {
        double alpha = 0.05;
        int minIndex = 0;
        int maxIndex = this.myGenotype.numberOfSites() - 1;
        int incr = left ? -1 : 1;
        SNP modelsnp = (SNP)this.currentModel.get(whichModelTerm).getID();
        int markerIndex = modelsnp.index;
        Chromosome chr = modelsnp.locus;
        boolean boundfound = false;
        int testIndex = markerIndex;
        int lastterm = this.currentModel.size();
        do {
            double p;
            if ((testIndex += incr) < minIndex || testIndex > maxIndex) {
                testIndex -= incr;
                boundfound = true;
                break;
            }
            ModelEffect markerEffect = null;
            SNP snp = new SNP(this.myGenotype.siteName(testIndex), this.myGenotype.chromosome(testIndex), this.myGenotype.chromosomalPosition(testIndex), testIndex);
            Chromosome chrOfTestedSnp = snp.locus;
            if (snp == null || !chrOfTestedSnp.equals(chr)) {
                testIndex -= incr;
                boundfound = true;
                continue;
            }
            if (this.myGenotype.hasReferenceProbablity()) {
                double[] cov = new double[this.numberNotMissing];
                int count = 0;
                float[] referenceProb = this.myData.referenceProb(testIndex);
                for (int i = 0; i < this.totalNumber; ++i) {
                    if (this.missing.fastGet(i)) continue;
                    cov[count++] = referenceProb[i];
                }
                if (this.isNested) {
                    CovariateModelEffect cme = new CovariateModelEffect(cov);
                    markerEffect = new NestedCovariateModelEffect(cme, this.nestingEffect);
                    markerEffect.setID(snp);
                } else {
                    markerEffect = new CovariateModelEffect(cov, snp);
                }
            } else if (this.myGenotype.hasGenotype()) {
                byte minor = this.myGenotype.minorAllele(testIndex);
                double[] cov = new double[this.numberNotMissing];
                byte[] siteGeno = AssociationUtils.getNonMissingBytes(this.myData.genotypeAllTaxa(testIndex), this.missing);
                for (int i = 0; i < this.numberNotMissing; ++i) {
                    byte[] diploidAlleles = GenotypeTableUtils.getDiploidValues(siteGeno[i]);
                    if (diploidAlleles[0] == minor) {
                        int n = i;
                        cov[n] = cov[n] + 0.5;
                    }
                    if (diploidAlleles[1] != minor) continue;
                    int n = i;
                    cov[n] = cov[n] + 0.5;
                }
                if (this.isNested) {
                    CovariateModelEffect cme = new CovariateModelEffect(cov);
                    markerEffect = new NestedCovariateModelEffect(cme, this.nestingEffect);
                    markerEffect.setID(snp);
                } else {
                    markerEffect = new CovariateModelEffect(cov, snp);
                }
            } else {
                throw new IllegalArgumentException("No genotypes or reference probabilities in the data set.");
            }
            this.currentModel.add(markerEffect);
            SweepFastLinearModel sflm = new SweepFastLinearModel(this.currentModel, this.y);
            double[] snpssdf = sflm.getMarginalSSdf(whichModelTerm);
            double[] errorssdf = sflm.getResidualSSdf();
            double F = snpssdf[0] / snpssdf[1] / errorssdf[0] * errorssdf[1];
            try {
                p = LinearModelUtils.Ftest(F, snpssdf[1], errorssdf[1]);
            }
            catch (Exception e) {
                p = 1.0;
            }
            if (p < alpha) {
                boundfound = true;
            }
            this.currentModel.remove(lastterm);
        } while (!boundfound && testIndex > minIndex && testIndex < maxIndex);
        return testIndex;
    }

    public boolean forwardStep() {
        double bestss = 0.0;
        double bestbic = Double.MAX_VALUE;
        double bestmbic = Double.MAX_VALUE;
        double bestaic = Double.MAX_VALUE;
        ModelEffect besteffect = null;
        SweepFastLinearModel sflm = new SweepFastLinearModel(this.currentModel, this.y);
        PartitionedLinearModel plm = new PartitionedLinearModel(this.currentModel, sflm);
        int numberOfSites = this.myGenotype.numberOfSites();
        System.out.println("We are in forwardStep()");
        double[] temperrorssdf = sflm.getResidualSSdf();
        System.out.println("The value of errorss before the loop in forwardStep() is: " + temperrorssdf[0]);
        for (int s = 0; s < numberOfSites; ++s) {
            int i;
            if (this.excludedSNPs.contains(s)) continue;
            ModelEffect markerEffect = null;
            SNP snp = new SNP(this.myGenotype.siteName(s), this.myGenotype.chromosome(s), this.myGenotype.chromosomalPosition(s), s);
            if (this.myGenotype.hasReferenceProbablity()) {
                double[] cov = new double[this.numberNotMissing];
                int count = 0;
                float[] referenceProb = this.myData.referenceProb(s);
                for (i = 0; i < this.totalNumber; ++i) {
                    if (this.missing.fastGet(i)) continue;
                    cov[count++] = referenceProb[i];
                }
                if (this.isNested) {
                    CovariateModelEffect cme = new CovariateModelEffect(cov);
                    markerEffect = new NestedCovariateModelEffect(cme, this.nestingEffect);
                    markerEffect.setID(snp);
                } else {
                    markerEffect = new CovariateModelEffect(cov, snp);
                }
            } else if (this.myGenotype.hasGenotype()) {
                byte minor = this.myGenotype.minorAllele(s);
                double[] cov = new double[this.numberNotMissing];
                byte[] siteGeno = AssociationUtils.getNonMissingBytes(this.myData.genotypeAllTaxa(s), this.missing);
                for (i = 0; i < this.numberNotMissing; ++i) {
                    byte[] diploidAlleles = GenotypeTableUtils.getDiploidValues(siteGeno[i]);
                    if (diploidAlleles[0] == minor) {
                        int n = i;
                        cov[n] = cov[n] + 0.5;
                    }
                    if (diploidAlleles[1] != minor) continue;
                    int n = i;
                    cov[n] = cov[n] + 0.5;
                }
                if (this.isNested) {
                    CovariateModelEffect cme = new CovariateModelEffect(cov);
                    markerEffect = new NestedCovariateModelEffect(cme, this.nestingEffect);
                    markerEffect.setID(snp);
                } else {
                    markerEffect = new CovariateModelEffect(cov, snp);
                }
            } else {
                throw new IllegalArgumentException("No genotypes or reference probabilities in the data set.");
            }
            plm.testNewModelEffect(markerEffect);
            double modelss = plm.getModelSS();
            this.currentModel.add(markerEffect);
            SweepFastLinearModel sflm2 = new SweepFastLinearModel(this.currentModel, this.y);
            int n = this.numberNotMissing;
            double[] errorss = sflm2.getResidualSSdf();
            double[] modeldf = sflm2.getFullModelSSdf();
            double pForBIC = modeldf[1];
            double bic = (double)n * Math.log(errorss[0] / (double)n) + pForBIC * Math.log(n);
            double aic = (double)n * Math.log(errorss[0] / (double)n) + 2.0 * pForBIC;
            if (s == 2) {
                System.out.println("The value of errorss in forwardStep() is: " + errorss[0]);
            }
            int numberOfTwoWayInteractions = numberOfSites * (numberOfSites - 1) / 2;
            double pForMbic = modeldf[1];
            double qForMbic = 0.0;
            double mbic = qForMbic == 0.0 ? (double)n * Math.log(errorss[0]) + (pForMbic + qForMbic) * Math.log(n) + 2.0 * pForMbic * Math.log((double)numberOfSites / 2.2 - 1.0) : (double)n * Math.log(errorss[0]) + (pForMbic + qForMbic) * Math.log(n) + 2.0 * pForMbic * Math.log((double)numberOfSites / 2.2 - 1.0) + 2.0 * qForMbic * Math.log((double)numberOfTwoWayInteractions / 2.2 - 1.0);
            switch (this.modelType) {
                case pvalue: {
                    this.test = modelss > bestss;
                    break;
                }
                case bic: {
                    this.test = bic < bestbic;
                    break;
                }
                case mbic: {
                    this.test = mbic < bestmbic;
                    break;
                }
                case aic: {
                    boolean bl = this.test = aic < bestaic;
                }
            }
            if (this.test) {
                bestmbic = mbic;
                bestbic = bic;
                bestaic = aic;
                bestss = modelss;
                besteffect = markerEffect;
            }
            this.currentModel.remove(markerEffect);
        }
        plm.testNewModelEffect(besteffect);
        double[] Fp = plm.getFp();
        if (this.modelType == MODEL_TYPE.pvalue) {
            if (Fp[1] < this.enterlimit) {
                this.currentModel.add(besteffect);
                return this.currentModel.size() != this.maxNumberOfMarkers + this.numberOfBaseModelEffects;
            }
            return false;
        }
        if (this.modelType == MODEL_TYPE.bic) {
            if (bestbic < this.globalbestbic) {
                this.globalbestbic = bestbic;
                this.currentModel.add(besteffect);
                return this.currentModel.size() != this.maxNumberOfMarkers + this.numberOfBaseModelEffects;
            }
            return false;
        }
        if (this.modelType == MODEL_TYPE.mbic) {
            if (bestmbic < this.globalbestmbic) {
                this.globalbestmbic = bestmbic;
                this.currentModel.add(besteffect);
                return this.currentModel.size() != this.maxNumberOfMarkers + this.numberOfBaseModelEffects;
            }
            return false;
        }
        if (this.modelType == MODEL_TYPE.aic) {
            if (bestaic < this.globalbestaic) {
                this.globalbestaic = bestaic;
                this.currentModel.add(besteffect);
                return this.currentModel.size() != this.maxNumberOfMarkers + this.numberOfBaseModelEffects;
            }
            return false;
        }
        return false;
    }

    public boolean backwardStep() {
        int numberOfTerms = this.currentModel.size();
        if (numberOfTerms <= this.numberOfBaseModelEffects) {
            return false;
        }
        double bestbic = Double.MAX_VALUE;
        double bestmbic = Double.MAX_VALUE;
        double bestaic = Double.MAX_VALUE;
        int n = this.y.length;
        int numberOfSites = this.myGenotype.numberOfSites();
        SweepFastLinearModel sflm0 = new SweepFastLinearModel(this.currentModel, this.y);
        double maxp = 0.0;
        double minF = -1.0;
        int maxterm = 0;
        Object worstMarkerEffect = null;
        double[] errorssdf = sflm0.getResidualSSdf();
        block16: for (int t = this.numberOfBaseModelEffects; t < numberOfTerms; ++t) {
            double p;
            double mbic;
            double aic;
            double bic;
            Object markerEffect = null;
            double[] termssdf = sflm0.getIncrementalSSdf(t);
            double F = termssdf[0] / termssdf[1] / errorssdf[0] * errorssdf[1];
            if (this.modelType != MODEL_TYPE.pvalue) {
                ModelEffect meTest1 = this.currentModel.remove(t);
                SNP snpRemoved = (SNP)meTest1.getID();
                System.out.println("CORRECT The SNP just removed is: " + snpRemoved);
                SweepFastLinearModel sflm = new SweepFastLinearModel(this.currentModel, this.y);
                double[] errorss = sflm.getResidualSSdf();
                double[] modeldf = sflm.getFullModelSSdf();
                double pForBIC = modeldf[1];
                bic = (double)n * Math.log(errorss[0] / (double)n) + pForBIC * Math.log(n);
                aic = (double)n * Math.log(errorss[0] / (double)n) + 2.0 * pForBIC;
                double numberOfTwoWayInteractions = (double)(numberOfSites * (numberOfSites - 1)) / 2.0;
                double pForMbic = modeldf[1];
                double qForMbic = 0.0;
                mbic = qForMbic == 0.0 ? (double)n * Math.log(errorss[0]) + (pForMbic + qForMbic) * Math.log(n) + 2.0 * pForMbic * Math.log((double)numberOfSites / 2.2 - 1.0) : (double)n * Math.log(errorss[0]) + (pForMbic + qForMbic) * Math.log(n) + 2.0 * pForMbic * Math.log((double)numberOfSites / 2.2 - 1.0) + 2.0 * qForMbic * Math.log(numberOfTwoWayInteractions / 2.2 - 1.0);
                this.currentModel.add(t, meTest1);
                sflm = new SweepFastLinearModel(this.currentModel, this.y);
            } else {
                bic = Double.MAX_VALUE;
                mbic = Double.MAX_VALUE;
                aic = Double.MAX_VALUE;
            }
            try {
                p = LinearModelUtils.Ftest(F, termssdf[1], errorssdf[1]);
            }
            catch (Exception e) {
                p = Double.NaN;
            }
            switch (this.modelType) {
                case pvalue: {
                    try {
                        if (!(p > maxp)) continue block16;
                        maxterm = t;
                        maxp = p;
                        minF = F;
                    }
                    catch (Exception exception) {}
                    continue block16;
                }
                case bic: {
                    if (!(bic < bestbic)) continue block16;
                    bestbic = bic;
                    bestaic = aic;
                    bestmbic = mbic;
                    maxterm = t;
                    worstMarkerEffect = markerEffect;
                    maxp = p;
                    minF = F;
                    continue block16;
                }
                case mbic: {
                    if (!(mbic < bestmbic)) continue block16;
                    bestbic = bic;
                    bestaic = aic;
                    bestmbic = mbic;
                    maxterm = t;
                    worstMarkerEffect = markerEffect;
                    maxp = p;
                    minF = F;
                    continue block16;
                }
                case aic: {
                    if (!(aic < bestaic)) continue block16;
                    bestbic = bic;
                    bestaic = aic;
                    bestmbic = mbic;
                    maxterm = t;
                    worstMarkerEffect = markerEffect;
                    maxp = p;
                    minF = F;
                }
            }
        }
        switch (this.modelType) {
            case pvalue: {
                this.test = maxp >= this.exitlimit;
                break;
            }
            case bic: {
                this.test = bestbic < this.globalbestbic;
                break;
            }
            case mbic: {
                this.test = bestmbic < this.globalbestmbic;
                break;
            }
            case aic: {
                boolean bl = this.test = bestaic < this.globalbestaic;
            }
        }
        if (this.test && maxterm != 0) {
            ModelEffect me = this.currentModel.remove(maxterm);
            this.globalbestbic = bestbic;
            this.globalbestmbic = bestmbic;
            this.globalbestaic = bestaic;
            return true;
        }
        return false;
    }

    public void runPermutationTestNoMissingData() {
        int p;
        ArrayList<double[]> permutedData = new ArrayList<double[]>();
        Object PvalueVectorAcrossMarkers = null;
        int indexOfThreshold = (int)(this.alpha * (double)this.numberOfPermutations);
        int numberOfSites = this.myGenotype.numberOfSites();
        System.out.println("-----------------Running permutations...----------------");
        int numberOfObs = this.y.length;
        double totalSS = 0.0;
        for (int i = 0; i < numberOfObs; ++i) {
            totalSS += this.y[i] * this.y[i];
        }
        ArrayList<double[]> baseModelSSdf = new ArrayList<double[]>();
        double[] permTotalSS = new double[this.numberOfPermutations];
        int[] mean = new int[numberOfObs];
        FactorModelEffect meanME = new FactorModelEffect(mean, false, "mean");
        int columnNumber = 2;
        columnNumber += this.covariateAttributeList.size();
        DoubleMatrix[][] Xmatrices = new DoubleMatrix[1][columnNumber += this.factorAttributeList.size()];
        Xmatrices[0][0] = meanME.getX();
        int effectCount = 1;
        for (PhenotypeAttribute attr : this.factorAttributeList) {
            CategoricalAttribute ca = (CategoricalAttribute)attr;
            ArrayList ids = new ArrayList();
            String[] labels = AssociationUtils.getNonMissingValues(ca.allLabels(), (BitSet)this.missing);
            int[] levels = ModelEffectUtils.getIntegerLevels(labels, ids);
            FactorModelEffect fme = new FactorModelEffect(levels, true, new Object[]{attr.name(), ids});
            if (this.isNested && this.myPhenotype.indexOfAttribute(attr) == this.nestingFactorIndex) {
                this.nestingEffect = fme;
                this.nestingFactorNames = ids;
            }
            Xmatrices[0][effectCount++] = fme.getX();
        }
        for (PhenotypeAttribute attr : this.covariateAttributeList) {
            NumericAttribute na = (NumericAttribute)attr;
            double[] cov = AssociationUtils.getNonMissingDoubles(na.floatValues(), (BitSet)this.missing);
            CovariateModelEffect cme = new CovariateModelEffect(cov, na.name());
            Xmatrices[0][effectCount++] = cme.getX();
        }
        SweepFastLinearModel baseSflm = new SweepFastLinearModel(this.currentModel, this.y);
        DoubleMatrix resAsDoubleMatrix = baseSflm.getResiduals();
        DoubleMatrix predAsDoubleMatrix = baseSflm.getPredictedValues();
        double[] res = new double[numberOfObs];
        double[] pred = new double[numberOfObs];
        for (int i = 0; i < numberOfObs; ++i) {
            res[i] = resAsDoubleMatrix.get(i, 0);
            pred[i] = predAsDoubleMatrix.get(i, 0);
        }
        double[] minP = new double[this.numberOfPermutations];
        DoubleMatrix minPAsDoubleMatrix = null;
        for (p = 0; p < this.numberOfPermutations; ++p) {
            int i;
            minP[p] = 1.0;
            double[] pdata = new double[numberOfObs];
            System.arraycopy(res, 0, pdata, 0, numberOfObs);
            BasicShuffler.shuffle(pdata);
            for (i = 0; i < numberOfObs; ++i) {
                pdata[i] = pdata[i] + pred[i];
            }
            totalSS = 0.0;
            for (i = 0; i < numberOfObs; ++i) {
                totalSS += pdata[i] * pdata[i];
            }
            permTotalSS[p] = totalSS;
            permutedData.add(pdata);
            SweepFastLinearModel sflm = new SweepFastLinearModel(this.currentModel, pdata);
            baseModelSSdf.add(sflm.getFullModelSSdf());
        }
        for (int m = 0; m < numberOfSites; ++m) {
            ModelEffect markerEffect = null;
            SNP snp = new SNP(this.myGenotype.siteName(m), this.myGenotype.chromosome(m), this.myGenotype.chromosomalPosition(m), m);
            if (this.myGenotype.hasReferenceProbablity()) {
                double[] cov = new double[this.numberNotMissing];
                int count = 0;
                float[] referenceProb = this.myData.referenceProb(m);
                for (int i = 0; i < this.totalNumber; ++i) {
                    if (this.missing.fastGet(i)) continue;
                    cov[count++] = referenceProb[i];
                }
                if (this.isNested) {
                    CovariateModelEffect cme = new CovariateModelEffect(cov);
                    markerEffect = new NestedCovariateModelEffect(cme, this.nestingEffect);
                    markerEffect.setID(snp);
                } else {
                    markerEffect = new CovariateModelEffect(cov, snp);
                }
            } else if (this.myGenotype.hasGenotype()) {
                byte minor = this.myGenotype.minorAllele(m);
                double[] cov = new double[this.numberNotMissing];
                byte[] siteGeno = AssociationUtils.getNonMissingBytes(this.myData.genotypeAllTaxa(m), this.missing);
                for (int i = 0; i < this.numberNotMissing; ++i) {
                    byte[] diploidAlleles = GenotypeTableUtils.getDiploidValues(siteGeno[i]);
                    if (diploidAlleles[0] == minor) {
                        int n = i;
                        cov[n] = cov[n] + 0.5;
                    }
                    if (diploidAlleles[1] != minor) continue;
                    int n = i;
                    cov[n] = cov[n] + 0.5;
                }
                if (this.isNested) {
                    CovariateModelEffect cme = new CovariateModelEffect(cov);
                    markerEffect = new NestedCovariateModelEffect(cme, this.nestingEffect);
                    markerEffect.setID(snp);
                } else {
                    markerEffect = new CovariateModelEffect(cov, snp);
                }
            } else {
                throw new IllegalArgumentException("No genotypes or reference probabilities in the data set.");
            }
            Xmatrices[0][columnNumber - 1] = markerEffect.getX();
            DoubleMatrix X = DoubleMatrixFactory.DEFAULT.compose(Xmatrices);
            this.currentModel.add(markerEffect);
            SweepFastLinearModel sflm = new SweepFastLinearModel(this.currentModel, this.y);
            double[] modelSSdf = sflm.getFullModelSSdf();
            DoubleMatrix G = sflm.getInverseOfXtX();
            for (int p2 = 0; p2 < this.numberOfPermutations; ++p2) {
                double probF;
                double[] pdata = (double[])permutedData.get(p2);
                DoubleMatrix yperm = DoubleMatrixFactory.DEFAULT.make(numberOfObs, 1, pdata);
                totalSS = permTotalSS[p2];
                DoubleMatrix Xty = X.crossproduct(yperm);
                double[] reducedSSdf = (double[])baseModelSSdf.get(p2);
                double fullSS = Xty.crossproduct(G.mult(Xty)).get(0, 0);
                double fulldf = modelSSdf[1];
                double markerSS = fullSS - reducedSSdf[0];
                double markerdf = fulldf - reducedSSdf[1];
                double errorSS = totalSS - fullSS;
                double errordf = (double)numberOfObs - fulldf;
                double F = markerSS / markerdf / errorSS * errordf;
                try {
                    probF = LinearModelUtils.Ftest(F, markerdf, errordf);
                }
                catch (Exception e) {
                    probF = 1.0;
                }
                minP[p2] = probF;
                minPAsDoubleMatrix = DoubleMatrixFactory.DEFAULT.make(minP.length, 1, minP);
            }
            PvalueVectorAcrossMarkers = m == 0 ? minPAsDoubleMatrix : PvalueVectorAcrossMarkers.concatenate(minPAsDoubleMatrix, false);
            this.currentModel.remove(markerEffect);
        }
        System.out.println(PvalueVectorAcrossMarkers.toString());
        for (p = 0; p < this.numberOfPermutations; ++p) {
            double minFromOnePermutation = 1.0;
            for (int m = 0; m < numberOfSites; ++m) {
                minFromOnePermutation = Math.min(PvalueVectorAcrossMarkers.get(p, m), minFromOnePermutation);
            }
            this.minPvalues[p] = minFromOnePermutation;
        }
        Arrays.sort(this.minPvalues);
        this.enterlimit = this.minPvalues[indexOfThreshold];
        this.exitlimit = 2.0 * this.enterlimit;
        System.out.println("--------------the Enter limit is " + this.enterlimit);
        System.out.println("--------------the Exit limit is " + this.exitlimit);
        System.out.println("--------------indexOfThreshold is " + indexOfThreshold);
    }

    public TableReport getPermutationReport() {
        if (this.numberOfPermutations == 0) {
            return null;
        }
        LinkedList<Object[]> pValueReportTable = new LinkedList<Object[]>();
        for (int i = 0; i < this.numberOfPermutations; ++i) {
            Object[] pValueReportRow = new Object[]{new Double(this.minPvalues[i])};
            pValueReportTable.add(pValueReportRow);
        }
        Object[][] table = new Object[pValueReportTable.size()][];
        pValueReportTable.toArray((T[])table);
        String reportName = this.numberOfPermutations + " Permutations for " + this.datasetName;
        Object[] reportHeader = new String[]{"P-value"};
        return new SimpleTableReport(reportName, reportHeader, table);
    }

    public LinkedList<Object[]> createReportRowsFromCurrentModel(SweepFastLinearModel sflm) {
        String traitname = this.dataAttributeList.get(this.currentPhenotypeIndex).name();
        int ncol = this.anovaReportHeader.length;
        LinkedList<Object[]> reportTable = new LinkedList<Object[]>();
        double[] residualSSdf = sflm.getResidualSSdf();
        int n = this.y.length;
        int numberOfSites = this.myGenotype.numberOfSites();
        double[] errorss = sflm.getResidualSSdf();
        double[] modeldf = sflm.getFullModelSSdf();
        double pForBIC = modeldf[1];
        double bic = (double)n * Math.log(errorss[0] / (double)n) + pForBIC * Math.log(n);
        double aic = (double)n * Math.log(errorss[0] / (double)n) + 2.0 * pForBIC;
        System.out.println("error ss is " + errorss[0]);
        System.out.println("pForBIC is " + pForBIC);
        System.out.println("n is " + n);
        double numberOfTwoWayInteractions = (double)(numberOfSites * (numberOfSites - 1)) / 2.0;
        double pForMbic = modeldf[1];
        double qForMbic = 0.0;
        double mbic = qForMbic == 0.0 ? (double)n * Math.log(errorss[0]) + (pForMbic + qForMbic) * Math.log(n) + 2.0 * pForMbic * Math.log((double)numberOfSites / 2.2 - 1.0) : (double)n * Math.log(errorss[0]) + (pForMbic + qForMbic) * Math.log(n) + 2.0 * pForMbic * Math.log((double)numberOfSites / 2.2 - 1.0) + 2.0 * qForMbic * Math.log(numberOfTwoWayInteractions / 2.2 - 1.0);
        int effectPtr = 0;
        for (ModelEffect me : this.currentModel) {
            double pval;
            Object[] reportRow = new Object[ncol];
            int ptr = 0;
            reportRow[ptr++] = traitname;
            if (me.getID() instanceof SNP) {
                SNP snp = (SNP)me.getID();
                reportRow[ptr++] = snp.name;
                reportRow[ptr++] = snp.locus.getName();
                reportRow[ptr++] = Integer.toString(snp.position);
            } else {
                reportRow[ptr++] = me.getID() instanceof String ? me.getID().toString() : (me instanceof FactorModelEffect ? ((Object[])me.getID())[0].toString() : me.getID().toString());
                reportRow[ptr++] = "--";
                reportRow[ptr++] = "--";
            }
            double[] effectSSdf = sflm.getMarginalSSdf(effectPtr);
            double ms = effectSSdf[0] / effectSSdf[1];
            double Fval = ms / residualSSdf[0] * residualSSdf[1];
            try {
                pval = LinearModelUtils.Ftest(Fval, effectSSdf[1], residualSSdf[1]);
            }
            catch (Exception e) {
                pval = Double.NaN;
            }
            reportRow[ptr++] = new Integer((int)effectSSdf[1]);
            reportRow[ptr++] = new Double(effectSSdf[0]);
            reportRow[ptr++] = new Double(ms);
            reportRow[ptr++] = new Double(Fval);
            reportRow[ptr++] = new Double(pval);
            reportRow[ptr++] = new Double(bic);
            reportRow[ptr++] = new Double(mbic);
            reportRow[ptr++] = new Double(aic);
            double[] modelSSdf = sflm.getModelcfmSSdf();
            reportRow[ptr++] = new Double(modelSSdf[0] / (modelSSdf[0] + residualSSdf[0]));
            reportTable.add(reportRow);
            ++effectPtr;
        }
        int ptr = 0;
        Object[] reportRow = new Object[ncol];
        reportRow[ptr++] = traitname;
        reportRow[ptr++] = "Error";
        reportRow[ptr++] = "--";
        reportRow[ptr++] = "--";
        reportRow[ptr++] = new Integer((int)residualSSdf[1]);
        reportRow[ptr++] = new Double(residualSSdf[0]);
        reportRow[ptr++] = new Double(residualSSdf[0] / residualSSdf[1]);
        reportRow[ptr++] = new Double(Double.NaN);
        reportRow[ptr++] = new Double(Double.NaN);
        reportTable.add(reportRow);
        return reportTable;
    }

    public LinkedList<Object[]> createReportRowsFromCurrentModelAfterScanCI(SweepFastLinearModel sflm) {
        String traitname = this.dataAttributeList.get(this.currentPhenotypeIndex).name();
        int ncol = this.anovaReportWithCIHeader.length;
        LinkedList<Object[]> reportTable = new LinkedList<Object[]>();
        double[] residualSSdf = sflm.getResidualSSdf();
        int n = this.y.length;
        int numberOfSites = this.myGenotype.numberOfSites();
        int firstMarkerIndex = 1;
        firstMarkerIndex += this.factorAttributeList.size();
        firstMarkerIndex += this.covariateAttributeList.size();
        double[] errorss = sflm.getResidualSSdf();
        double[] modeldf = sflm.getFullModelSSdf();
        double pForBIC = modeldf[1];
        double bic = (double)n * Math.log(errorss[0] / (double)n) + pForBIC * Math.log(n);
        double aic = (double)n * Math.log(errorss[0] / (double)n) + 2.0 * pForBIC;
        System.out.println("error ss is " + errorss[0]);
        System.out.println("pForBIC is " + pForBIC);
        System.out.println("n is " + n);
        double numberOfTwoWayInteractions = (double)(numberOfSites * (numberOfSites - 1)) / 2.0;
        double pForMbic = modeldf[1];
        double qForMbic = 0.0;
        double mbic = qForMbic == 0.0 ? (double)n * Math.log(errorss[0]) + (pForMbic + qForMbic) * Math.log(n) + 2.0 * pForMbic * Math.log((double)numberOfSites / 2.2 - 1.0) : (double)n * Math.log(errorss[0]) + (pForMbic + qForMbic) * Math.log(n) + 2.0 * pForMbic * Math.log((double)numberOfSites / 2.2 - 1.0) + 2.0 * qForMbic * Math.log(numberOfTwoWayInteractions / 2.2 - 1.0);
        int effectPtr = 0;
        for (ModelEffect me : this.currentModel) {
            double pval;
            Object[] reportRow = new Object[ncol];
            int ptr = 0;
            reportRow[ptr++] = traitname;
            if (me.getID() instanceof SNP) {
                SNP snp = (SNP)me.getID();
                reportRow[ptr++] = snp.name;
                reportRow[ptr++] = snp.locus.getName();
                reportRow[ptr++] = Integer.toString(snp.position);
            } else {
                reportRow[ptr++] = me.getID() instanceof String ? me.getID().toString() : (me instanceof FactorModelEffect ? ((Object[])me.getID())[0].toString() : me.getID().toString());
                reportRow[ptr++] = "--";
                reportRow[ptr++] = "--";
            }
            double[] effectSSdf = sflm.getMarginalSSdf(effectPtr);
            double ms = effectSSdf[0] / effectSSdf[1];
            double Fval = ms / residualSSdf[0] * residualSSdf[1];
            try {
                pval = LinearModelUtils.Ftest(Fval, effectSSdf[1], residualSSdf[1]);
            }
            catch (Exception e) {
                pval = Double.NaN;
            }
            reportRow[ptr++] = new Integer((int)effectSSdf[1]);
            reportRow[ptr++] = new Double(effectSSdf[0]);
            reportRow[ptr++] = new Double(ms);
            reportRow[ptr++] = new Double(Fval);
            reportRow[ptr++] = new Double(pval);
            reportRow[ptr++] = new Double(bic);
            reportRow[ptr++] = new Double(mbic);
            reportRow[ptr++] = new Double(aic);
            double[] modelSSdf = sflm.getModelcfmSSdf();
            reportRow[ptr++] = new Double(modelSSdf[0] / (modelSSdf[0] + residualSSdf[0]));
            if (me.getID() instanceof SNP) {
                reportRow[ptr++] = new String(this.myGenotype.siteName(this.theUpperAndLowerBound[effectPtr - firstMarkerIndex][0]));
                reportRow[ptr++] = new String(this.myGenotype.siteName(this.theUpperAndLowerBound[effectPtr - firstMarkerIndex][1]));
            } else {
                reportRow[ptr++] = "--";
                reportRow[ptr++] = "--";
            }
            reportTable.add(reportRow);
            ++effectPtr;
        }
        int ptr = 0;
        Object[] reportRow = new Object[ncol];
        reportRow[ptr++] = traitname;
        reportRow[ptr++] = "Error";
        reportRow[ptr++] = "--";
        reportRow[ptr++] = "--";
        reportRow[ptr++] = new Integer((int)residualSSdf[1]);
        reportRow[ptr++] = new Double(residualSSdf[0]);
        reportRow[ptr++] = new Double(residualSSdf[0] / residualSSdf[1]);
        reportRow[ptr++] = new Double(Double.NaN);
        reportRow[ptr++] = new Double(Double.NaN);
        reportTable.add(reportRow);
        return reportTable;
    }

    public Datum createReportFromCurrentModel(SweepFastLinearModel sflm) {
        String traitname = this.dataAttributeList.get(this.currentPhenotypeIndex).name();
        LinkedList<Object[]> reportTable = this.createReportRowsFromCurrentModel(sflm);
        Object[][] table = new Object[reportTable.size()][];
        reportTable.toArray((T[])table);
        String reportName = "ANOVA for " + traitname + ", " + this.datasetName;
        SimpleTableReport tr = new SimpleTableReport(reportName, this.anovaReportHeader, table);
        return new Datum(reportName, tr, "");
    }

    public Datum createReportFromCurrentModelWithCI(SweepFastLinearModel sflm) {
        String traitname = this.dataAttributeList.get(this.currentPhenotypeIndex).name();
        LinkedList<Object[]> reportTable = this.createReportRowsFromCurrentModelAfterScanCI(sflm);
        Object[][] table = new Object[reportTable.size()][];
        reportTable.toArray((T[])table);
        String reportName = "ANOVA With CI for " + traitname + ", " + this.datasetName;
        SimpleTableReport tr = new SimpleTableReport(reportName, this.anovaReportWithCIHeader, table);
        return new Datum(reportName, tr, "");
    }

    public void appendAnovaResults(SweepFastLinearModel sflm) {
        this.resultRowsAnova.addAll(this.createReportRowsFromCurrentModel(sflm));
    }

    public void appendAnovaResultsWithCI(SweepFastLinearModel sflm) {
        this.resultRowsAnovaWithCI.addAll(this.createReportRowsFromCurrentModelAfterScanCI(sflm));
    }

    public TableReport getAnovaReport() {
        String reportName = "ANOVA table for " + this.datasetName;
        Object[][] table = new Object[this.resultRowsAnova.size()][];
        this.resultRowsAnova.toArray((T[])table);
        return new SimpleTableReport(reportName, this.anovaReportHeader, table);
    }

    public TableReport getAnovaReportWithCI() {
        String reportName = "ANOVA table with CI scan for " + this.datasetName;
        Object[][] table = new Object[this.resultRowsAnovaWithCI.size()][];
        this.resultRowsAnovaWithCI.toArray((T[])table);
        return new SimpleTableReport(reportName, this.anovaReportWithCIHeader, table);
    }

    public TableReport getMarkerEffectReport() {
        if (this.rowsSiteEffectTable.size() == 0) {
            return null;
        }
        String reportName = "Marker effects for " + this.datasetName;
        Object[] reportHeader = new String[]{"Trait", "Snp", "Locus", "Position", "Within", "Estimate"};
        Object[][] table = new Object[this.rowsSiteEffectTable.size()][];
        this.rowsSiteEffectTable.toArray((T[])table);
        return new SimpleTableReport(reportName, reportHeader, table);
    }

    public TableReport getMarkerEffectReportWithCI() {
        if (this.rowsSiteEffectTableWithCI.size() == 0) {
            return null;
        }
        String reportName = "Marker effects for " + this.datasetName;
        Object[] reportHeader = new String[]{"Trait", "Snp", "Locus", "Position", "Within", "Estimate"};
        Object[][] table = new Object[this.rowsSiteEffectTableWithCI.size()][];
        this.rowsSiteEffectTableWithCI.toArray((T[])table);
        return new SimpleTableReport(reportName, reportHeader, table);
    }

    public void appendSiteEffectEstimates(SweepFastLinearModel sflm) {
        int nBaseModelParameters = 0;
        String traitname = this.dataAttributeList.get(this.currentPhenotypeIndex).name();
        for (int i = 0; i < this.numberOfBaseModelEffects; ++i) {
            nBaseModelParameters += this.currentModel.get(i).getEffectSize();
        }
        double[] beta = sflm.getBeta();
        int parameterIndex = nBaseModelParameters;
        for (int s = this.numberOfBaseModelEffects; s < this.currentModel.size(); ++s) {
            ModelEffect me = this.currentModel.get(s);
            if (me instanceof NestedCovariateModelEffect) {
                NestedCovariateModelEffect ncme = (NestedCovariateModelEffect)me;
                FactorModelEffect fme = ncme.getFactorModelEffect();
                SNP snp = (SNP)ncme.getID();
                int n = this.nestingFactorNames.size();
                for (int i = 0; i < n; ++i) {
                    Object[] rowValues = new Object[6];
                    int ptr = 0;
                    rowValues[ptr++] = traitname;
                    rowValues[ptr++] = snp.name;
                    rowValues[ptr++] = snp.locus.getName();
                    rowValues[ptr++] = new Integer(snp.position);
                    rowValues[ptr++] = this.nestingFactorNames.get(i);
                    rowValues[ptr++] = new Double(beta[parameterIndex++]);
                    this.rowsSiteEffectTable.add(rowValues);
                }
                continue;
            }
            if (me instanceof CovariateModelEffect) {
                SNP snp = (SNP)me.getID();
                Object[] rowValues = new Object[6];
                int ptr = 0;
                rowValues[ptr++] = traitname;
                rowValues[ptr++] = snp.name;
                rowValues[ptr++] = snp.locus.getName();
                rowValues[ptr++] = new Integer(snp.position);
                rowValues[ptr++] = "NA";
                rowValues[ptr++] = new Double(beta[parameterIndex++]);
                this.rowsSiteEffectTable.add(rowValues);
                continue;
            }
            if (!(me instanceof FactorModelEffect)) continue;
        }
    }

    public void appendSiteEffectEstimatesWithCI(SweepFastLinearModel sflm) {
        int nBaseModelParameters = 0;
        String traitname = this.dataAttributeList.get(this.currentPhenotypeIndex).name();
        for (int i = 0; i < this.numberOfBaseModelEffects; ++i) {
            nBaseModelParameters += this.currentModel.get(i).getEffectSize();
        }
        double[] beta = sflm.getBeta();
        int parameterIndex = nBaseModelParameters;
        for (int s = this.numberOfBaseModelEffects; s < this.currentModel.size(); ++s) {
            ModelEffect me = this.currentModel.get(s);
            if (me instanceof NestedCovariateModelEffect) {
                NestedCovariateModelEffect ncme = (NestedCovariateModelEffect)me;
                FactorModelEffect fme = ncme.getFactorModelEffect();
                SNP snp = (SNP)ncme.getID();
                int n = this.nestingFactorNames.size();
                for (int i = 0; i < n; ++i) {
                    Object[] rowValues = new Object[6];
                    int ptr = 0;
                    rowValues[ptr++] = traitname;
                    rowValues[ptr++] = snp.name;
                    rowValues[ptr++] = snp.locus.getName();
                    rowValues[ptr++] = new Integer(snp.position);
                    rowValues[ptr++] = this.nestingFactorNames.get(i);
                    rowValues[ptr++] = new Double(beta[parameterIndex++]);
                    this.rowsSiteEffectTableWithCI.add(rowValues);
                }
                continue;
            }
            if (me instanceof CovariateModelEffect) {
                SNP snp = (SNP)me.getID();
                Object[] rowValues = new Object[6];
                int ptr = 0;
                rowValues[ptr++] = traitname;
                rowValues[ptr++] = snp.name;
                rowValues[ptr++] = snp.locus.getName();
                rowValues[ptr++] = new Integer(snp.position);
                rowValues[ptr++] = "NA";
                rowValues[ptr++] = new Double(beta[parameterIndex++]);
                this.rowsSiteEffectTableWithCI.add(rowValues);
                continue;
            }
            if (!(me instanceof FactorModelEffect)) continue;
        }
    }

    public Phenotype generateChromosomeResidualsFromCurrentModel() {
        ArrayList<PhenotypeAttribute> attributes = new ArrayList<PhenotypeAttribute>();
        ArrayList<Phenotype.ATTRIBUTE_TYPE> types = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
        Taxon[] allTaxa = this.myPhenotype.taxaAttribute().allTaxa();
        Taxon[] nonmissingTaxa = AssociationUtils.getNonMissingValues(allTaxa, (BitSet)this.missing);
        attributes.add(new TaxaAttribute(Arrays.asList(nonmissingTaxa)));
        types.add(Phenotype.ATTRIBUTE_TYPE.taxa);
        for (PhenotypeAttribute factor : this.factorAttributeList) {
            String[] values = ((CategoricalAttribute)factor).allLabels();
            attributes.add(new CategoricalAttribute(factor.name(), AssociationUtils.getNonMissingValues(values, (BitSet)this.missing)));
            types.add(Phenotype.ATTRIBUTE_TYPE.factor);
        }
        for (int c = 0; c < 10; ++c) {
            String chrname = String.format("c%d", c + 1);
            List<ModelEffect> chrModel = this.currentModel.stream().filter(this.notInChr(c + 1)).collect(Collectors.toList());
            SweepFastLinearModel sflm = new SweepFastLinearModel(chrModel, this.y);
            DoubleMatrix resid = sflm.getResiduals();
            float[] data = AssociationUtils.convertDoubleArrayToFloat(resid.to1DArray());
            attributes.add(new NumericAttribute(chrname, data, new OpenBitSet(data.length)));
            types.add(Phenotype.ATTRIBUTE_TYPE.data);
        }
        return new PhenotypeBuilder().fromAttributeList(attributes, types).build().get(0);
    }

    private Predicate<ModelEffect> notInChr(int chr) {
        return me -> !(me.getID() instanceof SNP) || me.getID() instanceof SNP && ((SNP)me.getID()).locus.getChromosomeNumber() != chr;
    }

    public void setEnterlimits(double[] enterlimits) {
        this.enterlimits = enterlimits;
    }

    public void setExitlimits(double[] exitlimits) {
        this.exitlimits = exitlimits;
    }

    public void setEnterlimit(double enterlimit) {
        this.enterlimit = enterlimit;
    }

    public void setExitlimit(double exitlimit) {
        this.exitlimit = exitlimit;
    }

    public void setMaxNumberOfMarkers(int maxNumberOfMarkers) {
        this.maxNumberOfMarkers = maxNumberOfMarkers;
    }

    public void setNestingEffectIndex(int nestingFactorIndex) {
        this.nestingFactorIndex = nestingFactorIndex;
    }

    public void setNested(boolean isNested) {
        this.isNested = isNested;
    }

    public void setNumberOfPermutations(int numberOfPermutations) {
        this.numberOfPermutations = numberOfPermutations;
        this.minPvalues = new double[this.numberOfPermutations];
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public static enum MODEL_TYPE {
        pvalue,
        bic,
        mbic,
        aic;

    }

    public static enum VIF_TYPE {
        min,
        average,
        max;

    }
}

