/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.modelfitter;

import com.google.common.collect.Range;
import java.awt.Frame;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.modelfitter.StepwiseOLSModelFitter;
import net.maizegenetics.phenotype.GenotypePhenotype;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.TableReport;
import org.apache.log4j.Logger;

public class StepwiseOLSModelFitterPlugin
extends AbstractPlugin {
    private List<String> myFactorList;
    private GenotypePhenotype myGenoPheno;
    private String datasetName;
    private final String NONE = "None";
    private PluginParameter<StepwiseOLSModelFitter.MODEL_TYPE> modelType = new PluginParameter.Builder<StepwiseOLSModelFitter.MODEL_TYPE>("modelType", StepwiseOLSModelFitter.MODEL_TYPE.pvalue, StepwiseOLSModelFitter.MODEL_TYPE.class).range((Comparable<T>[])StepwiseOLSModelFitter.MODEL_TYPE.values()).guiName("Model type").description("The model selection criteria used to determine which terms enter the model and how many. Value must be one of pvalue, bic, mbic, or aic").build();
    private PluginParameter<Double> enterlimit = new PluginParameter.Builder<Double>("enter", 1.0E-6, Double.class).range((Range<Comparable<Double>>)Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0))).guiName("Entry limit").description("The enter limit or maximum p-value for which a term can enter the model").build();
    private PluginParameter<Double> exitlimit = new PluginParameter.Builder<Double>("exit", 2.0E-6, Double.class).range((Range<Comparable<Double>>)Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0))).guiName("Exit limit").description("A term exits the model on a backward step if its p-value is greater than this value").build();
    private PluginParameter<Integer> maxNumberOfMarkers = new PluginParameter.Builder<Integer>("maxMarkers", 100, Integer.class).range((Range<Comparable<Integer>>)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(10000))).guiName("Maximum markers").description("The maximum number of markers that will be fit, if the enter limit is not reached first").build();
    private PluginParameter<Boolean> nestMarkers = new PluginParameter.Builder<Boolean>("nestMarkers", false, Boolean.class).guiName("Nest markers").description("Should markers be nested within a model factor").build();
    private PluginParameter<String> nestingFactor = new PluginParameter.Builder<String>("nestFactor", null, String.class).guiName("Nesting factor").description("Nest markers within this factor.").dependentOnParameter(this.nestMarkers).objectListSingleSelect().build();
    private PluginParameter<Integer> numberOfPermutations = new PluginParameter.Builder<Integer>("nperm", 0, Integer.class).range((Range<Comparable<Integer>>)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100000))).guiName("Number of permutations").description("Number of permutations for the model to determine an empirical alpha").build();
    private static final Logger myLogger = Logger.getLogger(StepwiseOLSModelFitterPlugin.class);
    private double alpha = 0.05;

    public StepwiseOLSModelFitterPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    public StepwiseOLSModelFitterPlugin() {
        super(null, false);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        List<Datum> datasets = input.getDataOfType(new Class[]{GenotypePhenotype.class});
        if (datasets.size() < 1) {
            String msg = "Error in performFunction: No appropriate dataset selected.";
            throw new IllegalArgumentException(msg);
        }
        if (datasets.size() > 1) {
            String msg = "Multiple datasets selected. Only one dataset is allowed.";
            throw new IllegalArgumentException(msg);
        }
        this.myGenoPheno = (GenotypePhenotype)datasets.get(0).getData();
        this.datasetName = datasets.get(0).getName();
        this.myFactorList = this.myGenoPheno.phenotype().attributeListOfType(Phenotype.ATTRIBUTE_TYPE.factor).stream().map(pa -> pa.name()).collect(Collectors.toList());
        if (this.myFactorList.isEmpty()) {
            List<String> noneList = Arrays.asList("None");
            this.nestingFactor = new PluginParameter<String>(this.nestingFactor, noneList);
        } else {
            this.nestingFactor = new PluginParameter<String>(this.nestingFactor, this.myFactorList);
        }
    }

    @Override
    protected void postProcessParameters() {
        if (this.nestMarkers.value().booleanValue() && this.nestingFactor.value().isEmpty()) {
            if (this.myFactorList.size() == 1) {
                this.nestingFactor(this.myFactorList.get(0));
            } else if (this.myFactorList.size() > 1) {
                throw new IllegalArgumentException("Nest markers was checked (set to true), but a single factor was not selected to nest markers within. This must be corrected before the analysis will run.");
            }
        }
    }

    @Override
    public DataSet processData(DataSet input) {
        StepwiseOLSModelFitter modelFitter = new StepwiseOLSModelFitter(this.myGenoPheno, this.datasetName);
        modelFitter.setEnterlimit(this.enterlimit.value());
        modelFitter.setExitlimit(this.exitlimit.value());
        modelFitter.setMaxNumberOfMarkers(this.maxNumberOfMarkers.value());
        modelFitter.setNested(this.nestMarkers.value());
        if (this.nestMarkers.value().booleanValue()) {
            int ndx = this.myGenoPheno.phenotype().attributeIndexForName(this.nestingFactor.value());
            if (ndx < 0) {
                modelFitter.setNested(false);
            } else {
                modelFitter.setNestingEffectIndex(ndx);
            }
        }
        modelFitter.setModelType(this.modelType.value());
        modelFitter.setNumberOfPermutations(this.numberOfPermutations.value());
        modelFitter.setAlpha(this.alpha);
        modelFitter.runAnalysis();
        TableReport trResults = modelFitter.getAnovaReport();
        TableReport trEffects = modelFitter.getMarkerEffectReport();
        TableReport trResultsAfterCIScan = modelFitter.getAnovaReportWithCI();
        TableReport trEffectsAfterCIScan = modelFitter.getMarkerEffectReportWithCI();
        TableReport trPermPvalues = modelFitter.getPermutationReport();
        LinkedList<Datum> datumList = new LinkedList<Datum>();
        if (trResults != null) {
            datumList.add(new Datum("ANOVA_stepwise_" + this.datasetName, trResults, "comments"));
        }
        if (trEffects != null) {
            datumList.add(new Datum("Marker_estimates_" + this.datasetName, trEffects, "comments"));
        }
        if (trResultsAfterCIScan != null) {
            datumList.add(new Datum("ANOVA_stepwise_After_CI_Scan" + this.datasetName, trResultsAfterCIScan, "comments"));
        }
        if (trEffectsAfterCIScan != null) {
            datumList.add(new Datum("Marker_estimates_After_CI_Scan" + this.datasetName, trEffectsAfterCIScan, "comments"));
        }
        if (trPermPvalues != null) {
            datumList.add(new Datum("Permuted_Pvalues" + this.datasetName, trPermPvalues, "comments"));
        }
        DataSet myResult = new DataSet(datumList, (Plugin)this);
        this.fireDataSetReturned(myResult);
        return myResult;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = StepwiseOLSModelFitterPlugin.class.getResource("stepwise.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Stepwise";
    }

    @Override
    public String getToolTipText() {
        return "Fit multiple markers in a single model (experimental).";
    }

    @Override
    public String getCitation() {
        String citation = "Written in 2013 by Peter Bradbury and Alex Lipka";
        return citation;
    }

    public TableReport runPlugin(DataSet input) {
        return (TableReport)this.performFunction(input).getData(0).getData();
    }

    public StepwiseOLSModelFitter.MODEL_TYPE modelType() {
        return this.modelType.value();
    }

    public StepwiseOLSModelFitterPlugin modelType(StepwiseOLSModelFitter.MODEL_TYPE value) {
        this.modelType = new PluginParameter<StepwiseOLSModelFitter.MODEL_TYPE>(this.modelType, value);
        return this;
    }

    public Double enterlimit() {
        return this.enterlimit.value();
    }

    public StepwiseOLSModelFitterPlugin enterlimit(Double value) {
        this.enterlimit = new PluginParameter<Double>(this.enterlimit, value);
        return this;
    }

    public Double exitlimit() {
        return this.exitlimit.value();
    }

    public StepwiseOLSModelFitterPlugin exitlimit(Double value) {
        this.exitlimit = new PluginParameter<Double>(this.exitlimit, value);
        return this;
    }

    public Integer maxNumberOfMarkers() {
        return this.maxNumberOfMarkers.value();
    }

    public StepwiseOLSModelFitterPlugin maxNumberOfMarkers(Integer value) {
        this.maxNumberOfMarkers = new PluginParameter<Integer>(this.maxNumberOfMarkers, value);
        return this;
    }

    public Boolean nestMarkers() {
        return this.nestMarkers.value();
    }

    public StepwiseOLSModelFitterPlugin nestMarkers(Boolean value) {
        this.nestMarkers = new PluginParameter<Boolean>(this.nestMarkers, value);
        return this;
    }

    public String nestingFactor() {
        return this.nestingFactor.value();
    }

    public StepwiseOLSModelFitterPlugin nestingFactor(String value) {
        this.nestingFactor = new PluginParameter<String>(this.nestingFactor, value);
        return this;
    }

    public Integer numberOfPermutations() {
        return this.numberOfPermutations.value();
    }

    public StepwiseOLSModelFitterPlugin numberOfPermutations(Integer value) {
        this.numberOfPermutations = new PluginParameter<Integer>(this.numberOfPermutations, value);
        return this;
    }
}

