/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.numericaltransform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.stream.Collectors;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeUtils;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.apache.commons.math3.stat.inference.KolmogorovSmirnovTest;

public class BoxCoxTransformation {
    public Phenotype applyBoxCox(Phenotype pheno, boolean addSmallVal, long randomSeed, double startLambda, double endLambda, double stepLambda) throws Exception {
        ArrayList attributes = (ArrayList)pheno.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.data);
        attributes.addAll((ArrayList)pheno.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.covariate));
        ArrayList phenoNames = (ArrayList)attributes.stream().map(phenoAttr -> phenoAttr.name()).collect(Collectors.toList());
        ArrayList taxonList = (ArrayList)pheno.taxaAttribute().allTaxaAsList();
        ArrayList uniqueTaxaNames = (ArrayList)pheno.taxaAttribute().allTaxaAsList().stream().map(taxon -> taxon.getName()).collect(Collectors.toList());
        double minValue = Double.MAX_VALUE;
        HashMap phenoToDataList = new HashMap();
        for (String varName : phenoNames) {
            ArrayList<Double> currentPhenoValues = new ArrayList<Double>();
            for (int i = 0; i < taxonList.size(); ++i) {
                double currentValue = ((Float)pheno.value(i, pheno.attributeIndexForName(varName))).doubleValue();
                currentPhenoValues.add(currentValue);
                if (!(currentValue < minValue) || !(currentValue > 0.0)) continue;
                minValue = currentValue;
            }
            phenoToDataList.put(varName, currentPhenoValues);
        }
        if (!addSmallVal) {
            minValue = 0.0;
        } else {
            System.out.println(minValue);
        }
        double[][] fullTransformedVals = new double[uniqueTaxaNames.size()][phenoNames.size()];
        for (int phenoNameIndex = 0; phenoNameIndex < phenoNames.size(); ++phenoNameIndex) {
            double[] boxCoxValues = BoxCoxTransformation.computeBoxCox((ArrayList)phenoToDataList.get(phenoNames.get(phenoNameIndex)), minValue, randomSeed, startLambda, endLambda, stepLambda);
            for (int taxaIndex = 0; taxaIndex < uniqueTaxaNames.size(); ++taxaIndex) {
                fullTransformedVals[taxaIndex][phenoNameIndex] = boxCoxValues[taxaIndex];
            }
        }
        ArrayList<ArrayList<Double>> avgValues = new ArrayList<ArrayList<Double>>();
        for (int taxaCounter = 0; taxaCounter < fullTransformedVals.length; ++taxaCounter) {
            ArrayList<Double> currentTaxaVals = new ArrayList<Double>();
            for (int phenoCounter = 0; phenoCounter < fullTransformedVals[taxaCounter].length; ++phenoCounter) {
                currentTaxaVals.add(fullTransformedVals[taxaCounter][phenoCounter]);
            }
            avgValues.add(currentTaxaVals);
        }
        ArrayList<Phenotype.ATTRIBUTE_TYPE> originalTypes = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
        for (int i = 0; i < pheno.attributeListCopy().size(); ++i) {
            originalTypes.add(pheno.attributeType(i));
        }
        return PhenotypeUtils.createPhenotypeFromTransform(uniqueTaxaNames, phenoNames, avgValues, pheno.name() + "_BoxCoxTransformed", originalTypes);
    }

    public static double[] computeBoxCox(ArrayList<Double> phenotypeValues, double minimumValue, long randomSeed, double startLambda, double endLambda, double stepLambda) {
        Random rand = new Random(randomSeed);
        ArrayList addedSmallPhenoValues = (ArrayList)phenotypeValues.stream().map(currentVal -> rand.nextDouble() * 0.5 * minimumValue + currentVal).collect(Collectors.toList());
        if (!BoxCoxTransformation.attributeHasVariation(addedSmallPhenoValues)) {
            double[] valuesToReturn = new double[addedSmallPhenoValues.size()];
            for (int i = 0; i < addedSmallPhenoValues.size(); ++i) {
                valuesToReturn[i] = (Double)addedSmallPhenoValues.get(i);
            }
            return valuesToReturn;
        }
        double currentLambda = startLambda;
        double[] currentValues = new double[addedSmallPhenoValues.size()];
        double bestTestStat = Double.MAX_VALUE;
        double bestMean = 0.0;
        double bestStDev = 0.0;
        for (double lambda = startLambda; lambda < endLambda; lambda += stepLambda) {
            NormalDistribution normDist;
            KolmogorovSmirnovTest kst;
            double testStat;
            double[] transformedValues = new double[addedSmallPhenoValues.size()];
            for (int i = 0; i < addedSmallPhenoValues.size(); ++i) {
                transformedValues[i] = BoxCoxTransformation.boxCoxTransform((Double)addedSmallPhenoValues.get(i), lambda);
            }
            StandardDeviation sdev = new StandardDeviation();
            double sampleStandardDev = sdev.evaluate(transformedValues);
            Mean meanObj = new Mean();
            double meanVal = meanObj.evaluate(transformedValues);
            if (sampleStandardDev <= 0.0 || Double.isNaN(sampleStandardDev) || Double.isNaN(meanVal) || !((testStat = (kst = new KolmogorovSmirnovTest()).kolmogorovSmirnovStatistic((RealDistribution)(normDist = new NormalDistribution(meanVal, sampleStandardDev)), transformedValues)) < bestTestStat)) continue;
            currentLambda = lambda;
            currentValues = transformedValues;
            bestTestStat = testStat;
            bestMean = meanVal;
            bestStDev = sampleStandardDev;
        }
        return currentValues;
    }

    private static double boxCoxTransform(double value, double lambda) {
        if (lambda == 0.0) {
            return Math.log(value);
        }
        return (Math.pow(value, lambda) - 1.0) / lambda;
    }

    private static boolean attributeHasVariation(ArrayList<Double> phenoAttribute) {
        double prevVal = phenoAttribute.get(0);
        for (int i = 1; i < phenoAttribute.size(); ++i) {
            if (phenoAttribute.get(i) == prevVal) continue;
            return true;
        }
        return false;
    }
}

