/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.numericaltransform;

import java.awt.Frame;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.numericaltransform.BoxCoxTransformation;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;

public class BoxCoxTransformationPlugin
extends AbstractPlugin {
    private PluginParameter<Double> startLambda = new PluginParameter.Builder<Double>("startLambda", -5.0, Double.class).description("Parameter to set the starting point for the Lambda search in Box Cox.  The algorithm will start at this value and iterate by Lambda Step until it reaches End Lambda.").build();
    private PluginParameter<Double> endLambda = new PluginParameter.Builder<Double>("endLambda", 5.0, Double.class).description("Parameter to set the ending point for the Lambda search in Box Cox. The algorithm will start at Start Lambda and iterate by Lambda Step until it reaches this value.").build();
    private PluginParameter<Double> stepLambda = new PluginParameter.Builder<Double>("LambdaStep", 0.2, Double.class).description("Parameter to set the iteration step for the Lambda search in Box Cox. The algorithm will start at Start Lambda and iterate by this value until it reaches the End Lambda.").build();
    private PluginParameter<Boolean> addSmallValue = new PluginParameter.Builder<Boolean>("addSmallValue", true, Boolean.class).description("Boolean to allow for a small random value to be added to each observed value. The value is calculated by the following:\nrand(0:1) * .5 * minObservedValue").build();
    private PluginParameter<Long> randomSeed = new PluginParameter.Builder<Long>("randomSeed", 12345L, Long.class).description("Random Seed to be used in the Random Small Number Generation").dependentOnParameter(this.addSmallValue).build();

    public BoxCoxTransformationPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        List<Datum> datumList = input.getDataOfType(Phenotype.class);
        if (datumList.size() != 1) {
            throw new IllegalArgumentException("BoxCoxTransformationPluging: select exactly one phenotype dataset to average.");
        }
        if (this.startLambda.value() > this.endLambda.value()) {
            throw new IllegalArgumentException("Start Lambda must be smaller than End Lambda");
        }
        BoxCoxTransformation boxCoxPheno = new BoxCoxTransformation();
        try {
            Phenotype myPhenotype = boxCoxPheno.applyBoxCox((Phenotype)datumList.get(0).getData(), this.addSmallValue.value(), this.randomSeed.value(), this.startLambda.value(), this.endLambda.value(), this.stepLambda.value());
            if (myPhenotype != null) {
                String name = myPhenotype.name();
                Datum td = new Datum(name, myPhenotype, null);
                DataSet tds = new DataSet(td, (Plugin)this);
                return tds;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return null;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Box Cox Transformation";
    }

    @Override
    public String getToolTipText() {
        return "Box Cox Transformation.";
    }

    @Override
    public String getCitation() {
        return "Bradbury PJ, Zhang Z, Kroon DE, Casstevens TM, Ramdoss Y, Buckler ES. (2007) TASSEL: Software for association mapping of complex traits in diverse samples. Bioinformatics 23:2633\u00ad2635.";
    }

    @Override
    public String pluginUserManualURL() {
        return "https://bitbucket.org/tasseladmin/tassel\u00ad5\u00adsource/wiki/UserManual/Kinship/Kinship";
    }

    public Phenotype runPlugin(DataSet input) {
        return (Phenotype)this.performFunction(input).getData(0).getData();
    }

    public Boolean addSmallValue() {
        return this.addSmallValue.value();
    }

    public BoxCoxTransformationPlugin addSmallValue(Boolean value) {
        this.addSmallValue = new PluginParameter<Boolean>(this.addSmallValue, value);
        return this;
    }

    public Long randomSeed() {
        return this.randomSeed.value();
    }

    public BoxCoxTransformationPlugin randomSeed(Long value) {
        this.randomSeed = new PluginParameter<Long>(this.randomSeed, value);
        return this;
    }

    public Double startLambda() {
        return this.startLambda.value();
    }

    public BoxCoxTransformationPlugin startLambda(Double value) {
        this.startLambda = new PluginParameter<Double>(this.startLambda, value);
        return this;
    }

    public Double endLambda() {
        return this.endLambda.value();
    }

    public BoxCoxTransformationPlugin endLambda(Double value) {
        this.endLambda = new PluginParameter<Double>(this.endLambda, value);
        return this;
    }

    public Double stepLambda() {
        return this.stepLambda.value();
    }

    public BoxCoxTransformationPlugin stepLambda(Double value) {
        this.stepLambda = new PluginParameter<Double>(this.stepLambda, value);
        return this;
    }
}

