/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.popgen;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.maizegenetics.analysis.popgen.LinkageDisequilibrium;

class LinkageDiseqDialog
extends JDialog {
    private boolean myRunAnalysis = false;
    private int myTestSite = 0;
    private String myAlignmentForSiteList;
    private int myNumSites;
    private JPanel myPanel = new JPanel();
    private JPanel myLDSelectionPanel = new JPanel();
    private JLabel myLDTypeLabel = new JLabel("Select LD type: ");
    private JComboBox<String> myLDType;
    private JPanel myLDOptionsPanel = new JPanel();
    private JLabel myFullMatrixLabel = new JLabel();
    private JTextField myWindowSizeTextField = new JTextField();
    private JLabel myWindowSizeLabel = new JLabel("LD Window Size: ");
    private JLabel myWindowSizeCountLabel = new JLabel();
    private int myWindowSize = 50;
    private JTextField mySiteByAllTextField = new JTextField();
    private JLabel mySiteByAllLabel = new JLabel("Site: ");
    private JLabel mySiteByAllCountLabel = new JLabel();
    private JLabel mySiteListLabel = new JLabel();
    private JPanel myAccumulateOptionsPanel = new JPanel();
    private JCheckBox myAccumulativeResultsBox = new JCheckBox("Accumulate R2 Results");
    private JTextField myAccumulativeResultsTextField = new JTextField();
    private JLabel myAccumulativeResultsLabel = new JLabel("Number Of Intervals: ");
    private int myNumAccumulativeInterval = 100;
    private JPanel myHetTreatmentPanel = new JPanel();
    private JLabel myHetTreatmentLabel = new JLabel("How to treat heterozygous calls:");
    private JComboBox<String> myHetTreatment;
    private JPanel myButtonsPanel = new JPanel();
    private JButton myRunButton = new JButton("Run");
    private JButton myCloseButton = new JButton("Close");

    public LinkageDiseqDialog(int numSites, String alignmentForSiteList) {
        super((Frame)null, "Linkage Disequilibrium", true);
        this.myAlignmentForSiteList = alignmentForSiteList;
        this.myNumSites = numSites;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String[] ldTypes = this.myAlignmentForSiteList != null ? new String[]{"Full Matrix", "Sliding Window", "Site by All", "Site List"} : new String[]{"Full Matrix", "Sliding Window", "Site by All"};
        this.myLDType = new JComboBox<String>(ldTypes);
        this.myLDType.setSelectedIndex(1);
        this.myFullMatrixLabel.setText("Full LD with " + this.myNumSites * ((this.myNumSites - 1) / 2) + " comparisons.");
        long n = Math.min(this.myNumSites - 1, this.myWindowSize);
        this.myWindowSizeCountLabel.setText("Sliding Window LD with " + (n * (n + 1L) / 2L + ((long)this.myNumSites - n - 1L) * n) + " comparisons.");
        this.mySiteByAllCountLabel.setText("Site by All LD with " + (this.myNumSites - 1) + " comparisons.");
        if (this.myAlignmentForSiteList != null) {
            this.mySiteListLabel.setText("Sites From: " + this.myAlignmentForSiteList);
        }
        this.myLDSelectionPanel.setLayout(new GridBagLayout());
        this.myLDSelectionPanel.add((Component)this.myLDTypeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(10, 7, 0, 0), 0, 0));
        this.myLDSelectionPanel.add(this.myLDType, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.myLDType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkageDiseqDialog.this.ldType_actionPerformed(e);
            }
        });
        this.myAccumulativeResultsBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkageDiseqDialog.this.accumulativeResultsBox_actionPerformed(e);
            }
        });
        this.myLDOptionsPanel.setLayout(new GridBagLayout());
        this.myLDOptionsPanel.add((Component)this.myFullMatrixLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.myFullMatrixLabel.setVisible(false);
        this.myWindowSizeTextField.setText("" + this.myWindowSize);
        this.myLDOptionsPanel.add((Component)this.myWindowSizeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(10, 7, 0, 0), 0, 0));
        this.myLDOptionsPanel.add((Component)this.myWindowSizeTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 0, 0, 7), 0, 0));
        this.myLDOptionsPanel.add((Component)this.myWindowSizeCountLabel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(7, 7, 0, 7), 0, 0));
        this.myWindowSizeTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent ke) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                LinkageDiseqDialog.this.windowSizeTextField_actionPerformed(e);
            }
        });
        this.myLDOptionsPanel.add((Component)this.mySiteByAllLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(10, 7, 0, 0), 0, 0));
        this.myLDOptionsPanel.add((Component)this.mySiteByAllTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 0, 0, 7), 0, 0));
        this.myLDOptionsPanel.add((Component)this.mySiteByAllCountLabel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(7, 7, 0, 7), 0, 0));
        this.mySiteByAllLabel.setVisible(false);
        this.mySiteByAllTextField.setVisible(false);
        this.mySiteByAllCountLabel.setVisible(false);
        this.myLDOptionsPanel.add((Component)this.mySiteListLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.mySiteListLabel.setVisible(false);
        String[] hetTypes = new String[]{"Ignore (inbred lines only)", "Set to missing", "Treat as third state"};
        this.myHetTreatment = new JComboBox<String>(hetTypes);
        this.myHetTreatment.setSelectedIndex(1);
        this.myHetTreatmentPanel.setLayout(new GridBagLayout());
        this.myHetTreatmentPanel.add((Component)this.myHetTreatmentLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.myHetTreatmentPanel.add(this.myHetTreatment, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.myAccumulativeResultsTextField.setText(this.myNumAccumulativeInterval + "");
        this.myAccumulateOptionsPanel.setLayout(new GridBagLayout());
        this.myAccumulateOptionsPanel.add((Component)this.myAccumulativeResultsBox, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(25, 7, 0, 7), 0, 0));
        this.myAccumulateOptionsPanel.add((Component)this.myAccumulativeResultsLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 22, 0, new Insets(7, 7, 0, 0), 0, 0));
        this.myAccumulateOptionsPanel.add((Component)this.myAccumulativeResultsTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(7, 0, 0, 7), 0, 0));
        this.myAccumulativeResultsLabel.setVisible(false);
        this.myAccumulativeResultsTextField.setVisible(false);
        this.myButtonsPanel.setLayout(new GridBagLayout());
        this.myButtonsPanel.add((Component)this.myRunButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 20, 0, new Insets(0, 150, -5, 0), 0, 0));
        this.myButtonsPanel.add((Component)this.myCloseButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 20, 0, new Insets(0, 0, -5, 0), 0, 0));
        this.myPanel.setLayout(new GridLayout(5, 1));
        this.myPanel.add(this.myLDSelectionPanel);
        this.myPanel.add(this.myLDOptionsPanel);
        this.myPanel.add(this.myHetTreatmentPanel);
        this.myPanel.add(this.myAccumulateOptionsPanel);
        this.myPanel.add(this.myButtonsPanel);
        this.myRunButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkageDiseqDialog.this.runButton_actionPerformed(e);
            }
        });
        this.myCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkageDiseqDialog.this.closeButton_actionPerformed(e);
            }
        });
        this.getContentPane().add(this.myPanel);
        this.getContentPane().setPreferredSize(new Dimension(320, 375));
    }

    private void hideOptions() {
        this.myWindowSizeTextField.setVisible(false);
        this.myWindowSizeLabel.setVisible(false);
        this.mySiteByAllTextField.setVisible(false);
        this.mySiteByAllLabel.setVisible(false);
    }

    public boolean isAccumulateResults() {
        return this.myAccumulativeResultsBox.isSelected();
    }

    public LinkageDisequilibrium.testDesign getLDType() {
        if (this.myLDType.getSelectedIndex() == 0) {
            return LinkageDisequilibrium.testDesign.All;
        }
        if (this.myLDType.getSelectedIndex() == 1) {
            return LinkageDisequilibrium.testDesign.SlidingWindow;
        }
        if (this.myLDType.getSelectedIndex() == 2) {
            return LinkageDisequilibrium.testDesign.SiteByAll;
        }
        if (this.myLDType.getSelectedIndex() == 3) {
            return LinkageDisequilibrium.testDesign.SiteList;
        }
        throw new IllegalStateException("LinkageDisequilibriumPlugin: getLDType: No known LD Type selected.");
    }

    public boolean isRunAnalysis() {
        return this.myRunAnalysis;
    }

    public boolean isCancel() {
        return !this.myRunAnalysis;
    }

    public int getWindowSize() {
        return this.myWindowSize;
    }

    public int getTestSite() {
        return this.myTestSite;
    }

    public int getNumAccumulateIntervals() {
        return this.myNumAccumulativeInterval;
    }

    public LinkageDisequilibrium.HetTreatment getHetTreatment() {
        if (this.myHetTreatment.getSelectedIndex() == 0) {
            return LinkageDisequilibrium.HetTreatment.Haplotype;
        }
        if (this.myHetTreatment.getSelectedIndex() == 1) {
            return LinkageDisequilibrium.HetTreatment.Homozygous;
        }
        if (this.myHetTreatment.getSelectedIndex() == 2) {
            return LinkageDisequilibrium.HetTreatment.Genotype;
        }
        throw new IllegalStateException("LinkageDisequilibriumPlugin: getLDType: No known LD Type selected.");
    }

    void ldType_actionPerformed(ActionEvent e) {
        if (this.myLDType.getSelectedIndex() == 0) {
            this.myFullMatrixLabel.setVisible(true);
            this.myWindowSizeLabel.setVisible(false);
            this.myWindowSizeCountLabel.setVisible(false);
            this.myWindowSizeTextField.setVisible(false);
            this.mySiteByAllLabel.setVisible(false);
            this.mySiteByAllCountLabel.setVisible(false);
            this.mySiteByAllTextField.setVisible(false);
            this.mySiteListLabel.setVisible(false);
        } else if (this.myLDType.getSelectedIndex() == 1) {
            this.myFullMatrixLabel.setVisible(false);
            this.myWindowSizeLabel.setVisible(true);
            this.myWindowSizeCountLabel.setVisible(true);
            this.myWindowSizeTextField.setVisible(true);
            this.mySiteByAllLabel.setVisible(false);
            this.mySiteByAllCountLabel.setVisible(false);
            this.mySiteByAllTextField.setVisible(false);
            this.mySiteListLabel.setVisible(false);
        } else if (this.myLDType.getSelectedIndex() == 2) {
            this.myFullMatrixLabel.setVisible(false);
            this.myWindowSizeLabel.setVisible(false);
            this.myWindowSizeCountLabel.setVisible(false);
            this.myWindowSizeTextField.setVisible(false);
            this.mySiteByAllLabel.setVisible(true);
            this.mySiteByAllCountLabel.setVisible(true);
            this.mySiteByAllTextField.setVisible(true);
            this.mySiteListLabel.setVisible(false);
        } else if (this.myLDType.getSelectedIndex() == 3) {
            this.myFullMatrixLabel.setVisible(false);
            this.myWindowSizeLabel.setVisible(false);
            this.myWindowSizeCountLabel.setVisible(false);
            this.myWindowSizeTextField.setVisible(false);
            this.mySiteByAllLabel.setVisible(false);
            this.mySiteByAllCountLabel.setVisible(false);
            this.mySiteByAllTextField.setVisible(false);
            this.mySiteListLabel.setVisible(true);
        }
    }

    void windowSizeTextField_actionPerformed(KeyEvent e) {
        try {
            int newSize = Integer.parseInt(this.myWindowSizeTextField.getText());
            long n = Math.min(this.myNumSites - 1, newSize);
            this.myWindowSizeCountLabel.setText("Sliding Window LD with " + (n * (n + 1L) / 2L + ((long)this.myNumSites - n - 1L) * n) + " comparisons.");
        }
        catch (Exception err) {
            System.out.println("error!");
        }
    }

    void accumulativeResultsBox_actionPerformed(ActionEvent e) {
        if (this.myAccumulativeResultsBox.isSelected()) {
            this.myAccumulativeResultsLabel.setVisible(true);
            this.myAccumulativeResultsTextField.setVisible(true);
        } else {
            this.myAccumulativeResultsLabel.setVisible(false);
            this.myAccumulativeResultsTextField.setVisible(false);
        }
    }

    void runButton_actionPerformed(ActionEvent e) {
        if (this.getLDType() == LinkageDisequilibrium.testDesign.SlidingWindow) {
            try {
                this.myWindowSize = Integer.parseInt(this.myWindowSizeTextField.getText());
            }
            catch (Exception ee) {
                this.myWindowSizeTextField.setText("Set Integer");
                return;
            }
        }
        if (this.getLDType() == LinkageDisequilibrium.testDesign.SiteByAll) {
            try {
                this.myTestSite = Integer.parseInt(this.mySiteByAllTextField.getText());
            }
            catch (Exception ee) {
                this.mySiteByAllTextField.setText("Set Integer");
                return;
            }
        }
        if (this.isAccumulateResults()) {
            try {
                this.myNumAccumulativeInterval = Integer.parseInt(this.myAccumulativeResultsTextField.getText());
            }
            catch (Exception ee) {
                this.myAccumulativeResultsTextField.setText("Set Integer");
                return;
            }
        }
        this.myRunAnalysis = true;
        this.setVisible(false);
    }

    void closeButton_actionPerformed(ActionEvent e) {
        this.myRunAnalysis = false;
        this.setVisible(false);
    }
}

