/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.popgen;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.maizegenetics.analysis.popgen.LinkageDiseqDisplayPlugin;
import net.maizegenetics.analysis.popgen.LinkageDisequilibrium;
import net.maizegenetics.analysis.popgen.LinkageDisequilibriumComponent;
import net.maizegenetics.analysis.popgen.LinkageDisequilibriumMinimapComponent;

class LinkageDiseqDisplayDialog
extends JDialog {
    final int myDefaultViewableSize = 35;
    int maxWindowSize;
    int myMaxWindowSize = 1000;
    JPanel panel1 = new JPanel();
    JButton okButton = new JButton();
    JPanel linkPanel = new JPanel();
    JPanel mapPanel = new JPanel();
    LinkageDisequilibriumComponent ldFigurePanel;
    LinkageDisequilibriumMinimapComponent ldMapPanel;
    BorderLayout borderLayout1 = new BorderLayout();
    LinkageDisequilibrium theLinkageDisequilibrium;
    LinkageDiseqDisplayPlugin theLinkageDiseqDisplayPlugin;
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JButton saveButton = new JButton();
    JButton saveAllButton = new JButton();
    JLabel upperSqrLabel;
    JLabel lowerSqrLabel;
    JComboBox<String> upperSqrSelector;
    JComboBox<String> lowerSqrSelector;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JCheckBox schematicCheckBox = new JCheckBox();
    JCheckBox myLockScrollBarsCheckBox = new JCheckBox();
    boolean myLockedBars = false;
    JScrollBar verticalScrollBar = new JScrollBar(1);
    JScrollBar horizontalScrollBar = new JScrollBar(0);
    JPanel viewerLocationOptionsPanel = new JPanel();
    JLabel windowSizeLabel = new JLabel();
    JSlider windowSizeSlider;
    JTextField windowSizeText = new JTextField();
    JSlider windowXSlider;
    JPanel yAxisPanel = new JPanel();
    JSlider windowYSlider;
    int myXPos;
    int myYPos;

    public LinkageDiseqDisplayDialog(LinkageDiseqDisplayPlugin theQAF, LinkageDisequilibrium theLinkageDisequilibrium) {
        super(theQAF.getParentFrame(), "Linkage Disequilibrium", false);
        this.theLinkageDiseqDisplayPlugin = theQAF;
        this.theLinkageDisequilibrium = theLinkageDisequilibrium;
        this.maxWindowSize = theLinkageDisequilibrium.getSiteCount();
        this.myXPos = (int)Math.ceil((double)this.maxWindowSize / 2.0);
        this.myYPos = (int)Math.ceil((double)this.maxWindowSize / 2.0);
        try {
            this.jbInit();
            this.ldFigurePanel = theLinkageDisequilibrium.getSiteCount() > 35 ? new LinkageDisequilibriumComponent(theLinkageDisequilibrium, true, false, 35, theLinkageDisequilibrium.getSiteCount() / 2, theLinkageDisequilibrium.getSiteCount() / 2) : new LinkageDisequilibriumComponent(theLinkageDisequilibrium, true, false, this.maxWindowSize, (int)Math.ceil((double)this.maxWindowSize / 2.0), (int)Math.ceil((double)this.maxWindowSize / 2.0));
            this.linkPanel.add((Component)this.ldFigurePanel, "Center");
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this.getParent(), "Unable to create LD plot " + ex);
        }
        this.repaint();
    }

    void jbInit() throws Exception {
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jPanel1.setToolTipText("");
        if (this.theLinkageDisequilibrium.getSiteCount() > 35) {
            this.viewerLocationOptionsPanel.setLayout(new GridBagLayout());
            this.yAxisPanel.setLayout(new GridBagLayout());
            this.windowSizeLabel.setText("Select viewable size");
            this.windowSizeSlider = new JSlider(1, Math.min(this.maxWindowSize, this.myMaxWindowSize), 35);
            this.windowSizeText.setText(String.valueOf(this.windowSizeSlider.getValue()));
            this.windowSizeSlider.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent me) {
                }

                @Override
                public void mousePressed(MouseEvent me) {
                }

                @Override
                public void mouseReleased(MouseEvent me) {
                    LinkageDiseqDisplayDialog.this.sizeSlider_actionPerformed(me);
                }

                @Override
                public void mouseEntered(MouseEvent me) {
                }

                @Override
                public void mouseExited(MouseEvent me) {
                }
            });
            this.windowSizeText.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent ke) {
                }

                @Override
                public void keyPressed(KeyEvent ke) {
                }

                @Override
                public void keyReleased(KeyEvent ke) {
                    LinkageDiseqDisplayDialog.this.sizeTextField_keyTyped(ke);
                }
            });
            this.windowXSlider = new JSlider((int)Math.ceil(17.5), (int)Math.ceil((double)this.maxWindowSize - 17.5), (int)Math.ceil((double)this.maxWindowSize / 2.0));
            this.windowXSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    LinkageDiseqDisplayDialog.this.xSlider_actionPerformed(ce);
                }
            });
            this.windowYSlider = new JSlider((int)Math.ceil(17.5), (int)Math.ceil((double)this.maxWindowSize - 17.5), (int)Math.ceil((double)this.maxWindowSize / 2.0));
            this.windowYSlider.setOrientation(1);
            this.windowYSlider.setInverted(true);
            this.windowYSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    LinkageDiseqDisplayDialog.this.ySlider_actionPerformed(ce);
                }
            });
            this.ldMapPanel = new LinkageDisequilibriumMinimapComponent(this.theLinkageDisequilibrium, 35, (int)Math.ceil((double)this.maxWindowSize / 2.0), (int)Math.ceil((double)this.maxWindowSize / 2.0));
            this.mapPanel.add((Component)this.ldMapPanel, "Center");
            this.mapPanel.setBorder(BorderFactory.createEtchedBorder());
            this.ldMapPanel.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent me) {
                }

                @Override
                public void mousePressed(MouseEvent me) {
                    LinkageDiseqDisplayDialog.this.mapPanel_mouseEvent(me);
                }

                @Override
                public void mouseReleased(MouseEvent me) {
                }

                @Override
                public void mouseEntered(MouseEvent me) {
                }

                @Override
                public void mouseExited(MouseEvent me) {
                }
            });
            this.ldMapPanel.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent me) {
                    LinkageDiseqDisplayDialog.this.mapPanel_mouseEvent(me);
                }

                @Override
                public void mouseMoved(MouseEvent me) {
                }
            });
            this.viewerLocationOptionsPanel.add((Component)this.windowSizeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 26, 0, new Insets(0, 5, 8, 5), 0, 0));
            this.viewerLocationOptionsPanel.add((Component)this.windowSizeSlider, new GridBagConstraints(1, 0, 2, 1, 0.9, 1.0, 20, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.viewerLocationOptionsPanel.add((Component)this.windowSizeText, new GridBagConstraints(3, 0, 1, 1, 0.1, 1.0, 25, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.viewerLocationOptionsPanel.add((Component)this.mapPanel, new GridBagConstraints(4, 0, 1, 1, 0.2, 0.2, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.jPanel1.add((Component)this.windowXSlider, new GridBagConstraints(0, 0, 6, 1, 1.0, 1.0, 10, 2, new Insets(0, 172, 0, 85), 0, 0));
            this.yAxisPanel.add((Component)this.windowYSlider, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(10, 0, 30, 0), 0, 0));
            this.getContentPane().add((Component)this.viewerLocationOptionsPanel, "North");
            this.getContentPane().add((Component)this.mapPanel, "Before");
            this.getContentPane().add((Component)this.yAxisPanel, "After");
        }
        String[] valueOptions = new String[]{"P-Value", "R Squared", "D Prime"};
        this.upperSqrLabel = new JLabel("Upper triangle:");
        this.upperSqrSelector = new JComboBox<String>(valueOptions);
        this.upperSqrSelector.setSelectedIndex(1);
        this.upperSqrSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkageDiseqDisplayDialog.this.upperSqrSelector_actionPerformed(e);
            }
        });
        this.lowerSqrLabel = new JLabel("Lower triangle:");
        this.lowerSqrSelector = new JComboBox<String>(valueOptions);
        this.lowerSqrSelector.setSelectedIndex(0);
        this.lowerSqrSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkageDiseqDisplayDialog.this.lowerSqrSelector_actionPerformed(e);
            }
        });
        this.panel1.setLayout(this.borderLayout2);
        this.okButton.setText("Close");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkageDiseqDisplayDialog.this.okButton_actionPerformed(e);
            }
        });
        this.linkPanel.setBorder(BorderFactory.createEtchedBorder());
        this.linkPanel.setLayout(this.borderLayout1);
        this.panel1.setPreferredSize(new Dimension(600, 600));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkageDiseqDisplayDialog.this.saveButton_actionPerformed(e);
            }
        });
        this.saveButton.setText("Save");
        this.saveAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkageDiseqDisplayDialog.this.saveAllButton_actionPerformed(e);
            }
        });
        this.saveAllButton.setText("Save All");
        this.schematicCheckBox.setSelected(true);
        this.schematicCheckBox.setText("Schematic");
        this.schematicCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkageDiseqDisplayDialog.this.schematicCheckBox_actionPerformed(e);
            }
        });
        this.myLockScrollBarsCheckBox.setSelected(false);
        this.myLockScrollBarsCheckBox.setText("Lock Y Axis to X");
        this.myLockScrollBarsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkageDiseqDisplayDialog.this.lockScrollBarsCheckBox_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.panel1, "Center");
        this.panel1.add((Component)this.linkPanel, "Center");
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.upperSqrLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 10, 0, 0), 5, 0));
        this.jPanel1.add((Component)this.lowerSqrLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 10, 0, 0), 5, 0));
        this.jPanel1.add(this.upperSqrSelector, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.5, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add(this.lowerSqrSelector, new GridBagConstraints(1, 2, 1, 1, 0.5, 0.5, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.okButton, new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 15), 0, 0));
        this.jPanel1.add((Component)this.myLockScrollBarsCheckBox, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.saveButton, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.saveAllButton, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 15), 0, 0));
        this.jPanel1.add((Component)this.schematicCheckBox, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    void okButton_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    void saveButton_actionPerformed(ActionEvent e) {
        this.theLinkageDiseqDisplayPlugin.saveDataToFile(this.ldFigurePanel);
    }

    void saveAllButton_actionPerformed(ActionEvent e) {
        LinkageDisequilibriumComponent newGraph = new LinkageDisequilibriumComponent(this.theLinkageDisequilibrium, true, false, this.maxWindowSize, (int)Math.ceil((double)this.maxWindowSize / 2.0), (int)Math.ceil((double)this.maxWindowSize / 2.0));
        if (this.upperSqrSelector.getSelectedIndex() == 0) {
            newGraph.setUpperCorner(0);
        } else if (this.upperSqrSelector.getSelectedIndex() == 1) {
            newGraph.setUpperCorner(2);
        } else if (this.upperSqrSelector.getSelectedIndex() == 2) {
            newGraph.setUpperCorner(1);
        }
        if (this.lowerSqrSelector.getSelectedIndex() == 0) {
            newGraph.setLowerCorner(0);
        } else if (this.lowerSqrSelector.getSelectedIndex() == 1) {
            newGraph.setLowerCorner(2);
        } else if (this.lowerSqrSelector.getSelectedIndex() == 2) {
            newGraph.setLowerCorner(1);
        }
        newGraph.setGraphSize(4096, 4096);
        this.theLinkageDiseqDisplayPlugin.saveDataToFile(newGraph);
    }

    void upperSqrSelector_actionPerformed(ActionEvent e) {
        if (this.upperSqrSelector.getSelectedIndex() == 0) {
            this.ldFigurePanel.setUpperCorner(0);
        } else if (this.upperSqrSelector.getSelectedIndex() == 1) {
            this.ldFigurePanel.setUpperCorner(2);
        } else if (this.upperSqrSelector.getSelectedIndex() == 2) {
            this.ldFigurePanel.setUpperCorner(1);
        }
        this.repaint();
    }

    void lowerSqrSelector_actionPerformed(ActionEvent e) {
        if (this.lowerSqrSelector.getSelectedIndex() == 0) {
            this.ldFigurePanel.setLowerCorner(0);
        } else if (this.lowerSqrSelector.getSelectedIndex() == 1) {
            this.ldFigurePanel.setLowerCorner(2);
        } else if (this.lowerSqrSelector.getSelectedIndex() == 2) {
            this.ldFigurePanel.setLowerCorner(1);
        }
        this.repaint();
    }

    void upDPrimeRadioButton_actionPerformed(ActionEvent e) {
        this.ldFigurePanel.setUpperCorner(1);
        this.repaint();
    }

    void upRSqrRadioButton_actionPerformed(ActionEvent e) {
        this.ldFigurePanel.setUpperCorner(2);
        this.repaint();
    }

    void upPRadioButton_actionPerformed(ActionEvent e) {
        this.ldFigurePanel.setUpperCorner(0);
        this.repaint();
    }

    void lowRSqrRadioButton_actionPerformed(ActionEvent e) {
        this.ldFigurePanel.setLowerCorner(2);
        this.repaint();
    }

    void lowPRadioButton_actionPerformed(ActionEvent e) {
        this.ldFigurePanel.setLowerCorner(0);
        this.repaint();
    }

    void lowDPrimeRadioButton_actionPerformed(ActionEvent e) {
        this.ldFigurePanel.setLowerCorner(1);
        this.repaint();
    }

    void geneRadioButton_actionPerformed(ActionEvent e) {
        this.ldFigurePanel.setScaleOfView(false);
        this.repaint();
    }

    void chromoRadioButton_actionPerformed(ActionEvent e) {
        this.ldFigurePanel.setScaleOfView(true);
        this.repaint();
    }

    void schematicCheckBox_actionPerformed(ActionEvent e) {
        this.ldFigurePanel.setShowSchematic(this.schematicCheckBox.isSelected());
        this.repaint();
    }

    void lockScrollBarsCheckBox_actionPerformed(ActionEvent e) {
        this.myLockedBars = this.myLockScrollBarsCheckBox.isSelected();
    }

    void sizeSlider_actionPerformed(MouseEvent me) {
        this.windowSizeText.setText(String.valueOf(this.windowSizeSlider.getValue()));
        this.windowXSlider.setMinimum((int)Math.ceil((double)this.windowSizeSlider.getValue() / 2.0));
        this.windowXSlider.setMaximum((int)Math.ceil((double)this.maxWindowSize - (double)this.windowSizeSlider.getValue() / 2.0));
        this.windowXSlider.setValue(Math.min(this.windowXSlider.getMaximum(), Math.max(this.windowXSlider.getMinimum(), this.myXPos)));
        this.windowYSlider.setMinimum((int)Math.ceil((double)this.windowSizeSlider.getValue() / 2.0));
        this.windowYSlider.setMaximum((int)Math.ceil((double)this.maxWindowSize - (double)this.windowSizeSlider.getValue() / 2.0));
        this.windowYSlider.setValue(Math.min(this.windowYSlider.getMaximum(), Math.max(this.windowYSlider.getMinimum(), this.myYPos)));
        int ldMeasureLower = 0;
        int ldMeasureUpper = 0;
        ldMeasureLower = this.lowerSqrSelector.getSelectedIndex() == 0 ? 0 : (this.lowerSqrSelector.getSelectedIndex() == 1 ? 2 : 1);
        ldMeasureUpper = this.upperSqrSelector.getSelectedIndex() == 0 ? 0 : (this.upperSqrSelector.getSelectedIndex() == 1 ? 2 : 1);
        this.ldFigurePanel.setWindowSize(this.windowSizeSlider.getValue(), this.windowXSlider.getValue(), this.windowYSlider.getValue(), ldMeasureLower, ldMeasureUpper);
        this.ldMapPanel.setWindowSize(this.windowSizeSlider.getValue(), this.windowXSlider.getValue(), this.windowYSlider.getValue());
        this.repaint();
    }

    void sizeTextField_keyTyped(KeyEvent ke) {
        try {
            if (!this.windowSizeText.getText().equals("")) {
                int value = Integer.valueOf(this.windowSizeText.getText());
                if (value >= this.windowSizeSlider.getMinimum() && value <= this.windowSizeSlider.getMaximum()) {
                    this.windowSizeSlider.setValue(value);
                } else if (value <= this.windowSizeSlider.getMinimum()) {
                    this.windowSizeSlider.setValue(this.windowSizeSlider.getMinimum());
                    this.windowSizeText.setText(String.valueOf(this.windowSizeSlider.getMinimum()));
                } else if (value >= this.windowSizeSlider.getMaximum()) {
                    this.windowSizeSlider.setValue(this.windowSizeSlider.getMaximum());
                    this.windowSizeText.setText(String.valueOf(this.windowSizeSlider.getMaximum()));
                }
            }
        }
        catch (NumberFormatException nfe) {
            this.windowSizeText.setText(String.valueOf(this.windowSizeSlider.getValue()));
        }
    }

    void xSlider_actionPerformed(ChangeEvent ce) {
        int ldMeasureLower = 0;
        int ldMeasureUpper = 0;
        ldMeasureLower = this.lowerSqrSelector.getSelectedIndex() == 0 ? 0 : (this.lowerSqrSelector.getSelectedIndex() == 1 ? 2 : 1);
        ldMeasureUpper = this.upperSqrSelector.getSelectedIndex() == 0 ? 0 : (this.upperSqrSelector.getSelectedIndex() == 1 ? 2 : 1);
        this.ldFigurePanel.setWindowX(this.windowXSlider.getValue(), ldMeasureLower, ldMeasureUpper);
        this.ldMapPanel.setWindowX(this.windowXSlider.getValue());
        if (this.myLockedBars) {
            int diff = this.myXPos - this.windowXSlider.getValue();
            if (diff < 0) {
                this.windowYSlider.setValue(Math.max(this.windowYSlider.getMinimum(), this.windowYSlider.getValue() - diff));
            } else {
                this.windowYSlider.setValue(Math.min(this.windowYSlider.getMaximum(), this.windowYSlider.getValue() - diff));
            }
            this.ldFigurePanel.setWindowY(this.windowYSlider.getValue(), ldMeasureLower, ldMeasureUpper);
            this.ldMapPanel.setWindowY(this.windowYSlider.getValue());
            this.myYPos = this.windowYSlider.getValue();
        }
        this.myXPos = this.windowXSlider.getValue();
        this.repaint();
    }

    void ySlider_actionPerformed(ChangeEvent ce) {
        int ldMeasureLower = 0;
        int ldMeasureUpper = 0;
        ldMeasureLower = this.lowerSqrSelector.getSelectedIndex() == 0 ? 0 : (this.lowerSqrSelector.getSelectedIndex() == 1 ? 2 : 1);
        ldMeasureUpper = this.upperSqrSelector.getSelectedIndex() == 0 ? 0 : (this.upperSqrSelector.getSelectedIndex() == 1 ? 2 : 1);
        this.ldFigurePanel.setWindowY(this.windowYSlider.getValue(), ldMeasureLower, ldMeasureUpper);
        this.ldMapPanel.setWindowY(this.windowYSlider.getValue());
        this.myYPos = this.windowYSlider.getValue();
        this.repaint();
    }

    void mapPanel_mouseEvent(MouseEvent me) {
        double mouseX = me.getLocationOnScreen().getX();
        double mouseY = me.getLocationOnScreen().getY();
        double panelX = this.ldMapPanel.getLocationOnScreen().getX();
        double panelY = this.ldMapPanel.getLocationOnScreen().getY();
        int mapSize = this.ldMapPanel.getMapSize();
        double newX = (mouseX - panelX) / (double)mapSize;
        double newY = (mouseY - panelY) / (double)mapSize;
        int newXPos = Math.min(Math.max((int)((double)this.maxWindowSize * newX), this.windowXSlider.getMinimum()), this.windowXSlider.getMaximum());
        int newYPos = Math.min(Math.max((int)((double)this.maxWindowSize * newY), this.windowYSlider.getMinimum()), this.windowYSlider.getMaximum());
        int ldMeasureLower = 0;
        int ldMeasureUpper = 0;
        ldMeasureLower = this.lowerSqrSelector.getSelectedIndex() == 0 ? 0 : (this.lowerSqrSelector.getSelectedIndex() == 1 ? 2 : 1);
        ldMeasureUpper = this.upperSqrSelector.getSelectedIndex() == 0 ? 0 : (this.upperSqrSelector.getSelectedIndex() == 1 ? 2 : 1);
        this.windowXSlider.setValue(newXPos);
        this.windowYSlider.setValue(newYPos);
        this.ldFigurePanel.setWindowX(newXPos, ldMeasureLower, ldMeasureUpper);
        this.ldFigurePanel.setWindowY(newYPos, ldMeasureLower, ldMeasureUpper);
        this.ldMapPanel.setWindowX(newXPos);
        this.ldMapPanel.setWindowY(newYPos);
        this.myXPos = this.windowXSlider.getValue();
        this.myYPos = this.windowYSlider.getValue();
        this.repaint();
    }

    public int getWindowSizeSelection() {
        return this.windowSizeSlider.getValue();
    }

    public int getWindowXSelection() {
        return this.windowXSlider.getValue();
    }

    public int getWindowYSelection() {
        return this.windowYSlider.getValue();
    }
}

