/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.popgen;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import net.maizegenetics.analysis.popgen.LinkageDisequilibrium;

public class LinkageDisequilibriumMinimapComponent
extends JComponent {
    LinkageDisequilibrium myLD;
    int myNumSites;
    int myWindowSize;
    int myWindowX;
    int myWindowY;
    final int myMapSize = 100;
    final int myDiagonalWidth = 3;
    double myXStart;
    double myYStart;
    double myXEnd;
    double myYEnd;
    int myXStartPos;
    int myYStartPos;
    int myXEndPos;
    int myYEndPos;

    public LinkageDisequilibriumMinimapComponent(LinkageDisequilibrium theLD, int windowSize, int windowX, int windowY) {
        this.myLD = theLD;
        this.myNumSites = theLD.getSiteCount();
        this.myWindowSize = windowSize;
        this.myWindowX = windowX;
        this.myWindowY = windowY;
        this.calculateStartEndPositions();
        this.calculateCoordinates();
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setWindowSize(int windowSize, int windowX, int windowY) {
        this.myWindowSize = windowSize;
        this.myWindowX = windowX;
        this.myWindowY = windowY;
        this.calculateStartEndPositions();
        this.calculateCoordinates();
    }

    public void setWindowX(int windowX) {
        this.myWindowX = windowX;
        this.calculateStartEndPositions();
        this.calculateCoordinates();
    }

    public void setWindowY(int windowY) {
        this.myWindowY = windowY;
        this.calculateStartEndPositions();
        this.calculateCoordinates();
    }

    private void calculateStartEndPositions() {
        this.myXStart = Math.floor((double)this.myWindowX - (double)this.myWindowSize / 2.0) / (double)this.myNumSites;
        this.myYStart = Math.floor((double)this.myWindowY - (double)this.myWindowSize / 2.0) / (double)this.myNumSites;
        this.myXEnd = (Math.floor((double)this.myWindowX - (double)this.myWindowSize / 2.0) + (double)this.myWindowSize) / (double)this.myNumSites;
        this.myYEnd = (Math.floor((double)this.myWindowY - (double)this.myWindowSize / 2.0) + (double)this.myWindowSize) / (double)this.myNumSites;
    }

    private void calculateCoordinates() {
        this.myXStartPos = (int)(this.myXStart * 100.0);
        this.myYStartPos = (int)(this.myYStart * 100.0);
        this.myXEndPos = (int)(this.myXEnd * 100.0) - 1;
        this.myYEndPos = (int)(this.myYEnd * 100.0) - 1;
        if (this.myXStartPos >= 99) {
            this.myXStartPos = 98;
            this.myXEndPos = 99;
        }
        if (this.myYStartPos >= 99) {
            this.myYStartPos = 98;
            this.myYEndPos = 99;
        }
        if (this.myXEndPos <= this.myXStartPos) {
            this.myXEndPos = this.myXStartPos + 1;
        }
        if (this.myYEndPos <= this.myYStartPos) {
            this.myYEndPos = this.myYStartPos + 1;
        }
    }

    private void jbInit() throws Exception {
        this.setBackground(Color.white);
        this.setPreferredSize(new Dimension(100, 100));
    }

    @Override
    protected void paintComponent(Graphics g) {
        Dimension d = this.getSize();
        g.setColor(Color.white);
        g.fillRect(0, 0, 100, 100);
        this.paintDiagonal(g);
        g.setColor(Color.red);
        g.drawRect(this.myXStartPos, this.myYStartPos, this.myXEndPos - this.myXStartPos, this.myYEndPos - this.myYStartPos);
    }

    @Override
    public void paint(Graphics g) {
        this.paintComponent(g);
    }

    private void paintDiagonal(Graphics g) {
        g.setColor(Color.black);
        for (int i = 0; i < 3; ++i) {
            g.drawLine(0, 0 + i, 99 - i, 99);
            g.drawLine(0 + i, 0, 99, 99 - i);
        }
    }

    public int getMapSize() {
        return 100;
    }
}

