/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.popgen;

import com.google.common.collect.Range;
import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.popgen.DiversityAnalyses;
import net.maizegenetics.analysis.popgen.PolymorphismDistribution;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.SimpleTableReport;

public class SequenceDiversityPlugin
extends AbstractPlugin {
    private PluginParameter<Integer> myStartSite = new PluginParameter.Builder<Integer>("startSite", 0, Integer.class).description("Start Site").range((Range<Comparable<Integer>>)Range.atLeast((Comparable)Integer.valueOf(0))).build();
    private PluginParameter<Integer> myEndSite = new PluginParameter.Builder<Integer>("endSite", null, Integer.class).description("End Site").range((Range<Comparable<Integer>>)Range.atLeast((Comparable)Integer.valueOf(0))).build();
    private PluginParameter<Boolean> myIsSlidingWindowAnalysis = new PluginParameter.Builder<Boolean>("slidingWindowAnalysis", false, Boolean.class).description("Whether this is sliding window analysis").build();
    private PluginParameter<Integer> myStepSize = new PluginParameter.Builder<Integer>("stepSize", 100, Integer.class).description("Step Size").range((Range<Comparable<Integer>>)Range.atLeast((Comparable)Integer.valueOf(0))).dependentOnParameter(this.myIsSlidingWindowAnalysis).build();
    private PluginParameter<Integer> myWindowSize = new PluginParameter.Builder<Integer>("windowSize", 500, Integer.class).description("Window Size").range((Range<Comparable<Integer>>)Range.atLeast((Comparable)Integer.valueOf(0))).dependentOnParameter(this.myIsSlidingWindowAnalysis).build();
    private GenotypeTable myGenotypeTable = null;

    public SequenceDiversityPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        List<Datum> alignInList = input.getDataOfType(GenotypeTable.class);
        if (alignInList.size() != 1) {
            throw new IllegalArgumentException("SequenceDiversityPlugin: Please select one Genotype Table");
        }
        this.myGenotypeTable = (GenotypeTable)alignInList.get(0).getData();
        if (this.isInteractive()) {
            this.setParameter(this.myEndSite, (Object)(this.myGenotypeTable.numberOfSites() - 1));
        }
    }

    @Override
    protected void postProcessParameters() {
        if (this.endSite() == null) {
            this.setParameter(this.myEndSite, (Object)(this.myGenotypeTable.numberOfSites() - 1));
        }
    }

    @Override
    public DataSet processData(DataSet input) {
        Datum current = input.getDataOfType(GenotypeTable.class).get(0);
        PolymorphismDistribution pda = new PolymorphismDistribution();
        DiversityAnalyses theDA = new DiversityAnalyses(this.myGenotypeTable, this.isSlidingWindowAnalysis(), this.startSite(), this.endSite(), this.windowSize(), this.stepSize(), pda);
        ArrayList<Datum> results = new ArrayList<Datum>();
        results.add(new Datum("Diversity:" + current.getName(), theDA, "Diversity Analysis"));
        results.add(new Datum("PolyDist:" + current.getName(), new SimpleTableReport(pda.getTableTitle(), pda.getTableColumnNames(), pda.getTableData()), "Polymorphism Distribution"));
        return new DataSet(results, (Plugin)this);
    }

    public Integer startSite() {
        return this.myStartSite.value();
    }

    public SequenceDiversityPlugin startSite(Integer value) {
        this.myStartSite = new PluginParameter<Integer>(this.myStartSite, value);
        return this;
    }

    public Integer endSite() {
        return this.myEndSite.value();
    }

    public SequenceDiversityPlugin endSite(Integer value) {
        this.myEndSite = new PluginParameter<Integer>(this.myEndSite, value);
        return this;
    }

    public Boolean isSlidingWindowAnalysis() {
        return this.myIsSlidingWindowAnalysis.value();
    }

    public SequenceDiversityPlugin isSlidingWindowAnalysis(Boolean value) {
        this.myIsSlidingWindowAnalysis = new PluginParameter<Boolean>(this.myIsSlidingWindowAnalysis, value);
        return this;
    }

    public Integer windowSize() {
        return this.myWindowSize.value();
    }

    public SequenceDiversityPlugin windowSize(Integer value) {
        this.myWindowSize = new PluginParameter<Integer>(this.myWindowSize, value);
        return this;
    }

    public Integer stepSize() {
        return this.myStepSize.value();
    }

    public SequenceDiversityPlugin stepSize(Integer value) {
        this.myStepSize = new PluginParameter<Integer>(this.myStepSize, value);
        return this;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = SequenceDiversityPlugin.class.getResource("/net/maizegenetics/analysis/images/Diversity.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Diversity";
    }

    @Override
    public String getToolTipText() {
        return "Basic description of diversity";
    }
}

