/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.rna;

import com.google.common.collect.HashMultimap;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.IntStream;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.tag.Tag;
import net.maizegenetics.util.Tuple;
import org.biojava.nbio.alignment.Alignments;
import org.biojava.nbio.alignment.SimpleGapPenalty;
import org.biojava.nbio.alignment.SubstitutionMatrixHelper;
import org.biojava.nbio.alignment.template.GapPenalty;
import org.biojava.nbio.alignment.template.SequencePair;
import org.biojava.nbio.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.compound.NucleotideCompound;
import org.biojava.nbio.core.sequence.template.Sequence;

public class FindMatchByWordHash {
    private final List<Tag> tags;
    private final Map<String, int[]> kmerMap;
    private final Map<String, Integer> completeSeqMap;
    private final int wordLength;
    private final int maxWordCopies;
    private final MatchType matchType;
    private final int[] emptyInts = new int[0];
    private final boolean searchBiDirectional;
    private static GapPenalty penalty = new SimpleGapPenalty();
    private static SubstitutionMatrix<NucleotideCompound> matrix = SubstitutionMatrixHelper.getNuc4_4();

    private FindMatchByWordHash(Set<Tag> tagSet, MatchType matchType, int wordLength, int maxWordCopies, boolean searchBiDirectional) {
        this.wordLength = wordLength;
        this.maxWordCopies = maxWordCopies;
        this.matchType = matchType;
        this.searchBiDirectional = searchBiDirectional;
        this.tags = new ArrayList<Tag>(tagSet);
        long bpLength = 0L;
        HashMultimap completeKmerMap = HashMultimap.create((int)4000000, (int)2);
        for (int ti = 0; ti < this.tags.size(); ++ti) {
            String seq = this.tags.get(ti).sequence();
            bpLength += (long)seq.length();
            for (int i = 0; i <= seq.length() - wordLength; ++i) {
                String sub = seq.substring(i, i + wordLength);
                completeKmerMap.put((Object)sub, (Object)(ti + 1));
                if (!searchBiDirectional) continue;
                completeKmerMap.put((Object)BaseEncoder.getReverseComplement(sub), (Object)(-(ti + 1)));
            }
        }
        System.out.printf("Total bp %,d Kmer Map Size: %d %n", bpLength, completeKmerMap.size());
        this.kmerMap = new HashMap<String, int[]>(completeKmerMap.size() * 3 / 2);
        for (String kmer : completeKmerMap.keySet()) {
            Collection tagIndices = completeKmerMap.get((Object)kmer);
            if (tagIndices.size() > this.maxWordCopies) continue;
            this.kmerMap.put(kmer, Ints.toArray((Collection)tagIndices));
        }
        this.completeSeqMap = new HashMap<String, Integer>(this.tags.size() * 3 / 2);
        for (int ti = 0; ti < this.tags.size(); ++ti) {
            this.completeSeqMap.put(this.tags.get(ti).sequence(), ti + 1);
            if (!searchBiDirectional) continue;
            completeKmerMap.put((Object)BaseEncoder.getReverseComplement(this.tags.get(ti).sequence()), (Object)(-(ti + 1)));
        }
        System.out.println(this.kmerMap.size());
    }

    public int totalNumberOfTags() {
        return this.tags.size();
    }

    public List<Tag> getTags() {
        return Collections.unmodifiableList(this.tags);
    }

    public Match match(String seq) {
        switch (this.matchType) {
            case COMPLETE_SEQ: {
                return this.lookForCompleteMatch(seq);
            }
            case FIRST_KMER: {
                return this.getFirstUniqueMatchIndex(seq);
            }
            case MODAL_KMER: {
                return this.getMostCommonMatchIndex(seq);
            }
        }
        return new Match();
    }

    private Match getFirstUniqueMatchIndex(String seq) {
        OptionalInt index = IntStream.range(0, seq.length() - this.wordLength).mapToObj(i -> this.kmerMap.getOrDefault(seq.substring(i, i + this.wordLength), this.emptyInts)).filter(hits -> ((int[])hits).length == 1).mapToInt(hits -> hits[0]).findFirst();
        if (index.isPresent()) {
            return new Match(index.getAsInt(), Double.NaN);
        }
        return new Match();
    }

    private Match getMostCommonMatchIndex(String seq) {
        int[] allHits = IntStream.range(0, seq.length() - this.wordLength).filter(i -> i % 3 == 0).flatMap(i -> IntStream.of(this.kmerMap.getOrDefault(seq.substring(i, i + this.wordLength), this.emptyInts))).toArray();
        if (allHits.length == 0) {
            return new Match();
        }
        return new Match(FindMatchByWordHash.mode(allHits), Double.NaN);
    }

    private Match lookForCompleteMatch(String seq) {
        Integer tagIndex = this.completeSeqMap.get(seq);
        if (tagIndex != null) {
            return new Match(tagIndex, Double.NaN);
        }
        return new Match();
    }

    private double identity(String query, String target) {
        try {
            DNASequence querySeq = new DNASequence(query);
            DNASequence refSeq = new DNASequence(target);
            SequencePair pair = Alignments.getPairwiseAlignment((Sequence)refSeq, (Sequence)querySeq, (Alignments.PairwiseSequenceAlignerType)Alignments.PairwiseSequenceAlignerType.LOCAL, (GapPenalty)penalty, matrix);
            long gaps = IntStream.rangeClosed(1, pair.getLength()).filter(arg_0 -> ((SequencePair)pair).hasGap(arg_0)).count();
            double identity = (double)pair.getNumIdenticals() / (double)pair.getLength();
            double snpIdentity = (double)pair.getNumIdenticals() / (double)((long)pair.getLength() - gaps);
            boolean debug = false;
            if (debug) {
                System.out.println("Ref :" + refSeq.getSequenceAsString());
            }
            if (debug) {
                System.out.println("Query:" + querySeq.getSequenceAsString());
            }
            if (debug) {
                System.out.println("Alignment\n" + pair.toString());
            }
            if (debug) {
                System.out.println("pair.getNumIdenticals() = " + pair.getNumIdenticals());
            }
            if (debug) {
                System.out.println("pair.getLength() = " + pair.getLength());
            }
            if (debug) {
                System.out.printf("identity:%.3g snpidentity: %.3g %n", identity, snpIdentity);
            }
            if (debug) {
                System.out.println("-----------------------");
            }
            return snpIdentity;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Double.NaN;
        }
    }

    public String toString() {
        return "FindMatchByKmers{searchBiDirectional=" + this.searchBiDirectional + ", matchType=" + (Object)((Object)this.matchType) + ", maxWordCopies=" + this.maxWordCopies + ", wordLength=" + this.wordLength + '}';
    }

    public static Tuple<Integer, Integer> calcIdentity(String querySeq, String refSeq) {
        int seedLength = 6;
        int start = refSeq.indexOf(querySeq.substring(0, seedLength));
        int matchLength = 0;
        int identical = 0;
        for (int i = 0; i < querySeq.length(); ++i) {
            if (querySeq.charAt(i) == refSeq.charAt(i + start)) {
                ++identical;
            }
            ++matchLength;
        }
        return new Tuple<Integer, Integer>(matchLength, identical);
    }

    public static int LevenshteinDistance(byte[] s, byte[] t) {
        if (s == t) {
            return 0;
        }
        if (s.length == 0) {
            return t.length;
        }
        if (t.length == 0) {
            return s.length;
        }
        int[] v0 = new int[t.length + 1];
        int[] v1 = new int[s.length + 1];
        FindMatchByWordHash.FillConsecutive(v0);
        for (int i = 0; i < s.length; ++i) {
            v1[0] = i + 1;
            for (int j = 0; j < t.length; ++j) {
                v1[j + 1] = Math.min(v1[j] + 1, Math.min(v0[j + 1] + 1, v0[j] + FindMatchByWordHash.mismatchCost(s, i, t, j)));
            }
            System.arraycopy(v1, 0, v0, 0, v0.length);
        }
        return v1[t.length];
    }

    private static void FillConsecutive(int[] v) {
        for (int i = 0; i < v.length; ++i) {
            v[i] = i;
        }
    }

    private static int mismatchCost(byte[] s, int i, byte[] t, int j) {
        return s[i] != t[j] ? 1 : 0;
    }

    private static int mode(int[] array) {
        HashMap<Integer, Integer> cntMap = new HashMap<Integer, Integer>();
        int maxCnt = 1;
        int mode = array[0];
        for (int i = 0; i < array.length; ++i) {
            int count = cntMap.compute(array[i], (k, cnt) -> cnt == null ? 1 : cnt + 1);
            if (count <= maxCnt) continue;
            maxCnt = count;
            mode = array[i];
        }
        return mode;
    }

    public static Builder getBuilder(Set<Tag> tagSet) {
        return new Builder(tagSet);
    }

    static {
        penalty.setOpenPenalty(10);
        penalty.setExtensionPenalty(2);
    }

    public class Match {
        private final Tag tag;
        private final int tagIndex;
        private final boolean direction;
        private final double quality;

        public Match(int mapIndex, double quality) {
            this.tagIndex = Math.abs(mapIndex) - 1;
            this.tag = (Tag)FindMatchByWordHash.this.tags.get(this.tagIndex);
            this.direction = mapIndex > 0;
            this.quality = quality;
        }

        public Match() {
            this.tagIndex = Integer.MIN_VALUE;
            this.tag = null;
            this.direction = true;
            this.quality = Double.NaN;
        }

        public boolean isEmpty() {
            return this.tag == null;
        }

        public boolean isPresent() {
            return this.tag != null;
        }

        public Tag tag() {
            return this.tag;
        }

        public String sequence() {
            return this.isEmpty() ? "" : this.tag.sequence();
        }

        public int tagIndex() {
            return this.tagIndex;
        }

        public boolean direction() {
            return this.direction;
        }

        public double quality() {
            return this.quality;
        }
    }

    public static class Builder {
        private Set<Tag> tagSet;
        private MatchType matchType = MatchType.MODAL_KMER;
        private int wordLength = 16;
        private int maxWordCopies = 10;
        private boolean searchBiDirectional = true;

        public Builder(Set<Tag> tagSet) {
            this.tagSet = tagSet;
        }

        public Builder matchType(MatchType matchType) {
            this.matchType = matchType;
            return this;
        }

        public Builder wordLength(int wordLength) {
            this.wordLength = wordLength;
            return this;
        }

        public Builder maxWordCopies(int maxWordCopies) {
            this.maxWordCopies = maxWordCopies;
            return this;
        }

        public Builder searchBiDirectional(boolean searchBiDirectional) {
            this.searchBiDirectional = searchBiDirectional;
            return this;
        }

        public FindMatchByWordHash build() {
            return new FindMatchByWordHash(this.tagSet, this.matchType, this.wordLength, this.maxWordCopies, this.searchBiDirectional);
        }
    }

    public static enum MatchType {
        COMPLETE_SEQ,
        FIRST_KMER,
        MODAL_KMER;

    }
}

