/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.rna;

import java.awt.Frame;
import java.io.BufferedReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.Barcode;
import net.maizegenetics.analysis.gbs.v2.BarcodeTrie;
import net.maizegenetics.analysis.gbs.v2.GBSEnzyme;
import net.maizegenetics.analysis.gbs.v2.GBSUtils;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.tag.Tag;
import net.maizegenetics.dna.tag.TagBuilder;
import net.maizegenetics.dna.tag.TagDataSQLite;
import net.maizegenetics.dna.tag.TaxaDistBuilder;
import net.maizegenetics.dna.tag.TaxaDistribution;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListIOUtils;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.DirectoryCrawler;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class RNADeMultiPlexSeqToDBPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(RNADeMultiPlexSeqToDBPlugin.class);
    static LongAdder roughTagCnt = new LongAdder();
    private PluginParameter<String> myInputDir = new PluginParameter.Builder<String>("i", null, String.class).guiName("Input Directory").required(true).inDir().description("Input directory containing FASTQ files in text or gzipped text.\n     NOTE: Directory will be searched recursively and should\n     be written WITHOUT a slash after its name.").build();
    private PluginParameter<String> myKeyFile = new PluginParameter.Builder<String>("k", null, String.class).guiName("Key File").required(true).inFile().description("Key file listing barcodes distinguishing the samples").build();
    private PluginParameter<Integer> myMinKmerLength = new PluginParameter.Builder<Integer>("minKmerL", 20, Integer.class).guiName("Minimum Kmer Length").description("Minimum kmer Length after second cut site is removed").build();
    private PluginParameter<Integer> myMinKmerCount = new PluginParameter.Builder<Integer>("c", 10, Integer.class).guiName("Min Kmer Count").description("Minimum kmer count").build();
    private PluginParameter<String> myOutputDB = new PluginParameter.Builder<String>("db", null, String.class).guiName("Output Database File").required(true).outFile().description("Output Database File").build();
    private PluginParameter<Integer> myMinQualScore = new PluginParameter.Builder<Integer>("mnQS", 0, Integer.class).guiName("Minimum quality score").required(false).description("Minimum quality score within the barcode and read length to be accepted").build();
    private static String myEnzyme = "ignore";
    private static Integer myMaxKmerNumber = 50000000;
    private static Integer myBatchSize = 8;
    static final String inputFileGlob = "glob:*{.fq,fq.gz,fastq,fastq.txt,fastq.gz,fastq.txt.gz,_sequence.txt,_sequence.txt.gz}";
    static final String sampleNameField = "FullSampleName";
    static final String flowcellField = "Flowcell";
    static final String laneField = "Lane";
    static final String barcodeField = "Barcode";
    private static TagDistributionMap tagCntMap;
    private static boolean taglenException;

    @Override
    public DataSet processData(DataSet input) {
        float loadFactor = 0.95f;
        tagCntMap = new TagDistributionMap(myMaxKmerNumber, loadFactor, 128, this.minKmerCount());
        try {
            Path keyPath = Paths.get(this.keyFile(), new String[0]).toAbsolutePath();
            List<Path> directoryFiles = DirectoryCrawler.listPaths(inputFileGlob, Paths.get(this.inputDirectory(), new String[0]).toAbsolutePath());
            if (directoryFiles.isEmpty()) {
                myLogger.warn((Object)"No files matching:glob:*{.fq,fq.gz,fastq,fastq.txt,fastq.gz,fastq.txt.gz,_sequence.txt,_sequence.txt.gz}");
                System.out.println("RNADeMultiPlex - no files matching glob:*{.fq,fq.gz,fastq,fastq.txt,fastq.gz,fastq.txt.gz,_sequence.txt,_sequence.txt.gz}");
                return null;
            }
            List<Path> inputSeqFiles = directoryFiles;
            if (inputSeqFiles.size() == 0) {
                return null;
            }
            int batchNum = inputSeqFiles.size() / myBatchSize;
            if (inputSeqFiles.size() % myBatchSize != 0) {
                ++batchNum;
            }
            TaxaList masterTaxaList = TaxaListIOUtils.readTaxaAnnotationFile(this.keyFile(), sampleNameField, new HashMap<String, String>(), true);
            if (Files.exists(Paths.get(this.myOutputDB.value(), new String[0]), new LinkOption[0])) {
                try {
                    Files.delete(Paths.get(this.outputDatabaseFile(), new String[0]));
                }
                catch (Exception exc) {
                    System.out.println("Error when trying to delete database file: " + this.outputDatabaseFile());
                    System.out.println("File delete error: " + exc.getMessage());
                    return null;
                }
            }
            TagDataSQLite tdw = new TagDataSQLite(this.outputDatabaseFile());
            taglenException = false;
            for (int i = 0; i < inputSeqFiles.size(); i += myBatchSize.intValue()) {
                int end = i + myBatchSize;
                if (end > inputSeqFiles.size()) {
                    end = inputSeqFiles.size();
                }
                ArrayList<Path> sub = new ArrayList<Path>();
                for (int j = i; j < end; ++j) {
                    sub.add(inputSeqFiles.get(j));
                }
                System.out.println("\nStart processing batch " + String.valueOf(i / myBatchSize + 1));
                sub.parallelStream().forEach(inputSeqFile -> {
                    try {
                        RNADeMultiPlexSeqToDBPlugin.processFastQFile(masterTaxaList, keyPath, inputSeqFile, myEnzyme, this.minimumQualityScore(), this.minimumKmerLength(), tagCntMap);
                    }
                    catch (StringIndexOutOfBoundsException oobe) {
                        oobe.printStackTrace();
                        myLogger.error((Object)oobe.getMessage());
                        RNADeMultiPlexSeqToDBPlugin.setTagLenException();
                        return;
                    }
                });
                if (taglenException) {
                    return null;
                }
                System.out.println("\nKmers are added from batch " + String.valueOf(i / myBatchSize + 1) + ". Total batch number: " + batchNum);
                int currentSize = tagCntMap.size();
                System.out.println("Current number: " + String.valueOf(currentSize) + ". Max kmer number: " + String.valueOf(myMaxKmerNumber));
                System.out.println(String.valueOf((float)currentSize / (float)myMaxKmerNumber.intValue()) + " of max tag number");
                if (currentSize > 0) {
                    this.calcTagMapStats(tagCntMap);
                    System.out.println();
                    roughTagCnt.reset();
                    roughTagCnt.add(tagCntMap.size());
                } else {
                    System.out.println("WARNING: Current tagcntmap size is 0 after processing batch " + String.valueOf(i / myBatchSize + 1));
                }
                System.out.println("Total memory: " + String.valueOf((double)(Runtime.getRuntime().totalMemory() / 1024L / 1024L / 1024L)) + " Gb");
                System.out.println("Free memory: " + String.valueOf((double)(Runtime.getRuntime().freeMemory() / 1024L / 1024L / 1024L)) + " Gb");
                System.out.println("Max memory: " + String.valueOf((double)(Runtime.getRuntime().maxMemory() / 1024L / 1024L / 1024L)) + " Gb");
                System.out.println("\n");
            }
            System.out.println("\nAll the batch are processed");
            tagCntMap.removeTagByCount(this.minKmerCount());
            System.out.println("By removing kmers with minCount of " + this.myMinKmerCount + " Kmer number is reduced to " + tagCntMap.size() + "\n");
            tdw.putTaxaList(masterTaxaList);
            tdw.putAllTag(tagCntMap.keySet());
            tdw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private long[] calcTagMapStats(TagDistributionMap tagCntMap) {
        long totalDepth = 0L;
        long memory = 0L;
        int cnt = 0;
        for (Map.Entry entry : tagCntMap.entrySet()) {
            memory += (long)((TaxaDistribution)entry.getValue()).memorySize();
            memory += 25L;
            totalDepth += (long)((TaxaDistribution)entry.getValue()).totalDepth();
            ++cnt;
        }
        int currentSize = tagCntMap.size();
        long[] stats = new long[]{currentSize, memory += (long)(tagCntMap.size() * 2 * 16), totalDepth, totalDepth / (long)cnt};
        System.out.printf("Map Tags:%,d  Memory:%,d  TotalDepth:%,d  AvgDepthPerTag:%d%n", stats[0], stats[1], stats[2], stats[3]);
        return stats;
    }

    private static void processFastQFile(TaxaList masterTaxaList, Path keyPath, Path fastQPath, String enzymeName, int minQuality, int minKmerLen, TagDistributionMap masterTagTaxaMap) throws StringIndexOutOfBoundsException {
        ArrayList<Taxon> tl = TaxaListIOUtils.readTaxaAnnotationFileAL(keyPath.toAbsolutePath().toString(), sampleNameField, new HashMap<String, String>());
        if (tl.size() == 0) {
            return;
        }
        BarcodeTrie barcodeTrie = GBSUtils.initializeBarcodeTrie(tl, masterTaxaList, new GBSEnzyme(enzymeName));
        RNADeMultiPlexSeqToDBPlugin.processFastQ(fastQPath, barcodeTrie, masterTaxaList, masterTagTaxaMap, minQuality, minKmerLen);
    }

    private static void processFastQ(Path fastqFile, BarcodeTrie barcodeTrie, TaxaList masterTaxaList, TagDistributionMap masterTagTaxaMap, int minQual, int minKmerLen) throws StringIndexOutOfBoundsException {
        int allReads = 0;
        int goodBarcodedReads = 0;
        int lowQualityReads = 0;
        int badNoBarcode = 0;
        int nullTags = 0;
        int shortReads = 0;
        int maxTaxaNumber = masterTaxaList.size();
        int checkSize = 10000000;
        myLogger.info((Object)("processing file " + fastqFile.toString()));
        try {
            String[] seqAndQual;
            int qualityScoreBase = GBSUtils.determineQualityScoreBase(fastqFile);
            BufferedReader br = Utils.getBufferedReader(fastqFile.toString(), 0x400000);
            long time = System.nanoTime();
            String likelyReadEnd = "AGATCGGA";
            while ((seqAndQual = GBSUtils.readDeMultiPlexFastQBlock(br, allReads)) != null) {
                ++allReads;
                int adapterStart = 0;
                String tmpSeq = seqAndQual[2] + seqAndQual[0];
                Barcode barcode = barcodeTrie.longestPrefix(tmpSeq);
                if (barcode == null) {
                    System.out.println("BC not found: " + seqAndQual[0]);
                    ++badNoBarcode;
                    continue;
                }
                String sequence = seqAndQual[0];
                adapterStart = sequence.indexOf(likelyReadEnd);
                if (adapterStart > 0) {
                    sequence = sequence.substring(0, adapterStart - 1);
                }
                if (sequence.length() < minKmerLen) {
                    ++shortReads;
                    continue;
                }
                if (minQual > 0 && BaseEncoder.getFirstLowQualityPos(seqAndQual[1], minQual, qualityScoreBase) < sequence.length()) {
                    ++lowQualityReads;
                    continue;
                }
                Tag tag = null;
                tag = TagBuilder.instance(sequence).build();
                if (tag == null) {
                    ++nullTags;
                    continue;
                }
                ++goodBarcodedReads;
                TaxaDistribution taxaDistribution = (TaxaDistribution)masterTagTaxaMap.get(tag);
                if (taxaDistribution == null) {
                    masterTagTaxaMap.put(tag, TaxaDistBuilder.create(maxTaxaNumber, barcode.getTaxaIndex()));
                    roughTagCnt.increment();
                } else {
                    taxaDistribution.increment(barcode.getTaxaIndex());
                }
                if (allReads % checkSize == 0) {
                    myLogger.info((Object)("Total Reads:" + allReads + " Reads with barcode and cut site overhang:" + goodBarcodedReads + " rate:" + (System.nanoTime() - time) / (long)allReads + " ns/read. Current tag count:" + roughTagCnt));
                }
                if (allReads % checkSize != 0) continue;
                myLogger.info((Object)("Total Reads:" + allReads + " Reads with barcode and cut site overhang:" + goodBarcodedReads + " rate:" + (System.nanoTime() - time) / (long)allReads + " ns/read. Current tag count:" + roughTagCnt));
            }
            myLogger.info((Object)("Summary for " + fastqFile.toString() + "\nTotal number of reads in lane=" + allReads + "\nTotal number of good barcoded reads=" + goodBarcodedReads + "\nTotal number of low quality reads=" + lowQualityReads + "\nTotal number of short reads=" + shortReads + "\nTotal number of bad or no barcode found=" + badNoBarcode + "\nTotal number of null tags created=" + nullTags + "\nTiming process (sorting, collapsing, and writing TagCount to file).\nProcess took " + (double)(System.nanoTime() - time) / 1000000.0 + " milliseconds."));
            br.close();
        }
        catch (StringIndexOutOfBoundsException oobe) {
            throw oobe;
        }
        catch (Exception e) {
            myLogger.error((Object)("Good Barcodes Read: " + goodBarcodedReads));
            e.printStackTrace();
        }
    }

    public static void setTagLenException() {
        taglenException = true;
    }

    public RNADeMultiPlexSeqToDBPlugin() {
        super(null, false);
    }

    public RNADeMultiPlexSeqToDBPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    public RNADeMultiPlexSeqToDBPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return null;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    public String inputDirectory() {
        return this.myInputDir.value();
    }

    public RNADeMultiPlexSeqToDBPlugin inputDirectory(String value) {
        this.myInputDir = new PluginParameter<String>(this.myInputDir, value);
        return this;
    }

    public String keyFile() {
        return this.myKeyFile.value();
    }

    public RNADeMultiPlexSeqToDBPlugin keyFile(String value) {
        this.myKeyFile = new PluginParameter<String>(this.myKeyFile, value);
        return this;
    }

    public Integer minimumKmerLength() {
        return this.myMinKmerLength.value();
    }

    public RNADeMultiPlexSeqToDBPlugin minimumKmerLength(Integer value) {
        this.myMinKmerLength = new PluginParameter<Integer>(this.myMinKmerLength, value);
        return this;
    }

    public Integer minKmerCount() {
        return this.myMinKmerCount.value();
    }

    public RNADeMultiPlexSeqToDBPlugin minKmerCount(Integer value) {
        this.myMinKmerCount = new PluginParameter<Integer>(this.myMinKmerCount, value);
        return this;
    }

    public String outputDatabaseFile() {
        return this.myOutputDB.value();
    }

    public RNADeMultiPlexSeqToDBPlugin outputDatabaseFile(String value) {
        this.myOutputDB = new PluginParameter<String>(this.myOutputDB, value);
        return this;
    }

    public Integer minimumQualityScore() {
        return this.myMinQualScore.value();
    }

    public RNADeMultiPlexSeqToDBPlugin minimumQualityScore(Integer value) {
        this.myMinQualScore = new PluginParameter<Integer>(this.myMinQualScore, value);
        return this;
    }

    static class TagDistributionMap
    extends ConcurrentHashMap<Tag, TaxaDistribution> {
        private final int maxTagNum;
        private int minDepthToRetainInMap = 2;
        private final int minCount;

        TagDistributionMap(int maxTagNumber, float loadFactor, int concurrencyLevel, int minCount) {
            super(maxTagNumber * 2, loadFactor, concurrencyLevel);
            this.maxTagNum = maxTagNumber;
            this.minCount = minCount;
        }

        @Override
        public TaxaDistribution put(Tag key, TaxaDistribution value) {
            return super.put(key, value);
        }

        public synchronized void removeTagByCount(int minCnt) {
            this.entrySet().parallelStream().filter(e -> ((TaxaDistribution)e.getValue()).totalDepth() < minCnt).forEach((? super T e) -> {
                TaxaDistribution cfr_ignored_0 = (TaxaDistribution)this.remove(e.getKey());
            });
        }

        public long estimateMapMemorySize() {
            long size = 0L;
            int cnt = 0;
            for (Map.Entry entry : this.entrySet()) {
                size += 25L;
                size += 16L;
                size += (long)((TaxaDistribution)entry.getValue()).memorySize();
                if (++cnt <= 10000) continue;
                break;
            }
            long estSize = (long)(this.size() / cnt) * size;
            return estSize;
        }

        public long[] depthDistribution() {
            long[] base2bins = new long[34];
            int cnt = 0;
            for (Map.Entry entry : this.entrySet()) {
                int n = 31 - Integer.numberOfLeadingZeros(((TaxaDistribution)entry.getValue()).totalDepth());
                base2bins[n] = base2bins[n] + 1L;
                ++cnt;
            }
            return base2bins;
        }
    }
}

