/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.tree;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.distance.IBSDistanceMatrix;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.taxa.tree.NeighborJoiningTree;
import net.maizegenetics.taxa.tree.Tree;
import net.maizegenetics.taxa.tree.UPGMATree;
import org.apache.log4j.Logger;

public class CreateTreePlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(CreateTreePlugin.class);
    private PluginParameter<CLUSTERING_METHOD> myClusteringMethod = new PluginParameter.Builder<CLUSTERING_METHOD>("clusteringMethod", CLUSTERING_METHOD.Neighbor_Joining, CLUSTERING_METHOD.class).description("").range((Comparable<T>[])CLUSTERING_METHOD.values()).build();
    private PluginParameter<Boolean> mySaveDistanceMatrix = new PluginParameter.Builder<Boolean>("saveDistanceMatrix", true, Boolean.class).description("").build();
    private Datum myGenotypeTable = null;
    private Datum myDistanceMatrix = null;

    public CreateTreePlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        this.myGenotypeTable = null;
        List<Datum> alignInList = input.getDataOfType(GenotypeTable.class);
        if (alignInList.size() >= 1) {
            this.myGenotypeTable = alignInList.get(0);
            return;
        }
        List<Datum> matrixList = input.getDataOfType(DistanceMatrix.class);
        if (matrixList.size() >= 1) {
            this.myDistanceMatrix = matrixList.get(0);
            return;
        }
        throw new IllegalArgumentException("CreateTreePlugin: Invalid selection.  Please select a Genotype Table.");
    }

    @Override
    public DataSet processData(DataSet input) {
        Datum datum = null;
        DistanceMatrix distanceMatrix = null;
        if (this.myGenotypeTable != null) {
            datum = this.myGenotypeTable;
            distanceMatrix = IBSDistanceMatrix.getInstance((GenotypeTable)this.myGenotypeTable.getData(), this);
        } else if (this.myDistanceMatrix != null) {
            datum = this.myDistanceMatrix;
            distanceMatrix = (DistanceMatrix)this.myDistanceMatrix.getData();
        } else {
            throw new IllegalArgumentException("CreateTreePlugin: Invalid selection.  Please select a Genotype Table or Distance Matrix.");
        }
        ArrayList<Datum> results = new ArrayList<Datum>();
        if (this.clusteringMethod() == CLUSTERING_METHOD.Neighbor_Joining) {
            NeighborJoiningTree theTree = new NeighborJoiningTree(distanceMatrix);
            results.add(new Datum("Tree:" + datum.getName(), theTree, "NJ Tree"));
        } else if (this.clusteringMethod() == CLUSTERING_METHOD.UPGMA) {
            UPGMATree theTree = new UPGMATree(distanceMatrix);
            results.add(new Datum("Tree:" + datum.getName(), theTree, "UPGMA Tree"));
        } else {
            throw new IllegalArgumentException("CreateTreePlugin: processData: Unknown clustering method: " + (Object)((Object)this.clusteringMethod()));
        }
        if (this.saveDistanceMatrix().booleanValue()) {
            results.add(new Datum("Matrix:" + datum.getName(), distanceMatrix, "Distance Matrix"));
        }
        return new DataSet(results, (Plugin)this);
    }

    @Override
    public String pluginUserManualURL() {
        return "https://bitbucket.org/tasseladmin/tassel-5-source/wiki/UserManual/Cladogram/Cladogram";
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = CreateTreePlugin.class.getResource("/net/maizegenetics/analysis/images/Tree.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Create Tree";
    }

    @Override
    public String getToolTipText() {
        return "Create a tree";
    }

    public Tree runPlugin(DataSet input) {
        return (Tree)this.performFunction(input).getData(0).getData();
    }

    public CLUSTERING_METHOD clusteringMethod() {
        return this.myClusteringMethod.value();
    }

    public CreateTreePlugin clusteringMethod(CLUSTERING_METHOD value) {
        this.myClusteringMethod = new PluginParameter<CLUSTERING_METHOD>(this.myClusteringMethod, value);
        return this;
    }

    public Boolean saveDistanceMatrix() {
        return this.mySaveDistanceMatrix.value();
    }

    public CreateTreePlugin saveDistanceMatrix(Boolean value) {
        this.mySaveDistanceMatrix = new PluginParameter<Boolean>(this.mySaveDistanceMatrix, value);
        return this;
    }

    public static enum CLUSTERING_METHOD {
        Neighbor_Joining,
        UPGMA;

    }
}

