/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.tree;

import java.awt.Frame;
import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.maizegenetics.analysis.filter.FilterTaxaBuilderPlugin;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.tree.NewickUtils;
import net.maizegenetics.taxa.tree.Tree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J\u0006\u0010\u0007\u001a\u00020\tJ\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\tJ\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016R2\u0010\u0007\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnet/maizegenetics/analysis/tree/SubsetTreePlugin;", "Lnet/maizegenetics/plugindef/AbstractPlugin;", "parentFrame", "Ljava/awt/Frame;", "isInteractive", "", "(Ljava/awt/Frame;Z)V", "nameList", "Lnet/maizegenetics/plugindef/PluginParameter;", "Lnet/maizegenetics/taxa/TaxaList;", "kotlin.jvm.PlatformType", "getButtonName", "", "getIcon", "Ljavax/swing/ImageIcon;", "getToolTipText", "value", "preProcessParameters", "", "input", "Lnet/maizegenetics/plugindef/DataSet;", "processData", "tassel"})
public final class SubsetTreePlugin
extends AbstractPlugin {
    private PluginParameter<TaxaList> nameList;

    @Override
    protected void preProcessParameters(@Nullable DataSet input) {
        int numTrees;
        List<Datum> temp;
        DataSet dataSet = input;
        List<Datum> list = temp = dataSet != null ? dataSet.getDataOfType(Tree.class) : null;
        int n = numTrees = list != null ? list.size() : 0;
        if (numTrees != 1) {
            throw (Throwable)new IllegalArgumentException("SubsetTreePlugin: processData: must input 1 tree");
        }
    }

    @Override
    @Nullable
    public DataSet processData(@Nullable DataSet input) {
        DataSet dataSet = input;
        if (dataSet == null) {
            Intrinsics.throwNpe();
        }
        Datum datum = dataSet.getDataOfType(Tree.class).get(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)datum, (String)"input!!.getDataOfType(Tree::class.java).get(0)");
        Object object = datum.getData();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.maizegenetics.taxa.tree.Tree");
        }
        Tree tree = (Tree)object;
        return new DataSet(new Datum("Subset Tree", NewickUtils.subsetTree(tree, this.nameList()), null), (Plugin)this);
    }

    @NotNull
    public final TaxaList nameList() {
        TaxaList taxaList = this.nameList.value();
        Intrinsics.checkExpressionValueIsNotNull((Object)taxaList, (String)"nameList.value()");
        return taxaList;
    }

    @NotNull
    public final SubsetTreePlugin nameList(@NotNull TaxaList value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.nameList = new PluginParameter<TaxaList>(this.nameList, value);
        return this;
    }

    @Override
    @NotNull
    public String getToolTipText() {
        return "Subset Tree";
    }

    @Override
    @NotNull
    public String getButtonName() {
        return "Subset Tree";
    }

    @Override
    @Nullable
    public ImageIcon getIcon() {
        ImageIcon imageIcon;
        URL imageURL;
        URL uRL = imageURL = FilterTaxaBuilderPlugin.class.getResource("/net/maizegenetics/analysis/images/FilterNew.gif");
        if (uRL != null) {
            URL uRL2 = uRL;
            boolean bl = false;
            boolean bl2 = false;
            URL it = uRL2;
            boolean bl3 = false;
            imageIcon = new ImageIcon(it);
        } else {
            imageIcon = null;
        }
        return imageIcon;
    }

    public SubsetTreePlugin(@Nullable Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
        this.nameList = new PluginParameter.Builder<TaxaList>("nameList", null, TaxaList.class).description("List of names to include. This can be a comma separated list of names (no spaces unless surrounded by quotes), file (.txt) with list of names to include, or a taxa list file (.json or .json.gz).").required(true).build();
    }

    public /* synthetic */ SubsetTreePlugin(Frame frame, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            frame = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        this(frame, bl);
    }

    public SubsetTreePlugin() {
        this(null, false, 3, null);
    }
}

