/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.workflow;

import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.ImageIcon;
import net.maizegenetics.pipeline.TasselPipeline;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.tassel.TASSELMainFrame;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class WorkflowPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(WorkflowPlugin.class);
    private final String myButtonName;
    private final String[] myArgs;
    private final TASSELMainFrame myFrame;

    private WorkflowPlugin(TASSELMainFrame parentFrame, String buttonName, String[] args) {
        super(parentFrame, true);
        this.myButtonName = buttonName;
        this.myArgs = args;
        this.myFrame = parentFrame;
    }

    public static List<WorkflowPlugin> getInstances(TASSELMainFrame parentFrame) {
        ArrayList<WorkflowPlugin> result = new ArrayList<WorkflowPlugin>();
        List<String> filenames = WorkflowPlugin.getConfigFiles();
        if (!filenames.isEmpty()) {
            for (String filename : filenames) {
                String[] args = new String[]{"-configResourceFile", filename};
                WorkflowPlugin test = new WorkflowPlugin(parentFrame, WorkflowPlugin.buttonName(filename), args);
                result.add(test);
            }
        } else {
            filenames = WorkflowPlugin.getConfigFilesFromSrc();
            for (String filename : filenames) {
                String[] args = new String[]{"-configFile", filename};
                WorkflowPlugin test = new WorkflowPlugin(parentFrame, WorkflowPlugin.buttonName(filename), args);
                result.add(test);
            }
        }
        return result;
    }

    private static List<String> getConfigFiles() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            URL directory = WorkflowPlugin.class.getResource("/net/maizegenetics/analysis/workflow/");
            String directoryPath = directory.getPath();
            if (directoryPath.contains("!")) {
                String jarPath = directory.getPath().substring(5, directoryPath.indexOf("!"));
                JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    String name = entries.nextElement().getName();
                    if (!name.startsWith("net/maizegenetics/analysis/workflow/") || !name.endsWith(".xml")) continue;
                    result.add("/" + name);
                }
            }
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private static List<String> getConfigFilesFromSrc() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            URL directory = WorkflowPlugin.class.getResource("/net/maizegenetics/analysis/workflow/");
            String directoryPath = directory.getPath();
            File temp = new File(directoryPath);
            for (File current : temp.listFiles()) {
                String name = current.getCanonicalPath();
                if (!name.endsWith(".xml")) continue;
                result.add("/" + name);
            }
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private static String buttonName(String filename) {
        String temp = Utils.getFilename(filename, ".xml");
        StringBuilder builder = new StringBuilder();
        builder.append(Character.toUpperCase(temp.charAt(0)));
        boolean newWord = false;
        for (int i = 1; i < temp.length(); ++i) {
            char current = temp.charAt(i);
            if (current == '_' || current == '-' || current == ' ') {
                builder.append(' ');
                newWord = true;
                continue;
            }
            if (Character.isUpperCase(builder.charAt(builder.length() - 1))) {
                builder.append(current);
                newWord = false;
                continue;
            }
            if (Character.isUpperCase(current)) {
                builder.append(' ');
                builder.append(current);
                newWord = false;
                continue;
            }
            if (newWord) {
                builder.append(Character.toUpperCase(current));
                newWord = false;
                continue;
            }
            builder.append(current);
        }
        return builder.toString();
    }

    @Override
    public DataSet processData(DataSet input) {
        try {
            new TasselPipeline(this.myArgs, this.myFrame, true, this.myButtonName);
            DataSet dataSet = null;
            return dataSet;
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("WorkflowPlugin: Problem running workflow: " + this.myButtonName + "\n" + e.getMessage());
        }
        finally {
            this.fireProgress(100);
        }
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = WorkflowPlugin.class.getResource("/net/maizegenetics/analysis/images/Workflow.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return this.myButtonName;
    }

    @Override
    public String getToolTipText() {
        return this.myButtonName;
    }

    @Override
    public String getCitation() {
        return "Casstevens T, Wang Y. (2015) First Annual Tassel Hackathon.";
    }
}

