/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.maizegenetics.util.GeneralAnnotation;

public class Chromosome
implements Comparable<Chromosome> {
    private static final Pattern DIGITS = Pattern.compile("^\\d+");
    public static Chromosome UNKNOWN = new Chromosome("Unknown");
    private final String myName;
    private final int myChromosomeNumber;
    private final String myCompareString;
    private final int myLength;
    private final GeneralAnnotation myGA;
    private final int hashCode;
    private static final ConcurrentHashMap<String, Chromosome> CHROMOSOME_NAME_ONLY = new ConcurrentHashMap(25);

    public static Chromosome instance(String name) {
        return CHROMOSOME_NAME_ONLY.computeIfAbsent(name, s -> new Chromosome(name));
    }

    public static Chromosome instance(int name) {
        String chr = String.valueOf(name);
        return Chromosome.instance(chr);
    }

    public static Chromosome instance(String name, int length, GeneralAnnotation features) {
        return new Chromosome(name, length, features);
    }

    private Chromosome(String name, int length, GeneralAnnotation features) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Chromosome: name can't be null or empty.");
        }
        this.myName = Chromosome.parseName(name);
        Matcher matcher = DIGITS.matcher(this.myName);
        if (matcher.find()) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < 5 - matcher.end(); ++i) {
                builder.append("0");
            }
            builder.append(this.myName);
            this.myCompareString = builder.toString();
        } else {
            this.myCompareString = this.myName;
        }
        this.myLength = length;
        int convChr = Integer.MAX_VALUE;
        try {
            convChr = Integer.parseInt(this.myName);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.myChromosomeNumber = convChr;
        this.myGA = features;
        this.hashCode = this.calcHashCode();
    }

    public Chromosome(String name) {
        this(name, -1, null);
    }

    public String getName() {
        return this.myName;
    }

    public int getChromosomeNumber() {
        return this.myChromosomeNumber;
    }

    public int getLength() {
        return this.myLength;
    }

    public GeneralAnnotation getAnnotation() {
        return this.myGA;
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int calcHashCode() {
        return 553 + this.myName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Chromosome)) {
            return false;
        }
        if (this.hashCode != obj.hashCode()) {
            return false;
        }
        return this.compareTo((Chromosome)obj) == 0;
    }

    @Override
    public int compareTo(Chromosome o) {
        if (this == o) {
            return 0;
        }
        if (this.myChromosomeNumber != Integer.MAX_VALUE && o.myChromosomeNumber != Integer.MAX_VALUE) {
            return Integer.compare(this.myChromosomeNumber, o.myChromosomeNumber);
        }
        return this.myCompareString.compareTo(o.myCompareString);
    }

    private static String parseName(String name) {
        int spaceIndex;
        String parsedName = name.trim();
        if ((parsedName = parsedName.toUpperCase()).startsWith("CHROMOSOME")) {
            parsedName = parsedName.replaceFirst("CHROMOSOME", "");
        }
        if (parsedName.startsWith("CHR")) {
            parsedName = parsedName.replaceFirst("CHR", "");
        }
        if ((spaceIndex = parsedName.indexOf(" ")) > 0) {
            parsedName = parsedName.substring(0, parsedName.indexOf(" "));
        }
        return parsedName;
    }
}

