/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import com.google.common.base.Joiner;
import java.util.Arrays;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.util.GeneralAnnotation;
import net.maizegenetics.util.GeneralAnnotationStorage;

public final class GeneralPosition
implements Position {
    private final Chromosome myChromosome;
    private final int myPosition;
    private final short myInsertionPosition;
    private final byte myStrand;
    private final boolean isNucleotide;
    private final boolean isIndel;
    private final float myMAF;
    private final float mySiteCoverage;
    private final long myAlleleValue;
    private final byte[] mySNPIDAsBytes;
    private final GeneralAnnotation myVariantsAndAnno;
    private final int hashCode;

    private GeneralPosition(Builder builder) {
        this.myChromosome = builder.myChromosome;
        this.myPosition = builder.myPosition;
        this.myInsertionPosition = builder.myInsertionPosition;
        this.myStrand = builder.myStrand;
        this.mySNPIDAsBytes = (byte[])(builder.mySNPID == null ? null : builder.mySNPID.getBytes());
        this.isNucleotide = builder.isNucleotide;
        this.isIndel = builder.isIndel;
        this.myVariantsAndAnno = builder.myAnnotations.build();
        this.hashCode = this.calcHashCode();
        this.myMAF = builder.myMAF;
        this.mySiteCoverage = builder.mySiteCoverage;
        this.myAlleleValue = builder.myAllelesAsLong;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Position)) {
            return false;
        }
        Position o = (Position)obj;
        int result = this.compareTo(o);
        return result == 0;
    }

    @Override
    public int compareTo(Position o) {
        int result = this.myChromosome.compareTo(o.getChromosome());
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.myPosition, o.getPosition());
        if (result != 0) {
            return result;
        }
        result = Short.compare(this.myInsertionPosition, o.getInsertionPosition());
        if (result != 0) {
            return result;
        }
        result = Byte.compare(this.myStrand, o.getStrand());
        if (result != 0) {
            return result;
        }
        if (this.getActualSNPID() == null && o.getActualSNPID() == null) {
            return 0;
        }
        return this.getSNPID().compareTo(o.getSNPID());
    }

    public String toString() {
        Object[] variants;
        StringBuilder sb = new StringBuilder("Position");
        sb.append("\tChr:").append(this.getChromosome().getName());
        sb.append("\tPos:").append(this.getPosition());
        sb.append("\tInsertionPos:").append(this.getInsertionPosition());
        sb.append("\tName:").append(this.getSNPID());
        if (this.myVariantsAndAnno != null && (variants = this.myVariantsAndAnno.getTextAnnotation("VARIANT")) != null && variants.length != 0) {
            sb.append("\tVariants:").append(Joiner.on((String)",").join(variants));
        }
        sb.append("\tMAF:").append(this.getGlobalMAF());
        sb.append("\tRef:").append(NucleotideAlignmentConstants.getHaplotypeNucleotide(this.getAllele(WHICH_ALLELE.Reference)));
        return sb.toString();
    }

    private int calcHashCode() {
        int hash = 7;
        hash = 37 * hash + this.myChromosome.hashCode();
        hash = 37 * hash + this.myPosition;
        hash = 37 * hash + this.myInsertionPosition;
        hash = 37 * hash + this.myStrand;
        if (this.mySNPIDAsBytes != null) {
            hash = 37 * hash + Arrays.hashCode(this.mySNPIDAsBytes);
        }
        return hash;
    }

    @Override
    public float getGlobalMAF() {
        return this.myMAF;
    }

    @Override
    public float getGlobalSiteCoverage() {
        return this.mySiteCoverage;
    }

    @Override
    public byte getAllele(WHICH_ALLELE alleleType) {
        return (byte)(this.myAlleleValue >> alleleType.index() * 4 & 0xFL);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public Chromosome getChromosome() {
        return this.myChromosome;
    }

    @Override
    public int getPosition() {
        return this.myPosition;
    }

    @Override
    public short getInsertionPosition() {
        return this.myInsertionPosition;
    }

    @Override
    public byte getStrand() {
        return this.myStrand;
    }

    @Override
    public String getStrandStr() {
        return Position.getStrand(this.myStrand);
    }

    @Override
    public String getSNPID() {
        if (this.mySNPIDAsBytes == null) {
            return "S" + this.getChromosome().getName() + "_" + this.myPosition;
        }
        return new String(this.mySNPIDAsBytes);
    }

    @Override
    public String getActualSNPID() {
        if (this.mySNPIDAsBytes == null) {
            return null;
        }
        return new String(this.mySNPIDAsBytes);
    }

    @Override
    public boolean isNucleotide() {
        return this.isNucleotide;
    }

    @Override
    public boolean isIndel() {
        return this.isIndel;
    }

    @Override
    public String[] getKnownVariants() {
        if (this.myVariantsAndAnno == null) {
            return new String[0];
        }
        if (this.myVariantsAndAnno.getTextAnnotation("VARIANT").length == 0) {
            return new String[0];
        }
        return this.myVariantsAndAnno.getTextAnnotation("VARIANT")[0].replace("[", "").replace("]", "").split("/");
    }

    @Override
    public GeneralAnnotation getAnnotation() {
        return this.myVariantsAndAnno;
    }

    public static class Builder {
        private Chromosome myChromosome;
        private int myPosition;
        private short myInsertionPosition = 0;
        private byte myStrand = 1;
        private String mySNPID = null;
        private boolean isNucleotide = true;
        private boolean isIndel = false;
        private float myMAF = Float.NaN;
        private float mySiteCoverage = Float.NaN;
        private byte[] myAlleles = new byte[WHICH_ALLELE.COUNT];
        private long myAllelesAsLong;
        private final GeneralAnnotationStorage.Builder myAnnotations;

        public Builder(Chromosome chr, int position) {
            this(chr, position, GeneralAnnotationStorage.getBuilder());
        }

        public Builder(Chromosome chr, int position, GeneralAnnotationStorage.Builder annotationBuilder) {
            this.myChromosome = chr;
            this.myPosition = position;
            Arrays.fill(this.myAlleles, (byte)15);
            this.myAnnotations = annotationBuilder;
        }

        public Builder(Position aCorePosition) {
            this(aCorePosition.getChromosome(), aCorePosition.getPosition());
            this.myInsertionPosition = aCorePosition.getInsertionPosition();
            this.myStrand = aCorePosition.getStrand();
            this.mySNPID = aCorePosition.getSNPID();
            this.isNucleotide = aCorePosition.isNucleotide();
            this.isIndel = aCorePosition.isIndel();
            this.myMAF = aCorePosition.getGlobalMAF();
            this.mySiteCoverage = aCorePosition.getGlobalSiteCoverage();
            for (WHICH_ALLELE alleleType : WHICH_ALLELE.values()) {
                this.myAlleles[alleleType.index()] = aCorePosition.getAllele(alleleType);
            }
            this.myAnnotations.addAnnotations(aCorePosition.getAnnotation());
        }

        public Builder chromosome(Chromosome val) {
            this.myChromosome = val;
            return this;
        }

        public Builder position(int val) {
            this.myPosition = val;
            return this;
        }

        public Builder insertionPosition(short val) {
            this.myInsertionPosition = val;
            return this;
        }

        public Builder strand(byte val) {
            this.myStrand = val;
            return this;
        }

        public Builder strand(String val) {
            this.myStrand = Position.getStrand(val);
            return this;
        }

        public Builder snpName(String val) {
            this.mySNPID = val;
            return this;
        }

        public Builder nucleotide(boolean val) {
            this.isNucleotide = val;
            return this;
        }

        public Builder indel(boolean val) {
            this.isIndel = val;
            return this;
        }

        public Builder knownVariants(String[] val) {
            StringBuilder sb = new StringBuilder();
            for (String s : val) {
                sb.append(s).append("/");
            }
            sb.setLength(sb.length() - 1);
            this.myAnnotations.addAnnotation("VARIANT", sb.toString());
            return this;
        }

        public Builder knownVariants(String val) {
            this.myAnnotations.addAnnotation("VARIANT", val);
            return this;
        }

        public Builder maf(float val) {
            this.myMAF = val;
            return this;
        }

        public Builder siteCoverage(float val) {
            this.mySiteCoverage = val;
            return this;
        }

        public Builder allele(WHICH_ALLELE aT, byte val) {
            this.myAlleles[aT.index()] = val;
            return this;
        }

        public Builder addAnno(String key, Object value) {
            if (value instanceof Number) {
                this.myAnnotations.addAnnotation(key, (Number)value);
            } else {
                this.myAnnotations.addAnnotation(key, value.toString());
            }
            return this;
        }

        public Builder addAnno(String keyValue) {
            String[] sub = keyValue.split("=");
            if (sub.length == 1) {
                return this.addAnno(keyValue, "TRUE");
            }
            return this.addAnno(sub[0], sub[1]);
        }

        public GeneralPosition build() {
            String defaultS;
            for (int i = this.myAlleles.length - 1; i >= 0; --i) {
                this.myAllelesAsLong = this.myAllelesAsLong << 4 | (long)this.myAlleles[i];
            }
            if (this.mySNPID != null && (defaultS = "S" + this.myChromosome.getName() + "_" + this.myPosition).equals(this.mySNPID)) {
                this.mySNPID = null;
            }
            return new GeneralPosition(this);
        }
    }
}

