/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import com.google.common.collect.BoundType;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.maizegenetics.dna.map.GenomeFeature;
import net.maizegenetics.util.DirectedGraph;
import net.maizegenetics.util.Utils;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONObject;

public class GenomeFeatureMap {
    DirectedGraph<GenomeFeature> featureTree = null;
    private HashMap<String, GenomeFeature> nameLookup = new HashMap();
    private Multimap<String, GenomeFeature> typeLookup = null;
    private HashMap<String, RangeMap<Integer, HashSet<GenomeFeature>>> locationLookup = null;

    GenomeFeatureMap(HashMap<String, GenomeFeature> nameLookup, Multimap<String, GenomeFeature> typeLookup, HashMap<String, RangeMap<Integer, HashSet<GenomeFeature>>> locationLookup, DirectedGraph<GenomeFeature> featureTree) {
        this.typeLookup = typeLookup;
        this.nameLookup = nameLookup;
        this.locationLookup = locationLookup;
        this.featureTree = featureTree;
    }

    public GenomeFeature getFeatureFromId(String id) {
        return this.nameLookup.get(id);
    }

    public HashSet<GenomeFeature> getFeaturesInRange(String chrom, int start, int end) {
        Range myrange = Range.closed((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end));
        Map chromMap = this.locationLookup.get(chrom).subRangeMap(myrange).asMapOfRanges();
        HashSet<GenomeFeature> featureSet = new HashSet<GenomeFeature>();
        for (Range r : chromMap.keySet()) {
            featureSet.addAll((Collection)chromMap.get(r));
        }
        return featureSet;
    }

    public HashSet<GenomeFeature> getFeaturesAtLocation(int chrom, int position) {
        return this.getFeaturesInRange(chrom, position, position);
    }

    public HashSet<GenomeFeature> getFeaturesAtLocation(String chrom, int position) {
        return this.getFeaturesInRange(chrom, position, position);
    }

    public HashSet<GenomeFeature> getFeaturesInRange(int chrom, int start, int end) {
        return this.getFeaturesInRange("" + chrom, start, end);
    }

    public HashSet<GenomeFeature> getFeaturesOfType(String type) {
        HashSet<GenomeFeature> featureSet = new HashSet<GenomeFeature>();
        featureSet.addAll(this.typeLookup.get((Object)type));
        return featureSet;
    }

    public void writeLocationLookupToFile(String filename) {
        try {
            BufferedWriter writer = Utils.getBufferedWriter(filename);
            writer.append("chrom\tstart\tstop\tfeatures\n");
            Object[] chroms = this.locationLookup.keySet().toArray(new String[0]);
            Arrays.sort(chroms);
            for (Object chrom : chroms) {
                Map itermap = this.locationLookup.get(chrom).asMapOfRanges();
                for (Range r : itermap.keySet()) {
                    int start = (Integer)r.lowerEndpoint();
                    int stop = (Integer)r.upperEndpoint();
                    if (r.lowerBoundType() == BoundType.OPEN) {
                        ++start;
                    }
                    if (r.upperBoundType() == BoundType.OPEN) {
                        --stop;
                    }
                    writer.append((String)chrom + "\t" + start + "\t" + stop + "\t");
                    HashSet features = (HashSet)itermap.get(r);
                    for (GenomeFeature f : features) {
                        writer.append(f.id() + ";");
                    }
                    writer.append("\n");
                }
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeMapAsJsonFile(String filename) {
        try {
            BufferedWriter writer = Utils.getBufferedWriter(filename);
            writer.append("[\n");
            Object[] sortedNames = this.nameLookup.keySet().toArray(new String[0]);
            Arrays.sort(sortedNames);
            for (int i = 0; i < sortedNames.length; ++i) {
                GenomeFeature feature = this.nameLookup.get(sortedNames[i]);
                JSONObject json = new JSONObject();
                json.putAll(feature.annotations());
                if (i < sortedNames.length - 1) {
                    writer.append(json.toJSONString() + ",\n");
                    continue;
                }
                writer.append(json.toJSONString() + "\n");
            }
            writer.append("]");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeMapAsFlatFile(String filename) {
        HashSet<String> attributes = new HashSet<String>();
        for (GenomeFeature feature : this.nameLookup.values()) {
            attributes.addAll(feature.annotations().keySet());
        }
        ArrayList<Object> header = new ArrayList<Object>();
        if (attributes.contains("id")) {
            attributes.remove("id");
            header.add("id");
        }
        Object[] tempNames = attributes.toArray(new String[0]);
        Arrays.sort(tempNames);
        for (Object s : tempNames) {
            header.add(s);
        }
        try {
            BufferedWriter writer = Utils.getBufferedWriter(filename);
            String firstline = StringUtils.join(header, (String)"\t") + "\n";
            writer.append(firstline);
            Object[] names = this.nameLookup.keySet().toArray(new String[0]);
            Arrays.sort(names);
            for (Object id : names) {
                GenomeFeature feature = this.nameLookup.get(id);
                ArrayList<String> data = new ArrayList<String>();
                for (String string : header) {
                    data.add(feature.getAnnotation(string));
                }
                writer.append(StringUtils.join(data, (String)"\t") + "\n");
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeMapAsBinaryFile(String filename) {
    }
}

