/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.maizegenetics.dna.map.GenomeFeature;
import net.maizegenetics.dna.map.GenomeFeatureBuilder;
import net.maizegenetics.dna.map.GenomeFeatureMap;
import net.maizegenetics.util.DirectedGraph;
import net.maizegenetics.util.Graph;
import net.maizegenetics.util.GraphBuilder;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class GenomeFeatureMapBuilder {
    private static final Logger myLogger = Logger.getLogger(GenomeFeatureMapBuilder.class);
    DirectedGraph<GenomeFeature> featureTree = null;
    private HashMap<String, GenomeFeature> nameLookup = new HashMap();
    private HashMap<String, RangeMap<Integer, HashSet<GenomeFeature>>> locationLookup = new HashMap();
    private Multimap<String, GenomeFeature> typeLookup = HashMultimap.create();
    HashSet<String> chromosomes = new HashSet();

    public GenomeFeatureMap build() {
        this.buildGenomeTree();
        this.buildLocationLookup();
        return new GenomeFeatureMap(this.nameLookup, this.typeLookup, this.locationLookup, this.featureTree);
    }

    private void buildGenomeTree() {
        this.addRootFeaturesIfNeeded();
        GenomeFeature genome = this.getGenome();
        ArrayList<GenomeFeature> toReplace = new ArrayList<GenomeFeature>();
        for (GenomeFeature feature : this.nameLookup.values()) {
            if (feature.id() == this.getGenome().id() || !feature.parentId().equals("NA") && this.nameLookup.containsKey(feature.parentId())) continue;
            GenomeFeatureBuilder replacement = new GenomeFeatureBuilder(feature);
            if (feature.chromosome().equals("NA")) {
                replacement.parentId(genome.id());
            } else {
                replacement.parentId(feature.chromosome());
            }
            toReplace.add(replacement.build());
        }
        for (GenomeFeature f : toReplace) {
            this.replaceFeature(f);
        }
        GraphBuilder<GenomeFeature> builder = new GraphBuilder<GenomeFeature>(Graph.GraphType.DIRECTED);
        for (GenomeFeature feature : this.nameLookup.values()) {
            if (feature.id() == this.getGenome().id()) continue;
            if (!this.nameLookup.containsKey(feature.parentId())) {
                myLogger.warn((Object)("WARNING! Unable to find parent " + feature.parentId() + " for feature " + feature.id()));
                continue;
            }
            GenomeFeature parent = this.nameLookup.get(feature.parentId());
            builder.addEdge(parent, feature);
        }
        this.featureTree = (DirectedGraph)builder.build();
    }

    private void addRootFeaturesIfNeeded() {
        GenomeFeature genome;
        if (this.typeLookup.keySet().contains("genome")) {
            genome = this.getGenome();
        } else {
            genome = new GenomeFeatureBuilder().id("GENOME").type("genome").build();
            this.addFeature(genome);
        }
        ArrayList<GenomeFeature> toReplace = new ArrayList<GenomeFeature>();
        ArrayList<GenomeFeature> toAdd = new ArrayList<GenomeFeature>();
        for (String c : this.chromosomes) {
            if (this.nameLookup.containsKey(c)) {
                GenomeFeature mychrom = this.nameLookup.get(c);
                if (mychrom.parentId().equals("NA")) {
                    GenomeFeature newChrom = new GenomeFeatureBuilder(mychrom).parentId(genome.id()).build();
                    toReplace.add(newChrom);
                    continue;
                }
                if (mychrom.parentId().equals(genome.id())) continue;
                throw new UnsupportedOperationException("Error: Chromosome " + mychrom.id() + " assigned with parent " + mychrom.parentId() + " that does not match the recognized genome " + genome.id());
            }
            System.out.println("Making chromosome " + c + " from scratch");
            GenomeFeature newChrom = new GenomeFeatureBuilder().id(c).parentId(genome.id()).chromosome(c).type("chromosome").build();
            toAdd.add(newChrom);
        }
        for (GenomeFeature f : toAdd) {
            this.addFeature(f);
        }
        for (GenomeFeature f : toReplace) {
            this.replaceFeature(f);
        }
    }

    private GenomeFeature getGenome() {
        if (this.typeLookup.keySet().contains("genome")) {
            Collection genomes = this.typeLookup.get((Object)"genome");
            if (genomes.size() == 0) {
                throw new UnsupportedOperationException("Error: Cannot find feature with type 'genome' even though supposedly loaded");
            }
            if (genomes.size() > 1) {
                StringBuilder multiples = new StringBuilder();
                for (GenomeFeature g : genomes) {
                    multiples.append("\n\t" + g.id());
                }
                throw new UnsupportedOperationException("Error: Attempt to build a GenomeFeatureMap with more than one feature annotated as type 'genome':" + multiples);
            }
            return (GenomeFeature)genomes.iterator().next();
        }
        myLogger.warn((Object)"Warning! Attempting to retrieve the root genome when it hasn't been created yet");
        return null;
    }

    private void buildLocationLookup() {
        for (String c : this.chromosomes) {
            TreeRangeMap newmap = TreeRangeMap.create();
            this.locationLookup.put(c, (RangeMap<Integer, HashSet<GenomeFeature>>)newmap);
        }
        for (GenomeFeature feature : this.nameLookup.values()) {
            RangeMap<Integer, HashSet<GenomeFeature>> mymap = this.locationLookup.get(feature.chromosome());
            GenomeFeatureMapBuilder.addFeatureToRangemap(mymap, feature);
        }
    }

    public static void addFeatureToRangemap(RangeMap<Integer, HashSet<GenomeFeature>> masterMap, GenomeFeature feature) {
        if (feature.start() < 0 || feature.stop() < 0) {
            return;
        }
        Range featureRange = Range.closedOpen((Comparable)Integer.valueOf(feature.start()), (Comparable)Integer.valueOf(feature.stop() + 1));
        ArrayList<Range> rangeList = new ArrayList<Range>();
        ArrayList hashList = new ArrayList();
        Map subranges = masterMap.subRangeMap(featureRange).asMapOfRanges();
        for (Range r : subranges.keySet()) {
            rangeList.add(Range.closedOpen((Comparable)r.lowerEndpoint(), (Comparable)r.upperEndpoint()));
            hashList.add(new HashSet((Collection)subranges.get(r)));
        }
        HashSet<GenomeFeature> newset = new HashSet<GenomeFeature>();
        newset.add(feature);
        masterMap.put(featureRange, newset);
        for (int i = 0; i < rangeList.size(); ++i) {
            HashSet tempset = (HashSet)hashList.get(i);
            Range temprange = (Range)rangeList.get(i);
            tempset.add(feature);
            masterMap.put(temprange, (Object)tempset);
        }
    }

    public GenomeFeatureMapBuilder addFeature(GenomeFeature feature) {
        String ID = feature.id();
        if (this.nameLookup.containsKey(ID)) {
            throw new UnsupportedOperationException("Error: Attempt to add a GenomeFeature whose unique ID is already loaded: " + ID);
        }
        return this.addOrReplaceFeature(feature);
    }

    public GenomeFeatureMapBuilder replaceFeature(GenomeFeature feature) {
        String ID = feature.id();
        if (!this.nameLookup.containsKey(ID)) {
            throw new UnsupportedOperationException("Error: Attempt to replace a GenomeFeature whose unique ID has not been loaded yet: " + ID);
        }
        return this.addOrReplaceFeature(feature);
    }

    public GenomeFeatureMapBuilder addOrReplaceFeature(GenomeFeature feature) {
        this.nameLookup.put(feature.id(), feature);
        this.typeLookup.put((Object)feature.type(), (Object)feature);
        if (!feature.chromosome().equals("NA")) {
            this.chromosomes.add(feature.chromosome());
        }
        return this;
    }

    public GenomeFeatureMapBuilder addFromGffFile(String filename) {
        myLogger.warn((Object)"GenomeFeatureMapBuilder - Loading genome annotations from GFF file. Will try to parse annotations field as best as possible. (JSON or tab-delimited formats are preferred.)");
        try {
            BufferedReader reader = Utils.getBufferedReader(filename);
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith("#")) {
                    line = reader.readLine();
                    continue;
                }
                GenomeFeature newFeature = new GenomeFeatureBuilder().parseGffLine(line).build();
                this.addFeature(newFeature);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public GenomeFeatureMapBuilder addFromJsonFile(String filename) {
        JSONParser jparse = new JSONParser();
        BufferedReader reader = Utils.getBufferedReader(filename);
        try {
            JSONArray jarray = (JSONArray)jparse.parse((Reader)reader);
            for (JSONObject json : jarray) {
                GenomeFeature newFeature = new GenomeFeatureBuilder().parseJsonObject(json).build();
                this.addFeature(newFeature);
            }
            reader.close();
        }
        catch (IOException e) {
            myLogger.error((Object)("Error loading data from JSON file " + filename));
            e.printStackTrace();
        }
        catch (ParseException e) {
            myLogger.error((Object)("Error parsing information in JSON file " + filename));
            e.printStackTrace();
        }
        return this;
    }

    public GenomeFeatureMapBuilder addFromFlatFile(String filename) {
        try {
            BufferedReader reader = Utils.getBufferedReader(filename);
            String line = reader.readLine();
            String[] header = null;
            int n = 1;
            while (line != null) {
                ++n;
                if (line.startsWith("#")) {
                    line = reader.readLine();
                    continue;
                }
                String[] tokens = line.split("\t");
                if (header == null) {
                    header = tokens;
                    line = reader.readLine();
                    continue;
                }
                if (tokens.length != header.length) {
                    myLogger.error((Object)("Error: line " + n + " has a different number of fields (" + tokens.length + ") than the header (" + header.length + ")"));
                }
                HashMap<String, String> data = new HashMap<String, String>();
                for (int i = 0; i < tokens.length; ++i) {
                    data.put(header[i], tokens[i]);
                }
                GenomeFeature newFeature = new GenomeFeatureBuilder().loadAll(data).build();
                this.addFeature(newFeature);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }
}

