/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.RangeSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.TreeRangeMap;
import com.google.common.collect.TreeRangeSet;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Stream;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GVCFGenomeSequence;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.GeneralAnnotation;
import net.maizegenetics.util.OpenBitSet;
import net.maizegenetics.util.Tuple;

class HalfByteGenomeSequenceGVCF
implements GVCFGenomeSequence {
    private Map<Chromosome, byte[]> chromPositionMap;
    private Map<Chromosome, Integer> chromLengthLookup = new HashMap<Chromosome, Integer>();
    private RangeMap<Long, Chromosome> wholeGenomeIndexMap = TreeRangeMap.create();
    private PositionList gvcfAnnotationsAndCalls;
    private final long genomeSize;
    private BitSet maskBitSet;
    private BitSet filterBitSet;
    long totalQueryTime = 0L;
    HashMap<Chromosome, int[]> positionIndex = new HashMap();
    int indexScaleFactor = 10000;

    protected HalfByteGenomeSequenceGVCF(Map<Chromosome, byte[]> chromPositionMap, PositionList gvcfAnnotationsAndCalls) {
        this.chromPositionMap = chromPositionMap;
        this.gvcfAnnotationsAndCalls = gvcfAnnotationsAndCalls;
        long initialSequenceSetupStart = System.currentTimeMillis();
        chromPositionMap.entrySet().stream().forEach(e -> this.chromLengthLookup.put((Chromosome)e.getKey(), ((Chromosome)e.getKey()).getLength()));
        LongAdder genomeIndex = new LongAdder();
        this.chromosomes().stream().sorted().forEach(chrom -> {
            int length = this.chromLengthLookup.get(chrom);
            this.wholeGenomeIndexMap.put(Range.closed((Comparable)Long.valueOf(genomeIndex.longValue()), (Comparable)Long.valueOf(genomeIndex.longValue() + (long)length - 1L)), chrom);
            genomeIndex.add(length);
            int[] currentIndexArray = new int[length / this.indexScaleFactor + 2];
            Arrays.fill(currentIndexArray, -1);
            this.positionIndex.put((Chromosome)chrom, currentIndexArray);
        });
        this.genomeSize = genomeIndex.longValue();
        this.maskBitSet = new OpenBitSet(gvcfAnnotationsAndCalls.size());
        this.filterBitSet = new OpenBitSet(gvcfAnnotationsAndCalls.size());
        System.out.println("Initial Startup time for GVCF Sequence: " + (System.currentTimeMillis() - initialSequenceSetupStart) + "ms");
        long indexInitStart = System.currentTimeMillis();
        for (int i = 0; i < gvcfAnnotationsAndCalls.size(); ++i) {
            int currentBin = ((Position)gvcfAnnotationsAndCalls.get(i)).getPosition() / this.indexScaleFactor;
            if (this.positionIndex.get(((Position)gvcfAnnotationsAndCalls.get(i)).getChromosome())[currentBin] != -1) continue;
            this.positionIndex.get((Object)((Position)gvcfAnnotationsAndCalls.get((int)i)).getChromosome())[currentBin] = i;
        }
        System.out.println("Done Creating index: " + (System.currentTimeMillis() - indexInitStart) + "ms");
    }

    protected HalfByteGenomeSequenceGVCF(Map<Chromosome, byte[]> chromPositionMap, PositionList gvcfAnnotationsAndCalls, BitSet maskBitSet, BitSet filterBitSet) {
        this.chromPositionMap = chromPositionMap;
        this.gvcfAnnotationsAndCalls = gvcfAnnotationsAndCalls;
        chromPositionMap.entrySet().stream().forEach(e -> this.chromLengthLookup.put((Chromosome)e.getKey(), ((Chromosome)e.getKey()).getLength()));
        LongAdder genomeIndex = new LongAdder();
        this.chromosomes().stream().sorted().forEach(chrom -> {
            int length = this.chromLengthLookup.get(chrom);
            this.wholeGenomeIndexMap.put(Range.closed((Comparable)Long.valueOf(genomeIndex.longValue()), (Comparable)Long.valueOf(genomeIndex.longValue() + (long)length - 1L)), chrom);
            genomeIndex.add(length);
            int[] currentIndexArray = new int[length / this.indexScaleFactor + 2];
            Arrays.fill(currentIndexArray, -1);
            this.positionIndex.put((Chromosome)chrom, currentIndexArray);
        });
        this.genomeSize = genomeIndex.longValue();
        this.maskBitSet = maskBitSet;
        this.filterBitSet = filterBitSet;
        for (int i = 0; i < gvcfAnnotationsAndCalls.size(); ++i) {
            int currentBin = ((Position)gvcfAnnotationsAndCalls.get(i)).getPosition() / this.indexScaleFactor;
            if (this.positionIndex.get(((Position)gvcfAnnotationsAndCalls.get(i)).getChromosome())[currentBin] != -1) continue;
            this.positionIndex.get((Object)((Position)gvcfAnnotationsAndCalls.get((int)i)).getChromosome())[currentBin] = i;
        }
    }

    @Override
    public Set<Chromosome> chromosomes() {
        return this.chromPositionMap.keySet();
    }

    @Override
    public byte[] chromosomeSequence(Chromosome chrom) {
        return this.chromosomeSequence(chrom, 1, this.chromLengthLookup.get(chrom));
    }

    @Override
    public byte[] chromosomeSequence(Chromosome chrom, int startSite, int lastSite) {
        int i;
        int startSiteFinal = startSite;
        int lastSiteFinal = lastSite;
        this.gvcfAnnotationsAndCalls.chromosomeSiteCount(chrom);
        int[] currentIndex = this.positionIndex.get(chrom);
        int startPositionListIndex = currentIndex[startSite / this.indexScaleFactor];
        int endPositionListIndex = currentIndex[lastSite / this.indexScaleFactor + 1];
        int startPositionListCounter = 1;
        while (startPositionListIndex == -1) {
            if (startSite / this.indexScaleFactor - startPositionListCounter >= 0) {
                startPositionListIndex = currentIndex[startSite / this.indexScaleFactor - startPositionListCounter];
                ++startPositionListCounter;
                continue;
            }
            startPositionListIndex = 0;
            break;
        }
        ArrayList listOfChrPositions = new ArrayList();
        if (endPositionListIndex == -1) {
            for (i = startPositionListIndex; i < startPositionListIndex + this.indexScaleFactor && i < this.gvcfAnnotationsAndCalls.size(); ++i) {
                if (((Position)this.gvcfAnnotationsAndCalls.get(i)).getPosition() < startSiteFinal || ((Position)this.gvcfAnnotationsAndCalls.get(i)).getPosition() > lastSiteFinal) continue;
                listOfChrPositions.add(this.gvcfAnnotationsAndCalls.get(i));
            }
        } else {
            for (i = startPositionListIndex; i <= endPositionListIndex; ++i) {
                if (((Position)this.gvcfAnnotationsAndCalls.get(i)).getPosition() < startSiteFinal || ((Position)this.gvcfAnnotationsAndCalls.get(i)).getPosition() > lastSiteFinal) continue;
                listOfChrPositions.add(this.gvcfAnnotationsAndCalls.get(i));
            }
        }
        Collections.sort(listOfChrPositions);
        boolean actualStartPos = false;
        int startIndex = 0;
        boolean actualEndPos = false;
        boolean endIndex = false;
        boolean addingAtStart = false;
        if (listOfChrPositions.size() > 0) {
            for (int i2 = 1; i2 < this.gvcfAnnotationsAndCalls.size(); ++i2) {
                if (((Position)this.gvcfAnnotationsAndCalls.get(i2)).getPosition() != ((Position)listOfChrPositions.get(0)).getPosition()) continue;
                if (!this.checkPositionCoverage((Position)this.gvcfAnnotationsAndCalls.get(i2 - 1), startSiteFinal)) break;
                startIndex = i2 - 1;
                listOfChrPositions.add(0, this.gvcfAnnotationsAndCalls.get(startIndex));
                addingAtStart = true;
                break;
            }
        }
        int listOfChrPositionsCounter = 0;
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        if (listOfChrPositions.size() == 0) {
            byteList.add(NucleotideAlignmentConstants.getNucleotideAlleleByte("N"));
        } else {
            for (int siteCounter = startSite; siteCounter <= lastSite && listOfChrPositionsCounter < listOfChrPositions.size(); ++siteCounter) {
                int lengthOfPosBlock;
                GeneralAnnotation ga = ((Position)listOfChrPositions.get(listOfChrPositionsCounter)).getAnnotation();
                Set<String> annotationKeys = ga.getAnnotationKeys();
                if (addingAtStart) {
                    if (listOfChrPositionsCounter != 0 && this.filterBitSet.fastGet(listOfChrPositionsCounter - 1)) {
                        if (annotationKeys.contains("END")) {
                            lengthOfPosBlock = Integer.parseInt(ga.getTextAnnotation("END")[0]) - ((Position)listOfChrPositions.get(listOfChrPositionsCounter)).getPosition();
                            siteCounter += lengthOfPosBlock;
                        } else {
                            String[] variants = ((Position)listOfChrPositions.get(listOfChrPositionsCounter)).getKnownVariants();
                            siteCounter += variants[0].length() - 1;
                        }
                        ++listOfChrPositionsCounter;
                        continue;
                    }
                } else if (this.filterBitSet.fastGet(listOfChrPositionsCounter)) {
                    if (annotationKeys.contains("END")) {
                        lengthOfPosBlock = Integer.parseInt(ga.getTextAnnotation("END")[0]) - ((Position)listOfChrPositions.get(listOfChrPositionsCounter)).getPosition();
                        siteCounter += lengthOfPosBlock;
                    } else {
                        String[] variants = ((Position)listOfChrPositions.get(listOfChrPositionsCounter)).getKnownVariants();
                        siteCounter += variants[0].length() - 1;
                    }
                    ++listOfChrPositionsCounter;
                    continue;
                }
                if (this.maskBitSet.fastGet(listOfChrPositionsCounter)) {
                    // empty if block
                }
                if (((Position)listOfChrPositions.get(listOfChrPositionsCounter)).getPosition() <= siteCounter) {
                    int i3;
                    String[] variants;
                    int rightAllele;
                    int leftAllele;
                    String[] callSplit;
                    boolean haploid;
                    boolean phased;
                    String call;
                    if (annotationKeys.contains("END")) {
                        int depth;
                        int endPoint;
                        call = ga.getTextAnnotation("GT")[0];
                        phased = true;
                        haploid = false;
                        if (call.contains("/")) {
                            phased = false;
                        } else if (call.contains("|")) {
                            phased = true;
                        } else {
                            haploid = true;
                        }
                        callSplit = phased ? call.split("|") : call.split("/");
                        rightAllele = leftAllele = Integer.parseInt(callSplit[0]);
                        if (!haploid) {
                            rightAllele = Integer.parseInt(callSplit[1]);
                        }
                        if (lastSite - 1 < (endPoint = Integer.parseInt(ga.getTextAnnotation("END")[0]) - 1)) {
                            endPoint = lastSite - 1;
                        }
                        int startSiteShifted = siteCounter - 1;
                        if (startSite < 0) {
                            throw new IllegalArgumentException("GenomeSequenceBuilder.chromosomeSequence: starting parameter is less than 1 for 1-based method");
                        }
                        byte[] packedBytes = this.chromPositionMap.get(chrom);
                        if (packedBytes == null) {
                            throw new IllegalArgumentException("GenomeSequenceBuilder.chromosomeSequence: chromosome not found");
                        }
                        if (startSiteShifted > packedBytes.length * 2 || endPoint > packedBytes.length * 2) {
                            throw new IllegalArgumentException("GenomeSequenceBuilder.chromosomeSequence: requested sequence is out of range");
                        }
                        variants = ((Position)listOfChrPositions.get(listOfChrPositionsCounter)).getKnownVariants();
                        String leftAlleleString = variants[leftAllele];
                        String dpFullString = ga.getTextAnnotation("DP")[0];
                        if (this.maskBitSet.fastGet(listOfChrPositionsCounter) || dpFullString.equals("0")) {
                            for (int i4 = startSiteShifted; i4 <= endPoint; ++i4) {
                                byteList.add(NucleotideAlignmentConstants.getNucleotideAlleleByte("N"));
                            }
                        } else if (leftAllele == 0) {
                            depth = 0;
                            boolean minDepth = false;
                            if (!dpFullString.equals("")) {
                                depth = Integer.parseInt(dpFullString);
                            }
                            for (int i5 = startSiteShifted; i5 <= endPoint; ++i5) {
                                byteList.add((byte)(i5 % 2 == 0 ? (packedBytes[i5 / 2] & 0xF0) >> 4 : packedBytes[i5 / 2] & 0xF));
                            }
                        } else {
                            depth = 0;
                            if (!dpFullString.equals("")) {
                                depth = Integer.parseInt(dpFullString);
                            }
                            for (i3 = startSiteShifted; i3 <= endPoint; ++i3) {
                                byteList.add(NucleotideAlignmentConstants.getNucleotideAlleleByte("N"));
                            }
                        }
                        siteCounter = endPoint + 1;
                    } else {
                        call = ga.getTextAnnotation("GT")[0];
                        phased = true;
                        haploid = false;
                        if (call.contains("/")) {
                            phased = false;
                        } else if (call.contains("|")) {
                            phased = true;
                        } else {
                            haploid = true;
                        }
                        callSplit = phased ? call.split("|") : call.split("/");
                        rightAllele = leftAllele = Integer.parseInt(callSplit[0]);
                        if (!haploid) {
                            rightAllele = Integer.parseInt(callSplit[1]);
                        }
                        String adsFullString = ga.getTextAnnotation("AD")[0];
                        String dpFullString = ga.getTextAnnotation("DP")[0];
                        String[] adSplit = adsFullString.split(",");
                        variants = ((Position)listOfChrPositions.get(listOfChrPositionsCounter)).getKnownVariants();
                        boolean isHet = this.calcHet(adSplit);
                        if (isHet) {
                            String leftAlleleString = variants[0];
                            for (int alleleCounter = 0; alleleCounter < leftAlleleString.length(); ++alleleCounter) {
                                byteList.add(NucleotideAlignmentConstants.getNucleotideAlleleByte("N"));
                            }
                            siteCounter += leftAlleleString.length() - 1;
                        } else if (adSplit[0].equals("1") || adSplit[0].equals("2")) {
                            if (adSplit[1].equals("0")) {
                                String leftAlleleString = variants[0];
                                int depth = 0;
                                if (!dpFullString.equals("")) {
                                    depth = Integer.parseInt(dpFullString);
                                }
                                if (this.maskBitSet.fastGet(listOfChrPositionsCounter)) {
                                    for (i3 = 0; i3 < leftAlleleString.length() && siteCounter + i3 < lastSite - 1; ++i3) {
                                        byteList.add(NucleotideAlignmentConstants.getNucleotideAlleleByte("N"));
                                    }
                                } else {
                                    for (i3 = 0; i3 < leftAlleleString.length() && siteCounter + i3 < lastSite - 1; ++i3) {
                                        byteList.add(NucleotideAlignmentConstants.getNucleotideAlleleByte(leftAlleleString.charAt(i3)));
                                    }
                                }
                            }
                        } else if (adSplit[1].equals("1") || adSplit[1].equals("2")) {
                            String leftAlleleString = variants[1];
                            int depth = 0;
                            if (!dpFullString.equals("")) {
                                depth = Integer.parseInt(dpFullString);
                            }
                            for (i3 = 0; i3 < leftAlleleString.length(); ++i3) {
                                byteList.add(NucleotideAlignmentConstants.getNucleotideAlleleByte("N"));
                            }
                        } else if (Integer.parseInt(adSplit[1]) >= 3) {
                            int depth = 0;
                            if (!dpFullString.equals("")) {
                                depth = Integer.parseInt(dpFullString);
                            }
                            String leftAlleleString = variants[1];
                            if (this.maskBitSet.fastGet(listOfChrPositionsCounter)) {
                                for (i3 = 0; i3 < leftAlleleString.length(); ++i3) {
                                    byteList.add(NucleotideAlignmentConstants.getNucleotideAlleleByte("N"));
                                }
                            } else {
                                for (i3 = 0; i3 < leftAlleleString.length(); ++i3) {
                                    byteList.add(NucleotideAlignmentConstants.getNucleotideAlleleByte(leftAlleleString.charAt(i3)));
                                }
                                siteCounter += variants[0].length() - 1;
                            }
                        } else {
                            String leftAlleleString = variants[0];
                            for (int i6 = 0; i6 < leftAlleleString.length(); ++i6) {
                                byteList.add(NucleotideAlignmentConstants.getNucleotideAlleleByte(leftAlleleString.charAt(i6)));
                            }
                            siteCounter += variants[0].length() - 1;
                        }
                    }
                    ++listOfChrPositionsCounter;
                    continue;
                }
                byteList.add(NucleotideAlignmentConstants.getNucleotideAlleleByte("N"));
            }
        }
        byte[] fullBytes = new byte[byteList.size()];
        for (int i7 = 0; i7 < fullBytes.length; ++i7) {
            fullBytes[i7] = (Byte)byteList.get(i7);
        }
        return fullBytes;
    }

    @Override
    public HashMap<String, String> chromosomeSequenceAndStats(Chromosome chrom, int startSite, int lastSite) {
        int i;
        long queryTimeStart = System.currentTimeMillis();
        int regionTotalReferenceBPCount = 0;
        int regionTotalExportedBPCount = 0;
        int regionHetCount = 0;
        int regionAltCount = 0;
        int regionDepthCount = 0;
        int regionGQCount = 0;
        int regionMinDepthCount = 0;
        int regionZeroCoverageCount = 0;
        int regionNumberHomoRef1Or2Count = 0;
        boolean regionNumberHomoRef3PlusCount = false;
        int regionNumberHomoAlt1Or2Count = 0;
        int regionNumberHomoAlt3PlusCount = 0;
        int startSiteFinal = startSite;
        int lastSiteFinal = lastSite;
        regionTotalReferenceBPCount = lastSite - startSite + 1;
        long getCurrentSubsetPositionListTimeStart = System.currentTimeMillis();
        int[] currentIndex = this.positionIndex.get(chrom);
        int startPositionListIndex = currentIndex[startSite / this.indexScaleFactor];
        int endPositionListIndex = currentIndex[lastSite / this.indexScaleFactor + 1];
        int startPositionListCounter = 1;
        while (startPositionListIndex == -1) {
            startPositionListIndex = currentIndex[startSite / this.indexScaleFactor - startPositionListCounter];
            ++startPositionListCounter;
        }
        ArrayList listOfChrPositions = new ArrayList();
        int actualStartIndex = Integer.MAX_VALUE;
        if (endPositionListIndex == -1) {
            for (i = startPositionListIndex; i < startPositionListIndex + this.indexScaleFactor && i < this.gvcfAnnotationsAndCalls.size(); ++i) {
                if (((Position)this.gvcfAnnotationsAndCalls.get(i)).getPosition() < startSiteFinal || ((Position)this.gvcfAnnotationsAndCalls.get(i)).getPosition() > lastSiteFinal) continue;
                if (i < actualStartIndex) {
                    actualStartIndex = i;
                }
                listOfChrPositions.add(this.gvcfAnnotationsAndCalls.get(i));
            }
        } else {
            for (i = startPositionListIndex; i <= endPositionListIndex; ++i) {
                if (((Position)this.gvcfAnnotationsAndCalls.get(i)).getPosition() < startSiteFinal || ((Position)this.gvcfAnnotationsAndCalls.get(i)).getPosition() > lastSiteFinal) continue;
                if (i < actualStartIndex) {
                    actualStartIndex = i;
                }
                listOfChrPositions.add(this.gvcfAnnotationsAndCalls.get(i));
            }
        }
        long totalTimeToSubsetPosList = System.currentTimeMillis() - getCurrentSubsetPositionListTimeStart;
        long sortPosTimeStart = System.currentTimeMillis();
        Collections.sort(listOfChrPositions);
        long totalTimeToSortPosList = System.currentTimeMillis() - sortPosTimeStart;
        boolean actualStartPos = false;
        int startIndex = 0;
        boolean actualEndPos = false;
        boolean endIndex = false;
        long addAPositionToStartTime = System.currentTimeMillis();
        boolean addingAtStart = false;
        if (listOfChrPositions.size() > 0 && startPositionListIndex != 0 && this.checkPositionCoverage((Position)this.gvcfAnnotationsAndCalls.get(actualStartIndex - 1), startSiteFinal)) {
            startIndex = actualStartIndex - 1;
            listOfChrPositions.add(0, this.gvcfAnnotationsAndCalls.get(startIndex));
            addingAtStart = true;
        }
        long totalTimeToAddStartPosition = System.currentTimeMillis() - addAPositionToStartTime;
        int listOfChrPositionsCounter = 0;
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        if (listOfChrPositions.size() == 0) {
            byteList.add(NucleotideAlignmentConstants.getNucleotideAlleleByte("N"));
        } else {
            for (int siteCounter = startSite; siteCounter <= lastSite && listOfChrPositionsCounter < listOfChrPositions.size(); ++siteCounter) {
                int lengthOfPosBlock;
                GeneralAnnotation ga = ((Position)listOfChrPositions.get(listOfChrPositionsCounter)).getAnnotation();
                Set<String> annotationKeys = ga.getAnnotationKeys();
                if (addingAtStart) {
                    if (listOfChrPositionsCounter != 0 && this.filterBitSet.fastGet(listOfChrPositionsCounter - 1)) {
                        if (annotationKeys.contains("END")) {
                            lengthOfPosBlock = Integer.parseInt(ga.getTextAnnotation("END")[0]) - ((Position)listOfChrPositions.get(listOfChrPositionsCounter)).getPosition();
                            siteCounter += lengthOfPosBlock;
                        } else {
                            String[] variants = ((Position)listOfChrPositions.get(listOfChrPositionsCounter)).getKnownVariants();
                            siteCounter += variants[0].length() - 1;
                        }
                        ++listOfChrPositionsCounter;
                        continue;
                    }
                } else if (this.filterBitSet.fastGet(listOfChrPositionsCounter)) {
                    if (annotationKeys.contains("END")) {
                        lengthOfPosBlock = Integer.parseInt(ga.getTextAnnotation("END")[0]) - ((Position)listOfChrPositions.get(listOfChrPositionsCounter)).getPosition();
                        siteCounter += lengthOfPosBlock;
                    } else {
                        String[] variants = ((Position)listOfChrPositions.get(listOfChrPositionsCounter)).getKnownVariants();
                        siteCounter += variants[0].length() - 1;
                    }
                    ++listOfChrPositionsCounter;
                    continue;
                }
                if (this.maskBitSet.fastGet(listOfChrPositionsCounter)) {
                    // empty if block
                }
                if (((Position)listOfChrPositions.get(listOfChrPositionsCounter)).getPosition() <= siteCounter) {
                    int i2;
                    String[] variants;
                    int rightAllele;
                    int leftAllele;
                    String[] callSplit;
                    boolean haploid;
                    boolean phased;
                    String call;
                    if (annotationKeys.contains("END")) {
                        int depth;
                        int endPoint;
                        call = ga.getTextAnnotation("GT")[0];
                        phased = true;
                        haploid = false;
                        if (call.contains("/")) {
                            phased = false;
                        } else if (call.contains("|")) {
                            phased = true;
                        } else {
                            haploid = true;
                        }
                        callSplit = phased ? call.split("|") : call.split("/");
                        rightAllele = leftAllele = Integer.parseInt(callSplit[0]);
                        if (!haploid) {
                            rightAllele = Integer.parseInt(callSplit[1]);
                        }
                        if (lastSite - 1 < (endPoint = Integer.parseInt(ga.getTextAnnotation("END")[0]) - 1)) {
                            endPoint = lastSite - 1;
                        }
                        int startSiteShifted = siteCounter - 1;
                        if (startSite < 0) {
                            throw new IllegalArgumentException("GenomeSequenceBuilder.chromosomeSequence: starting parameter is less than 1 for 1-based method");
                        }
                        byte[] packedBytes = this.chromPositionMap.get(chrom);
                        if (packedBytes == null) {
                            throw new IllegalArgumentException("GenomeSequenceBuilder.chromosomeSequence: chromosome not found");
                        }
                        if (startSiteShifted > packedBytes.length * 2 || endPoint > packedBytes.length * 2) {
                            throw new IllegalArgumentException("GenomeSequenceBuilder.chromosomeSequence: requested sequence is out of range");
                        }
                        variants = ((Position)listOfChrPositions.get(listOfChrPositionsCounter)).getKnownVariants();
                        String leftAlleleString = variants[leftAllele];
                        String dpFullString = ga.getTextAnnotation("DP")[0];
                        if (this.maskBitSet.fastGet(listOfChrPositionsCounter) || dpFullString.equals("0")) {
                            for (int i3 = startSiteShifted; i3 <= endPoint; ++i3) {
                                regionDepthCount += 0;
                                ++regionZeroCoverageCount;
                                byteList.add(NucleotideAlignmentConstants.getNucleotideAlleleByte("N"));
                            }
                        } else if (leftAllele == 0) {
                            depth = 0;
                            int minDepth = 0;
                            if (!dpFullString.equals("")) {
                                depth = Integer.parseInt(dpFullString);
                            }
                            for (int i4 = startSiteShifted; i4 <= endPoint; ++i4) {
                                regionDepthCount += depth;
                                regionMinDepthCount += minDepth;
                                byteList.add((byte)(i4 % 2 == 0 ? (packedBytes[i4 / 2] & 0xF0) >> 4 : packedBytes[i4 / 2] & 0xF));
                            }
                        } else {
                            depth = 0;
                            if (!dpFullString.equals("")) {
                                depth = Integer.parseInt(dpFullString);
                            }
                            for (i2 = startSiteShifted; i2 <= endPoint; ++i2) {
                                regionDepthCount += depth;
                                ++regionZeroCoverageCount;
                                byteList.add(NucleotideAlignmentConstants.getNucleotideAlleleByte("N"));
                            }
                        }
                        siteCounter = endPoint + 1;
                    } else {
                        call = ga.getTextAnnotation("GT")[0];
                        phased = true;
                        haploid = false;
                        if (call.contains("/")) {
                            phased = false;
                        } else if (call.contains("|")) {
                            phased = true;
                        } else {
                            haploid = true;
                        }
                        callSplit = phased ? call.split("|") : call.split("/");
                        rightAllele = leftAllele = Integer.parseInt(callSplit[0]);
                        if (!haploid) {
                            rightAllele = Integer.parseInt(callSplit[1]);
                        }
                        String adsFullString = ga.getTextAnnotation("AD")[0];
                        String dpFullString = ga.getTextAnnotation("DP")[0];
                        String[] adSplit = adsFullString.split(",");
                        variants = ((Position)listOfChrPositions.get(listOfChrPositionsCounter)).getKnownVariants();
                        boolean isHet = this.calcHet(adSplit);
                        if (isHet) {
                            String leftAlleleString = variants[0];
                            siteCounter += leftAlleleString.length() - 1;
                            for (int i5 = 0; i5 < leftAlleleString.length(); ++i5) {
                                ++regionHetCount;
                            }
                        } else if (adSplit[0].equals("1") || adSplit[0].equals("2")) {
                            if (adSplit[1].equals("0")) {
                                String leftAlleleString = variants[0];
                                int depth = 0;
                                if (!dpFullString.equals("")) {
                                    depth = Integer.parseInt(dpFullString);
                                }
                                if (this.maskBitSet.fastGet(listOfChrPositionsCounter)) {
                                    for (i2 = 0; i2 < leftAlleleString.length() && siteCounter + i2 < lastSite - 1; ++i2) {
                                        regionDepthCount += depth;
                                        ++regionNumberHomoRef1Or2Count;
                                        byteList.add(NucleotideAlignmentConstants.getNucleotideAlleleByte("N"));
                                    }
                                } else {
                                    for (i2 = 0; i2 < leftAlleleString.length() && siteCounter + i2 < lastSite - 1; ++i2) {
                                        regionDepthCount += depth;
                                        ++regionNumberHomoRef1Or2Count;
                                        byteList.add(NucleotideAlignmentConstants.getNucleotideAlleleByte(leftAlleleString.charAt(i2)));
                                    }
                                }
                            }
                        } else if (adSplit[1].equals("1") || adSplit[1].equals("2")) {
                            String leftAlleleString = variants[1];
                            int depth = 0;
                            if (!dpFullString.equals("")) {
                                depth = Integer.parseInt(dpFullString);
                            }
                            for (i2 = 0; i2 < leftAlleleString.length(); ++i2) {
                                regionDepthCount += depth;
                                ++regionNumberHomoAlt1Or2Count;
                                byteList.add(NucleotideAlignmentConstants.getNucleotideAlleleByte("N"));
                            }
                        } else if (Integer.parseInt(adSplit[1]) >= 3) {
                            int depth = 0;
                            if (!dpFullString.equals("")) {
                                depth = Integer.parseInt(dpFullString);
                            }
                            String leftAlleleString = variants[1];
                            if (this.maskBitSet.fastGet(listOfChrPositionsCounter)) {
                                for (i2 = 0; i2 < leftAlleleString.length(); ++i2) {
                                    ++regionAltCount;
                                    ++regionNumberHomoAlt3PlusCount;
                                    regionDepthCount += depth;
                                    byteList.add(NucleotideAlignmentConstants.getNucleotideAlleleByte("N"));
                                }
                            } else {
                                for (i2 = 0; i2 < leftAlleleString.length(); ++i2) {
                                    ++regionAltCount;
                                    ++regionNumberHomoAlt3PlusCount;
                                    regionDepthCount += depth;
                                    byteList.add(NucleotideAlignmentConstants.getNucleotideAlleleByte(leftAlleleString.charAt(i2)));
                                }
                                siteCounter += variants[0].length() - 1;
                            }
                        } else {
                            String leftAlleleString = variants[0];
                            for (int i6 = 0; i6 < leftAlleleString.length(); ++i6) {
                                byteList.add(NucleotideAlignmentConstants.getNucleotideAlleleByte(leftAlleleString.charAt(i6)));
                            }
                            siteCounter += variants[0].length() - 1;
                        }
                    }
                    ++listOfChrPositionsCounter;
                    continue;
                }
                byteList.add(NucleotideAlignmentConstants.getNucleotideAlleleByte("N"));
                regionDepthCount += 0;
                ++regionZeroCoverageCount;
            }
        }
        regionTotalExportedBPCount = byteList.size();
        byte[] fullBytes = new byte[byteList.size()];
        for (int i7 = 0; i7 < fullBytes.length; ++i7) {
            fullBytes[i7] = (Byte)byteList.get(i7);
        }
        HashMap<String, String> sequenceAndStats = new HashMap<String, String>();
        sequenceAndStats.put("Sequence", NucleotideAlignmentConstants.nucleotideBytetoString(fullBytes));
        sequenceAndStats.put("RefSize", "" + regionTotalReferenceBPCount);
        sequenceAndStats.put("Size", "" + regionTotalExportedBPCount);
        sequenceAndStats.put("HetCount", "" + regionHetCount);
        sequenceAndStats.put("AltCount", "" + regionAltCount);
        sequenceAndStats.put("Depth", "" + regionDepthCount);
        sequenceAndStats.put("GQ", "" + regionGQCount);
        sequenceAndStats.put("Min_Depth", "" + regionMinDepthCount);
        sequenceAndStats.put("ZeroCoverageCount", "" + regionZeroCoverageCount);
        sequenceAndStats.put("HomoRefCount", "" + regionNumberHomoRef1Or2Count);
        sequenceAndStats.put("HomoAltLowDepthCount", "" + regionNumberHomoAlt1Or2Count);
        sequenceAndStats.put("HomoAltHighDepthCount", "" + regionNumberHomoAlt3PlusCount);
        long queryTimeEnd = System.currentTimeMillis();
        return sequenceAndStats;
    }

    @Override
    public byte[] genomeSequence(long startSite, long lastSite) {
        byte[] chromoSeq;
        if (lastSite - startSite > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Less than 2147483647 sites must be requested at a time");
        }
        byte[] fullBytes = new byte[(int)(lastSite - startSite + 1L)];
        for (long currentSiteToGet = startSite; currentSiteToGet < lastSite; currentSiteToGet += (long)chromoSeq.length) {
            Map.Entry rangeChromEntry = this.wholeGenomeIndexMap.getEntry((Comparable)Long.valueOf(currentSiteToGet));
            int chrStart = (int)(currentSiteToGet - (Long)((Range)rangeChromEntry.getKey()).lowerEndpoint());
            int chrLast = (int)Math.min((Long)((Range)rangeChromEntry.getKey()).upperEndpoint() - (Long)((Range)rangeChromEntry.getKey()).lowerEndpoint(), lastSite - (Long)((Range)rangeChromEntry.getKey()).lowerEndpoint());
            chromoSeq = this.chromosomeSequence((Chromosome)rangeChromEntry.getValue(), chrStart + 1, chrLast + 1);
            System.arraycopy(chromoSeq, 0, fullBytes, (int)(currentSiteToGet - startSite), chromoSeq.length);
        }
        return fullBytes;
    }

    @Override
    public int chromosomeSize(Chromosome chromosome) {
        return this.chromLengthLookup.get(chromosome);
    }

    @Override
    public long genomeSize() {
        return this.genomeSize;
    }

    @Override
    public int numberOfChromosomes() {
        return this.chromPositionMap.size();
    }

    @Override
    public Map<Long, Tuple<Chromosome, Integer>> fullRefCoordinateToChromCoordinate(ArrayList<Long> coordinates) {
        ConcurrentHashMap<Long, Tuple<Chromosome, Integer>> mappedCoordinates = new ConcurrentHashMap<Long, Tuple<Chromosome, Integer>>();
        ((Stream)coordinates.stream().parallel()).forEach(coordinate -> {
            Map.Entry rangeChromEntry = this.wholeGenomeIndexMap.getEntry((Comparable)coordinate);
            Chromosome curChrom = (Chromosome)rangeChromEntry.getValue();
            long chromCoordinate = coordinate - (Long)((Range)rangeChromEntry.getKey()).lowerEndpoint();
            Tuple<Chromosome, Integer> chromWithCoordinate = new Tuple<Chromosome, Integer>(curChrom, (int)chromCoordinate);
            mappedCoordinates.put((Long)coordinate, chromWithCoordinate);
        });
        return mappedCoordinates;
    }

    private boolean checkPositionCoverage(Position pos, int site) {
        GeneralAnnotation ga = pos.getAnnotation();
        String[] endArray = ga.getTextAnnotation("END");
        if (endArray.length != 0) {
            int endPoint = Integer.parseInt(endArray[0]);
            return pos.getPosition() <= site && site <= endPoint;
        }
        if (pos.getPosition() == site) {
            return true;
        }
        String[] alleles = pos.getKnownVariants();
        return alleles[0].length() + pos.getPosition() >= site;
    }

    @Override
    public Map<Chromosome, byte[]> getChrPosMap() {
        return this.chromPositionMap;
    }

    @Override
    public HashMap<Chromosome, ArrayList<ArrayList<Integer>>> getConsecutiveRegions() {
        HashMap<Chromosome, ArrayList<ArrayList<Integer>>> consecRegions = new HashMap<Chromosome, ArrayList<ArrayList<Integer>>>();
        Set<Chromosome> chromosomeSet = this.chromosomes();
        HashMap<Chromosome, TreeRangeSet> rangeMaps = new HashMap<Chromosome, TreeRangeSet>();
        for (Chromosome chr : chromosomeSet) {
            rangeMaps.put(chr, TreeRangeSet.create());
            consecRegions.put(chr, new ArrayList());
        }
        for (int i = 0; i < this.gvcfAnnotationsAndCalls.size(); ++i) {
            if (this.filterBitSet.fastGet(i)) continue;
            Position currentPosition = (Position)this.gvcfAnnotationsAndCalls.get(i);
            SetMultimap<String, String> annos = currentPosition.getAnnotation().getAnnotationAsMap();
            if (annos.containsKey((Object)"END")) {
                int endPoint = Integer.parseInt((String)annos.get((Object)"END").toArray()[0]);
                ((RangeSet)rangeMaps.get(currentPosition.getChromosome())).add(Range.closed((Comparable)Integer.valueOf(currentPosition.getPosition()), (Comparable)Integer.valueOf(endPoint + 1)));
                continue;
            }
            String[] variants = currentPosition.getKnownVariants();
            String refAlleleString = variants[0];
            if (refAlleleString.length() > 1) {
                ((RangeSet)rangeMaps.get(currentPosition.getChromosome())).add(Range.closed((Comparable)Integer.valueOf(currentPosition.getPosition()), (Comparable)Integer.valueOf(currentPosition.getPosition() + refAlleleString.length())));
                continue;
            }
            ((RangeSet)rangeMaps.get(currentPosition.getChromosome())).add(Range.closed((Comparable)Integer.valueOf(currentPosition.getPosition()), (Comparable)Integer.valueOf(currentPosition.getPosition() + 1)));
        }
        for (Chromosome chr : chromosomeSet) {
            Set rangeSet = ((RangeSet)rangeMaps.get(chr)).asRanges();
            for (Range currentRange : rangeSet) {
                ArrayList<Comparable> currentList = new ArrayList<Comparable>();
                currentList.add(currentRange.lowerEndpoint());
                currentList.add(Integer.valueOf((Integer)currentRange.upperEndpoint() - 1));
                consecRegions.get(chr).add(currentList);
            }
        }
        return consecRegions;
    }

    @Override
    public void writeFASTA(String fileName) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            HashMap<Chromosome, ArrayList<ArrayList<Integer>>> consecutiveRegions = this.getConsecutiveRegions();
            Set<Chromosome> chromosomes = this.chromosomes();
            for (Chromosome chr : chromosomes) {
                for (ArrayList<Integer> bounds : consecutiveRegions.get(chr)) {
                    writer.write(">Chr_" + chr.getChromosomeNumber() + "_StartSite_" + bounds.get(0) + "_EndSite_" + bounds.get(1));
                    writer.newLine();
                    writer.write("" + NucleotideAlignmentConstants.nucleotideBytetoString(this.chromosomeSequence(chr, bounds.get(0), bounds.get(1))));
                    writer.newLine();
                }
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public BitSet getMaskBitSet() {
        return this.maskBitSet;
    }

    @Override
    public void setMaskBitSet(BitSet newMaskBitSet) {
        this.maskBitSet = newMaskBitSet;
    }

    @Override
    public BitSet getFilterBitSet() {
        return this.filterBitSet;
    }

    @Override
    public void setFilterBitSet(BitSet newFilterBitSet) {
        this.filterBitSet = newFilterBitSet;
    }

    @Override
    public void flipMaskBit(int index) {
        this.maskBitSet.fastFlip(index);
    }

    @Override
    public void flipFilterBit(int index) {
        this.filterBitSet.fastFlip(index);
    }

    @Override
    public PositionList getGVCFPositions() {
        return this.gvcfAnnotationsAndCalls;
    }

    private boolean calcHet(String[] adSplit) {
        boolean isHet = false;
        int refDepth = Integer.parseInt(adSplit[0]);
        int altDepth = Integer.parseInt(adSplit[1]);
        if (refDepth > 0 && altDepth > 0) {
            isHet = true;
        }
        return isHet;
    }

    @Override
    public void resetCounters() {
    }

    @Override
    public HashMap<String, Integer> getPreviousRegionStats() {
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        return stats;
    }

    @Override
    public byte genotype(Chromosome chrom, int position) {
        return 0;
    }

    @Override
    public byte genotype(Chromosome chrom, Position positionObject) {
        return 0;
    }

    @Override
    public String genotypeAsString(Chromosome chrom, int position) {
        return null;
    }

    @Override
    public String genotypeAsString(Chromosome chrom, Position positionObject) {
        return null;
    }

    @Override
    public String genotypeAsString(Chromosome chrom, int startSite, int endSite) {
        return null;
    }
}

