/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

public class TagMappingInfoV3 {
    public int chromosome = Integer.MIN_VALUE;
    public byte strand = (byte)-128;
    public int startPosition = Integer.MIN_VALUE;
    public int endPosition = Integer.MIN_VALUE;
    public byte divergence = (byte)-128;
    public byte perfectMatch = (byte)-128;
    public byte mappingSource = (byte)-128;
    public byte mappingRank = (byte)-128;
    public short mappingScore = Short.MIN_VALUE;
    public byte dcoP = (byte)-128;
    public byte mapP = (byte)-128;

    public TagMappingInfoV3() {
    }

    public TagMappingInfoV3(int chromosome, byte strand, int startPosition, int endPosition, byte divergence, byte perfectMatch, byte mappingSource, short mappingScore) {
        this.chromosome = chromosome;
        this.strand = strand;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.divergence = divergence;
        this.perfectMatch = perfectMatch;
        this.mappingSource = mappingSource;
        this.mappingScore = mappingScore;
    }

    public TagMappingInfoV3(int chromosome, byte strand, int startPosition, int endPosition, byte divergence, byte perfectMatch, byte mappingSource, short mappingScore, byte[] variantPosOff, byte[] variantDef, byte dcoP, byte mapP) {
        this(chromosome, strand, startPosition, endPosition, divergence, perfectMatch, mappingSource, mappingScore);
        this.dcoP = dcoP;
        this.mapP = mapP;
    }

    public void setMappingRank(byte mappingRank) {
        this.mappingRank = mappingRank;
    }

    public void setMappingSource(byte mappingSource) {
        this.mappingSource = mappingSource;
    }

    public static enum Aligner {
        Bowtie2(0, "Bowtie2"),
        BWA(1, "BWA"),
        Blast(2, "Blast"),
        BWAMEM(3, "BWAMEM"),
        PEEnd1(4, "PEEnd1"),
        PEEnd2(5, "PEEnd2");

        private byte value;
        private String name;

        private Aligner(byte mappingSource, String alignerName) {
            this.value = mappingSource;
            this.name = alignerName;
        }

        public byte getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public static byte getValueFromName(String name) {
            if (name.equalsIgnoreCase(Aligner.Bowtie2.name)) {
                return Bowtie2.getValue();
            }
            if (name.equalsIgnoreCase(Aligner.BWA.name)) {
                return BWA.getValue();
            }
            if (name.equalsIgnoreCase(Aligner.Blast.name)) {
                return Blast.getValue();
            }
            if (name.equalsIgnoreCase(Aligner.BWAMEM.name)) {
                return BWAMEM.getValue();
            }
            if (name.equalsIgnoreCase(Aligner.PEEnd1.name)) {
                return PEEnd1.getValue();
            }
            if (name.equalsIgnoreCase(Aligner.PEEnd2.name)) {
                return PEEnd2.getValue();
            }
            return -128;
        }

        public static Aligner getAlignerFromName(String name) {
            if (name.equalsIgnoreCase(Aligner.Bowtie2.name)) {
                return Bowtie2;
            }
            if (name.equalsIgnoreCase(Aligner.BWA.name)) {
                return BWA;
            }
            if (name.equalsIgnoreCase(Aligner.Blast.name)) {
                return Blast;
            }
            if (name.equalsIgnoreCase(Aligner.BWAMEM.name)) {
                return BWAMEM;
            }
            if (name.equalsIgnoreCase(Aligner.PEEnd1.name)) {
                return PEEnd1;
            }
            if (name.equalsIgnoreCase(Aligner.PEEnd2.name)) {
                return PEEnd2;
            }
            return null;
        }

        public static Aligner getAlignerFromValue(byte value) {
            if (value == Bowtie2.getValue()) {
                return Bowtie2;
            }
            if (value == BWA.getValue()) {
                return BWA;
            }
            if (value == Blast.getValue()) {
                return Blast;
            }
            if (value == BWAMEM.getValue()) {
                return BWAMEM;
            }
            if (value == PEEnd1.getValue()) {
                return PEEnd1;
            }
            if (value == PEEnd2.getValue()) {
                return PEEnd2;
            }
            return null;
        }
    }
}

