/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.pd;

import java.io.File;
import java.util.HashSet;

public class FolderParser {
    private File directory;
    private int traitPosition = 0;
    private int chrPosition = 5;
    private String filenameToken = "\\.";

    public FolderParser(File directoryIn) {
        this.directory = directoryIn;
    }

    public FolderParser(File directoryIn, int traitPositionIn, int chrPositionIn, String filenameTokenIn) {
        if (this.traitPosition >= 0) {
            this.traitPosition = traitPositionIn;
        }
        if (this.chrPosition >= 0) {
            this.chrPosition = chrPositionIn;
        }
        if (this.filenameToken != null) {
            this.filenameToken = filenameTokenIn;
        }
    }

    public String[] getAllTraits() {
        File[] files = this.getFiles();
        HashSet<String> traitSet = new HashSet<String>();
        for (int i = 0; i < files.length; ++i) {
            traitSet.add(this.getFileFeature(files[i], this.filenameToken, this.traitPosition));
        }
        String[] trait = new String[traitSet.size()];
        traitSet.toArray(trait);
        return trait;
    }

    public File getFile(String chromosome, String trait) {
        File[] chrFiles = this.getAllChromosomeFiles(chromosome);
        for (int i = 0; i < chrFiles.length; ++i) {
            if (!chrFiles[i].toString().contains(trait)) continue;
            return chrFiles[i];
        }
        return null;
    }

    private File[] getAllChromosomeFiles(String chromosome) {
        HashSet<File> chrFile = new HashSet<File>();
        File[] files = this.getFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].toString().contains(chromosome)) continue;
            chrFile.add(files[i]);
        }
        File[] chrFiles = new File[chrFile.size()];
        chrFile.toArray(chrFiles);
        return chrFiles;
    }

    private String getFileFeature(File aFile, String token, int field) {
        String fileName = aFile.getName();
        String[] part = fileName.split(token);
        return part[field];
    }

    private File[] getFiles() {
        File[] directoryFile = this.directory.listFiles();
        if (directoryFile.length < 1) {
            String output = "Directory contains no files.";
            return null;
        }
        return directoryFile;
    }

    public static void main(String[] args) {
        String testDir = "C:\\Users\\dkroon\\Documents\\TASSEL\\code\\GWAS\\src\\supporting\\gwas_results";
        File fileDir = new File(testDir);
        FolderParser fp = new FolderParser(fileDir);
        File[] file = fp.getAllChromosomeFiles("chr8");
        System.out.println("numberOfChrFiles = " + file.length);
        for (int i = 0; i < file.length; ++i) {
            System.out.println("file = " + file[i]);
        }
        String[] trait = fp.getAllTraits();
        System.out.println("numberOfTraitsAcrossAllFiles = " + trait.length);
        for (int i = 0; i < trait.length; ++i) {
            System.out.println("trait = " + trait[i]);
        }
    }
}

