/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.pd;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import ch.systemsx.cisd.hdf5.IHDF5WriterConfigurator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.util.Utils;

public class PDAnnotation {
    private static final String HAS_DATA = "HasData";
    private String hapMapFile_prefix = "/maizeHapMapV2_B73RefGenV2_201203028_";
    private String hapMapFile_suffix = "h.hmp.txt.gz";
    private static final int PHYSICAL_POSITION_COLUMN = 0;
    private static final int MINOR_ALLELE_FREQUENCY_COLUMN = 1;
    private static final int COLUMN_OFFSET = 1;
    private int traitIndex = 0;
    private int chrIndex = 1;
    private int physPosIndex = 2;
    private int resultIndex = 5;
    private String[] allTraits;
    private int[][] allPositions;
    private float[][] allResults;
    private int[][] featurePositions;
    private String[] allFeatures;

    public PDAnnotation(String hapMapPath, String pathGwas, String annoPath, String outputFile, int startChr, int endChr) {
        File aHapMapDir = new File(hapMapPath);
        File aGwasDir = new File(pathGwas);
        this.createAnnoHDF5WithHapMap(aHapMapDir, outputFile, startChr);
        this.loadGWAS(aGwasDir, outputFile, startChr, "\t");
    }

    public void createAnnoHDF5WithHapMap(File hapMapDir, String outputFile, int currChr) {
        IHDF5WriterConfigurator config = HDF5Factory.configure((String)outputFile);
        config.overwrite();
        IHDF5Writer writer = config.writer();
        int[] hasData = null;
        String chromosomeFile = hapMapDir + this.hapMapFile_prefix + "chr" + currChr + this.hapMapFile_suffix;
        System.out.println("Loading:" + chromosomeFile);
        GenotypeTable bna = ImportUtils.readFromHapmap(chromosomeFile, null);
        int siteCnt = bna.numberOfSites();
        int[] alignmentPhysPos = bna.physicalPositions();
        hasData = new int[siteCnt];
        float[] maf = new float[siteCnt];
        byte[] mjAllele = new byte[siteCnt];
        byte[] mnAllele = new byte[siteCnt];
        for (int j = 0; j < siteCnt; ++j) {
            mjAllele[j] = bna.majorAlleleAsString(j).getBytes()[0];
            mnAllele[j] = bna.minorAlleleAsString(j).getBytes()[0];
            maf[j] = (float)bna.minorAlleleFrequency(j);
        }
        String chrGroup = "chr" + currChr + "/";
        writer.object().createGroup(chrGroup);
        writer.int32().setAttr(chrGroup, "numSites", siteCnt);
        writer.int32().createArray(chrGroup + "Positions", alignmentPhysPos.length);
        writer.writeIntArray(chrGroup + "Positions", alignmentPhysPos);
        writer.int8().createArray(chrGroup + "SiteDesc/MajorAllele", mjAllele.length);
        writer.writeByteArray(chrGroup + "SiteDesc/MajorAllele", mjAllele);
        writer.int8().createArray(chrGroup + "SiteDesc/MinorAllele", mnAllele.length);
        writer.writeByteArray(chrGroup + "SiteDesc/MinorAllele", mnAllele);
        writer.float32().createArray(chrGroup + "SiteDesc/MAF", maf.length);
        writer.float32().writeArray(chrGroup + "SiteDesc/MAF", maf);
        writer.object().createGroup(chrGroup + "GWAS");
        writer.object().createGroup(chrGroup + "GenomeAnno");
        writer.object().createGroup(chrGroup + "PopGenAnno");
        writer.close();
    }

    private void loadGWAS(File gwasFileIn, String outputFile, int currChr, String delimiter) {
        IHDF5Writer writer = HDF5Factory.open((String)outputFile);
        System.out.println("Loading GWAS by chromosome");
        this.loadDataByChromosome(gwasFileIn, currChr, delimiter);
        String chrGroup = "chr" + currChr + "/";
        int[] positions = writer.readIntArray(chrGroup + "Positions");
        for (int i = 0; i < this.allTraits.length; ++i) {
            int posMatch = 0;
            int posMisMatch = 0;
            float[] rmip = new float[positions.length];
            for (int j = 0; j < this.allPositions[i].length; ++j) {
                if (this.allPositions[i][j] > 3600000) continue;
                int[] aInt = this.allPositions[i];
                int site = Arrays.binarySearch(positions, this.allPositions[i][j]);
                if (site < 0) {
                    System.out.println("Error Position not found:" + this.allPositions[i][j]);
                    ++posMisMatch;
                    continue;
                }
                ++posMatch;
                rmip[site] = this.allResults[i][j];
                System.out.printf("Hit Chr:%d Trait:%s Position:%d site:%d rmip:%f %n ", currChr, this.allTraits[i], this.allPositions[i][j], site, Float.valueOf(this.allResults[i][j]));
            }
            System.out.printf("Position matches:%d errors:%d %n", posMatch, posMisMatch);
            String dataSetName = chrGroup + "GWAS" + "/" + this.allTraits[i];
            writer.float32().createArray(dataSetName, rmip.length);
            writer.writeFloatArray(dataSetName, rmip);
        }
    }

    private void loadGWAS(File gwasFileIn, String outputFile, int currChr) {
        IHDF5Writer writer = HDF5Factory.open((String)outputFile);
        String[] traits = this.getGWASTraits(gwasFileIn, this.traitIndex, "\t");
        String chrGroup = "chr" + currChr + "/";
        int[] positions = writer.readIntArray(chrGroup + "Positions");
        for (int j = 0; j < traits.length; ++j) {
            System.out.println(gwasFileIn.toString());
            int posMatch = 0;
            int posMisMatch = 0;
            float[] rmip = new float[positions.length];
            Arrays.fill(rmip, Float.NaN);
            try {
                String s;
                BufferedReader fileIn = Utils.getBufferedReader(gwasFileIn, 1000000);
                while ((s = fileIn.readLine()) != null) {
                    String[] fields = s.split("\t");
                    try {
                        int theChr = Integer.parseInt(fields[this.chrIndex]);
                        int position = Integer.parseInt(fields[this.physPosIndex]);
                        float rmipValue = Float.parseFloat(fields[this.resultIndex]);
                        if (theChr != 9 || position > 7600000) continue;
                        int site = Arrays.binarySearch(positions, position);
                        if (site < 0) {
                            System.out.println("Error Position not found:" + position);
                            ++posMisMatch;
                            continue;
                        }
                        ++posMatch;
                        rmip[site] = rmipValue;
                        System.out.printf("Hit Chr:%d Trait:%s Position:%d site:%d rmip:%d %n ", theChr, traits[j], position, site, Float.valueOf(rmipValue));
                    }
                    catch (Exception exception) {}
                }
            }
            catch (IOException e) {
                System.out.println("IOError");
                e.printStackTrace();
            }
            System.out.printf("Position matches:%d errors:%d %n", posMatch, posMisMatch);
            String dataSetName = chrGroup + "GWAS" + "/" + traits[j];
            writer.float32().createArray(dataSetName, rmip.length);
            writer.writeFloatArray(dataSetName, rmip);
        }
    }

    private String[] getGWASTraits(File gwasResults, int traitIndex, String delimiter) {
        BufferedReader br = Utils.getBufferedReader(gwasResults, 1000000);
        String line = null;
        HashSet<String> aSet = new HashSet<String>();
        try {
            while ((line = br.readLine()) != null) {
                String[] fields = line.split(delimiter);
                aSet.add(fields[traitIndex]);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        String[] result = new String[aSet.size()];
        aSet.toArray(result);
        return result;
    }

    private void loadDataByChromosome(File gwasFileIn, int currChr, String delimiter) {
        BufferedReader br = Utils.getBufferedReader(gwasFileIn, 1000000);
        String line = null;
        HashMap<String, List> traitPosition = new HashMap<String, List>();
        HashMap traitResult = new HashMap();
        block4: while (true) {
            try {
                while ((line = br.readLine()) != null) {
                    String[] fields = line.split(delimiter);
                    try {
                        int chromosome = Integer.parseInt(fields[this.chrIndex]);
                        if (currChr != chromosome) continue;
                        String aTrait = fields[this.traitIndex].trim();
                        if (traitPosition.containsKey(aTrait)) {
                            ((List)traitPosition.get(aTrait)).add(fields[this.physPosIndex]);
                            List l = (List)traitResult.get(aTrait);
                            l.add(fields[this.resultIndex]);
                            traitPosition.put(aTrait, l);
                            continue block4;
                        }
                        ArrayList<String> position = new ArrayList<String>();
                        position.add(fields[this.physPosIndex]);
                        ArrayList o = traitPosition.put(aTrait, position);
                        System.out.printf("%s %s %d %n", o, aTrait, position);
                        ArrayList<String> result = new ArrayList<String>();
                        result.add(fields[this.resultIndex]);
                        traitResult.put(fields[this.traitIndex], result);
                        continue block4;
                    }
                    catch (Exception e) {
                        System.out.println("Header");
                    }
                }
                break;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                break;
            }
        }
        this.allTraits = new String[traitPosition.size()];
        traitPosition.keySet().toArray(this.allTraits);
        int traitCount = this.allTraits.length;
        this.allPositions = new int[traitCount][];
        this.allResults = new float[traitCount][];
        for (int i = 0; i < traitCount; ++i) {
            List posList = (List)traitPosition.get(this.allTraits[i]);
            int posCount = posList.size();
            this.allPositions[i] = new int[posCount];
            Iterator posIt = posList.iterator();
            int count = 0;
            while (posIt.hasNext()) {
                this.allPositions[i][count++] = Integer.parseInt((String)posIt.next());
            }
            List resList = (List)traitResult.get(this.allTraits[i]);
            int resCount = resList.size();
            this.allResults[i] = new float[resCount];
            Iterator resIt = resList.iterator();
            count = 0;
            while (resIt.hasNext()) {
                this.allResults[i][count++] = Float.parseFloat((String)resIt.next());
            }
        }
        System.out.println("Breakpoint");
    }

    private void loadAnnotations() {
    }

    private void loadAnnotationsByFile(File annoFile, String delimiter) {
        boolean snpIdIndex = false;
        int locationIndex = 1;
        String locationDelimiter = ":";
        int featureIndex = 6;
        HashMap featurePosition = new HashMap();
        BufferedReader br = Utils.getBufferedReader(annoFile, 1000000);
        String line = null;
        block4: while (true) {
            try {
                while ((line = br.readLine()) != null) {
                    String[] fields = line.split(delimiter);
                    try {
                        List<Integer> l;
                        String aLoc = fields[locationIndex];
                        int aPosition = this.getPosition(aLoc, locationDelimiter);
                        String feature = fields[featureIndex].trim();
                        if (featurePosition.containsKey(feature)) {
                            l = (List)featurePosition.get(feature);
                            l.add(aPosition);
                            featurePosition.put(feature, l);
                            continue block4;
                        }
                        l = new ArrayList();
                        l.add(aPosition);
                        featurePosition.put(feature, l);
                        continue block4;
                    }
                    catch (Exception e) {
                        System.out.println("Header");
                    }
                }
                break;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                break;
            }
        }
        int featureCount = featurePosition.size();
        this.featurePositions = new int[featureCount][];
        this.allFeatures = new String[featureCount];
        featurePosition.keySet().toArray(this.allFeatures);
        for (int i = 0; i < featureCount; ++i) {
            List posList = (List)featurePosition.get(this.allFeatures[i]);
            int posCount = posList.size();
            this.featurePositions[i] = new int[posCount];
            Iterator iterator = posList.iterator();
            for (int j = 0; j < posCount; ++j) {
                this.featurePositions[i][j] = (Integer)iterator.next();
            }
        }
    }

    private int getPosition(String location, String delimiter) {
        String[] fields = location.split(delimiter);
        int position = Integer.parseInt(fields[1]);
        return position;
    }

    public static void main(String[] args) {
        String hapMapPath = "/Volumes/LaCie/HapMapV2/compressed/";
        String pathGwas = "/Volumes/LaCie/PolymorphismDescriptors/gwas_hits_all.txt";
        String PDfile = "/Volumes/LaCie/PolymorphismDescriptors/XtestPD.h5";
        String annoPath = "/Volumes/LaCie/PolymorphismDescriptors/maizeHapMapV2_B73RefGenV2_201203028_chr9h.WorstPerSnp.vcf";
        PDAnnotation p = new PDAnnotation(hapMapPath, pathGwas, annoPath, PDfile, 9, 9);
    }
}

