/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ForkJoinPool;
import net.maizegenetics.dna.snp.MaskMatrix;
import net.maizegenetics.util.BitSet;

public abstract class AbstractMaskMatrix
implements MaskMatrix {
    private static final int NUM_SITES_PER_BLOCK = 10;
    protected final int myNumTaxa;
    protected final int myNumSites;
    private final Cache<Integer, BitSet> myCache;
    private final Cache<Integer, BitSet> mySmallCache;
    private final ForkJoinPool myThreadPool = ForkJoinPool.commonPool();

    AbstractMaskMatrix(int numTaxa, int numSites) {
        this.myNumTaxa = numTaxa;
        this.myNumSites = numSites;
        this.myCache = CacheBuilder.newBuilder().initialCapacity(1000).maximumSize(1000L).build();
        this.mySmallCache = CacheBuilder.newBuilder().initialCapacity(100).maximumSize(100L).build();
    }

    protected abstract BitSet siteMask(int var1);

    protected abstract BitSet taxonMask(int var1);

    protected abstract boolean isMasked(int var1, int var2);

    private BitSet getFromCache(int site) {
        BitSet result = (BitSet)this.myCache.getIfPresent((Object)site);
        if (result != null) {
            this.myThreadPool.submit(new ProcessSite(this.siteBlockKey(site + 10)));
            return result;
        }
        this.myThreadPool.submit(new ProcessSite(this.siteBlockKey(site)));
        this.myThreadPool.submit(new ProcessSite(this.siteBlockKey(site + 10)));
        result = this.siteMask(site);
        this.myCache.put((Object)site, (Object)result);
        return result;
    }

    private int siteBlockKey(int site) {
        return site / 10 * 10;
    }

    @Override
    public boolean get(int taxon, int site) {
        BitSet temp = (BitSet)this.mySmallCache.getIfPresent((Object)site);
        if (temp == null) {
            temp = this.getFromCache(site);
            this.mySmallCache.put((Object)site, (Object)temp);
        }
        return temp.fastGet(taxon);
    }

    @Override
    public boolean isTaxonMaskedHint(int taxon) {
        return true;
    }

    @Override
    public BitSet maskForTaxon(int taxon) {
        return this.taxonMask(taxon);
    }

    @Override
    public boolean isSiteMaskedHint(int site) {
        return this.getFromCache(site).cardinality() != 0L;
    }

    @Override
    public BitSet maskForSite(int site) {
        return this.siteMask(site);
    }

    @Override
    public int numTaxa() {
        return this.myNumTaxa;
    }

    @Override
    public int numSites() {
        return this.myNumSites;
    }

    @Override
    public boolean isSiteOptimized() {
        return true;
    }

    private class ProcessSite
    implements Runnable {
        private final int mySite;

        public ProcessSite(int site) {
            this.mySite = site;
        }

        @Override
        public void run() {
            int end = Math.min(this.mySite + 10, AbstractMaskMatrix.this.myNumSites);
            for (int s = this.mySite; s < end; ++s) {
                if (AbstractMaskMatrix.this.myCache.getIfPresent((Object)s) != null) {
                    return;
                }
                AbstractMaskMatrix.this.myCache.put((Object)s, (Object)AbstractMaskMatrix.this.siteMask(s));
            }
        }
    }
}

