/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.maizegenetics.dna.snp.Filter;
import net.maizegenetics.taxa.TaxaList;

public final class FilterTaxa
implements Filter {
    private final Map<FILTER_TAXA_ATTRIBUTES, Object> myAttributes = new LinkedHashMap<FILTER_TAXA_ATTRIBUTES, Object>();

    public FilterTaxa(Map<String, Object> values) {
        for (Map.Entry<String, Object> current : values.entrySet()) {
            if (current.getValue() == null || current.getValue() instanceof String && ((String)current.getValue()).isEmpty()) continue;
            FILTER_TAXA_ATTRIBUTES attribute = FILTER_TAXA_ATTRIBUTES.valueOf(current.getKey());
            this.myAttributes.put(attribute, current.getValue());
        }
        if (this.filterName() == null || this.filterName().length() == 0) {
            this.myAttributes.put(FILTER_TAXA_ATTRIBUTES.filterName, "Filter");
        }
    }

    public Map<FILTER_TAXA_ATTRIBUTES, Object> attributes() {
        return Collections.unmodifiableMap(this.myAttributes);
    }

    @Override
    public int numAttributes() {
        return this.myAttributes.size();
    }

    public String filterName() {
        return (String)this.myAttributes.get((Object)FILTER_TAXA_ATTRIBUTES.filterName);
    }

    public double minNotMissing() {
        Double value = (Double)this.myAttributes.get((Object)FILTER_TAXA_ATTRIBUTES.minNotMissing);
        if (value == null) {
            return 0.0;
        }
        return value;
    }

    public double minHeterozygous() {
        Double value = (Double)this.myAttributes.get((Object)FILTER_TAXA_ATTRIBUTES.minHeterozygous);
        if (value == null) {
            return 0.0;
        }
        return value;
    }

    public double maxHeterozygous() {
        Double value = (Double)this.myAttributes.get((Object)FILTER_TAXA_ATTRIBUTES.maxHeterozygous);
        if (value == null) {
            return 1.0;
        }
        return value;
    }

    public boolean includeTaxa() {
        Boolean value = (Boolean)this.myAttributes.get((Object)FILTER_TAXA_ATTRIBUTES.includeTaxa);
        if (value == null) {
            return true;
        }
        return value;
    }

    public TaxaList taxaList() {
        return (TaxaList)this.myAttributes.get((Object)FILTER_TAXA_ATTRIBUTES.taxaList);
    }

    public static enum FILTER_TAXA_ATTRIBUTES {
        filterName,
        minNotMissing,
        minHeterozygous,
        maxHeterozygous,
        includeTaxa,
        taxaList;

    }
}

