/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import java.util.function.Predicate;
import net.maizegenetics.dna.snp.AbstractMaskMatrix;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;

public class MaskGenotypeMatrix
extends AbstractMaskMatrix {
    private final GenotypeCallTable myGenotype;
    private final Predicate<Byte> myPredicate;

    MaskGenotypeMatrix(GenotypeCallTable genotype, Predicate<Byte> predicate) {
        super(genotype.numberOfTaxa(), genotype.numberOfSites());
        this.myGenotype = genotype;
        this.myPredicate = predicate;
    }

    @Override
    protected BitSet siteMask(int site) {
        OpenBitSet result = new OpenBitSet(this.myNumTaxa);
        byte[] temp = this.myGenotype.genotypeForAllTaxa(site);
        for (int t = 0; t < this.myNumTaxa; ++t) {
            if (!this.myPredicate.test(temp[t])) continue;
            result.fastSet(t);
        }
        return result;
    }

    @Override
    protected BitSet taxonMask(int taxon) {
        OpenBitSet result = new OpenBitSet(this.myNumSites);
        byte[] temp = this.myGenotype.genotypeForAllSites(taxon);
        for (int t = 0; t < this.myNumTaxa; ++t) {
            if (!this.myPredicate.test(temp[t])) continue;
            result.fastSet(t);
        }
        return result;
    }

    @Override
    protected boolean isMasked(int taxon, int site) {
        return this.myPredicate.test(this.myGenotype.genotype(taxon, site));
    }
}

