/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import java.util.Random;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.maizegenetics.dna.snp.MaskGenotypeMatrix;
import net.maizegenetics.dna.snp.MaskGenotypeStatsMatrix;
import net.maizegenetics.dna.snp.MaskMatrix;
import net.maizegenetics.dna.snp.MaskSiteMatrix;
import net.maizegenetics.dna.snp.MaskTaxaMatrix;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.Stats;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;

public class MaskMatrixBuilder {
    private BitSet[] myBitSets;
    private final boolean myIsSiteOptimized;
    private final int myNumTaxa;
    private final int myNumSites;
    private int myNextSite = 0;
    private int myNextTaxon = 0;
    private long myNextCount = 0L;

    private MaskMatrixBuilder(int numTaxa, int numSites, boolean isSiteOptimized) {
        this.myNumTaxa = numTaxa;
        this.myNumSites = numSites;
        this.myIsSiteOptimized = isSiteOptimized;
        if (this.myIsSiteOptimized) {
            this.myBitSets = new BitSet[this.myNumSites];
            for (int s = 0; s < this.myNumSites; ++s) {
                this.myBitSets[s] = new OpenBitSet(this.myNumTaxa);
            }
        } else {
            this.myBitSets = new BitSet[this.myNumTaxa];
            for (int t = 0; t < this.myNumTaxa; ++t) {
                this.myBitSets[t] = new OpenBitSet(this.myNumSites);
            }
        }
    }

    public static MaskMatrixBuilder getInstance(int numTaxa, int numSites, boolean isSiteOptimized) {
        return new MaskMatrixBuilder(numTaxa, numSites, isSiteOptimized);
    }

    public static MaskMatrixBuilder getInstance(MaskMatrix orig) {
        if (orig == null) {
            throw new IllegalArgumentException("MaskMatrixBuilder: getInstance: must specific orig");
        }
        if (orig instanceof MaskSiteMatrix) {
            MaskSiteMatrix temp = (MaskSiteMatrix)orig;
            MaskMatrixBuilder result = new MaskMatrixBuilder(orig.numTaxa(), orig.numSites(), true);
            for (int s = 0; s < temp.numSites(); ++s) {
                result.myBitSets[s].or(temp.maskForSite(s));
            }
            return result;
        }
        if (orig instanceof MaskTaxaMatrix) {
            MaskTaxaMatrix temp = (MaskTaxaMatrix)orig;
            MaskMatrixBuilder result = new MaskMatrixBuilder(orig.numTaxa(), orig.numSites(), false);
            for (int t = 0; t < temp.numTaxa(); ++t) {
                result.myBitSets[t].or(temp.maskForTaxon(t));
            }
            return result;
        }
        throw new IllegalArgumentException("MaskMatrixBuilder: getInstance: don't know type: " + orig.getClass().getName());
    }

    public static MaskMatrix getInstanceRemoveMinorSNPs(GenotypeCallTable genotype) {
        return MaskMatrixBuilder.getInstance(genotype, (Byte t, Stats u) -> {
            byte major = u.majorAllele();
            byte minor = u.minorAllele();
            if ((t & 0xF) != major && (t & 0xF) != minor) {
                return true;
            }
            return t >>> 4 != major && t >>> 4 != minor;
        });
    }

    public static MaskMatrix getInstanceRemoveHeterozygous(GenotypeCallTable genotype) {
        return MaskMatrixBuilder.getInstance(genotype, (Byte t) -> (t & 0xF) != t >>> 4);
    }

    public static MaskMatrix getInstanceRemoveHomozygous(GenotypeCallTable genotype) {
        return MaskMatrixBuilder.getInstance(genotype, (Byte t) -> (t & 0xF) == t >>> 4);
    }

    public static MaskMatrix getInstanceRemoveIndels(GenotypeCallTable genotype) {
        return MaskMatrixBuilder.getInstance(genotype, (Byte t) -> t == 85 || t == 68);
    }

    public static MaskMatrix getInstance(GenotypeCallTable genotype, Predicate<Byte> predicate) {
        return new MaskGenotypeMatrix(genotype, predicate);
    }

    public static MaskMatrix getInstance(GenotypeCallTable genotype, BiPredicate<Byte, Stats> predicate) {
        return new MaskGenotypeStatsMatrix(genotype, predicate);
    }

    public boolean get(int taxon, int site) {
        if (this.myIsSiteOptimized) {
            return this.myBitSets[site].fastGet(taxon);
        }
        return this.myBitSets[taxon].fastGet(site);
    }

    public void set(int taxon, int site) {
        if (this.myIsSiteOptimized) {
            this.myBitSets[site].fastSet(taxon);
        } else {
            this.myBitSets[taxon].fastSet(site);
        }
    }

    public void setNext(boolean value) {
        if (this.myIsSiteOptimized) {
            if (value) {
                this.myBitSets[this.myNextTaxon].fastSet(this.myNextSite);
            }
            ++this.myNextCount;
            this.myNextTaxon = (int)(this.myNextCount % (long)this.myNumTaxa);
            this.myNextSite = (int)(this.myNextCount / (long)this.myNumTaxa);
        } else {
            if (value) {
                this.myBitSets[this.myNextTaxon].fastSet(this.myNextSite);
            }
            ++this.myNextCount;
            this.myNextTaxon = (int)(this.myNextCount / (long)this.myNumSites);
            this.myNextSite = (int)(this.myNextCount % (long)this.myNumSites);
        }
    }

    public long reduceMaskTo(double percent) {
        if (this.myIsSiteOptimized) {
            return this.siteReduceMaskTo(percent);
        }
        return this.taxaReduceMaskTo(percent);
    }

    private long taxaReduceMaskTo(double percent) {
        Random random = new Random();
        double remainder = 0.0;
        long totalNumMasked = 0L;
        for (BitSet current : this.myBitSets) {
            int site;
            int numOfMasksToKeep;
            long numMasksThisTaxon = current.cardinality();
            double percentOfMasksToKeep = (double)numMasksThisTaxon * percent;
            if ((remainder += percentOfMasksToKeep - (double)(numOfMasksToKeep = (int)Math.floor(percentOfMasksToKeep))) > 1.0) {
                ++numOfMasksToKeep;
                remainder -= 1.0;
            }
            if (numOfMasksToKeep == 0) continue;
            OpenBitSet copy = new OpenBitSet(current);
            int numCleared = 0;
            while (!copy.getAndClear(site = random.nextInt(this.myNumSites)) || ++numCleared < numOfMasksToKeep) {
            }
            current.xor(copy);
            totalNumMasked += (long)numOfMasksToKeep;
        }
        return totalNumMasked;
    }

    private long siteReduceMaskTo(double percent) {
        Random random = new Random();
        double remainder = 0.0;
        long totalNumMasked = 0L;
        for (BitSet current : this.myBitSets) {
            int taxon;
            int numOfMasksToKeep;
            long numMasksThisSite = current.cardinality();
            double percentOfMasksToKeep = (double)numMasksThisSite * percent;
            if ((remainder += percentOfMasksToKeep - (double)(numOfMasksToKeep = (int)Math.floor(percentOfMasksToKeep))) > 1.0) {
                ++numOfMasksToKeep;
                remainder -= 1.0;
            }
            if (numOfMasksToKeep == 0) continue;
            OpenBitSet copy = new OpenBitSet(current);
            int numCleared = 0;
            while (!copy.getAndClear(taxon = random.nextInt(this.myNumTaxa)) || ++numCleared < numOfMasksToKeep) {
            }
            current.xor(copy);
            totalNumMasked += (long)numOfMasksToKeep;
        }
        return totalNumMasked;
    }

    public MaskMatrix build() {
        BitSet[] temp = this.myBitSets;
        this.myBitSets = null;
        if (this.myIsSiteOptimized) {
            return new MaskSiteMatrix(temp, this.myNumTaxa, this.myNumSites);
        }
        return new MaskTaxaMatrix(temp, this.myNumTaxa, this.myNumSites);
    }
}

