/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import net.maizegenetics.dna.snp.MaskMatrix;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;
import net.maizegenetics.util.UnmodifiableBitSet;

public class MaskSiteMatrix
implements MaskMatrix {
    private final BitSet[] myBitSets;
    private final int myNumTaxa;
    private final int myNumSites;

    MaskSiteMatrix(BitSet[] bitSets, int numTaxa, int numSites) {
        this.myBitSets = bitSets;
        this.myNumTaxa = numTaxa;
        this.myNumSites = numSites;
    }

    @Override
    public boolean get(int taxon, int site) {
        return this.myBitSets[site].fastGet(taxon);
    }

    @Override
    public boolean isTaxonMaskedHint(int taxon) {
        for (int s = 0; s < this.myNumSites; ++s) {
            if (!this.myBitSets[s].fastGet(taxon)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BitSet maskForTaxon(int taxon) {
        OpenBitSet result = new OpenBitSet(this.myNumSites);
        for (int s = 0; s < this.myNumSites; ++s) {
            if (!this.myBitSets[s].fastGet(taxon)) continue;
            result.fastSet(s);
        }
        return result;
    }

    @Override
    public boolean isSiteMaskedHint(int site) {
        return this.myBitSets[site].cardinality() != 0L;
    }

    @Override
    public BitSet maskForSite(int site) {
        return UnmodifiableBitSet.getInstance(this.myBitSets[site]);
    }

    @Override
    public int numTaxa() {
        return this.myNumTaxa;
    }

    @Override
    public int numSites() {
        return this.myNumSites;
    }

    @Override
    public boolean isSiteOptimized() {
        return true;
    }
}

