/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import net.maizegenetics.dna.snp.MaskMatrix;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;
import net.maizegenetics.util.UnmodifiableBitSet;

public class MaskTaxaMatrix
implements MaskMatrix {
    private final BitSet[] myBitSets;
    private final int myNumTaxa;
    private final int myNumSites;

    MaskTaxaMatrix(BitSet[] bitSets, int numTaxa, int numSites) {
        this.myBitSets = bitSets;
        this.myNumTaxa = numTaxa;
        this.myNumSites = numSites;
    }

    @Override
    public boolean get(int taxon, int site) {
        return this.myBitSets[taxon].fastGet(site);
    }

    @Override
    public boolean isTaxonMaskedHint(int taxon) {
        return this.myBitSets[taxon].cardinality() != 0L;
    }

    @Override
    public BitSet maskForTaxon(int taxon) {
        return UnmodifiableBitSet.getInstance(this.myBitSets[taxon]);
    }

    @Override
    public boolean isSiteMaskedHint(int site) {
        for (int t = 0; t < this.myNumTaxa; ++t) {
            if (!this.myBitSets[t].fastGet(site)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BitSet maskForSite(int site) {
        OpenBitSet result = new OpenBitSet(this.myNumTaxa);
        for (int t = 0; t < this.myNumTaxa; ++t) {
            if (!this.myBitSets[t].fastGet(site)) continue;
            result.fastSet(t);
        }
        return result;
    }

    @Override
    public int numTaxa() {
        return this.myNumTaxa;
    }

    @Override
    public int numSites() {
        return this.myNumSites;
    }

    @Override
    public boolean isSiteOptimized() {
        return false;
    }
}

