/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.genotypecall;

import java.util.List;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.genotypecall.AbstractGenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;

public class DifferenceGenotypeCallTable
extends AbstractGenotypeCallTable {
    private final GenotypeCallTable myBase;
    private final int[] myHybrids;
    private final int[] myParents;

    public DifferenceGenotypeCallTable(GenotypeCallTable base, List<Integer> hybrids, List<Integer> parents) {
        super(hybrids.size(), base.numberOfSites(), base.isPhased(), base.alleleDefinitions());
        int numParents = parents.size();
        if (numParents != hybrids.size()) {
            throw new IllegalArgumentException("DifferenceGenotypeCallTable: init: number of parents and hybrids must be the same");
        }
        this.myHybrids = hybrids.stream().mapToInt(Integer::intValue).toArray();
        this.myParents = parents.stream().mapToInt(Integer::intValue).toArray();
        this.myBase = base;
    }

    @Override
    public byte genotype(int taxon, int site) {
        byte hybrid = this.myBase.genotype(this.myHybrids[taxon], site);
        byte parent = this.myBase.genotype(this.myParents[taxon], site);
        if (GenotypeTableUtils.isHomozygous(hybrid)) {
            if (hybrid == parent) {
                return hybrid;
            }
            return -1;
        }
        if (GenotypeTableUtils.isHomozygous(parent)) {
            byte[] hybridAlleles = GenotypeTableUtils.getDiploidValues(hybrid);
            byte parentAllele = GenotypeTableUtils.getDiploidValues(parent)[0];
            if (parentAllele == hybridAlleles[0]) {
                return GenotypeTableUtils.getDiploidValue(hybridAlleles[1], hybridAlleles[1]);
            }
            return GenotypeTableUtils.getDiploidValue(hybridAlleles[0], hybridAlleles[0]);
        }
        return -1;
    }

    @Override
    public String genotypeAsString(int taxon, int site) {
        return this.myBase.diploidAsString(site, this.genotype(taxon, site));
    }

    @Override
    public String genotypeAsStringRange(int taxon, int startSite, int endSite) {
        return this.myBase.genotypeAsStringRange(taxon, startSite, endSite);
    }

    @Override
    public String diploidAsString(int site, byte value) {
        return this.myBase.diploidAsString(site, value);
    }

    @Override
    public void transposeData(boolean siteInnerLoop) {
        this.myBase.transposeData(siteInnerLoop);
    }

    @Override
    public boolean isSiteOptimized() {
        return this.myBase.isSiteOptimized();
    }
}

