/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.genotypecall;

import java.util.Arrays;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.maizegenetics.dna.snp.Translate;
import net.maizegenetics.dna.snp.genotypecall.AbstractGenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;

class FilterGenotypeCallTable
extends AbstractGenotypeCallTable {
    final GenotypeCallTable myBaseGenotype;
    final Translate myTranslate;

    FilterGenotypeCallTable(GenotypeCallTable genotype, Translate translate) {
        super(translate.numTaxa(), translate.numSites(), genotype.isPhased(), null, genotype.maxNumAlleles());
        this.myBaseGenotype = genotype;
        this.myTranslate = translate;
    }

    @Override
    public byte genotype(int taxon, int site) {
        long taxonSite = this.myTranslate.taxonSite(taxon, site);
        if (taxonSite == -1L) {
            return -1;
        }
        return this.myBaseGenotype.genotype((int)(taxonSite >>> 32), (int)(taxonSite & 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public String genotypeAsString(int taxon, int site) {
        long taxonSite = this.myTranslate.taxonSite(taxon, site);
        if (taxonSite == -1L) {
            return "N";
        }
        return this.myBaseGenotype.genotypeAsString((int)(taxonSite >>> 32), (int)(taxonSite & 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public String diploidAsString(int site, byte value) {
        return this.myBaseGenotype.diploidAsString(site, value);
    }

    @Override
    public byte[] genotypeForAllTaxa(int site) {
        if (this.myTranslate.site(site) == -1) {
            byte[] result = new byte[this.numberOfTaxa()];
            Arrays.fill(result, (byte)-1);
            return result;
        }
        if (!this.myTranslate.hasTaxaTranslations()) {
            return this.myBaseGenotype.genotypeForAllTaxa(this.myTranslate.site(site));
        }
        byte[] orig = this.myBaseGenotype.genotypeForAllTaxa(this.myTranslate.site(site));
        int[] translations = this.myTranslate.taxaTranslations();
        int numTaxa = this.myTranslate.numTaxa();
        byte[] result = new byte[numTaxa];
        for (int i = 0; i < numTaxa; ++i) {
            result[i] = translations[i] == -1 ? -1 : orig[translations[i]];
        }
        return result;
    }

    @Override
    public byte[] genotypeForAllSites(int taxon) {
        if (this.myTranslate.taxon(taxon) == -1) {
            byte[] result = new byte[this.numberOfSites()];
            Arrays.fill(result, (byte)-1);
            return result;
        }
        if (!this.myTranslate.hasSiteTranslations()) {
            return this.myBaseGenotype.genotypeForAllSites(this.myTranslate.taxon(taxon));
        }
        return super.genotypeForAllSites(taxon);
    }

    @Override
    public int[][] allelesSortedByFrequency(int site) {
        if (this.myTranslate.site(site) == -1) {
            return new int[0][0];
        }
        if (!this.myTranslate.hasTaxaTranslations()) {
            return this.myBaseGenotype.allelesSortedByFrequency(this.myTranslate.site(site));
        }
        return super.allelesSortedByFrequency(site);
    }

    @Override
    public void transposeData(boolean siteInnerLoop) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isSiteOptimized() {
        return this.myBaseGenotype.isSiteOptimized();
    }

    @Override
    public String[][] alleleDefinitions() {
        String[][] encodings = this.myBaseGenotype.alleleDefinitions();
        if (encodings.length == 1) {
            return encodings;
        }
        if (this.myTranslate.hasSiteTranslations()) {
            int numSites = this.numberOfSites();
            String[][] result = new String[numSites][];
            for (int i = 0; i < numSites; ++i) {
                result[i] = this.alleleDefinitions(i);
            }
            return result;
        }
        return encodings;
    }

    @Override
    public String[] alleleDefinitions(int site) {
        return this.myBaseGenotype.alleleDefinitions(this.myTranslate.site(site));
    }

    @Override
    public int maxNumAlleles() {
        return this.myBaseGenotype.maxNumAlleles();
    }

    @Override
    public Stream<Byte> stream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    @Override
    public Stream<Byte> stream(int taxon) {
        return StreamSupport.stream(new FilterGenotypeCallTableSpliterator(taxon, 0, this.numberOfSites(), taxon, this.numberOfSites()), true);
    }

    @Override
    public Spliterator<Byte> spliterator() {
        return new FilterGenotypeCallTableSpliterator(0, 0, this.numberOfSites(), this.numberOfTaxa() - 1, this.numberOfSites());
    }

    class FilterGenotypeCallTableSpliterator<T extends Byte>
    implements Spliterator<Byte> {
        protected int myTaxaOrigin;
        protected int mySiteOrigin;
        protected final int myNumSites;
        protected final int myTaxaFence;
        protected final int mySiteFence;

        FilterGenotypeCallTableSpliterator(int taxaOrigin, int siteOrigin, int numSites, int taxaFence, int siteFence) {
            this.myTaxaOrigin = taxaOrigin;
            this.mySiteOrigin = siteOrigin;
            this.myNumSites = numSites;
            this.myTaxaFence = taxaFence;
            this.mySiteFence = siteFence;
        }

        @Override
        public void forEachRemaining(Consumer<? super Byte> action) {
            if (FilterGenotypeCallTable.this.myTranslate.hasSiteTranslations()) {
                int taxaIndex;
                while (this.myTaxaOrigin < this.myTaxaFence) {
                    taxaIndex = FilterGenotypeCallTable.this.myTranslate.taxon(this.myTaxaOrigin);
                    if (taxaIndex == -1) {
                        while (this.mySiteOrigin < this.myNumSites) {
                            action.accept((Byte)((byte)-1));
                            ++this.mySiteOrigin;
                        }
                    } else {
                        while (this.mySiteOrigin < this.myNumSites) {
                            action.accept((Byte)FilterGenotypeCallTable.this.myBaseGenotype.genotype(taxaIndex, FilterGenotypeCallTable.this.myTranslate.site(this.mySiteOrigin)));
                            ++this.mySiteOrigin;
                        }
                    }
                    this.mySiteOrigin = 0;
                    ++this.myTaxaOrigin;
                }
                taxaIndex = FilterGenotypeCallTable.this.myTranslate.taxon(this.myTaxaOrigin);
                if (taxaIndex == -1) {
                    while (this.mySiteOrigin < this.mySiteFence) {
                        action.accept((Byte)((byte)-1));
                        ++this.mySiteOrigin;
                    }
                } else {
                    while (this.mySiteOrigin < this.mySiteFence) {
                        action.accept((Byte)FilterGenotypeCallTable.this.myBaseGenotype.genotype(taxaIndex, FilterGenotypeCallTable.this.myTranslate.site(this.mySiteOrigin)));
                        ++this.mySiteOrigin;
                    }
                }
            } else {
                int taxaIndex;
                while (this.myTaxaOrigin < this.myTaxaFence) {
                    taxaIndex = FilterGenotypeCallTable.this.myTranslate.taxon(this.myTaxaOrigin);
                    if (taxaIndex == -1) {
                        while (this.mySiteOrigin < this.myNumSites) {
                            action.accept((Byte)((byte)-1));
                            ++this.mySiteOrigin;
                        }
                    } else {
                        while (this.mySiteOrigin < this.myNumSites) {
                            action.accept((Byte)FilterGenotypeCallTable.this.myBaseGenotype.genotype(taxaIndex, this.mySiteOrigin));
                            ++this.mySiteOrigin;
                        }
                    }
                    this.mySiteOrigin = 0;
                    ++this.myTaxaOrigin;
                }
                taxaIndex = FilterGenotypeCallTable.this.myTranslate.taxon(this.myTaxaOrigin);
                if (taxaIndex == -1) {
                    while (this.mySiteOrigin < this.mySiteFence) {
                        action.accept((Byte)((byte)-1));
                        ++this.mySiteOrigin;
                    }
                } else {
                    while (this.mySiteOrigin < this.mySiteFence) {
                        action.accept((Byte)FilterGenotypeCallTable.this.myBaseGenotype.genotype(taxaIndex, this.mySiteOrigin));
                        ++this.mySiteOrigin;
                    }
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super Byte> action) {
            if (this.myTaxaOrigin < this.myTaxaFence && this.mySiteOrigin < this.myNumSites || this.myTaxaOrigin == this.myTaxaFence && this.mySiteOrigin < this.mySiteFence) {
                action.accept((Byte)FilterGenotypeCallTable.this.genotype(this.myTaxaOrigin, this.mySiteOrigin));
                ++this.mySiteOrigin;
                if (this.mySiteOrigin >= this.myNumSites) {
                    this.mySiteOrigin = 0;
                    ++this.myTaxaOrigin;
                }
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<Byte> trySplit() {
            long size = this.estimateSize();
            if (size > 1L) {
                int loTaxa = this.myTaxaOrigin;
                int loSite = this.mySiteOrigin;
                int midTaxa = this.myTaxaOrigin;
                int midSite = this.mySiteOrigin;
                midTaxa = (int)((long)midTaxa + (size >>>= 1) / (long)this.myNumSites);
                if ((midSite = (int)((long)midSite + size % (long)this.myNumSites)) > this.myNumSites) {
                    ++midTaxa;
                    midSite -= this.myNumSites;
                }
                this.myTaxaOrigin = midTaxa;
                this.mySiteOrigin = midSite;
                return new FilterGenotypeCallTableSpliterator<T>(loTaxa, loSite, this.myNumSites, midTaxa, midSite);
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return (long)(this.myTaxaFence - this.myTaxaOrigin) * (long)this.myNumSites - (long)this.mySiteOrigin + (long)this.mySiteFence;
        }

        @Override
        public int characteristics() {
            return 17488;
        }
    }
}

