/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.genotypecall;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.nio.ByteBuffer;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.snp.genotypecall.AbstractGenotypeCallTable;
import net.maizegenetics.util.Tuple;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.log4j.Logger;

public class GOBIIAvroGenotypeCallTable
extends AbstractGenotypeCallTable {
    private static final Logger myLogger = Logger.getLogger(GOBIIAvroGenotypeCallTable.class);
    private static final int NUM_LOOK_AHEAD_BLOCKS = 5;
    public static final int GENOTYPE_BLOCK_SIZE = 256;
    private final GenericRecord myRecord;
    private final WeakHashMap<Thread, Tuple<Long, byte[][]>> myLastSite = new WeakHashMap();
    private final Cache<Long, byte[][]> myGenoCache;
    private final ConcurrentHashMap<Long, CompletableFuture<byte[][]>> myFutureQueue = new ConcurrentHashMap();
    private final ForkJoinPool myThreadPool;
    public static int myNumCacheMisses = 0;
    public static int myNumBlocksRead = 0;
    public static long myTimeReading = 0L;
    public static int myNumProcesses = 0;

    private GOBIIAvroGenotypeCallTable(int numTaxa, int numSites, boolean phased, GenericRecord record) {
        super(numTaxa, numSites, phased, NucleotideAlignmentConstants.NUCLEOTIDE_ALLELES);
        long oneThirdMemory = Runtime.getRuntime().maxMemory() / 65536L;
        int maxCacheSize = (int)Math.min((long)(100 * Runtime.getRuntime().availableProcessors()), oneThirdMemory);
        this.myGenoCache = CacheBuilder.newBuilder().initialCapacity(maxCacheSize).maximumSize((long)maxCacheSize).build();
        this.myThreadPool = new ForkJoinPool();
        this.myRecord = record;
    }

    public static GOBIIAvroGenotypeCallTable getInstance(int numTaxa, int numSites, boolean phased, GenericRecord record) {
        return new GOBIIAvroGenotypeCallTable(numTaxa, numSites, phased, record);
    }

    public static long getCacheKey(int taxon, int site) {
        return ((long)(taxon / 256) << 32) + (long)(site / 256);
    }

    public static String getKey(int taxon, int site) {
        return "B" + String.valueOf(GOBIIAvroGenotypeCallTable.getCacheKey(taxon, site));
    }

    private byte[][] getFromCache(int taxon, int site) {
        long cacheKey = GOBIIAvroGenotypeCallTable.getCacheKey(taxon, site);
        byte[][] result = (byte[][])this.myGenoCache.getIfPresent((Object)cacheKey);
        if (result == null) {
            ++myNumCacheMisses;
            CompletableFuture future = new CompletableFuture();
            CompletableFuture temp = this.myFutureQueue.putIfAbsent(cacheKey, future);
            try {
                if (temp == null) {
                    this.myThreadPool.submit(new ReadBlocks(taxon, site));
                    return (byte[][])future.get();
                }
                return (byte[][])temp.get();
            }
            catch (Exception e) {
                myLogger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public byte genotype(int taxon, int site) {
        try {
            Tuple<Long, byte[][]> temp = this.myLastSite.get(Thread.currentThread());
            long key = GOBIIAvroGenotypeCallTable.getCacheKey(taxon, site);
            if (temp != null) {
                if ((Long)temp.x == key) {
                    return ((byte[][])temp.y)[site % 256][taxon % 256];
                }
                byte[][] result = this.getFromCache(taxon, site);
                this.myLastSite.put(Thread.currentThread(), new Tuple<Long, byte[][]>(key, result));
                return result[site % 256][taxon % 256];
            }
            byte[][] result = this.getFromCache(taxon, site);
            this.myLastSite.put(Thread.currentThread(), new Tuple<Long, byte[][]>(key, result));
            return result[site % 256][taxon % 256];
        }
        catch (Exception ex) {
            myLogger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new IllegalStateException("GOBIIGenotypeCallTable: genotype: Error getting genotype from cache: " + ex.getMessage());
        }
    }

    @Override
    public byte[] genotypeForAllTaxa(int site) {
        byte[] result = new byte[this.myTaxaCount];
        int count = 0;
        int siteOffset = site % 256;
        for (int t = 0; t < this.myTaxaCount; t += 256) {
            byte[][] temp = this.getFromCache(t, site);
            System.arraycopy(temp[siteOffset], 0, result, 256 * count, temp[siteOffset].length);
            ++count;
        }
        return result;
    }

    @Override
    public byte[] genotypeAllSites(int taxon) {
        byte[] result = new byte[this.mySiteCount];
        int count = 0;
        int taxaOffset = taxon % 256;
        for (int s = 0; s < this.mySiteCount; s += 256) {
            byte[][] temp = this.getFromCache(taxon, s);
            int n = temp.length;
            for (int s1 = 0; s1 < n; ++s1) {
                result[count++] = temp[s1][taxaOffset];
            }
        }
        return result;
    }

    @Override
    public String genotypeAsString(int taxon, int site) {
        return NucleotideAlignmentConstants.getNucleotideIUPAC(this.genotype(taxon, site));
    }

    @Override
    public String diploidAsString(int site, byte value) {
        return NucleotideAlignmentConstants.getNucleotideIUPAC(value);
    }

    @Override
    public void transposeData(boolean siteInnerLoop) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isSiteOptimized() {
        return true;
    }

    private class ReadBlocks
    implements Runnable {
        private final int myStartTaxa;
        private final int myStartSite;
        private long myProcessBlock;

        public ReadBlocks(int taxon, int site) {
            this.myProcessBlock = GOBIIAvroGenotypeCallTable.getCacheKey(taxon, site);
            this.myStartTaxa = taxon / 256 * 256;
            this.myStartSite = site / 256 * 256;
        }

        @Override
        public void run() {
            ++myNumProcesses;
            if (this.myStartTaxa >= GOBIIAvroGenotypeCallTable.this.myTaxaCount || this.myStartSite >= GOBIIAvroGenotypeCallTable.this.mySiteCount) {
                return;
            }
            try {
                byte[][] temp = (byte[][])GOBIIAvroGenotypeCallTable.this.myGenoCache.getIfPresent((Object)this.myProcessBlock);
                if (temp != null) {
                    CompletableFuture future = (CompletableFuture)GOBIIAvroGenotypeCallTable.this.myFutureQueue.get(this.myProcessBlock);
                    if (future != null) {
                        future.complete(temp);
                        GOBIIAvroGenotypeCallTable.this.myFutureQueue.remove(this.myProcessBlock, future);
                    }
                } else {
                    ++myNumBlocksRead;
                    GenericData.Array byteBufferArray = (GenericData.Array)GOBIIAvroGenotypeCallTable.this.myRecord.get(GOBIIAvroGenotypeCallTable.getKey(this.myStartTaxa, this.myStartSite));
                    if (byteBufferArray == null) {
                        throw new IllegalStateException("GOBIIAvroGenotypeCallTable: byte buffer array is null: " + GOBIIAvroGenotypeCallTable.getKey(this.myStartTaxa, this.myStartSite));
                    }
                    int numTaxa = byteBufferArray.size();
                    ByteBuffer current = (ByteBuffer)byteBufferArray.get(0);
                    current.rewind();
                    int numSites = current.remaining();
                    byte[][] result = new byte[numTaxa][numSites];
                    for (int t = 0; t < numTaxa; ++t) {
                        current = (ByteBuffer)byteBufferArray.get(t);
                        current.rewind();
                        for (int s = 0; s < numSites; ++s) {
                            result[t][s] = current.get();
                        }
                    }
                    GOBIIAvroGenotypeCallTable.this.myGenoCache.put((Object)this.myProcessBlock, (Object)result);
                    CompletableFuture future = (CompletableFuture)GOBIIAvroGenotypeCallTable.this.myFutureQueue.get(this.myProcessBlock);
                    if (future != null) {
                        future.complete(result);
                        GOBIIAvroGenotypeCallTable.this.myFutureQueue.remove(this.myProcessBlock, future);
                    }
                    GOBIIAvroGenotypeCallTable.this.myGenoCache.getIfPresent((Object)this.myProcessBlock);
                }
                int lookaheadTaxa = this.myStartTaxa;
                int lookaheadSite = this.myStartSite;
                for (int b = 0; b < 5; ++b) {
                    CompletableFuture future;
                    int s;
                    byte[][] result;
                    int numSites;
                    ByteBuffer current;
                    this.myProcessBlock = GOBIIAvroGenotypeCallTable.getCacheKey(lookaheadTaxa += 256, this.myStartSite);
                    if (lookaheadTaxa < GOBIIAvroGenotypeCallTable.this.myTaxaCount && GOBIIAvroGenotypeCallTable.this.myGenoCache.getIfPresent((Object)this.myProcessBlock) == null && GOBIIAvroGenotypeCallTable.this.myFutureQueue.putIfAbsent(this.myProcessBlock, new CompletableFuture()) == null) {
                        ++myNumBlocksRead;
                        GenericData.Array byteBufferArray = (GenericData.Array)GOBIIAvroGenotypeCallTable.this.myRecord.get(GOBIIAvroGenotypeCallTable.getKey(lookaheadTaxa, this.myStartSite));
                        if (byteBufferArray == null) {
                            throw new IllegalStateException("GOBIIAvroGenotypeCallTable: byte buffer array is null: " + GOBIIAvroGenotypeCallTable.getKey(lookaheadTaxa, this.myStartSite));
                        }
                        int numTaxa = byteBufferArray.size();
                        current = (ByteBuffer)byteBufferArray.get(0);
                        current.rewind();
                        numSites = current.remaining();
                        result = new byte[numTaxa][numSites];
                        for (int t = 0; t < numTaxa; ++t) {
                            current = (ByteBuffer)byteBufferArray.get(t);
                            current.rewind();
                            for (s = 0; s < numSites; ++s) {
                                result[t][s] = current.get();
                            }
                        }
                        GOBIIAvroGenotypeCallTable.this.myGenoCache.put((Object)this.myProcessBlock, (Object)result);
                        future = (CompletableFuture)GOBIIAvroGenotypeCallTable.this.myFutureQueue.get(this.myProcessBlock);
                        if (future != null) {
                            future.complete(result);
                            GOBIIAvroGenotypeCallTable.this.myFutureQueue.remove(this.myProcessBlock, future);
                        }
                        GOBIIAvroGenotypeCallTable.this.myGenoCache.getIfPresent((Object)this.myProcessBlock);
                    }
                    this.myProcessBlock = GOBIIAvroGenotypeCallTable.getCacheKey(this.myStartTaxa, lookaheadSite += 256);
                    if (lookaheadSite >= GOBIIAvroGenotypeCallTable.this.mySiteCount || GOBIIAvroGenotypeCallTable.this.myGenoCache.getIfPresent((Object)this.myProcessBlock) != null || GOBIIAvroGenotypeCallTable.this.myFutureQueue.putIfAbsent(this.myProcessBlock, new CompletableFuture()) != null) continue;
                    ++myNumBlocksRead;
                    GenericData.Array byteBufferArray = (GenericData.Array)GOBIIAvroGenotypeCallTable.this.myRecord.get(GOBIIAvroGenotypeCallTable.getKey(this.myStartTaxa, lookaheadSite));
                    if (byteBufferArray == null) {
                        throw new IllegalStateException("GOBIIAvroGenotypeCallTable: byte buffer array is null: " + GOBIIAvroGenotypeCallTable.getKey(this.myStartTaxa, lookaheadSite));
                    }
                    int numTaxa = byteBufferArray.size();
                    current = (ByteBuffer)byteBufferArray.get(0);
                    current.rewind();
                    numSites = current.remaining();
                    result = new byte[numTaxa][numSites];
                    for (int t = 0; t < numTaxa; ++t) {
                        current = (ByteBuffer)byteBufferArray.get(t);
                        current.rewind();
                        for (s = 0; s < numSites; ++s) {
                            result[t][s] = current.get();
                        }
                    }
                    GOBIIAvroGenotypeCallTable.this.myGenoCache.put((Object)this.myProcessBlock, (Object)result);
                    future = (CompletableFuture)GOBIIAvroGenotypeCallTable.this.myFutureQueue.get(this.myProcessBlock);
                    if (future != null) {
                        future.complete(result);
                        GOBIIAvroGenotypeCallTable.this.myFutureQueue.remove(this.myProcessBlock, future);
                    }
                    GOBIIAvroGenotypeCallTable.this.myGenoCache.getIfPresent((Object)this.myProcessBlock);
                }
            }
            catch (Exception e) {
                myLogger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

