/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.genotypecall;

import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Map;
import net.maizegenetics.dna.snp.genotypecall.FilterGenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.ListStatsFilterSite;
import net.maizegenetics.dna.snp.genotypecall.ListStatsFilterTaxa;
import net.maizegenetics.dna.snp.genotypecall.ListStatsSite;
import net.maizegenetics.dna.snp.genotypecall.ListStatsTaxa;
import net.maizegenetics.dna.snp.genotypecall.Stats;

public abstract class ListStats
extends AbstractList<Stats> {
    private static final Map<GenotypeCallTable, WeakReference<ListStats>> TAXA_INSTANCES = new HashMap<GenotypeCallTable, WeakReference<ListStats>>();
    private static final Map<GenotypeCallTable, WeakReference<ListStats>> SITE_INSTANCES = new HashMap<GenotypeCallTable, WeakReference<ListStats>>();
    protected final GenotypeCallTable myGenotype;
    private final int myNumIndices;

    ListStats(GenotypeCallTable genotype, int numIndices) {
        this.myGenotype = genotype;
        this.myNumIndices = numIndices;
    }

    public static ListStats getTaxaInstance(GenotypeCallTable genotype) {
        WeakReference<ListStats> temp = TAXA_INSTANCES.get(genotype);
        ListStats result = null;
        if (temp != null) {
            result = (ListStats)temp.get();
        }
        if (result == null) {
            if (genotype instanceof FilterGenotypeCallTable) {
                FilterGenotypeCallTable filter = (FilterGenotypeCallTable)genotype;
                WeakReference<ListStats> temp1 = TAXA_INSTANCES.get(filter.myBaseGenotype);
                ListStats base = null;
                if (temp1 != null) {
                    base = (ListStats)temp1.get();
                }
                result = base == null || filter.myTranslate.hasSiteTranslations() ? new ListStatsTaxa(genotype) : new ListStatsFilterTaxa(filter, base);
            } else {
                result = new ListStatsTaxa(genotype);
            }
            TAXA_INSTANCES.put(genotype, new WeakReference<ListStats>(result));
        }
        return result;
    }

    public static ListStats getSiteInstance(GenotypeCallTable genotype) {
        WeakReference<ListStats> temp = SITE_INSTANCES.get(genotype);
        ListStats result = null;
        if (temp != null) {
            result = (ListStats)temp.get();
        }
        if (result == null) {
            if (genotype instanceof FilterGenotypeCallTable) {
                FilterGenotypeCallTable filter = (FilterGenotypeCallTable)genotype;
                WeakReference<ListStats> temp1 = SITE_INSTANCES.get(filter.myBaseGenotype);
                ListStats base = null;
                if (temp1 != null) {
                    base = (ListStats)temp1.get();
                }
                result = base == null || filter.myTranslate.hasTaxaTranslations() ? new ListStatsSite(genotype) : new ListStatsFilterSite(filter, base);
            } else {
                result = new ListStatsSite(genotype);
            }
            SITE_INSTANCES.put(genotype, new WeakReference<ListStats>(result));
        }
        return result;
    }

    @Override
    public int size() {
        return this.myNumIndices;
    }

    public byte majorAllele(int index) {
        return ((Stats)this.get(index)).majorAllele();
    }

    public double majorAlleleFrequency(int index) {
        return ((Stats)this.get(index)).majorAlleleFrequency();
    }

    public byte minorAllele(int index) {
        return ((Stats)this.get(index)).minorAllele();
    }

    public double minorAlleleFrequency(int index) {
        return ((Stats)this.get(index)).minorAlleleFrequency();
    }
}

