/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.genotypecall;

public class Stats {
    private final int[][] myAlleleCounts;
    private final int[] myStats;
    private final int myNumIndices;
    private final int myIndex;

    private Stats(int[][] alleleCounts, int[] stats, int numIndices, int index) {
        this.myAlleleCounts = alleleCounts;
        this.myStats = stats;
        this.myIndex = index;
        this.myNumIndices = numIndices;
    }

    public static Stats getInstance(int[][] alleleCounts, int[] stats, int numIndices, int index) {
        return new Stats(alleleCounts, stats, numIndices, index);
    }

    public static Stats getInstance(Stats orig, int newIndex) {
        return new Stats(orig.myAlleleCounts, orig.myStats, orig.myNumIndices, newIndex);
    }

    public byte majorAllele() {
        if (this.myAlleleCounts[0].length >= 1) {
            return (byte)this.myAlleleCounts[0][0];
        }
        return 15;
    }

    public double majorAlleleFrequency() {
        int numAlleles = this.myAlleleCounts[0].length;
        if (numAlleles >= 1) {
            int totalNonMissing = 0;
            for (int i = 0; i < numAlleles; ++i) {
                totalNonMissing += this.myAlleleCounts[1][i];
            }
            return (double)this.myAlleleCounts[1][0] / (double)totalNonMissing;
        }
        return 0.0;
    }

    public byte minorAllele() {
        if (this.myAlleleCounts[0].length >= 2) {
            return (byte)this.myAlleleCounts[0][1];
        }
        return 15;
    }

    public double minorAlleleFrequency() {
        int numAlleles = this.myAlleleCounts[0].length;
        if (numAlleles >= 2) {
            int totalNonMissing = 0;
            for (int i = 0; i < numAlleles; ++i) {
                totalNonMissing += this.myAlleleCounts[1][i];
            }
            return (double)this.myAlleleCounts[1][1] / (double)totalNonMissing;
        }
        return 0.0;
    }

    public int numAllMinorAlleles() {
        int result = 0;
        for (int i = 1; i < this.myAlleleCounts[0].length; ++i) {
            result += this.myAlleleCounts[1][i];
        }
        return result;
    }

    public int totalGametesNonMissingForSite() {
        int numAlleles = this.myAlleleCounts[0].length;
        int result = 0;
        for (int i = 0; i < numAlleles; ++i) {
            result += this.myAlleleCounts[1][i];
        }
        return result;
    }

    public double proportionHeterozygous() {
        return (double)this.myStats[2] / (double)this.myNumIndices;
    }

    public double percentNotMissing() {
        return (double)(this.myNumIndices - this.myStats[0]) / (double)this.myNumIndices;
    }

    public boolean hasIndel() {
        int numAlleles = this.myAlleleCounts[0].length;
        for (int i = 0; i < numAlleles; ++i) {
            if (this.myAlleleCounts[0][i] != 5 && this.myAlleleCounts[0][i] != 4) continue;
            return true;
        }
        return false;
    }

    public int index() {
        return this.myIndex;
    }
}

